/*
 * Decompiled with CFR 0.152.
 */
package org.autumnframework.service.jpa.services.elementary;

import java.util.UUID;
import org.autumnframework.service.event.metadata.EventMetaData;
import org.autumnframework.service.jpa.identifiable.JpaApiIdentifiable;
import org.autumnframework.service.jpa.services.elementary.DeleteByIdService;
import org.autumnframework.service.jpa.services.elementary.ReadFindByApiIdService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

public interface DeleteByApiIdService<T extends JpaApiIdentifiable>
extends ReadFindByApiIdService<T>,
DeleteByIdService<T> {
    public static final Logger log = LoggerFactory.getLogger(DeleteByApiIdService.class);

    @Transactional
    default public void deleteByApiId(UUID id, EventMetaData eventMetaData) {
        log.trace("deleteByApiId(id: {}, eventMetaData: {})", (Object)id, (Object)eventMetaData);
        this.findByApiId(id).ifPresentOrElse(t -> {
            log.trace("Found by api id {}, delegating delete by id {}", (Object)id, t.getId());
            this.delete((Long)t.getId(), eventMetaData);
        }, () -> log.trace("Could not find entity by api id {}, nothing to delete", (Object)id));
    }

    default public void deleteByApiId(UUID id) {
        UUID newMessageChainId = UUID.randomUUID();
        log.debug("deleteByApiId({}), initiating new message chain id: {}", (Object)id, (Object)newMessageChainId);
        this.deleteByApiId(id, EventMetaData.builder().messageChainId(newMessageChainId).build());
    }
}

