/*
 * Decompiled with CFR 0.152.
 */
package org.autumnframework.service.jpa.services.elementary;

import java.time.LocalDateTime;
import java.util.stream.Stream;
import org.autumnframework.service.jpa.identifiable.JpaApiIdentifiable;
import org.autumnframework.service.jpa.services.elementary.ReadFindAllService;
import org.autumnframework.service.jpa.services.genericdefault.shared.GenericJpaGetApiRepositoryService;
import org.autumnframework.service.services.GenericAuditedReadFindAllService;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;

public interface ReadFindAllModifiedBetweenService<T extends JpaApiIdentifiable>
extends GenericJpaGetApiRepositoryService<T>,
GenericAuditedReadFindAllService<T, Long>,
ReadFindAllService<T> {
    @Transactional(readOnly=true)
    default public Page<T> findAllModifiedBetween(LocalDateTime start, LocalDateTime end, Pageable page) {
        return this.getRepository().findAllByLastModifiedDateBetween(start, end, page);
    }

    @Transactional(readOnly=true)
    default public Stream<T> streamAllModifiedBetween(LocalDateTime start, LocalDateTime end) {
        return this.getRepository().streamAllByLastModifiedDateBetweenOrderByCreationDate(start, end);
    }
}

