/*
 * Decompiled with CFR 0.152.
 */
package org.autumnframework.service.jpa.services.elementary;

import java.time.LocalDateTime;
import java.util.stream.Stream;
import org.autumnframework.service.jpa.identifiable.JpaApiIdentifiable;
import org.autumnframework.service.jpa.services.elementary.ReadFindAllService;
import org.autumnframework.service.jpa.services.genericdefault.shared.GenericJpaGetApiRepositoryService;
import org.autumnframework.service.services.GenericAuditedReadFindAllService;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.transaction.annotation.Transactional;

public interface ReadFindAllModifiedSinceService<T extends JpaApiIdentifiable>
extends GenericJpaGetApiRepositoryService<T>,
GenericAuditedReadFindAllService<T, Long>,
ReadFindAllService<T> {
    @Transactional(readOnly=true)
    default public Page<T> findAllModifiedSince(LocalDateTime date, Pageable page) {
        return this.getRepository().findAllByLastModifiedDateAfter(date, page);
    }

    @Transactional(readOnly=true)
    default public Stream<T> streamAllModifiedSince(LocalDateTime date) {
        return this.getRepository().streamAllByLastModifiedDateAfterOrderByCreationDate(date);
    }
}

