/*
 * Decompiled with CFR 0.152.
 */
package org.autumnframework.service.jpa.services.elementary;

import java.util.UUID;
import org.autumnframework.service.event.metadata.EventMetaData;
import org.autumnframework.service.jpa.identifiable.JpaIdentifiable;
import org.autumnframework.service.jpa.services.elementary.shared.GetRepositoryService;
import org.autumnframework.service.jpa.services.genericdefault.GenericJpaUpdateService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface UpdateService<T extends JpaIdentifiable>
extends GetRepositoryService<T>,
GenericJpaUpdateService<T, Long, EventMetaData> {
    public static final Logger log = LoggerFactory.getLogger(UpdateService.class);

    @Override
    default public T update(T t) {
        UUID messageChainId = UUID.randomUUID();
        log.debug("update {} with id: {}, initiating new message chain id: {}", new Object[]{t.getClass().getSimpleName(), t.getId(), messageChainId});
        return (T)((JpaIdentifiable)GenericJpaUpdateService.super.update(t, EventMetaData.builder().messageChainId(messageChainId).build()));
    }
}

