/*
 * Decompiled with CFR 0.152.
 */
package org.autumnframework.service.jpa.services.genericdefault;

import jakarta.transaction.Transactional;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.autumnframework.service.event.listeners.generic.GenericOnCreateListener;
import org.autumnframework.service.identifiable.GenericIdentifiable;
import org.autumnframework.service.jpa.services.genericdefault.shared.GenericJpaGetRepositoryService;
import org.autumnframework.service.services.GenericCreateService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public interface GenericJpaCreateService<T extends GenericIdentifiable<ID>, ID extends Serializable, EVENT_METADATA>
extends GenericJpaGetRepositoryService<T, ID>,
GenericCreateService<T, ID> {
    public static final Logger log = LoggerFactory.getLogger(GenericJpaCreateService.class);

    default public List<GenericOnCreateListener<T, ID, EVENT_METADATA>> getOnCreateListeners() {
        log.trace("Returning default: empty OnCreateListener list");
        return Collections.emptyList();
    }

    @Transactional
    default public T create(T t, EVENT_METADATA eventMetaData) {
        if (log.isTraceEnabled()) {
            log.trace("Create entity: {}", t);
        } else {
            log.debug("Create entity: {}", (Object)t.getClass().getSimpleName());
        }
        GenericIdentifiable tCreated = (GenericIdentifiable)this.getRepository().save(t);
        this.getOnCreateListeners().forEach(createEventListener -> {
            if (log.isTraceEnabled()) {
                log.trace("Calling onCreate for {} with id {}, entity: {}, eventMetaData: {}", new Object[]{t.getClass().getSimpleName(), t.getId(), t, eventMetaData});
            } else {
                log.debug("Calling onCreate for {} with id {}", (Object)t.getClass().getSimpleName(), t.getId());
            }
            try {
                createEventListener.onCreate(tCreated, eventMetaData);
            }
            catch (Exception e) {
                log.error("Failed to execute onCreate handler for {} with id {}, continuing with other handlers ", new Object[]{t.getClass().getSimpleName(), t.getId(), e});
            }
        });
        return (T)tCreated;
    }

    @Transactional
    default public List<T> createAll(List<T> t, EVENT_METADATA eventMetaData) {
        if (!CollectionUtils.isEmpty(t)) {
            if (log.isTraceEnabled()) {
                log.trace("Create {} entities: {}", (Object)t.size(), t);
            } else {
                log.debug("Create {} entities: {}", (Object)t.size(), (Object)((GenericIdentifiable)t.get(0)).getClass().getSimpleName());
            }
            List lstCreated = this.getRepository().saveAll(t);
            lstCreated.stream().forEach(tCreated -> this.getOnCreateListeners().forEach(createEventListener -> {
                if (log.isTraceEnabled()) {
                    log.trace("Calling onCreate for {} with id {}, entity: {}, eventMetaData: {}", new Object[]{((GenericIdentifiable)t.get(0)).getClass().getSimpleName(), ((GenericIdentifiable)t.get(0)).getId(), t.get(0), eventMetaData});
                } else {
                    log.debug("Calling onCreate for {} with id {}", (Object)t.getClass().getSimpleName(), ((GenericIdentifiable)t.get(0)).getId());
                }
                try {
                    createEventListener.onCreate(tCreated, eventMetaData);
                }
                catch (Exception e) {
                    log.error("Failed to execute onCreate handler for {} with id {}, continuing with other handlers ", new Object[]{((GenericIdentifiable)t.get(0)).getClass().getSimpleName(), ((GenericIdentifiable)t.get(0)).getId(), e});
                }
            }));
            return lstCreated;
        }
        log.warn("Empty list passed in, nothing persisted");
        return Collections.emptyList();
    }

    default public void performOnCreateHandlers() {
    }

    default public T create(T t) {
        return this.create(t, null);
    }
}

