/*
 * Decompiled with CFR 0.152.
 */
package org.autumnframework.service.jpa.services.genericdefault;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.autumnframework.service.event.listeners.generic.GenericOnDeleteListener;
import org.autumnframework.service.identifiable.GenericIdentifiable;
import org.autumnframework.service.jpa.services.genericdefault.shared.GenericJpaGetRepositoryService;
import org.autumnframework.service.services.GenericDeleteByIdService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

public interface GenericJpaDeleteByIdService<T extends GenericIdentifiable<ID>, ID extends Serializable, EVENT_METADATA>
extends GenericJpaGetRepositoryService<T, ID>,
GenericDeleteByIdService<T, ID> {
    public static final Logger log = LoggerFactory.getLogger(GenericJpaDeleteByIdService.class);

    default public List<GenericOnDeleteListener<T, ID, EVENT_METADATA>> getOnDeleteListeners() {
        log.trace("Returning default: empty OnDeleteListener list");
        return Collections.emptyList();
    }

    @Transactional
    default public void delete(ID id, EVENT_METADATA eventMetaData) {
        GenericIdentifiable t;
        boolean hasFullEntityReceivingDeleteListeners;
        if (eventMetaData != null) {
            log.trace("Delete by id: {}, meta data: {}", id, eventMetaData);
        } else {
            log.trace("Delete by id: {}", id);
        }
        boolean bl = hasFullEntityReceivingDeleteListeners = !CollectionUtils.isEmpty(this.getOnDeleteListeners());
        if (hasFullEntityReceivingDeleteListeners) {
            log.trace("Found OnDeleteListeners for entity, looking up entity before deleting it");
            Optional optionalEntity = this.getRepository().findById(id);
            if (optionalEntity.isEmpty()) {
                log.trace("No entity found to delete, nothing to delete.");
                return;
            }
            t = (GenericIdentifiable)optionalEntity.get();
            log.trace("Found entity: {} with id: {} to delete, caching entity for OnDeleteListener", (Object)t.getClass().getSimpleName(), t.getId());
        } else {
            t = null;
        }
        this.getRepository().deleteById(id);
        if (hasFullEntityReceivingDeleteListeners) {
            this.getOnDeleteListeners().forEach(onDeleteListeners -> {
                if (log.isTraceEnabled()) {
                    log.trace("Calling onDelete for {} with id {}, entity: {}, eventMetaData: {}", new Object[]{t.getClass(), t.getId(), t, eventMetaData});
                } else {
                    log.debug("Calling onDelete for {} with id {}", (Object)t.getClass().getSimpleName(), t.getId());
                }
                try {
                    onDeleteListeners.onDelete(t, eventMetaData);
                }
                catch (Exception e) {
                    log.error("Failed to execute onDelete handler for {} with id {}, continuing with other handlers ", new Object[]{t.getClass().getSimpleName(), t.getId(), e});
                }
            });
        }
    }

    @Transactional
    default public void deleteById(ID id) {
        this.delete(id, null);
    }
}

