/*
 * Decompiled with CFR 0.152.
 */
package org.autumnframework.service.jpa.services.genericdefault;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.autumnframework.service.event.listeners.generic.GenericOnUpdateListener;
import org.autumnframework.service.identifiable.GenericIdentifiable;
import org.autumnframework.service.jpa.services.genericdefault.shared.GenericJpaGetRepositoryService;
import org.autumnframework.service.services.GenericUpdateService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

public interface GenericJpaUpdateService<T extends GenericIdentifiable<ID>, ID extends Serializable, EVENT_METADATA>
extends GenericJpaGetRepositoryService<T, ID>,
GenericUpdateService<T, ID> {
    public static final Logger log = LoggerFactory.getLogger(GenericJpaUpdateService.class);

    default public List<GenericOnUpdateListener<T, ID, EVENT_METADATA>> getOnUpdateListeners() {
        log.trace("Returning default: empty OnUpdateListener list");
        return Collections.emptyList();
    }

    @Transactional
    default public T update(T t, EVENT_METADATA eventMetaData) {
        if (log.isTraceEnabled()) {
            log.trace("Update entity: {}", t);
        } else {
            log.debug("Update entity: {} with id: {}", (Object)t.getClass().getSimpleName(), t.getId());
        }
        GenericIdentifiable tUpdated = (GenericIdentifiable)this.getRepository().save(t);
        this.getOnUpdateListeners().forEach(onUpdateListener -> {
            if (log.isTraceEnabled()) {
                log.trace("Calling onUpdate for {} with id {}, entity: {}, eventMetaData: {}", new Object[]{t.getClass(), t.getId(), t, eventMetaData});
            } else {
                log.debug("Calling onUpdate for {} with id {}", (Object)t.getClass().getSimpleName(), t.getId());
            }
            try {
                onUpdateListener.onUpdate(tUpdated, eventMetaData);
            }
            catch (Exception e) {
                log.error("Failed to execute onUpdate handler for {} with id {}, continuing with other handlers ", new Object[]{t.getClass().getSimpleName(), t.getId(), e});
            }
        });
        return (T)tUpdated;
    }

    @Transactional
    default public List<T> updateAll(List<T> t, EVENT_METADATA eventMetaData) {
        if (!CollectionUtils.isEmpty(t)) {
            if (log.isTraceEnabled()) {
                log.trace("Update {} entities: {}", (Object)t.size(), t);
            } else {
                log.debug("Update {} entities: {} with id: {}", new Object[]{t.size(), ((GenericIdentifiable)t.get(0)).getClass().getSimpleName(), ((GenericIdentifiable)t.get(0)).getId()});
            }
            List lstUpdated = this.getRepository().saveAll(t);
            lstUpdated.stream().forEach(tUpdated -> this.getOnUpdateListeners().forEach(onUpdateListener -> {
                if (log.isTraceEnabled()) {
                    log.trace("Calling onUpdate for {} with id {}, entity: {}, eventMetaData: {}", new Object[]{((GenericIdentifiable)t.get(0)).getClass(), ((GenericIdentifiable)t.get(0)).getId(), t.get(0), eventMetaData});
                } else {
                    log.debug("Calling onUpdate for {} with id {}", (Object)((GenericIdentifiable)t.get(0)).getClass().getSimpleName(), ((GenericIdentifiable)t.get(0)).getId());
                }
                try {
                    onUpdateListener.onUpdate(tUpdated, eventMetaData);
                }
                catch (Exception e) {
                    log.error("Failed to execute onUpdate handler for {} with id {}, continuing with other handlers ", new Object[]{((GenericIdentifiable)t.get(0)).getClass().getSimpleName(), ((GenericIdentifiable)t.get(0)).getId(), e});
                }
            }));
            return lstUpdated;
        }
        log.warn("Empty list passed in, nothing persisted");
        return Collections.emptyList();
    }

    @Transactional
    default public T update(T t) {
        return this.update(t, null);
    }
}

