/*
 * Decompiled with CFR 0.152.
 */
package org.autumnframework.service.pageable;

import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.util.CollectionUtils;

public class PagedIterator<T>
implements Iterator<T> {
    private static final Logger log = LoggerFactory.getLogger(PagedIterator.class);
    public static final Pageable PAGEABLE_FINISHED = null;
    private final Function<Pageable, Page<T>> findPaged;
    private Pageable pageable;
    private Page<T> currentPage;
    private Iterator<T> currentPageIterator;

    public PagedIterator(Function<Pageable, Page<T>> findPaged, Pageable pageable) {
        this.findPaged = findPaged;
        this.pageable = pageable;
    }

    @Override
    public boolean hasNext() {
        if (this.pageable == PAGEABLE_FINISHED) {
            log.debug("No pageable, iterator already used once");
            return false;
        }
        if (this.currentPage == null || this.currentPageIterator == null) {
            log.debug("Fetching page {}, requesting {} items", (Object)this.pageable.getPageNumber(), (Object)this.pageable.getPageSize());
            Page<T> newPage = this.findPaged.apply(this.pageable);
            if (CollectionUtils.isEmpty((Collection)newPage.getContent())) {
                log.trace("No content found in page, marking pageable as ended");
                this.pageable = PAGEABLE_FINISHED;
                return false;
            }
            log.trace("Found page number {} of {} pages with {} elements ", new Object[]{newPage.getPageable().getPageNumber(), newPage.getTotalPages(), newPage.getNumberOfElements()});
            this.currentPage = newPage;
            this.currentPageIterator = this.currentPage.getContent().iterator();
            return true;
        }
        if (this.currentPageIterator.hasNext()) {
            log.trace("Current page hasNext");
            return true;
        }
        log.trace("Current page {} has no next, selecting next page {}", (Object)this.pageable.getPageNumber(), (Object)(this.pageable.getPageNumber() + 1));
        this.pageable = this.pageable.next();
        this.currentPage = null;
        this.currentPageIterator = null;
        return this.hasNext();
    }

    @Override
    public T next() {
        if (this.pageable == PAGEABLE_FINISHED) {
            throw new IllegalStateException("Next called without checking hasNext(). Iterator already used once and ended.");
        }
        if (this.currentPage == null || this.currentPageIterator == null) {
            throw new IllegalStateException("Next called without checking hasNext(). No pages fetched yet.");
        }
        return this.currentPageIterator.next();
    }
}

