/*
 * Copyright © 2016-2023 the original author or authors (info@autumnframework.org)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.autumnframework.service.services;

import java.io.Serializable;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import org.autumnframework.service.identifiable.GenericIdentifiable;

/**
 * In it's bare essentials defines what a read findAll service should look like
 * @param <T>
 * @param <ID>
 */
public interface GenericReadFindAllService< T extends GenericIdentifiable<ID>,
                                            ID extends Serializable> {

    Page<T> findAll(Pageable page);
    
}
