/*
 * Decompiled with CFR 0.152.
 */
package org.autumnframework.service.services;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.stream.Stream;
import org.autumnframework.service.identifiable.GenericApiIdentifiable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.lang.NonNull;

public interface GenericAuditedReadFindAllService<T extends GenericApiIdentifiable<ID>, ID extends Serializable> {
    public Page<T> findAllModifiedSince(@NonNull LocalDateTime var1, Pageable var2);

    public Page<T> findAllModifiedBetween(@NonNull LocalDateTime var1, @NonNull LocalDateTime var2, Pageable var3);

    public Stream<T> streamAllModifiedSince(@NonNull LocalDateTime var1);

    public Stream<T> streamAllModifiedBetween(@NonNull LocalDateTime var1, @NonNull LocalDateTime var2);

    default public Page<T> findAllModifiedSince(@NonNull Date date, Pageable page) {
        return this.findAllModifiedSince(LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()), page);
    }

    default public Page<T> findAllModifiedBetween(@NonNull Date start, @NonNull Date end, Pageable page) {
        return this.findAllModifiedBetween(LocalDateTime.ofInstant(start.toInstant(), ZoneId.systemDefault()), LocalDateTime.ofInstant(end.toInstant(), ZoneId.systemDefault()), page);
    }

    default public Stream<T> streamAllModifiedSince(@NonNull Date date) {
        return this.streamAllModifiedSince(LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault()));
    }

    default public Stream<T> streamAllModifiedBetween(@NonNull Date start, @NonNull Date end) {
        return this.streamAllModifiedBetween(LocalDateTime.ofInstant(start.toInstant(), ZoneId.systemDefault()), LocalDateTime.ofInstant(end.toInstant(), ZoneId.systemDefault()));
    }
}

