/*
 * Decompiled with CFR 0.152.
 */
package org.auxis.commons.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.auxis.commons.tree.Selector;
import org.auxis.commons.tree.Tree;
import org.auxis.commons.tree.annotated.Tag;

public class TreeIndex
implements Tree {
    private final Tree m_tree;
    private final Map<Selector, TreeIndex> m_selectors = new HashMap<Selector, TreeIndex>();
    private final TreeIndex[] m_sub;

    public TreeIndex(Tree tree) {
        if (tree instanceof TreeIndex) {
            throw new RuntimeException("You should not wrap a TreeIndex.. waaaayyy too expensive..");
        }
        this.m_tree = tree;
        ArrayList<TreeIndex> sub = new ArrayList<TreeIndex>();
        for (Tree h : tree.branches()) {
            TreeIndex idx = new TreeIndex(h);
            if (h.selector() != null) {
                this.m_selectors.put(h.selector(), idx);
            }
            sub.add(idx);
        }
        this.m_sub = sub.toArray(new TreeIndex[sub.size()]);
    }

    public TreeIndex select(Selector selector) {
        return this.m_selectors.get(selector);
    }

    public TreeIndex select(Selector ... selectors) {
        TreeIndex r = this;
        for (Selector s : selectors) {
            r = r.select(s);
        }
        return r;
    }

    public boolean selectable() {
        return this.m_tree.selector() != null;
    }

    @Override
    public String fingerprint() {
        return this.m_tree.fingerprint();
    }

    @Override
    public Selector selector() {
        return this.m_tree.selector();
    }

    public TreeIndex[] branches() {
        return this.m_sub;
    }

    public String toString() {
        return "TreeIndex of [" + this.m_tree.toString() + "] with selectors: " + this.m_selectors.size();
    }

    @Override
    public Tag tags() {
        return this.m_tree.tags();
    }
}

