/*
 * Decompiled with CFR 0.152.
 */
package org.auxis.commons.tree.internal;

import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import org.auxis.commons.tree.Selector;
import org.auxis.commons.tree.StaticTreeBuilder;
import org.auxis.commons.tree.Tree;
import org.auxis.commons.tree.TreeAlreadySealedException;
import org.auxis.commons.tree.TreeBuilder;
import org.auxis.commons.tree.TreeException;
import org.auxis.commons.tree.annotated.Tag;
import org.auxis.commons.tree.util.TreeTools;

public class InMemoryTreeBuilderImpl
implements TreeBuilder {
    private final MessageDigest m_digest;
    private Tree m_hash;
    private boolean m_sealed = false;
    private final List<TreeBuilder> m_sub;
    private Selector m_selector;
    private Tag m_tag;
    private final TreeTools m_tools;

    public InMemoryTreeBuilderImpl(TreeTools tools) {
        this.m_tools = tools;
        this.m_digest = this.m_tools.createMessageDigest();
        this.m_sub = new ArrayList<TreeBuilder>();
    }

    @Override
    public synchronized TreeBuilder add(byte[] bytes) {
        this.verifyTreeNotSealed();
        this.m_digest.update(bytes);
        return this;
    }

    @Override
    public synchronized Tree seal() {
        if (!this.m_sealed) {
            if (this.m_selector == null) {
                throw new TreeException("Sealing not possible due to missing selector.");
            }
            ArrayList<Tree> subHashes = new ArrayList<Tree>(this.m_sub.size());
            for (TreeBuilder c : this.m_sub) {
                Tree subHash = c.seal();
                subHashes.add(subHash);
                this.add(subHash.fingerprint().getBytes());
            }
            this.m_hash = this.m_tools.createTree(this.m_selector, InMemoryTreeBuilderImpl.convertToHex(this.m_digest.digest()), subHashes.toArray(new Tree[subHashes.size()]), this.m_tag);
            this.m_sealed = true;
            this.resetMembers();
        }
        return this.m_hash;
    }

    private void resetMembers() {
        this.m_sub.clear();
        this.m_selector = null;
        this.m_digest.reset();
    }

    @Override
    public synchronized TreeBuilder branch(Selector selector) {
        this.verifyTreeNotSealed();
        TreeBuilder c = this.m_tools.createTreeBuilder().selector(selector);
        this.m_sub.add(c);
        return c;
    }

    @Override
    public TreeBuilder branch(Tree subtree) {
        this.verifyTreeNotSealed();
        StaticTreeBuilder c = new StaticTreeBuilder(subtree);
        this.m_sub.add(c);
        return c;
    }

    private void verifyTreeNotSealed() {
        if (this.m_sealed) {
            throw new TreeAlreadySealedException("No modification on a sealed tree!");
        }
    }

    private static String convertToHex(byte[] data) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (two_halfs++ < 1);
        }
        return buf.toString();
    }

    @Override
    public synchronized TreeBuilder selector(Selector selector) {
        this.verifyTreeNotSealed();
        this.m_selector = selector;
        return this;
    }

    @Override
    public TreeBuilder tag(Tag tag) {
        this.m_tag = tag;
        return this;
    }
}

