/*
 * Decompiled with CFR 0.152.
 */
package org.auxis.commons.tree.internal;

import org.auxis.commons.tree.Selector;
import org.auxis.commons.tree.Tree;
import org.auxis.commons.tree.annotated.Tag;
import org.auxis.commons.tree.util.TreeTools;

public class InMemoryTreeImpl
implements Tree {
    private final String m_hashValue;
    private final Tree[] m_subs;
    private final Selector m_selector;
    private final Tag m_tag;
    private final TreeTools m_tools;

    public InMemoryTreeImpl(TreeTools treeTools, Selector selector, String hashValue, Tree[] subs, Tag tag) {
        this.m_tools = treeTools;
        this.m_selector = selector;
        this.m_hashValue = hashValue;
        this.m_subs = subs;
        this.m_tag = tag;
    }

    @Override
    public String fingerprint() {
        return this.m_hashValue;
    }

    @Override
    public Selector selector() {
        return this.m_selector;
    }

    @Override
    public Tree[] branches() {
        return this.m_subs;
    }

    public String toString() {
        return this.m_hashValue.substring(0, 6) + " /Selector: " + this.m_selector + " /Children: " + this.m_subs.length;
    }

    public int hashCode() {
        return this.m_hashValue.hashCode();
    }

    public boolean equals(Object other) {
        if (other instanceof Tree) {
            Tree sn2 = (Tree)other;
            Tree compare = this.m_tools.compare(this, sn2);
            return compare.branches().length == 0;
        }
        throw new RuntimeException("Should not come here..");
    }

    @Override
    public Tag tags() {
        return this.m_tag;
    }
}

