/*
 * Decompiled with CFR 0.152.
 */
package org.auxis.commons.tree.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.auxis.commons.tree.Selector;
import org.auxis.commons.tree.Tree;
import org.auxis.commons.tree.TreeBuilder;
import org.auxis.commons.tree.TreeException;
import org.auxis.commons.tree.annotated.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamTreeBuilder
implements TreeBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(StreamTreeBuilder.class);
    private long m_dataAmountRead = 0L;
    private final TreeBuilder m_delegate;

    public StreamTreeBuilder(TreeBuilder delegate) {
        this.m_delegate = delegate;
    }

    public StreamTreeBuilder add(InputStream is) throws IOException {
        byte[] bytes = new byte[1024];
        int numRead = 0;
        while ((numRead = is.read(bytes)) >= 0) {
            this.m_delegate.add(Arrays.copyOf(bytes, numRead));
            this.m_dataAmountRead += (long)numRead;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamTreeBuilder add(File f) {
        try {
            FileInputStream is = new FileInputStream(f);
            try {
                this.add(is);
            }
            finally {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException e) {
                        LOG.warn("Problem closing file " + f.getAbsolutePath(), (Throwable)e);
                    }
                }
            }
        }
        catch (IOException ioE) {
            throw new TreeException("Problem reading file " + f.getAbsolutePath() + " contents.", ioE);
        }
        return this;
    }

    public long getDataRead() {
        return this.m_dataAmountRead;
    }

    public void reset() {
        this.m_dataAmountRead = 0L;
    }

    @Override
    public StreamTreeBuilder add(byte[] bytes) {
        this.m_delegate.add(bytes);
        return this;
    }

    @Override
    public StreamTreeBuilder selector(Selector selector) {
        this.m_delegate.selector(selector);
        return this;
    }

    @Override
    public StreamTreeBuilder branch(Selector selector) {
        LOG.warn("Branching from StreamTreeBuilder is pretty unusually as it means you add raw data to an intermediate tree. ");
        return new StreamTreeBuilder(this.m_delegate.branch(selector));
    }

    @Override
    public StreamTreeBuilder branch(Tree subtree) {
        LOG.warn("Branching from StreamTreeBuilder is pretty unusually as it means you add raw data to an intermediate tree. ");
        return new StreamTreeBuilder(this.m_delegate.branch(subtree));
    }

    @Override
    public StreamTreeBuilder tag(Tag tag) {
        this.m_delegate.tag(tag);
        return this;
    }

    @Override
    public Tree seal() {
        return this.m_delegate.seal();
    }
}

