/*
 * Decompiled with CFR 0.152.
 */
package org.auxis.commons.tree.util;

import org.auxis.commons.tree.TreeBuilder;
import org.auxis.commons.tree.TreeException;
import org.auxis.commons.tree.TreeIndex;
import org.auxis.commons.tree.annotated.Tag;

public class TreeCompare {
    public static final Tag ADDED = new Tag("ADDED");
    public static final Tag REMOVED = new Tag("REMOVED");
    public static final Tag MODIFIED = new Tag("MODIFIED");

    static void compare(TreeBuilder collector, TreeIndex left, TreeIndex right) {
        if (left == null) {
            for (TreeIndex tree : right.branches()) {
                TreeBuilder mod = collector.branch(tree.selector()).tag(ADDED);
                TreeCompare.compare(mod, null, tree);
            }
            return;
        }
        if (right == null) {
            for (TreeIndex tree : left.branches()) {
                TreeBuilder mod = collector.branch(tree.selector()).tag(REMOVED);
                TreeCompare.compare(mod, tree, null);
            }
            return;
        }
        if (!left.fingerprint().equals(right.fingerprint())) {
            TreeIndex origin;
            TreeBuilder modification = collector.branch(right.selector()).tag(MODIFIED);
            for (TreeIndex tree : left.branches()) {
                if (tree.selectable()) {
                    origin = right.select(tree.selector());
                    if (origin == null) {
                        TreeBuilder removed = modification.branch(tree.selector()).tag(REMOVED);
                        TreeCompare.compare(removed, tree, origin);
                        continue;
                    }
                    TreeCompare.compare(modification, tree, origin);
                    continue;
                }
                throw new TreeException("Item " + tree + " is not selectable.");
            }
            for (TreeIndex tree : right.branches()) {
                if (tree.selectable()) {
                    origin = left.select(tree.selector());
                    if (origin != null) continue;
                    TreeBuilder added = modification.branch(tree.selector()).tag(ADDED);
                    TreeCompare.compare(added, origin, tree);
                    continue;
                }
                throw new TreeException("Item " + tree + " is not selectable.");
            }
        }
    }
}

