/*
 * Decompiled with CFR 0.152.
 */
package org.auxis.commons.tree.util;

import java.io.PrintStream;
import org.auxis.commons.tree.Tree;

public class TreeConsoleFormatter {
    private final PrintStream m_out;

    public TreeConsoleFormatter() {
        this(System.out);
    }

    public TreeConsoleFormatter(PrintStream ps) {
        this.m_out = ps;
    }

    public void displayTree(int depth, Tree dbHash) {
        if (depth == 0) {
            this.m_out.println(" ---- TREE ----------");
        }
        this.m_out.print("+");
        for (int i = 0; i < depth; ++i) {
            this.m_out.print("--");
        }
        this.m_out.println(" " + dbHash.toString());
        ++depth;
        Tree[] elements = dbHash.branches();
        int count = elements.length < 10 ? elements.length : 10;
        for (int i = 0; i < count; ++i) {
            this.displayTree(depth, elements[i]);
        }
    }

    public void prettyPrint(int depth, Tree dbHash) {
        if (depth == 0) {
            this.m_out.println(" ---- TREE: ");
        }
        this.m_out.print("+");
        for (int i = 0; i < depth; ++i) {
            this.m_out.print("--");
        }
        this.m_out.println(" " + dbHash.tags() + " " + dbHash.selector());
        ++depth;
        for (Tree sub : dbHash.branches()) {
            this.prettyPrint(depth, sub);
        }
    }
}

