/*
 * Decompiled with CFR 0.152.
 */
package org.auxis.commons.tree.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.auxis.commons.tree.Selector;
import org.auxis.commons.tree.Tree;
import org.auxis.commons.tree.TreeBuilder;
import org.auxis.commons.tree.TreeException;
import org.auxis.commons.tree.TreeIndex;
import org.auxis.commons.tree.annotated.Tag;
import org.auxis.commons.tree.internal.InMemoryTreeBuilderImpl;
import org.auxis.commons.tree.internal.InMemoryTreeImpl;
import org.auxis.commons.tree.util.StreamTreeBuilder;
import org.auxis.commons.tree.util.TreeCompare;

public class TreeTools {
    private static final String DEFAULT_HASH_ALOGO = "SHA-1";
    private String m_messageDigestAlgorithm = "SHA-1";

    public long nodes(Tree tree) {
        int total = 1;
        for (Tree sub : tree.branches()) {
            total = (int)((long)total + this.nodes(sub));
        }
        return total;
    }

    public TreeBuilder createTreeBuilder() {
        return new InMemoryTreeBuilderImpl(this);
    }

    public StreamTreeBuilder createStreamTreeBuilder() {
        return new StreamTreeBuilder(this.createTreeBuilder());
    }

    public StreamTreeBuilder createStreamTreeBuilder(TreeBuilder delegate) {
        return new StreamTreeBuilder(delegate);
    }

    public Tree createTree(Selector selector, String hashValue, Tree[] subs, Tag tag) {
        return new InMemoryTreeImpl(this, selector, hashValue, subs, tag);
    }

    public TreeTools setDigestAlgorithm(String algo) {
        this.m_messageDigestAlgorithm = algo;
        return this;
    }

    public MessageDigest createMessageDigest() {
        try {
            return MessageDigest.getInstance(this.m_messageDigestAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new TreeException("Problem loading digest with algorthm.");
        }
    }

    public Tree compare(Tree left, Tree right) {
        return this.compare(new TreeIndex(left), new TreeIndex(right));
    }

    public Tree compare(TreeIndex left, TreeIndex right) {
        TreeBuilder target = this.createTreeBuilder().selector(Selector.selector("[" + left.selector() + " ] and [" + right.selector() + " ]"));
        target.tag(Tag.tag("DIFF"));
        TreeCompare.compare(target, left, right);
        return target.seal();
    }
}

