/*
 * Decompiled with CFR 0.152.
 */
package org.availlang.artifact;

import java.io.File;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.availlang.artifact.AvailArtifactException;
import org.availlang.artifact.PackageType;
import org.availlang.artifact.manifest.AvailArtifactManifest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J'\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\t\u00a8\u0006 "}, d2={"Lorg/availlang/artifact/ArtifactDescriptor;", "", "packageType", "Lorg/availlang/artifact/PackageType;", "version", "", "manifestVersion", "(Lorg/availlang/artifact/PackageType;II)V", "getManifestVersion", "()I", "getPackageType", "()Lorg/availlang/artifact/PackageType;", "serializedFileContent", "", "getSerializedFileContent", "()[B", "getVersion", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "writeFile", "", "targetFile", "Ljava/io/File;", "Companion", "avail-artifact"})
public final class ArtifactDescriptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PackageType packageType;
    private final int version;
    private final int manifestVersion;
    @NotNull
    public static final String artifactDescriptorFileName = "artifact-descriptor";
    @NotNull
    public static final String artifactDescriptorFilePath = "avail-artifact-contents/artifact-descriptor";

    public ArtifactDescriptor(@NotNull PackageType packageType, int version, int manifestVersion) {
        Intrinsics.checkNotNullParameter((Object)((Object)packageType), (String)"packageType");
        this.packageType = packageType;
        this.version = version;
        this.manifestVersion = manifestVersion;
    }

    @NotNull
    public final PackageType getPackageType() {
        return this.packageType;
    }

    public final int getVersion() {
        return this.version;
    }

    public final int getManifestVersion() {
        return this.manifestVersion;
    }

    @NotNull
    public final byte[] getSerializedFileContent() {
        ByteBuffer byteBuffer;
        ByteBuffer $this$_get_serializedFileContent__u24lambda_u240 = byteBuffer = ByteBuffer.allocate(12);
        boolean bl = false;
        $this$_get_serializedFileContent__u24lambda_u240.putInt(this.packageType.ordinal());
        $this$_get_serializedFileContent__u24lambda_u240.putInt(this.version);
        $this$_get_serializedFileContent__u24lambda_u240.putInt(this.manifestVersion);
        byte[] byArray = byteBuffer.array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"allocate(12).apply {\n\t\t\t\u2026ifestVersion)\n\t\t}.array()");
        return byArray;
    }

    public final void writeFile(@NotNull File targetFile) {
        Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
        FilesKt.writeBytes((File)targetFile, (byte[])this.getSerializedFileContent());
    }

    @NotNull
    public final PackageType component1() {
        return this.packageType;
    }

    public final int component2() {
        return this.version;
    }

    public final int component3() {
        return this.manifestVersion;
    }

    @NotNull
    public final ArtifactDescriptor copy(@NotNull PackageType packageType, int version, int manifestVersion) {
        Intrinsics.checkNotNullParameter((Object)((Object)packageType), (String)"packageType");
        return new ArtifactDescriptor(packageType, version, manifestVersion);
    }

    public static /* synthetic */ ArtifactDescriptor copy$default(ArtifactDescriptor artifactDescriptor, PackageType packageType, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            packageType = artifactDescriptor.packageType;
        }
        if ((n3 & 2) != 0) {
            n = artifactDescriptor.version;
        }
        if ((n3 & 4) != 0) {
            n2 = artifactDescriptor.manifestVersion;
        }
        return artifactDescriptor.copy(packageType, n, n2);
    }

    @NotNull
    public String toString() {
        return "ArtifactDescriptor(packageType=" + this.packageType + ", version=" + this.version + ", manifestVersion=" + this.manifestVersion + ")";
    }

    public int hashCode() {
        int result = this.packageType.hashCode();
        result = result * 31 + Integer.hashCode(this.version);
        result = result * 31 + Integer.hashCode(this.manifestVersion);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ArtifactDescriptor)) {
            return false;
        }
        ArtifactDescriptor artifactDescriptor = (ArtifactDescriptor)other;
        if (this.packageType != artifactDescriptor.packageType) {
            return false;
        }
        if (this.version != artifactDescriptor.version) {
            return false;
        }
        return this.manifestVersion == artifactDescriptor.manifestVersion;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/availlang/artifact/ArtifactDescriptor$Companion;", "", "()V", "artifactDescriptorFileName", "", "artifactDescriptorFilePath", "from", "Lorg/availlang/artifact/ArtifactDescriptor;", "bytes", "", "avail-artifact"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ArtifactDescriptor from(@NotNull byte[] bytes) {
            int version;
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            if (bytes.length != 12) {
                throw new AvailArtifactException("Expected the `artifact-descriptor` file to have exactly 12 bytes: 4-byte int for package type ordinal, 4-byte int for artifact version, 4-byte int for manifest file version.");
            }
            ByteBuffer descriptorBytes = ByteBuffer.wrap(bytes);
            int typeOrdinal = descriptorBytes.getInt();
            if (!PackageType.Companion.checkOrdinal(typeOrdinal)) {
                throw new AvailArtifactException("Expected the `artifact-descriptor` file to have a valid package type ordinal value: received " + typeOrdinal + " but a valid ordianl is in the range [0, " + PackageType.values().length + ")");
            }
            PackageType packageType = PackageType.values()[typeOrdinal];
            if (!packageType.isValidVersion(version = descriptorBytes.getInt())) {
                throw new AvailArtifactException("Expected the `artifact-descriptor` file to have a valid package version: received " + version + " but a valid version for a " + packageType + " is in the range [0, " + packageType.getCurrentVersion() + "]");
            }
            int manifestVersion = descriptorBytes.getInt();
            if (!AvailArtifactManifest.Companion.isValidVersion(manifestVersion)) {
                throw new AvailArtifactException("Expected the `artifact-descriptor` file to have a valid manifest version: received " + manifestVersion + " but a valid version for is in the range [0, 1]");
            }
            return new ArtifactDescriptor(packageType, version, manifestVersion);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

