/*
 * Decompiled with CFR 0.152.
 */
package org.availlang.artifact.environment.project;

import java.awt.Color;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.availlang.json.JSONData;
import org.availlang.json.JSONFriendly;
import org.availlang.json.JSONObject;
import org.availlang.json.JSONWriter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B-\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u0012\u0010\r\u001a\u00020\u000b8\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\fR\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\t\u00a8\u0006\u0016"}, d2={"Lorg/availlang/artifact/environment/project/Palette;", "Lorg/availlang/json/JSONFriendly;", "lightColors", "", "", "Ljava/awt/Color;", "darkColors", "(Ljava/util/Map;Ljava/util/Map;)V", "getDarkColors", "()Ljava/util/Map;", "isEmpty", "", "()Z", "isNotEmpty", "getLightColors", "hex", "name", "writeTo", "", "writer", "Lorg/availlang/json/JSONWriter;", "Companion", "avail-artifact"})
public final class Palette
implements JSONFriendly {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Color> lightColors;
    @NotNull
    private final Map<String, Color> darkColors;
    @NotNull
    private static final Palette empty = new Palette(MapsKt.emptyMap(), MapsKt.emptyMap());

    public Palette(@NotNull Map<String, ? extends Color> lightColors, @NotNull Map<String, ? extends Color> darkColors) {
        Intrinsics.checkNotNullParameter(lightColors, (String)"lightColors");
        Intrinsics.checkNotNullParameter(darkColors, (String)"darkColors");
        this.lightColors = lightColors;
        this.darkColors = darkColors;
        boolean bl = Intrinsics.areEqual(this.lightColors.keySet(), this.darkColors.keySet());
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "light and dark maps have different keys";
            throw new AssertionError((Object)string);
        }
    }

    @NotNull
    public final Map<String, Color> getLightColors() {
        return this.lightColors;
    }

    @NotNull
    public final Map<String, Color> getDarkColors() {
        return this.darkColors;
    }

    public final boolean isEmpty() {
        return this.lightColors.isEmpty();
    }

    public final boolean isNotEmpty() {
        boolean $i$f$isNotEmpty = false;
        return !this.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(@NotNull JSONWriter writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        JSONWriter this_$iv = writer;
        boolean $i$f$writeObject = false;
        this_$iv.startObject();
        try {
            JSONWriter $this$writeTo_u24lambda_u243 = this_$iv;
            boolean bl = false;
            Iterable $this$forEach$iv = this.lightColors.keySet();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl2 = false;
                JSONWriter this_$iv2 = $this$writeTo_u24lambda_u243;
                boolean $i$f$at = false;
                this_$iv2.write(it);
                JSONWriter $this$writeTo_u24lambda_u243_u24lambda_u242_u24lambda_u241 = this_$iv2;
                boolean bl3 = false;
                $this$writeTo_u24lambda_u243_u24lambda_u242_u24lambda_u241.write(this.hex(it));
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.endObject();
        }
    }

    private final String hex(String name) {
        Color color;
        StringBuilder stringBuilder;
        int n = 18;
        StringBuilder $this$hex_u24lambda_u246 = stringBuilder = new StringBuilder(n);
        boolean bl = false;
        $this$hex_u24lambda_u246.append('#');
        Color color2 = this.lightColors.get(name);
        Intrinsics.checkNotNull((Object)color2);
        Color $this$hex_u24lambda_u246_u24lambda_u244 = color = color2;
        boolean bl2 = false;
        String string = "%02X";
        Object[] objectArray = new Object[]{$this$hex_u24lambda_u246_u24lambda_u244.getRed()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
        $this$hex_u24lambda_u246.append(string2);
        string = "%02X";
        objectArray = new Object[]{$this$hex_u24lambda_u246_u24lambda_u244.getGreen()};
        String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(this, *args)");
        $this$hex_u24lambda_u246.append(string3);
        string = "%02X";
        objectArray = new Object[]{$this$hex_u24lambda_u246_u24lambda_u244.getBlue()};
        String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(this, *args)");
        $this$hex_u24lambda_u246.append(string4);
        string = "%02X";
        objectArray = new Object[]{$this$hex_u24lambda_u246_u24lambda_u244.getAlpha()};
        String string5 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(this, *args)");
        $this$hex_u24lambda_u246.append(string5);
        $this$hex_u24lambda_u246.append('/');
        Color color3 = this.darkColors.get(name);
        Intrinsics.checkNotNull((Object)color3);
        Color $this$hex_u24lambda_u246_u24lambda_u245 = color = color3;
        boolean bl3 = false;
        string = "%02X";
        objectArray = new Object[]{$this$hex_u24lambda_u246_u24lambda_u245.getRed()};
        String string6 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(this, *args)");
        $this$hex_u24lambda_u246.append(string6);
        string = "%02X";
        objectArray = new Object[]{$this$hex_u24lambda_u246_u24lambda_u245.getGreen()};
        String string7 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"format(this, *args)");
        $this$hex_u24lambda_u246.append(string7);
        string = "%02X";
        objectArray = new Object[]{$this$hex_u24lambda_u246_u24lambda_u245.getBlue()};
        String string8 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"format(this, *args)");
        $this$hex_u24lambda_u246.append(string8);
        string = "%02X";
        objectArray = new Object[]{$this$hex_u24lambda_u246_u24lambda_u245.getAlpha()};
        String string9 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"format(this, *args)");
        $this$hex_u24lambda_u246.append(string9);
        String string10 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"StringBuilder(capacity).\u2026builderAction).toString()");
        return string10;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lorg/availlang/artifact/environment/project/Palette$Companion;", "", "()V", "empty", "Lorg/availlang/artifact/environment/project/Palette;", "getEmpty", "()Lorg/availlang/artifact/environment/project/Palette;", "decodeColor", "Ljava/awt/Color;", "hex", "", "decodeColors", "Lkotlin/Pair;", "from", "data", "Lorg/availlang/json/JSONObject;", "avail-artifact"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Palette getEmpty() {
            return empty;
        }

        @NotNull
        public final Palette from(@NotNull JSONObject data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Map lightColors = new LinkedHashMap();
            Map darkColors = new LinkedHashMap();
            Iterable $this$forEach$iv = (Iterable)data;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry entry = (Map.Entry)element$iv;
                boolean bl = false;
                String name = (String)entry.getKey();
                JSONData value = (JSONData)entry.getValue();
                Pair<Color, Color> colors = Companion.decodeColors(value.getString());
                lightColors.put(name, colors.getFirst());
                darkColors.put(name, colors.getSecond());
            }
            return new Palette(lightColors, darkColors);
        }

        private final Pair<Color, Color> decodeColors(String hex2) {
            Object object;
            Color light;
            block3: {
                block2: {
                    String string = hex2.substring(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                    char[] cArray = new char[]{'/'};
                    List values = StringsKt.split$default((CharSequence)string, (char[])cArray, (boolean)false, (int)0, (int)6, null);
                    light = this.decodeColor((String)values.get(0));
                    object = (String)CollectionsKt.getOrNull((List)values, (int)1);
                    if (object == null) break block2;
                    String it = object;
                    boolean bl = false;
                    Color color = Companion.decodeColor(it);
                    object = color;
                    if (color != null) break block3;
                }
                object = light;
            }
            Object dark = object;
            return TuplesKt.to((Object)light, (Object)dark);
        }

        private final Color decodeColor(String hex2) {
            int r = Integer.parseInt(StringsKt.substring((String)hex2, (IntRange)new IntRange(0, 1)), CharsKt.checkRadix((int)16));
            int g = Integer.parseInt(StringsKt.substring((String)hex2, (IntRange)new IntRange(2, 3)), CharsKt.checkRadix((int)16));
            int b = Integer.parseInt(StringsKt.substring((String)hex2, (IntRange)new IntRange(4, 5)), CharsKt.checkRadix((int)16));
            int a = hex2.length() == 8 ? Integer.parseInt(StringsKt.substring((String)hex2, (IntRange)new IntRange(6, 7)), CharsKt.checkRadix((int)16)) : 255;
            return new Color(r, g, b, a);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

