/*
 * Decompiled with CFR 0.152.
 */
package org.availlang.artifact.jar;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.availlang.artifact.AvailArtifact;
import org.availlang.artifact.AvailArtifactException;
import org.availlang.artifact.DigestUtility;
import org.availlang.artifact.PackageType;
import org.availlang.artifact.UtilityKt;
import org.availlang.artifact.environment.location.Scheme;
import org.availlang.artifact.manifest.AvailArtifactManifest;
import org.availlang.artifact.roots.AvailRoot;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0003J\u000e\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0003H\u0002J\u0006\u0010\"\u001a\u00020\u0011R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/availlang/artifact/jar/AvailArtifactJarBuilder;", "", "outputLocation", "", "implementationVersion", "implementationTitle", "availArtifactManifest", "Lorg/availlang/artifact/manifest/AvailArtifactManifest;", "jarManifestMainClass", "customManifestItems", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/availlang/artifact/manifest/AvailArtifactManifest;Ljava/lang/String;Ljava/util/Map;)V", "added", "", "jarOutputStream", "Ljava/util/jar/JarOutputStream;", "addDir", "", "dir", "Ljava/io/File;", "addFile", "file", "targetDirectory", "addJar", "jarFile", "Ljava/util/jar/JarFile;", "addRoot", "targetRoot", "Lorg/availlang/artifact/roots/AvailRoot;", "addZip", "zipFile", "Ljava/util/zip/ZipFile;", "canonicalizePath", "path", "finish", "avail-artifact"})
public final class AvailArtifactJarBuilder {
    @NotNull
    private final String outputLocation;
    @NotNull
    private final String implementationVersion;
    @NotNull
    private final String implementationTitle;
    @NotNull
    private final AvailArtifactManifest availArtifactManifest;
    @NotNull
    private final String jarManifestMainClass;
    @NotNull
    private final Map<String, String> customManifestItems;
    @NotNull
    private final JarOutputStream jarOutputStream;
    @NotNull
    private final Set<String> added;

    public AvailArtifactJarBuilder(@NotNull String outputLocation, @NotNull String implementationVersion, @NotNull String implementationTitle, @NotNull AvailArtifactManifest availArtifactManifest, @NotNull String jarManifestMainClass, @NotNull Map<String, String> customManifestItems) {
        Intrinsics.checkNotNullParameter((Object)outputLocation, (String)"outputLocation");
        Intrinsics.checkNotNullParameter((Object)implementationVersion, (String)"implementationVersion");
        Intrinsics.checkNotNullParameter((Object)implementationTitle, (String)"implementationTitle");
        Intrinsics.checkNotNullParameter((Object)availArtifactManifest, (String)"availArtifactManifest");
        Intrinsics.checkNotNullParameter((Object)jarManifestMainClass, (String)"jarManifestMainClass");
        Intrinsics.checkNotNullParameter(customManifestItems, (String)"customManifestItems");
        this.outputLocation = outputLocation;
        this.implementationVersion = implementationVersion;
        this.implementationTitle = implementationTitle;
        this.availArtifactManifest = availArtifactManifest;
        this.jarManifestMainClass = jarManifestMainClass;
        this.customManifestItems = customManifestItems;
        this.added = new LinkedHashSet();
        Manifest manifest2 = new Manifest();
        Attributes attributes = manifest2.getMainAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)attributes, (String)"manifest.mainAttributes");
        Map map = attributes;
        Attributes.Name name = Attributes.Name.MANIFEST_VERSION;
        Object object = "1.0";
        map.put(name, object);
        Attributes attributes2 = manifest2.getMainAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)attributes2, (String)"manifest.mainAttributes");
        map = attributes2;
        name = new Attributes.Name("Build-Time");
        object = UtilityKt.getFormattedNow();
        map.put(name, object);
        Attributes attributes3 = manifest2.getMainAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)attributes3, (String)"manifest.mainAttributes");
        map = attributes3;
        name = Attributes.Name.IMPLEMENTATION_VERSION;
        object = this.implementationVersion;
        map.put(name, object);
        Attributes attributes4 = manifest2.getMainAttributes();
        Intrinsics.checkNotNullExpressionValue((Object)attributes4, (String)"manifest.mainAttributes");
        map = attributes4;
        name = Attributes.Name.IMPLEMENTATION_TITLE;
        object = this.implementationTitle;
        map.put(name, object);
        Map<String, String> $this$forEach$iv = this.customManifestItems;
        boolean $i$f$forEach = false;
        object = $this$forEach$iv.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = (Map.Entry)object.next();
            boolean bl = false;
            String k = (String)entry.getKey();
            String v = (String)entry.getValue();
            Attributes attributes5 = manifest2.getMainAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)attributes5, (String)"manifest.mainAttributes");
            Map map2 = attributes5;
            map2.put(new Attributes.Name(k), v);
        }
        if (((CharSequence)this.jarManifestMainClass).length() > 0) {
            Attributes attributes6 = manifest2.getMainAttributes();
            Intrinsics.checkNotNullExpressionValue((Object)attributes6, (String)"manifest.mainAttributes");
            map = attributes6;
            Attributes.Name name2 = Attributes.Name.MAIN_CLASS;
            object = this.jarManifestMainClass;
            map.put(name2, object);
        }
        this.jarOutputStream = new JarOutputStream((OutputStream)new FileOutputStream(this.outputLocation), manifest2);
        this.jarOutputStream.putNextEntry(new JarEntry("META-INF/"));
        this.jarOutputStream.closeEntry();
        this.added.add("META-INF/");
        this.jarOutputStream.putNextEntry(new JarEntry("avail-artifact-contents/"));
        this.jarOutputStream.closeEntry();
        this.added.add("avail-artifact-contents/");
        this.jarOutputStream.putNextEntry(new JarEntry("avail-artifact-contents/artifact-descriptor"));
        this.jarOutputStream.write(PackageType.JAR.getArtifactDescriptor().getSerializedFileContent());
        this.jarOutputStream.closeEntry();
        this.added.add("avail-artifact-contents/artifact-descriptor");
    }

    public /* synthetic */ AvailArtifactJarBuilder(String string, String string2, String string3, AvailArtifactManifest availArtifactManifest, String string4, Map map, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            string4 = "";
        }
        if ((n & 0x20) != 0) {
            map = MapsKt.emptyMap();
        }
        this(string, string2, string3, availArtifactManifest, string4, map);
    }

    private final String canonicalizePath(String path) {
        return StringsKt.replace$default((String)path, (String)"\\", (String)"/", (boolean)false, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void addRoot(@NotNull AvailRoot targetRoot) {
        void $this$forEach$iv;
        Intrinsics.checkNotNullParameter((Object)targetRoot, (String)"targetRoot");
        String rootPath = StringsKt.removePrefix((String)targetRoot.getAbsolutePath(), (CharSequence)Scheme.JAR.getPrefix());
        File root = new File(rootPath);
        if (!root.isDirectory()) {
            if (StringsKt.endsWith$default((String)rootPath, (String)"jar", (boolean)false, (int)2, null)) {
                this.addJar(new JarFile(root));
                return;
            }
            throw new AvailArtifactException("Failed to add module root, " + targetRoot.getName() + "; provided root path, " + rootPath + ", is not a directory");
        }
        String rootEntryName = this.canonicalizePath("avail-artifact-contents/" + targetRoot.getName() + "/");
        this.jarOutputStream.putNextEntry(new JarEntry(rootEntryName));
        this.added.add(rootEntryName);
        this.jarOutputStream.closeEntry();
        String sourceDirPrefix = AvailArtifact.Companion.rootArtifactSourcesDir(targetRoot.getName());
        Sequence sequence = (Sequence)FilesKt.walk$default((File)root, null, (int)1, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File file = (File)element$iv;
            boolean bl = false;
            String string = file.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.absolutePath");
            String pathRelativeName = this.canonicalizePath(sourceDirPrefix + StringsKt.removePrefix((String)string, (CharSequence)rootPath) + (file.isDirectory() ? "/" : ""));
            this.jarOutputStream.putNextEntry(new JarEntry(pathRelativeName));
            this.added.add(pathRelativeName);
            if (file.isFile()) {
                byte[] fileBytes = FilesKt.readBytes((File)file);
                this.jarOutputStream.write(fileBytes);
            }
            this.jarOutputStream.closeEntry();
        }
        String entryName = this.canonicalizePath(AvailArtifact.Companion.rootArtifactDigestDirPath(targetRoot.getName()) + "/Avail-Digests/");
        this.jarOutputStream.putNextEntry(new JarEntry(entryName));
        this.added.add(entryName);
        this.jarOutputStream.closeEntry();
        String digestFileName = AvailArtifact.Companion.rootArtifactDigestFilePath(targetRoot.getName());
        String digest = DigestUtility.INSTANCE.createDigest(rootPath, targetRoot.getDigestAlgorithm());
        this.jarOutputStream.putNextEntry(new JarEntry(digestFileName));
        byte[] byArray = digest.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        this.jarOutputStream.write(byArray);
        this.added.add(digestFileName);
        this.jarOutputStream.closeEntry();
    }

    /*
     * Unable to fully structure code
     */
    public final void addJar(@NotNull JarFile jarFile) {
        Intrinsics.checkNotNullParameter((Object)jarFile, (String)"jarFile");
        jarSimpleName = new File(jarFile.getName()).getName();
        v0 = jarFile.entries().asIterator();
        Intrinsics.checkNotNullExpressionValue(v0, (String)"jarFile.entries().asIterator()");
        $this$forEach$iv = v0;
        $i$f$forEach = false;
        var5_5 = $this$forEach$iv;
        while (var5_5.hasNext()) {
            it = element$iv = var5_5.next();
            $i$a$-forEach-AvailArtifactJarBuilder$addJar$1 = false;
            var9_9 = it.getName();
            if (var9_9 == null) ** GOTO lbl-1000
            tmp = -1;
            switch (var9_9.hashCode()) {
                case -893091530: {
                    if (var9_9.equals("avail-artifact-contents/avail-artifact-manifest.txt")) {
                        tmp = 1;
                    }
                    break;
                }
                case -770367560: {
                    if (var9_9.equals("avail-artifact-contents/")) {
                        tmp = 2;
                    }
                    break;
                }
                case 1700358998: {
                    if (var9_9.equals("META-INF/")) {
                        tmp = 2;
                    }
                    break;
                }
                case 1539143842: {
                    if (var9_9.equals("META-INF/MANIFEST.MF")) {
                        tmp = 3;
                    }
                    break;
                }
                case 1016944530: {
                    if (var9_9.equals("avail-artifact-contents/artifact-descriptor")) {
                        tmp = 4;
                    }
                    break;
                }
            }
            switch (tmp) {
                case 3: {
                    adjustedManifest = "META-INF/" + jarSimpleName + "/MANIFEST.MF";
                    this.jarOutputStream.putNextEntry(new JarEntry(adjustedManifest));
                    this.added.add(adjustedManifest);
                    bytes = new byte[(int)it.getSize()];
                    stream = new DataInputStream(new BufferedInputStream(jarFile.getInputStream(it), (int)it.getSize()));
                    stream.readFully(bytes);
                    this.jarOutputStream.write(bytes);
                    this.jarOutputStream.closeEntry();
                    break;
                }
                case 4: {
                    adjustedDescriptor = this.canonicalizePath("avail-artifact-contents/" + jarSimpleName + "/artifact-descriptor");
                    this.jarOutputStream.putNextEntry(new JarEntry(adjustedDescriptor));
                    this.added.add(adjustedDescriptor);
                    bytes = new byte[(int)it.getSize()];
                    stream = new DataInputStream(new BufferedInputStream(jarFile.getInputStream(it), (int)it.getSize()));
                    stream.readFully(bytes);
                    this.jarOutputStream.write(bytes);
                    this.jarOutputStream.closeEntry();
                    break;
                }
                case 1: {
                    adjustedAvailManifest = this.canonicalizePath("avail-artifact-contents/" + jarSimpleName + "/avail-artifact-manifest.txt");
                    entry = new JarEntry(adjustedAvailManifest);
                    this.jarOutputStream.putNextEntry(entry);
                    this.added.add(adjustedAvailManifest);
                    bytes = new byte[(int)it.getSize()];
                    stream = new DataInputStream(new BufferedInputStream(jarFile.getInputStream(it), (int)it.getSize()));
                    stream.readFully(bytes);
                    this.jarOutputStream.write(bytes);
                    this.jarOutputStream.closeEntry();
                    break;
                }
                default: lbl-1000:
                // 2 sources

                {
                    if (this.added.contains(it.getName())) break;
                    this.jarOutputStream.putNextEntry(new JarEntry(it));
                    if (it.getSize() > 0L) {
                        bytes = new byte[(int)it.getSize()];
                        stream = new DataInputStream(new BufferedInputStream(jarFile.getInputStream(it), (int)it.getSize()));
                        stream.readFully(bytes);
                        this.jarOutputStream.write(bytes);
                    }
                    v1 = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it.name");
                    this.added.add(v1);
                    this.jarOutputStream.closeEntry();
                }
                case 2: 
            }
        }
    }

    public final void addZip(@NotNull ZipFile zipFile) {
        Intrinsics.checkNotNullParameter((Object)zipFile, (String)"zipFile");
        Iterator<? extends ZipEntry> iterator = zipFile.entries().asIterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"zipFile.entries().asIterator()");
        Iterator<? extends ZipEntry> $this$forEach$iv = iterator;
        boolean $i$f$forEach = false;
        Iterator<? extends ZipEntry> iterator2 = $this$forEach$iv;
        while (iterator2.hasNext()) {
            ZipEntry element$iv;
            ZipEntry it = element$iv = iterator2.next();
            boolean bl = false;
            String string = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
            if (this.added.add(string)) continue;
            this.jarOutputStream.putNextEntry(new JarEntry(it));
            if (it.getSize() > 0L) {
                byte[] bytes = new byte[(int)it.getSize()];
                DataInputStream stream = new DataInputStream(new BufferedInputStream(zipFile.getInputStream(it), (int)it.getSize()));
                stream.readFully(bytes);
                this.jarOutputStream.write(bytes);
            }
            this.jarOutputStream.closeEntry();
        }
    }

    public final void addFile(@NotNull File file, @NotNull String targetDirectory) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)targetDirectory, (String)"targetDirectory");
        if (!(!file.isDirectory())) {
            boolean $i$a$-require-AvailArtifactJarBuilder$addFile$22 = false;
            String $i$a$-require-AvailArtifactJarBuilder$addFile$22 = "Expected " + file + " to be a file not a directory!";
            throw new IllegalArgumentException($i$a$-require-AvailArtifactJarBuilder$addFile$22.toString());
        }
        String pathRelativeName = this.canonicalizePath(targetDirectory + "/" + file.getName());
        if (!this.added.add(pathRelativeName)) {
            this.jarOutputStream.putNextEntry(new JarEntry(pathRelativeName));
            if (file.isFile()) {
                byte[] fileBytes = FilesKt.readBytes((File)file);
                this.jarOutputStream.write(fileBytes);
            }
            this.jarOutputStream.closeEntry();
        }
    }

    public final void addDir(@NotNull File dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        if (!dir.isDirectory()) {
            boolean $i$a$-require-AvailArtifactJarBuilder$addDir$22 = false;
            String $i$a$-require-AvailArtifactJarBuilder$addDir$22 = "Expected " + dir + " to be a directory!";
            throw new IllegalArgumentException($i$a$-require-AvailArtifactJarBuilder$addDir$22.toString());
        }
        Sequence $this$forEach$iv = (Sequence)FilesKt.walk$default((File)dir, null, (int)1, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File file = (File)element$iv;
            boolean bl = false;
            String string = dir.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dir.name");
            this.addFile(file, string);
        }
    }

    public final void finish() {
        this.jarOutputStream.putNextEntry(new JarEntry("avail-artifact-contents/avail-artifact-manifest.txt"));
        byte[] byArray = this.availArtifactManifest.getFileContent().getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        this.jarOutputStream.write(byArray);
        this.added.add("avail-artifact-contents/avail-artifact-manifest.txt");
        this.jarOutputStream.closeEntry();
        this.jarOutputStream.finish();
        this.jarOutputStream.flush();
        this.jarOutputStream.close();
    }
}

