/*
 * Decompiled with CFR 0.152.
 */
package org.availlang.artifact.roots;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.availlang.artifact.environment.location.AvailLocation;
import org.availlang.artifact.manifest.AvailRootManifest;
import org.availlang.artifact.roots.AvailModule;
import org.availlang.artifact.roots.AvailModulePackage;
import org.availlang.artifact.roots.AvailRoot;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0006\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tBu\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u0012\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e\u0012\u000e\b\u0002\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e\u0012\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u000b\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\u0013J\u0012\u0010\u001c\u001a\u00020\b2\n\u0010\u001d\u001a\u00060\u001ej\u0002`\u001fJ\u000e\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\u000bJ\u0018\u0010\"\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010#\u001a\u00020\u000bJ\u0018\u0010$\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010#\u001a\u00020\u000bR\u0014\u0010\u0014\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/availlang/artifact/roots/CreateAvailRoot;", "Lorg/availlang/artifact/roots/AvailRoot;", "location", "Lorg/availlang/artifact/environment/location/AvailLocation;", "manifestRoot", "Lorg/availlang/artifact/manifest/AvailRootManifest;", "action", "Lkotlin/Function1;", "", "(Lorg/availlang/artifact/environment/location/AvailLocation;Lorg/availlang/artifact/manifest/AvailRootManifest;Lkotlin/jvm/functions/Function1;)V", "name", "", "digestAlgorithm", "availModuleExtensions", "", "entryPoints", "templates", "", "description", "(Ljava/lang/String;Lorg/availlang/artifact/environment/location/AvailLocation;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/Map;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "configString", "getConfigString", "()Ljava/lang/String;", "modulePackages", "", "Lorg/availlang/artifact/roots/AvailModulePackage;", "modules", "Lorg/availlang/artifact/roots/AvailModule;", "appendRootHierarchy", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "create", "moduleHeaderCommentBody", "module", "extension", "modulePackage", "avail-artifact"})
public final class CreateAvailRoot
extends AvailRoot {
    @NotNull
    private final Set<AvailModule> modules;
    @NotNull
    private final Set<AvailModulePackage> modulePackages;

    public CreateAvailRoot(@NotNull String name, @NotNull AvailLocation location, @NotNull String digestAlgorithm, @NotNull List<String> availModuleExtensions, @NotNull List<String> entryPoints, @NotNull Map<String, String> templates, @NotNull String description, @NotNull Function1<? super AvailRoot, Unit> action) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)digestAlgorithm, (String)"digestAlgorithm");
        Intrinsics.checkNotNullParameter(availModuleExtensions, (String)"availModuleExtensions");
        Intrinsics.checkNotNullParameter(entryPoints, (String)"entryPoints");
        Intrinsics.checkNotNullParameter(templates, (String)"templates");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        super(name, location, digestAlgorithm, availModuleExtensions, entryPoints, templates, description, action);
        this.modules = new LinkedHashSet();
        this.modulePackages = new LinkedHashSet();
    }

    public /* synthetic */ CreateAvailRoot(String string, AvailLocation availLocation, String string2, List list, List list2, Map map, String string3, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string2 = "SHA-256";
        }
        if ((n & 8) != 0) {
            Object[] objectArray = new String[]{"avail"};
            list = CollectionsKt.mutableListOf((Object[])objectArray);
        }
        if ((n & 0x10) != 0) {
            list2 = new ArrayList();
        }
        if ((n & 0x20) != 0) {
            map = new LinkedHashMap();
        }
        if ((n & 0x40) != 0) {
            string3 = "";
        }
        if ((n & 0x80) != 0) {
            function1 = 1.INSTANCE;
        }
        this(string, availLocation, string2, list, list2, map, string3, (Function1<? super AvailRoot, Unit>)function1);
    }

    public CreateAvailRoot(@NotNull AvailLocation location, @NotNull AvailRootManifest manifestRoot, @NotNull Function1<? super AvailRoot, Unit> action) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        Intrinsics.checkNotNullParameter((Object)manifestRoot, (String)"manifestRoot");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this(manifestRoot.getName(), location, manifestRoot.getDigestAlgorithm(), manifestRoot.getAvailModuleExtensions(), manifestRoot.getEntryPoints(), manifestRoot.getTemplates(), manifestRoot.getDescription(), action);
    }

    @Override
    @NotNull
    public String getConfigString() {
        StringBuilder stringBuilder;
        StringBuilder $this$_get_configString__u24lambda_u240 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$_get_configString__u24lambda_u240.append("\n\t\t" + this.getName());
        $this$_get_configString__u24lambda_u240.append("\n\t\t\tRoot Contents:");
        this.appendRootHierarchy($this$_get_configString__u24lambda_u240);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public final AvailModule module(@NotNull String name, @NotNull String extension) {
        AvailModule availModule;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        AvailModule $this$module_u24lambda_u241 = availModule = new AvailModule(name, extension);
        boolean bl = false;
        this.modules.add($this$module_u24lambda_u241);
        return availModule;
    }

    public static /* synthetic */ AvailModule module$default(CreateAvailRoot createAvailRoot, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "avail";
        }
        return createAvailRoot.module(string, string2);
    }

    @NotNull
    public final AvailModulePackage modulePackage(@NotNull String name, @NotNull String extension) {
        AvailModulePackage availModulePackage;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        AvailModulePackage $this$modulePackage_u24lambda_u242 = availModulePackage = new AvailModulePackage(name, extension);
        boolean bl = false;
        this.modulePackages.add($this$modulePackage_u24lambda_u242);
        return availModulePackage;
    }

    public static /* synthetic */ AvailModulePackage modulePackage$default(CreateAvailRoot createAvailRoot, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "avail";
        }
        return createAvailRoot.modulePackage(string, string2);
    }

    public final void create(@NotNull String moduleHeaderCommentBody) {
        AvailModule it;
        Intrinsics.checkNotNullParameter((Object)moduleHeaderCommentBody, (String)"moduleHeaderCommentBody");
        Iterable $this$forEach$iv = this.modulePackages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (AvailModulePackage)element$iv;
            boolean bl = false;
            if (((CharSequence)it.getModuleHeaderCommentBody()).length() == 0 && ((CharSequence)moduleHeaderCommentBody).length() > 0) {
                it.setModuleHeaderCommentBody(moduleHeaderCommentBody);
            }
            ((AvailModulePackage)it).create$avail_artifact(this.getAbsolutePath());
        }
        $this$forEach$iv = this.modules;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (AvailModule)element$iv;
            boolean bl = false;
            it.create$avail_artifact(this.getAbsolutePath());
        }
    }

    public final void appendRootHierarchy(@NotNull StringBuilder sb) {
        AvailModule it;
        Intrinsics.checkNotNullParameter((Object)sb, (String)"sb");
        Iterable $this$forEach$iv = this.modulePackages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (AvailModulePackage)element$iv;
            boolean bl = false;
            ((AvailModulePackage)it).hierarchyPrinter(1, sb);
        }
        $this$forEach$iv = this.modules;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (AvailModule)element$iv;
            boolean bl = false;
            it.hierarchyPrinter(1, sb);
        }
    }
}

