/*
 * Decompiled with CFR 0.152.
 */
package org.availlang.json;

import java.math.BigDecimal;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.availlang.json.JSONData;
import org.availlang.json.JSONWriter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB\r\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001fR\u0014\u0010 \u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006'"}, d2={"Lorg/availlang/json/JSONNumber;", "Lorg/availlang/json/JSONData;", "value", "", "(J)V", "", "(I)V", "", "(D)V", "", "(F)V", "bigDecimal", "Ljava/math/BigDecimal;", "(Ljava/math/BigDecimal;)V", "getBigDecimal", "()Ljava/math/BigDecimal;", "bigInteger", "Ljava/math/BigInteger;", "getBigInteger", "()Ljava/math/BigInteger;", "double", "getDouble", "()D", "float", "getFloat", "()F", "int", "getInt", "()I", "isNumber", "", "()Z", "long", "getLong", "()J", "writeTo", "", "writer", "Lorg/availlang/json/JSONWriter;", "avail-json"})
public final class JSONNumber
extends JSONData {
    @NotNull
    private final BigDecimal bigDecimal;

    public JSONNumber(@NotNull BigDecimal bigDecimal) {
        Intrinsics.checkNotNullParameter((Object)bigDecimal, (String)"bigDecimal");
        this.bigDecimal = bigDecimal;
    }

    @Override
    @NotNull
    public BigDecimal getBigDecimal() {
        return this.bigDecimal;
    }

    @Override
    public boolean isNumber() {
        return true;
    }

    @Override
    @NotNull
    public BigInteger getBigInteger() throws ArithmeticException {
        BigInteger bigInteger = this.getBigDecimal().toBigIntegerExact();
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"bigDecimal.toBigIntegerExact()");
        return bigInteger;
    }

    @Override
    public int getInt() throws ArithmeticException {
        return this.getBigDecimal().intValueExact();
    }

    @Override
    public long getLong() throws ArithmeticException {
        return this.getBigDecimal().longValueExact();
    }

    @Override
    public float getFloat() {
        return this.getBigDecimal().floatValue();
    }

    @Override
    public double getDouble() {
        return this.getBigDecimal().doubleValue();
    }

    public JSONNumber(long value) {
        this(new BigDecimal(value));
    }

    public JSONNumber(int value) {
        this(new BigDecimal(value));
    }

    public JSONNumber(double value) {
        this(new BigDecimal(value));
    }

    public JSONNumber(float value) {
        this(new BigDecimal(value));
    }

    @Override
    public void writeTo(@NotNull JSONWriter writer) {
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        writer.write(this.getBigDecimal());
    }
}

