/*
 * Decompiled with CFR 0.152.
 */
package org.availlang.json;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.nio.charset.MalformedInputException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.availlang.json.JSONArray;
import org.availlang.json.JSONData;
import org.availlang.json.JSONException;
import org.availlang.json.JSONIOException;
import org.availlang.json.JSONNull;
import org.availlang.json.JSONNumber;
import org.availlang.json.JSONObject;
import org.availlang.json.JSONValue;
import org.availlang.json.MalformedJSONException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0002J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u000e\u0010\f\u001a\n\u0018\u00010\rj\u0004\u0018\u0001`\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\n2\u000e\u0010\f\u001a\n\u0018\u00010\rj\u0004\u0018\u0001`\u000eH\u0002J\u0018\u0010\u0010\u001a\u00020\n2\u000e\u0010\f\u001a\n\u0018\u00010\rj\u0004\u0018\u0001`\u000eH\u0002J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0006\u0010\u0014\u001a\u00020\u0015J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\bH\u0002J\b\u0010\u0019\u001a\u00020\u0015H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u0013H\u0002J\b\u0010\u001f\u001a\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/availlang/json/JSONReader;", "Ljava/io/Closeable;", "reader", "Ljava/io/Reader;", "(Ljava/io/Reader;)V", "close", "", "peekCodePoint", "", "peekFor", "", "codePoint", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "peekForDigit", "peekForHexDigit", "peekForKeyword", "keyword", "", "read", "Lorg/availlang/json/JSONData;", "readArray", "Lorg/availlang/json/JSONArray;", "readCodePoint", "readData", "readNumber", "Lorg/availlang/json/JSONNumber;", "readObject", "Lorg/availlang/json/JSONObject;", "readString", "skipWhitespace", "avail-json"})
public final class JSONReader
implements Closeable {
    @NotNull
    private final Reader reader;

    public JSONReader(@NotNull Reader reader) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        this.reader = reader;
        if (!this.reader.markSupported()) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    private final int readCodePoint() throws IOException {
        boolean bl;
        int next = this.reader.read();
        if (next == -1) {
            return -1;
        }
        boolean bl2 = bl = (next & 0xFFFF) == next;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        char high = (char)next;
        if (Character.isSurrogate(high)) {
            boolean bl3;
            next = this.reader.read();
            if (next == -1) {
                throw new MalformedInputException(1);
            }
            boolean bl4 = bl3 = (next & 0xFFFF) == next;
            if (_Assertions.ENABLED && !bl3) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            char low = (char)next;
            if (!Character.isSurrogate(low)) {
                throw new MalformedInputException(1);
            }
            return Character.toCodePoint(high, low);
        }
        return high;
    }

    private final int peekCodePoint() throws IOException {
        this.reader.mark(2);
        int next = this.readCodePoint();
        this.reader.reset();
        return next;
    }

    private final void skipWhitespace() throws IOException {
        int n;
        do {
            this.reader.mark(2);
        } while ((((n = this.readCodePoint()) == 32 ? true : n == 9) ? true : n == 10) ? true : n == 13);
        this.reader.reset();
    }

    private final boolean peekForDigit(StringBuilder builder) throws IOException {
        this.reader.mark(2);
        int codePoint = this.readCodePoint();
        if (Character.getType(codePoint) == 9) {
            StringBuilder stringBuilder = builder;
            if (stringBuilder != null) {
                stringBuilder.appendCodePoint(codePoint);
            }
            return true;
        }
        this.reader.reset();
        return false;
    }

    private final boolean peekForHexDigit(StringBuilder builder) throws IOException {
        this.reader.mark(2);
        int codePoint = this.readCodePoint();
        if (Character.getType(codePoint) == 9) {
            StringBuilder stringBuilder = builder;
            if (stringBuilder != null) {
                stringBuilder.appendCodePoint(codePoint);
            }
            return true;
        }
        int n = codePoint;
        if (((((((((((n == 65 ? true : n == 66) ? true : n == 67) ? true : n == 68) ? true : n == 69) ? true : n == 70) ? true : n == 97) ? true : n == 98) ? true : n == 99) ? true : n == 100) ? true : n == 101) ? true : n == 102) {
            StringBuilder stringBuilder = builder;
            if (stringBuilder != null) {
                stringBuilder.appendCodePoint(codePoint);
            }
            return true;
        }
        this.reader.reset();
        return false;
    }

    private final boolean peekFor(int codePoint, StringBuilder builder) throws IOException {
        this.reader.mark(2);
        int next = this.readCodePoint();
        if (next == codePoint) {
            StringBuilder stringBuilder = builder;
            if (stringBuilder != null) {
                stringBuilder.appendCodePoint(codePoint);
            }
            return true;
        }
        this.reader.reset();
        return false;
    }

    private final boolean peekForKeyword(String keyword) throws IOException {
        int size = keyword.length();
        this.reader.mark(size);
        int codePoint = 0;
        for (int i = 0; i < size; i += Character.charCount(codePoint)) {
            int expected = keyword.codePointAt(i);
            codePoint = this.readCodePoint();
            if (codePoint == expected) continue;
            this.reader.reset();
            return false;
        }
        return true;
    }

    private final JSONNumber readNumber() throws IOException {
        StringBuilder builder = new StringBuilder();
        this.peekFor(45, builder);
        while (this.peekForDigit(builder)) {
        }
        if (this.peekFor(46, builder)) {
            while (this.peekForDigit(builder)) {
            }
        }
        if (this.peekFor(101, builder) || this.peekFor(69, builder)) {
            if (!this.peekFor(45, builder)) {
                this.peekFor(43, builder);
            }
            while (this.peekForDigit(builder)) {
            }
        }
        return new JSONNumber(new BigDecimal(builder.toString()));
    }

    private final String readString() throws IOException, MalformedJSONException {
        this.peekFor(34, null);
        StringBuilder builder = new StringBuilder();
        while (!this.peekFor(34, null)) {
            int codePoint;
            if (this.peekFor(92, null)) {
                codePoint = this.readCodePoint();
                if (codePoint == 34) {
                    builder.append('\"');
                    continue;
                }
                if (codePoint == 92) {
                    builder.append('\\');
                    continue;
                }
                if (codePoint == 47) {
                    builder.append('/');
                    continue;
                }
                if (codePoint == 98) {
                    builder.append('\b');
                    continue;
                }
                if (codePoint == 102) {
                    builder.append("\\f");
                    continue;
                }
                if (codePoint == 110) {
                    builder.append('\n');
                    continue;
                }
                if (codePoint == 114) {
                    builder.append('\r');
                    continue;
                }
                if (codePoint == 116) {
                    builder.append('\t');
                    continue;
                }
                if (codePoint == 117) {
                    StringBuilder hex = new StringBuilder(4);
                    for (int i = 0; i < 4; ++i) {
                        if (this.peekForHexDigit(hex)) continue;
                        int bad = this.peekCodePoint();
                        throw new MalformedInputException(Character.charCount(bad));
                    }
                    builder.appendCodePoint(Integer.parseInt(hex.toString(), 16));
                    continue;
                }
                throw new MalformedInputException(Character.charCount(codePoint));
            }
            codePoint = this.readCodePoint();
            if (codePoint == -1) {
                throw new MalformedJSONException("Ran out of data while reading a String.");
            }
            if (codePoint <= 31) {
                throw new MalformedInputException(Character.charCount(codePoint));
            }
            builder.appendCodePoint(codePoint);
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    private final JSONArray readArray() throws IOException, MalformedJSONException {
        this.peekFor(91, null);
        this.skipWhitespace();
        if (this.peekFor(93, null)) {
            return JSONArray.Companion.empty$avail_json();
        }
        LinkedList<JSONData> list = new LinkedList<JSONData>();
        do {
            list.add(this.readData());
            this.skipWhitespace();
        } while (this.peekFor(44, null));
        if (!this.peekFor(93, null)) {
            throw new MalformedJSONException("Array not properly closed expected codepoint " + 91 + " (']'), but got " + this.peekCodePoint() + ".");
        }
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        JSONData[] jSONDataArray = thisCollection$iv.toArray(new JSONData[0]);
        if (jSONDataArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        return new JSONArray(jSONDataArray);
    }

    private final JSONObject readObject() throws IOException, MalformedJSONException {
        this.peekFor(123, null);
        this.skipWhitespace();
        if (this.peekFor(125, null)) {
            return JSONObject.Companion.getEmpty();
        }
        Map map = new LinkedHashMap();
        do {
            this.skipWhitespace();
            String key = this.readString();
            this.skipWhitespace();
            if (!this.peekFor(58, null)) {
                throw new MalformedJSONException("Attempted to read a key-value pair from an object but no colon ':' (" + 58 + ") was found after key name was read.");
            }
            JSONData value = this.readData();
            map.put(key, value);
            this.skipWhitespace();
        } while (this.peekFor(44, null));
        if (!this.peekFor(125, null)) {
            throw new MalformedJSONException("Object not properly closed expected codepoint " + 125 + " ('}'), but got " + this.peekCodePoint() + ".");
        }
        return new JSONObject(map);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final JSONData readData() throws IOException, MalformedJSONException {
        this.skipWhitespace();
        int firstCodePoint = this.peekCodePoint();
        JSONData data = null;
        int n = firstCodePoint;
        if (n == -1) {
            return JSONNull.INSTANCE;
        }
        if ((((((((((n == 45 ? true : n == 48) ? true : n == 49) ? true : n == 50) ? true : n == 51) ? true : n == 52) ? true : n == 53) ? true : n == 54) ? true : n == 55) ? true : n == 56) ? true : n == 57) {
            return this.readNumber();
        }
        if (n == 34) {
            return new JSONValue(this.readString());
        }
        if (n == 91) {
            return this.readArray();
        }
        if (n == 123) {
            return this.readObject();
        }
        if (n == 102) {
            if (!this.peekForKeyword("false")) throw new MalformedJSONException("Attempted to read a field value that started with codepoint " + 102 + " ('f') which implies boolean value 'false' but text 'false' was not read.");
            return JSONValue.Companion.getJsonFalse();
        }
        if (n == 110) {
            if (!this.peekForKeyword("null")) throw new MalformedJSONException("Attempted to read a field value that started with codepoint " + 110 + " ('n') which implies 'null' value but text 'null' was not read.");
            return JSONNull.INSTANCE;
        }
        if (n != 116) throw new MalformedJSONException("Attempted to read a field value but the field did not start with a valid character, started with codepoint, " + firstCodePoint + ".");
        if (!this.peekForKeyword("true")) throw new MalformedJSONException("Attempted to read a field value that started with codepoint " + 102 + " ('t') which implies boolean value 'true' but text 'true' was not read.");
        return JSONValue.Companion.getJsonTrue();
    }

    @NotNull
    public final JSONData read() throws JSONException {
        try {
            JSONData data = this.readData();
            this.skipWhitespace();
            int codePoint = this.readCodePoint();
            if (codePoint != -1) {
                throw new MalformedJSONException("Incomplete JSON: No more data available");
            }
            return data;
        }
        catch (IOException e) {
            throw new JSONIOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

