/*
 * Decompiled with CFR 0.152.
 */
package avail.builder;

import avail.builder.AvailBuilder;
import avail.builder.GraphTracer;
import avail.builder.ResolvedModuleName;
import avail.io.IOSystem;
import avail.io.SimpleCompletionHandler;
import avail.utility.Graph;
import avail.utility.Strings;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002J$\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\u0013H\u0002J\u0006\u0010\u0015\u001a\u00020\u0011R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lavail/builder/GraphTracer;", "", "availBuilder", "Lavail/builder/AvailBuilder;", "targetModule", "Lavail/builder/ResolvedModuleName;", "outputFile", "Ljava/io/File;", "(Lavail/builder/AvailBuilder;Lavail/builder/ResolvedModuleName;Ljava/io/File;)V", "allocatedNames", "", "", "encounteredNames", "", "asNodeName", "input", "renderGraph", "", "reducedGraph", "Lavail/utility/Graph;", "spanningDag", "traceGraph", "avail"})
public final class GraphTracer {
    @NotNull
    private final AvailBuilder availBuilder;
    @NotNull
    private final ResolvedModuleName targetModule;
    @NotNull
    private final File outputFile;
    @NotNull
    private final Map<String, String> encounteredNames;
    @NotNull
    private final Set<String> allocatedNames;

    public GraphTracer(@NotNull AvailBuilder availBuilder, @NotNull ResolvedModuleName targetModule, @NotNull File outputFile) {
        Intrinsics.checkNotNullParameter((Object)availBuilder, (String)"availBuilder");
        Intrinsics.checkNotNullParameter((Object)targetModule, (String)"targetModule");
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        this.availBuilder = availBuilder;
        this.targetModule = targetModule;
        this.outputFile = outputFile;
        this.encounteredNames = new LinkedHashMap();
        this.allocatedNames = new LinkedHashSet();
    }

    public final void traceGraph() {
        if (!this.availBuilder.getShouldStopBuild()) {
            Graph<ResolvedModuleName> ancestry = this.availBuilder.getModuleGraph().ancestryOfAll(SetsKt.setOf((Object)this.targetModule));
            Graph<ResolvedModuleName> dag = ancestry.getSpanningDag();
            Graph<ResolvedModuleName> reduced = ancestry.withoutRedundantEdges(dag);
            this.renderGraph(reduced, dag);
        }
        this.availBuilder.trimGraphToLoadedModules$avail();
    }

    private final String asNodeName(String input) {
        Object outputString;
        boolean bl;
        if (this.encounteredNames.containsKey(input)) {
            String string2 = this.encounteredNames.get(input);
            Intrinsics.checkNotNull((Object)string2);
            return string2;
        }
        boolean bl2 = bl = input.charAt(0) == '/';
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        int startPosition = input.length() + 1;
        StringBuilder output = new StringBuilder(startPosition + 10);
        while (startPosition > 1) {
            output.setLength(0);
            startPosition = StringsKt.lastIndexOf$default((CharSequence)input, (char)'/', (int)(startPosition - 2), (boolean)false, (int)4, null) + 1;
            int c = 0;
            for (int i = startPosition; i < input.length(); i += Character.charCount(c)) {
                c = input.codePointAt(i);
                if (97 <= c && c <= 122 || 65 <= c && c <= 90 || i > startPosition && 48 <= c && c <= 57) {
                    output.appendCodePoint(c);
                    continue;
                }
                if (c == 47) {
                    output.append("__");
                    continue;
                }
                Object[] objectArray = new Object[]{c};
                output.append(String.format("_%x_", objectArray));
            }
            Intrinsics.checkNotNullExpressionValue((Object)output.toString(), (String)"output.toString()");
            if (this.allocatedNames.contains(outputString)) continue;
            this.allocatedNames.add((String)outputString);
            this.encounteredNames.put(input, (String)outputString);
            return outputString;
        }
        output.append("_");
        String string4 = output.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"output.toString()");
        String leadingPart = string4;
        int sequence = 2;
        while (true) {
            if (!this.allocatedNames.contains(outputString = leadingPart + sequence)) {
                this.allocatedNames.add((String)outputString);
                this.encounteredNames.put(input, (String)outputString);
                return outputString;
            }
            ++sequence;
        }
    }

    private final void renderGraph(Graph<ResolvedModuleName> reducedGraph, Graph<ResolvedModuleName> spanningDag2) {
        AsynchronousFileChannel asynchronousFileChannel;
        StringBuilder stringBuilder;
        boolean bl;
        boolean bl2 = bl = reducedGraph.getVertexCount() == spanningDag2.getVertexCount();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        Map trees = new LinkedHashMap();
        AvailBuilder.ModuleTree root = new AvailBuilder.ModuleTree("root_", "Module Dependencies", null);
        trees.put("", root);
        for (ResolvedModuleName resolvedModuleName : reducedGraph.getVertices()) {
            AvailBuilder.ModuleTree previous;
            String string3 = resolvedModuleName.getQualifiedName();
            String string2 = this.asNodeName(string3);
            String string4 = string3.substring(StringsKt.lastIndexOf$default((CharSequence)string3, (char)'/', (int)0, (boolean)false, (int)6, null) + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
            AvailBuilder.ModuleTree node = new AvailBuilder.ModuleTree(string2, string4, resolvedModuleName);
            trees.put(string3, node);
            while (true) {
                Intrinsics.checkNotNullExpressionValue((Object)string3.substring(0, StringsKt.lastIndexOf$default((CharSequence)string3, (char)'/', (int)0, (boolean)false, (int)6, null)), (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                previous = node;
                node = (AvailBuilder.ModuleTree)trees.get(string3);
                if (node != null) break;
                String string5 = this.asNodeName(string3);
                String string6 = string3.substring(StringsKt.lastIndexOf$default((CharSequence)string3, (char)'/', (int)0, (boolean)false, (int)6, null) + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String).substring(startIndex)");
                node = new AvailBuilder.ModuleTree(string5, string6, null);
                trees.put(string3, node);
                node.addChild(previous);
            }
            node.addChild(previous);
        }
        StringBuilder $this$renderGraph_u24lambda_u2d0 = stringBuilder = new StringBuilder();
        boolean bl3 = false;
        root.recursiveDo((Function2<? super AvailBuilder.ModuleTree, ? super Integer, Unit>)((Function2)new Function2<AvailBuilder.ModuleTree, Integer, Unit>($this$renderGraph_u24lambda_u2d0, root){
            final /* synthetic */ StringBuilder $this_buildString;
            final /* synthetic */ AvailBuilder.ModuleTree $root;
            {
                this.$this_buildString = $receiver;
                this.$root = $root;
                super(2);
            }

            public final void invoke(@NotNull AvailBuilder.ModuleTree node, int depth) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Strings.INSTANCE.tab(this.$this_buildString, depth);
                if (node == this.$root) {
                    this.$this_buildString.append("digraph ");
                    this.$this_buildString.append(node.getNode());
                    this.$this_buildString.append("\n");
                    Strings.INSTANCE.tab(this.$this_buildString, depth);
                    this.$this_buildString.append("{\n");
                    Strings.INSTANCE.tab(this.$this_buildString, depth + 1);
                    this.$this_buildString.append("remincross = true;\n");
                    Strings.INSTANCE.tab(this.$this_buildString, depth + 1);
                    this.$this_buildString.append("compound = true;\n");
                    Strings.INSTANCE.tab(this.$this_buildString, depth + 1);
                    this.$this_buildString.append("splines = compound;\n");
                    Strings.INSTANCE.tab(this.$this_buildString, depth + 1);
                    this.$this_buildString.append("node [shape=box, margin=\"0.1,0.1\", width=0, height=0, style=filled, fillcolor=moccasin ];\n");
                    Strings.INSTANCE.tab(this.$this_buildString, depth + 1);
                    this.$this_buildString.append("edge [color=grey];\n");
                    Strings.INSTANCE.tab(this.$this_buildString, depth + 1);
                    this.$this_buildString.append("label = ");
                    this.$this_buildString.append(node.getSafeLabel());
                    this.$this_buildString.append(";\n\n");
                } else if (node.getResolvedModuleName() == null) {
                    this.$this_buildString.append("subgraph cluster_");
                    this.$this_buildString.append(node.getNode());
                    this.$this_buildString.append('\n');
                    Strings.INSTANCE.tab(this.$this_buildString, depth);
                    this.$this_buildString.append("{\n");
                    Strings.INSTANCE.tab(this.$this_buildString, depth + 1);
                    this.$this_buildString.append("label = ");
                    this.$this_buildString.append(node.getSafeLabel());
                    this.$this_buildString.append(";\n");
                    Strings.INSTANCE.tab(this.$this_buildString, depth + 1);
                    this.$this_buildString.append("penwidth = 2.0;\n");
                    Strings.INSTANCE.tab(this.$this_buildString, depth + 1);
                    this.$this_buildString.append("fontsize = 18;\n");
                } else {
                    this.$this_buildString.append(node.getNode());
                    this.$this_buildString.append(" [label=");
                    this.$this_buildString.append(node.getSafeLabel());
                    this.$this_buildString.append("];\n");
                }
            }
        }), (Function2<? super AvailBuilder.ModuleTree, ? super Integer, Unit>)((Function2)new Function2<AvailBuilder.ModuleTree, Integer, Unit>(root, $this$renderGraph_u24lambda_u2d0, reducedGraph, (Map<String, AvailBuilder.ModuleTree>)trees, this, spanningDag2){
            final /* synthetic */ AvailBuilder.ModuleTree $root;
            final /* synthetic */ StringBuilder $this_buildString;
            final /* synthetic */ Graph<ResolvedModuleName> $reducedGraph;
            final /* synthetic */ Map<String, AvailBuilder.ModuleTree> $trees;
            final /* synthetic */ GraphTracer this$0;
            final /* synthetic */ Graph<ResolvedModuleName> $spanningDag;
            {
                this.$root = $root;
                this.$this_buildString = $receiver;
                this.$reducedGraph = $reducedGraph;
                this.$trees = $trees;
                this.this$0 = $receiver2;
                this.$spanningDag = $spanningDag;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull AvailBuilder.ModuleTree node, int depth) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (node == this.$root) {
                    this.$this_buildString.append("\n");
                    for (ResolvedModuleName from : this.$reducedGraph.getVertices()) {
                        String[] parts;
                        void $this$toTypedArray$iv;
                        List list;
                        Collection $this$dropLastWhile$iv;
                        String qualified = from.getQualifiedName();
                        Intrinsics.checkNotNull((Object)this.$trees.get(qualified));
                        Object object = qualified;
                        Regex regex = new Regex("/");
                        int n = 0;
                        object = regex.split((CharSequence)object, n);
                        boolean $i$f$dropLastWhile = false;
                        if (!$this$dropLastWhile$iv.isEmpty()) {
                            ListIterator<E> iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                            while (iterator$iv.hasPrevious()) {
                                String it = (String)iterator$iv.previous();
                                boolean bl = false;
                                if (((CharSequence)it).length() == 0) continue;
                                list = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                                break;
                            }
                        } else {
                            list = CollectionsKt.emptyList();
                        }
                        $this$dropLastWhile$iv = list;
                        boolean $i$f$toTypedArray = false;
                        void thisCollection$iv = $this$toTypedArray$iv;
                        if (thisCollection$iv.toArray(new String[0]) == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                        }
                        boolean fromPackage = Intrinsics.areEqual((Object)parts[parts.length - 2], (Object)parts[parts.length - 1]);
                        for (ResolvedModuleName to : this.$reducedGraph.successorsOf(from)) {
                            AvailBuilder.ModuleTree fromNode;
                            String toName = GraphTracer.access$asNodeName(this.this$0, to.getQualifiedName());
                            Strings.INSTANCE.tab(this.$this_buildString, depth + 1);
                            this.$this_buildString.append(fromNode.getNode());
                            this.$this_buildString.append(" -> ");
                            this.$this_buildString.append(toName);
                            List edgeStrings = new ArrayList<E>();
                            if (fromPackage) {
                                AvailBuilder.ModuleTree parent;
                                Intrinsics.checkNotNull((Object)fromNode.getParent$avail());
                                String parentName2 = "cluster_" + parent.getNode();
                                edgeStrings.add("ltail=" + parentName2);
                            }
                            if (!this.$spanningDag.includesEdge(from, to)) {
                                edgeStrings.add("constraint=false");
                                edgeStrings.add("color=crimson");
                                edgeStrings.add("penwidth=3.0");
                                edgeStrings.add("style=dashed");
                            }
                            if (!((Collection)edgeStrings).isEmpty()) {
                                this.$this_buildString.append("[");
                                this.$this_buildString.append(CollectionsKt.joinToString$default((Iterable)edgeStrings, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null));
                                this.$this_buildString.append("]");
                            }
                            this.$this_buildString.append(";\n");
                        }
                    }
                    Strings.INSTANCE.tab(this.$this_buildString, depth);
                    this.$this_buildString.append("}\n");
                } else if (node.getResolvedModuleName() == null) {
                    Strings.INSTANCE.tab(this.$this_buildString, depth);
                    this.$this_buildString.append("}\n");
                }
            }
        }), 0);
        String string7 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"StringBuilder().apply(builderAction).toString()");
        String out2 = string7;
        Object var6_10 = null;
        try {
            IOSystem iOSystem = this.availBuilder.getRuntime().getIoSystem();
            Path path = this.outputFile.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"outputFile.toPath()");
            EnumSet<Enum> enumSet = EnumSet.of((Enum)StandardOpenOption.WRITE, (Enum)StandardOpenOption.CREATE, (Enum)StandardOpenOption.TRUNCATE_EXISTING);
            Intrinsics.checkNotNullExpressionValue(enumSet, (String)"of(\n\t\t\t\t\tStandardOpenOpt\u2026Option.TRUNCATE_EXISTING)");
            asynchronousFileChannel = iOSystem.openFile(path, (Set<? extends OpenOption>)enumSet, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ByteBuffer buffer = StandardCharsets.UTF_8.encode(out2);
        Ref.IntRef position = new Ref.IntRef();
        new SimpleCompletionHandler((Function1)new Function1<SimpleCompletionHandler.Companion.SuccessHelper<Integer>, Unit>(position, buffer, asynchronousFileChannel){
            final /* synthetic */ Ref.IntRef $position;
            final /* synthetic */ ByteBuffer $buffer;
            final /* synthetic */ AsynchronousFileChannel $channel;
            {
                this.$position = $position;
                this.$buffer = $buffer;
                this.$channel = $channel;
                super(1);
            }

            public final void invoke(@NotNull SimpleCompletionHandler.Companion.SuccessHelper<Integer> $this$$receiver) {
                Intrinsics.checkNotNullParameter($this$$receiver, (String)"$this$$receiver");
                this.$position.element += ((Number)$this$$receiver.getValue()).intValue();
                if (this.$buffer.hasRemaining()) {
                    $this$$receiver.getHandler().guardedDo((Function1<SimpleCompletionHandler.Companion.GuardHelper<Integer>, Unit>)((Function1)new Function1<SimpleCompletionHandler.Companion.GuardHelper<Integer>, Unit>(this.$channel, this.$buffer, this.$position){
                        final /* synthetic */ AsynchronousFileChannel $channel;
                        final /* synthetic */ ByteBuffer $buffer;
                        final /* synthetic */ Ref.IntRef $position;
                        {
                            this.$channel = $channel;
                            this.$buffer = $buffer;
                            this.$position = $position;
                            super(1);
                        }

                        public final void invoke(@NotNull SimpleCompletionHandler.Companion.GuardHelper<Integer> $this$guardedDo) {
                            Intrinsics.checkNotNullParameter($this$guardedDo, (String)"$this$guardedDo");
                            this.$channel.write(this.$buffer, this.$position.element, Unit.INSTANCE, (CompletionHandler)$this$guardedDo.getHandler());
                        }
                    }));
                }
            }
        }, renderGraph.2.INSTANCE).guardedDo((Function1)new Function1<SimpleCompletionHandler.Companion.GuardHelper<Integer>, Unit>(asynchronousFileChannel, buffer){
            final /* synthetic */ AsynchronousFileChannel $channel;
            final /* synthetic */ ByteBuffer $buffer;
            {
                this.$channel = $channel;
                this.$buffer = $buffer;
                super(1);
            }

            public final void invoke(@NotNull SimpleCompletionHandler.Companion.GuardHelper<Integer> $this$guardedDo) {
                Intrinsics.checkNotNullParameter($this$guardedDo, (String)"$this$guardedDo");
                this.$channel.write(this.$buffer, 0L, Unit.INSTANCE, (CompletionHandler)$this$guardedDo.getHandler());
            }
        });
    }

    public static final /* synthetic */ String access$asNodeName(GraphTracer $this, String input) {
        return $this.asNodeName(input);
    }
}

