/*
 * Decompiled with CFR 0.152.
 */
package avail.compiler;

import avail.compiler.AvailCodeGenerator;
import avail.compiler.instruction.AvailCall;
import avail.compiler.instruction.AvailCloseCode;
import avail.compiler.instruction.AvailDuplicate;
import avail.compiler.instruction.AvailGetLiteralVariable;
import avail.compiler.instruction.AvailGetLocalVariable;
import avail.compiler.instruction.AvailGetOuterVariable;
import avail.compiler.instruction.AvailInstruction;
import avail.compiler.instruction.AvailInstructionWithIndex;
import avail.compiler.instruction.AvailLabel;
import avail.compiler.instruction.AvailMakeTuple;
import avail.compiler.instruction.AvailPermute;
import avail.compiler.instruction.AvailPop;
import avail.compiler.instruction.AvailPushLabel;
import avail.compiler.instruction.AvailPushLiteral;
import avail.compiler.instruction.AvailPushLocalVariable;
import avail.compiler.instruction.AvailPushOuterVariable;
import avail.compiler.instruction.AvailSetLiteralVariable;
import avail.compiler.instruction.AvailSetLocalConstant;
import avail.compiler.instruction.AvailSetLocalVariable;
import avail.compiler.instruction.AvailSetOuterVariable;
import avail.compiler.instruction.AvailSuperCall;
import avail.compiler.instruction.AvailVariableAccessNote;
import avail.descriptor.bundles.A_Bundle;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.functions.CompiledCodeDescriptor;
import avail.descriptor.module.A_Module;
import avail.descriptor.phrases.A_Phrase;
import avail.descriptor.phrases.BlockPhraseDescriptor;
import avail.descriptor.phrases.DeclarationPhraseDescriptor;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.sets.A_Set;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.NybbleTupleDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.StringDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.BottomTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.PhraseTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.VariableTypeDescriptor;
import avail.interpreter.Primitive;
import avail.interpreter.primitive.privatehelpers.P_GetGlobalVariableValue;
import avail.interpreter.primitive.privatehelpers.P_PushArgument1;
import avail.interpreter.primitive.privatehelpers.P_PushArgument2;
import avail.interpreter.primitive.privatehelpers.P_PushArgument3;
import avail.interpreter.primitive.privatehelpers.P_PushConstant;
import avail.interpreter.primitive.privatehelpers.P_PushLastOuter;
import avail.io.NybbleOutputStream;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 Y2\u00020\u0001:\u0001YB\u007f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0018H\u0002J\u0010\u0010/\u001a\u00020-2\u0006\u00100\u001a\u00020\u0013H\u0002J&\u00101\u001a\u00020-2\u0006\u00102\u001a\u00020*2\u0006\u00103\u001a\u00020\u00132\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u000eJ\u001e\u00107\u001a\u00020-2\u0006\u00102\u001a\u00020*2\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020*J\u0006\u0010;\u001a\u00020-J\u0016\u0010<\u001a\u00020-2\u0006\u00102\u001a\u00020*2\u0006\u0010=\u001a\u00020\u001dJ\u0016\u0010>\u001a\u00020-2\u0006\u00102\u001a\u00020*2\u0006\u0010?\u001a\u00020\u0006J\u000e\u0010@\u001a\u00020-2\u0006\u0010A\u001a\u00020\u0006J\u0016\u0010B\u001a\u00020-2\u0006\u00102\u001a\u00020*2\u0006\u0010C\u001a\u00020\u0013J\u0016\u0010D\u001a\u00020-2\u0006\u00102\u001a\u00020*2\u0006\u0010E\u001a\u00020*J\u0006\u0010F\u001a\u00020-J\u0016\u0010G\u001a\u00020-2\u0006\u00102\u001a\u00020*2\u0006\u0010=\u001a\u00020\u001dJ\u0016\u0010H\u001a\u00020-2\u0006\u00102\u001a\u00020*2\u0006\u0010I\u001a\u00020\u0006J\u0016\u0010J\u001a\u00020-2\u0006\u00102\u001a\u00020*2\u0006\u0010=\u001a\u00020\u001dJ\u0016\u0010K\u001a\u00020-2\u0006\u00102\u001a\u00020*2\u0006\u0010L\u001a\u00020\u0006J\u0016\u0010M\u001a\u00020-2\u0006\u00102\u001a\u00020*2\u0006\u0010?\u001a\u00020\u0006J.\u0010N\u001a\u00020-2\u0006\u00102\u001a\u00020*2\u0006\u00103\u001a\u00020\u00132\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u000e2\u0006\u0010O\u001a\u00020\u000eJ\u0010\u0010P\u001a\u0002092\u0006\u0010Q\u001a\u00020\u0006H\u0002J\b\u0010R\u001a\u00020-H\u0002J\b\u0010S\u001a\u00020-H\u0002J\u0010\u0010T\u001a\u00020\u00132\u0006\u0010=\u001a\u00020\u001dH\u0002J\u001c\u0010U\u001a\u00020-2\u0006\u00102\u001a\u00020*2\f\u0010V\u001a\b\u0012\u0004\u0012\u00020-0WJ\b\u0010X\u001a\u00020-H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u001a\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00130\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010%\u001a\u0004\u0018\u00010\b@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b&\u0010'R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010+\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00130\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Z"}, d2={"Lavail/compiler/AvailCodeGenerator;", "", "module", "Lavail/descriptor/module/A_Module;", "args", "", "Lavail/descriptor/phrases/A_Phrase;", "primitive", "Lavail/interpreter/Primitive;", "locals", "constants", "labels", "outers", "resultType", "Lavail/descriptor/types/A_Type;", "resultTypeIfPrimitiveFails", "exceptionSet", "Lavail/descriptor/sets/A_Set;", "startingLineNumber", "", "(Lavail/descriptor/module/A_Module;Ljava/util/List;Lavail/interpreter/Primitive;Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;Lavail/descriptor/types/A_Type;Lavail/descriptor/types/A_Type;Lavail/descriptor/sets/A_Set;I)V", "depth", "instructions", "", "Lavail/compiler/instruction/AvailInstruction;", "labelInstructions", "", "Lavail/compiler/instruction/AvailLabel;", "literals", "Lavail/descriptor/representation/A_BasicObject;", "maxDepth", "getModule", "()Lavail/descriptor/module/A_Module;", "numArgs", "getNumArgs", "()I", "outerMap", "thePrimitive", "setPrimitive", "(Lavail/interpreter/Primitive;)V", "tokensStack", "Ljava/util/ArrayDeque;", "Lavail/descriptor/tuples/A_Tuple;", "varMap", "addInstruction", "", "instruction", "decreaseDepth", "delta", "emitCall", "tokens", "nArgs", "bundle", "Lavail/descriptor/bundles/A_Bundle;", "returnType", "emitCloseCode", "compiledCode", "Lavail/descriptor/functions/A_RawFunction;", "neededVariables", "emitDuplicate", "emitGetLiteral", "aLiteral", "emitGetLocalOrOuter", "localOrOuter", "emitLabelDeclaration", "labelNode", "emitMakeTuple", "count", "emitPermute", "permutation", "emitPop", "emitPushLiteral", "emitPushLocalOrOuter", "variableDeclaration", "emitSetLiteral", "emitSetLocalFrameSlot", "localConstant", "emitSetLocalOrOuter", "emitSuperCall", "superUnionType", "endBlock", "originatingBlockPhrase", "fixFinalUses", "increaseDepth", "indexOfLiteral", "setTokensWhile", "action", "Lkotlin/Function0;", "stackShouldBeEmpty", "Companion", "avail"})
public final class AvailCodeGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final A_Module module;
    @NotNull
    private final List<A_Phrase> args;
    @NotNull
    private final List<A_Phrase> locals;
    @NotNull
    private final List<A_Phrase> constants;
    @NotNull
    private final List<A_Phrase> outers;
    @NotNull
    private final A_Type resultType;
    @NotNull
    private final A_Type resultTypeIfPrimitiveFails;
    @NotNull
    private final A_Set exceptionSet;
    private final int startingLineNumber;
    @Nullable
    private Primitive primitive;
    @NotNull
    private final List<AvailInstruction> instructions;
    @NotNull
    private final ArrayDeque<A_Tuple> tokensStack;
    @NotNull
    private final Map<A_Phrase, Integer> varMap;
    @NotNull
    private final Map<A_Phrase, Integer> outerMap;
    @NotNull
    private final List<A_BasicObject> literals;
    private int depth;
    private int maxDepth;
    @NotNull
    private final Map<A_Phrase, AvailLabel> labelInstructions;

    private AvailCodeGenerator(A_Module module, List<? extends A_Phrase> args, Primitive primitive2, List<? extends A_Phrase> locals, List<? extends A_Phrase> constants, List<? extends A_Phrase> labels, List<? extends A_Phrase> outers2, A_Type resultType, A_Type resultTypeIfPrimitiveFails, A_Set exceptionSet, int startingLineNumber) {
        this.module = module;
        this.args = args;
        this.locals = locals;
        this.constants = constants;
        this.outers = outers2;
        this.resultType = resultType;
        this.resultTypeIfPrimitiveFails = resultTypeIfPrimitiveFails;
        this.exceptionSet = exceptionSet;
        this.startingLineNumber = startingLineNumber;
        this.primitive = primitive2;
        this.instructions = new ArrayList();
        this.tokensStack = new ArrayDeque();
        this.varMap = new LinkedHashMap();
        this.outerMap = new LinkedHashMap();
        this.literals = new ArrayList();
        this.labelInstructions = new LinkedHashMap();
        for (A_Phrase a_Phrase : this.args) {
            this.varMap.put(a_Phrase, this.varMap.size() + 1);
        }
        for (A_Phrase a_Phrase : this.locals) {
            this.varMap.put(a_Phrase, this.varMap.size() + 1);
        }
        for (A_Phrase a_Phrase : this.constants) {
            this.varMap.put(a_Phrase, this.varMap.size() + 1);
        }
        for (A_Phrase a_Phrase : this.outers) {
            this.outerMap.put(a_Phrase, this.outerMap.size() + 1);
        }
        for (A_Phrase a_Phrase : labels) {
            this.labelInstructions.put(a_Phrase, new AvailLabel(A_Phrase.Companion.getTokens(a_Phrase)));
        }
    }

    @NotNull
    public final A_Module getModule() {
        return this.module;
    }

    private final void setPrimitive(Primitive thePrimitive) {
        boolean bl;
        boolean bl2 = bl = this.primitive == null;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Primitive was already set";
            throw new AssertionError((Object)string2);
        }
        this.primitive = thePrimitive;
    }

    private final int indexOfLiteral(A_BasicObject aLiteral) {
        int index2 = this.literals.indexOf(aLiteral) + 1;
        if (index2 == 0) {
            this.literals.add(aLiteral);
            index2 = this.literals.size();
        }
        return index2;
    }

    public final int getNumArgs() {
        return this.args.size();
    }

    /*
     * WARNING - void declaration
     */
    private final A_RawFunction endBlock(A_Phrase originatingBlockPhrase) {
        boolean $this$mapTo$iv$iv22;
        void $this$mapTo$iv$iv22;
        void $this$map$iv;
        Collection collection;
        void $this$mapTo$iv$iv3;
        void $this$map$iv2;
        this.fixFinalUses();
        if (this.primitive == null && this.instructions.size() == 1) {
            AvailInstruction onlyInstruction = this.instructions.get(0);
            if (onlyInstruction instanceof AvailPushLiteral && ((AvailPushLiteral)onlyInstruction).getIndex() == 1) {
                this.setPrimitive(P_PushConstant.INSTANCE);
            } else if (this.getNumArgs() >= 1 && onlyInstruction instanceof AvailPushLocalVariable) {
                switch (((AvailPushLocalVariable)onlyInstruction).getIndex()) {
                    case 1: {
                        this.setPrimitive(P_PushArgument1.INSTANCE);
                        break;
                    }
                    case 2: {
                        this.setPrimitive(P_PushArgument2.INSTANCE);
                        break;
                    }
                    case 3: {
                        this.setPrimitive(P_PushArgument3.INSTANCE);
                    }
                }
            } else if (onlyInstruction instanceof AvailPushOuterVariable) {
                boolean bl;
                boolean bl2 = bl = ((AvailPushOuterVariable)onlyInstruction).getIndex() == 1;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                bl = ((AvailPushOuterVariable)onlyInstruction).isLastAccess();
                if (_Assertions.ENABLED && !bl) {
                    String string3 = "Assertion failed";
                    throw new AssertionError((Object)string3);
                }
                this.setPrimitive(P_PushLastOuter.INSTANCE);
            }
            if (onlyInstruction instanceof AvailGetLiteralVariable && ((AvailGetLiteralVariable)onlyInstruction).getIndex() == 1 && this.literals.get(0).isInitializedWriteOnceVariable()) {
                this.setPrimitive(P_GetGlobalVariableValue.INSTANCE);
            }
        }
        BitSet unusedOuters = new BitSet(this.outerMap.size());
        unusedOuters.flip(0, this.outerMap.size());
        NybbleOutputStream nybbles2 = new NybbleOutputStream(50);
        List encodedLineNumberDeltas = new ArrayList();
        int currentLineNumber = this.startingLineNumber;
        for (AvailInstruction availInstruction : this.instructions) {
            int n;
            if (availInstruction.isOuterUse()) {
                n = ((AvailInstructionWithIndex)availInstruction).getIndex();
                unusedOuters.clear(n - 1);
            }
            availInstruction.writeNybblesOn(nybbles2);
            n = availInstruction.getLineNumber();
            if (n == -1) {
                encodedLineNumberDeltas.add(0);
                continue;
            }
            int delta = n - currentLineNumber;
            int encodedDelta = delta < 0 ? -delta << 1 | 1 : delta << 1;
            encodedLineNumberDeltas.add(encodedDelta);
            currentLineNumber = n;
        }
        if (!unusedOuters.isEmpty()) {
            Set unusedOuterDeclarations = new LinkedHashSet();
            for (Map.Entry<A_Phrase, Integer> entry : this.outerMap.entrySet()) {
                A_Phrase key = entry.getKey();
                int value = ((Number)entry.getValue()).intValue();
                if (!unusedOuters.get(value - 1)) continue;
                unusedOuterDeclarations.add(key);
            }
            if (_Assertions.ENABLED) {
                boolean bl = false;
                String string2 = "Some outers were unused: " + unusedOuterDeclarations;
                throw new AssertionError((Object)string2);
            }
        }
        byte[] nybblesArray = nybbles2.toByteArray();
        AvailObject availObject = NybbleTupleDescriptor.Companion.generateNybbleTupleFrom(nybblesArray.length, (Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(nybblesArray){
            final /* synthetic */ byte[] $nybblesArray;
            {
                this.$nybblesArray = $nybblesArray;
                super(1);
            }

            @NotNull
            public final Integer invoke(int i) {
                return this.$nybblesArray[i - 1];
            }
        }));
        boolean bl = this.resultType.isType();
        if (_Assertions.ENABLED && !bl) {
            String key = "Assertion failed";
            throw new AssertionError((Object)key);
        }
        AvailObject availObject2 = ObjectTupleDescriptor.Companion.generateObjectTupleFrom(this.args.size(), (Function1<? super Integer, ? extends A_BasicObject>)((Function1)new Function1<Integer, A_BasicObject>(this){
            final /* synthetic */ AvailCodeGenerator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final A_BasicObject invoke(int it) {
                return A_Phrase.Companion.getDeclaredType((A_Phrase)AvailCodeGenerator.access$getArgs$p(this.this$0).get(it - 1));
            }
        }));
        Iterable value = this.locals;
        ObjectTupleDescriptor.Companion companion = ObjectTupleDescriptor.Companion;
        boolean $i$f$map232 = false;
        void var12_30 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void it;
            A_Phrase a_Phrase = (A_Phrase)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(VariableTypeDescriptor.Companion.variableTypeFor(A_Phrase.Companion.getDeclaredType((A_Phrase)it)));
        }
        A_Tuple localTypes2 = companion.tupleFromList((List)destination$iv$iv);
        Iterable $i$f$map232 = this.constants;
        companion = ObjectTupleDescriptor.Companion;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Object destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv22) {
            void it;
            A_Phrase bl3 = (A_Phrase)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl32 = false;
            collection.add(A_Phrase.Companion.getDeclaredType((A_Phrase)it));
        }
        A_Tuple constantTypes2 = companion.tupleFromList((List)destination$iv$iv2);
        AvailObject outerTypes2 = ObjectTupleDescriptor.Companion.generateObjectTupleFrom(this.outers.size(), (Function1<? super Integer, ? extends A_BasicObject>)((Function1)new Function1<Integer, A_BasicObject>(this){
            final /* synthetic */ AvailCodeGenerator this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final A_BasicObject invoke(int it) {
                return avail.compiler.AvailCodeGenerator$Companion.access$outerType(AvailCodeGenerator.Companion, (A_Phrase)AvailCodeGenerator.access$getOuters$p(this.this$0).get(it - 1));
            }
        }));
        List declarations = new ArrayList();
        CollectionsKt.addAll((Collection)declarations, (Iterable)A_Phrase.Companion.getArgumentsTuple(originatingBlockPhrase));
        declarations.addAll((Collection)BlockPhraseDescriptor.Companion.locals(originatingBlockPhrase));
        declarations.addAll((Collection)BlockPhraseDescriptor.Companion.constants(originatingBlockPhrase));
        declarations.addAll((Collection)BlockPhraseDescriptor.Companion.labels(originatingBlockPhrase));
        declarations.addAll((Collection)this.outers);
        boolean bl4 = $this$mapTo$iv$iv22 = CollectionsKt.toSet((Iterable)declarations).size() == declarations.size();
        if (_Assertions.ENABLED && !$this$mapTo$iv$iv22) {
            destination$iv$iv2 = "Assertion failed";
            throw new AssertionError(destination$iv$iv2);
        }
        String packedDeclarationNames2 = CollectionsKt.joinToString$default((Iterable)declarations, (CharSequence)",", null, null, (int)0, null, (Function1)endBlock.packedDeclarationNames.1.INSTANCE, (int)30, null);
        A_Type functionType = FunctionTypeDescriptor.Companion.functionType(availObject2, this.resultType, this.exceptionSet);
        AvailObject code = CompiledCodeDescriptor.Companion.newCompiledCode(availObject, this.maxDepth, functionType, this.primitive, this.resultTypeIfPrimitiveFails, ObjectTupleDescriptor.Companion.tupleFromList(this.literals), localTypes2, constantTypes2, outerTypes2, this.module, this.startingLineNumber, TupleDescriptor.Companion.tupleFromIntegerList(encodedLineNumberDeltas), -1, originatingBlockPhrase, StringDescriptor.Companion.stringFrom(packedDeclarationNames2));
        return code.makeShared();
    }

    private final void decreaseDepth(int delta) {
        boolean bl;
        this.depth -= delta;
        boolean bl2 = bl = this.depth >= 0;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Inconsistency - Generated code would pop too much.";
            throw new AssertionError((Object)string2);
        }
    }

    private final void increaseDepth() {
        int n = this.depth;
        this.depth = n + 1;
        if (this.depth > this.maxDepth) {
            this.maxDepth = this.depth;
        }
    }

    private final void stackShouldBeEmpty() {
        boolean bl;
        boolean bl2 = bl = this.depth == 0;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "The stack should be empty here";
            throw new AssertionError((Object)string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setTokensWhile(@NotNull A_Tuple tokens, @NotNull Function0<Unit> action2) {
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        if (A_Tuple.Companion.getTupleSize(tokens) == 0) {
            action2.invoke();
            return;
        }
        this.tokensStack.addLast(tokens);
        try {
            action2.invoke();
        }
        finally {
            this.tokensStack.removeLast();
        }
    }

    public final void emitCall(@NotNull A_Tuple tokens, int nArgs, @NotNull A_Bundle bundle, @NotNull A_Type returnType) {
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        Intrinsics.checkNotNullParameter((Object)returnType, (String)"returnType");
        int messageIndex = this.indexOfLiteral(bundle);
        int returnIndex = this.indexOfLiteral(returnType);
        this.addInstruction(new AvailCall(tokens, messageIndex, returnIndex));
        this.decreaseDepth(nArgs);
        this.increaseDepth();
    }

    public final void emitSuperCall(@NotNull A_Tuple tokens, int nArgs, @NotNull A_Bundle bundle, @NotNull A_Type returnType, @NotNull A_Type superUnionType) {
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        Intrinsics.checkNotNullParameter((Object)bundle, (String)"bundle");
        Intrinsics.checkNotNullParameter((Object)returnType, (String)"returnType");
        Intrinsics.checkNotNullParameter((Object)superUnionType, (String)"superUnionType");
        int messageIndex = this.indexOfLiteral(bundle);
        int returnIndex = this.indexOfLiteral(returnType);
        int superUnionIndex = this.indexOfLiteral(superUnionType);
        this.addInstruction(new AvailSuperCall(tokens, messageIndex, returnIndex, superUnionIndex));
        this.decreaseDepth(nArgs);
        this.increaseDepth();
    }

    public final void emitCloseCode(@NotNull A_Tuple tokens, @NotNull A_RawFunction compiledCode2, @NotNull A_Tuple neededVariables) {
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        Intrinsics.checkNotNullParameter((Object)compiledCode2, (String)"compiledCode");
        Intrinsics.checkNotNullParameter((Object)neededVariables, (String)"neededVariables");
        for (AvailObject variableDeclaration : neededVariables) {
            this.emitPushLocalOrOuter(tokens, variableDeclaration);
        }
        int codeIndex = this.indexOfLiteral(compiledCode2);
        this.addInstruction(new AvailCloseCode(tokens, A_Tuple.Companion.getTupleSize(neededVariables), codeIndex));
        this.decreaseDepth(A_Tuple.Companion.getTupleSize(neededVariables));
        this.increaseDepth();
    }

    public final void emitDuplicate() {
        this.increaseDepth();
        this.addInstruction(new AvailDuplicate(TupleDescriptor.Companion.getEmptyTuple()));
    }

    public final void emitGetLiteral(@NotNull A_Tuple tokens, @NotNull A_BasicObject aLiteral) {
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        Intrinsics.checkNotNullParameter((Object)aLiteral, (String)"aLiteral");
        this.increaseDepth();
        int index2 = this.indexOfLiteral(aLiteral);
        this.addInstruction(new AvailGetLiteralVariable(tokens, index2));
    }

    public final void emitGetLocalOrOuter(@NotNull A_Tuple tokens, @NotNull A_Phrase localOrOuter) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        Intrinsics.checkNotNullParameter((Object)localOrOuter, (String)"localOrOuter");
        this.increaseDepth();
        if (this.varMap.containsKey(localOrOuter)) {
            Integer n = this.varMap.get(localOrOuter);
            Intrinsics.checkNotNull((Object)n);
            this.addInstruction(new AvailGetLocalVariable(tokens, ((Number)n).intValue()));
            return;
        }
        if (this.outerMap.containsKey(localOrOuter)) {
            Integer n = this.outerMap.get(localOrOuter);
            Intrinsics.checkNotNull((Object)n);
            this.addInstruction(new AvailGetOuterVariable(tokens, ((Number)n).intValue()));
            return;
        }
        boolean bl2 = bl = !this.labelInstructions.containsKey(localOrOuter);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-AvailCodeGenerator$emitGetLocalOrOuter$32 = false;
            String $i$a$-assert-AvailCodeGenerator$emitGetLocalOrOuter$32 = "This case should have been handled a different way!";
            throw new AssertionError((Object)$i$a$-assert-AvailCodeGenerator$emitGetLocalOrOuter$32);
        }
        if (_Assertions.ENABLED) {
            boolean bl3 = false;
            String string2 = "Consistency error - unknown variable.";
            throw new AssertionError((Object)string2);
        }
    }

    public final void emitLabelDeclaration(@NotNull A_Phrase labelNode) {
        Intrinsics.checkNotNullParameter((Object)labelNode, (String)"labelNode");
        boolean bl = this.instructions.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string2 = "Label must be first statement in block";
            throw new AssertionError((Object)string2);
        }
        AvailLabel availLabel = this.labelInstructions.get(labelNode);
        Intrinsics.checkNotNull((Object)availLabel);
        this.addInstruction(availLabel);
    }

    public final void emitMakeTuple(@NotNull A_Tuple tokens, int count) {
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        this.addInstruction(new AvailMakeTuple(tokens, count));
        this.decreaseDepth(count);
        this.increaseDepth();
    }

    public final void emitPermute(@NotNull A_Tuple tokens, @NotNull A_Tuple permutation) {
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        Intrinsics.checkNotNullParameter((Object)permutation, (String)"permutation");
        int index2 = this.indexOfLiteral(permutation);
        this.addInstruction(new AvailPermute(tokens, index2));
    }

    public final void emitPop() {
        this.addInstruction(new AvailPop(TupleDescriptor.Companion.getEmptyTuple()));
        this.decreaseDepth(1);
    }

    public final void emitPushLiteral(@NotNull A_Tuple tokens, @NotNull A_BasicObject aLiteral) {
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        Intrinsics.checkNotNullParameter((Object)aLiteral, (String)"aLiteral");
        this.increaseDepth();
        int index2 = this.indexOfLiteral(aLiteral);
        this.addInstruction(new AvailPushLiteral(tokens, index2));
    }

    public final void emitPushLocalOrOuter(@NotNull A_Tuple tokens, @NotNull A_Phrase variableDeclaration) {
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        Intrinsics.checkNotNullParameter((Object)variableDeclaration, (String)"variableDeclaration");
        this.increaseDepth();
        if (this.varMap.containsKey(variableDeclaration)) {
            Integer n = this.varMap.get(variableDeclaration);
            Intrinsics.checkNotNull((Object)n);
            this.addInstruction(new AvailPushLocalVariable(tokens, ((Number)n).intValue()));
            return;
        }
        if (this.outerMap.containsKey(variableDeclaration)) {
            Integer n = this.outerMap.get(variableDeclaration);
            Intrinsics.checkNotNull((Object)n);
            this.addInstruction(new AvailPushOuterVariable(tokens, ((Number)n).intValue()));
            return;
        }
        boolean bl = this.labelInstructions.containsKey(variableDeclaration);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string2 = "Consistency error - unknown variable.";
            throw new AssertionError((Object)string2);
        }
        this.addInstruction(new AvailPushLabel(tokens));
    }

    public final void emitSetLiteral(@NotNull A_Tuple tokens, @NotNull A_BasicObject aLiteral) {
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        Intrinsics.checkNotNullParameter((Object)aLiteral, (String)"aLiteral");
        int index2 = this.indexOfLiteral(aLiteral);
        this.addInstruction(new AvailSetLiteralVariable(tokens, index2));
        this.decreaseDepth(1);
    }

    public final void emitSetLocalOrOuter(@NotNull A_Tuple tokens, @NotNull A_Phrase localOrOuter) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        Intrinsics.checkNotNullParameter((Object)localOrOuter, (String)"localOrOuter");
        this.decreaseDepth(1);
        if (this.varMap.containsKey(localOrOuter)) {
            Integer n = this.varMap.get(localOrOuter);
            Intrinsics.checkNotNull((Object)n);
            this.addInstruction(new AvailSetLocalVariable(tokens, ((Number)n).intValue()));
            return;
        }
        if (this.outerMap.containsKey(localOrOuter)) {
            Integer n = this.outerMap.get(localOrOuter);
            Intrinsics.checkNotNull((Object)n);
            this.addInstruction(new AvailSetOuterVariable(tokens, ((Number)n).intValue()));
            return;
        }
        boolean bl2 = bl = !this.labelInstructions.containsKey(localOrOuter);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-AvailCodeGenerator$emitSetLocalOrOuter$32 = false;
            String $i$a$-assert-AvailCodeGenerator$emitSetLocalOrOuter$32 = "You can't assign to a label!";
            throw new AssertionError((Object)$i$a$-assert-AvailCodeGenerator$emitSetLocalOrOuter$32);
        }
        if (_Assertions.ENABLED) {
            boolean bl3 = false;
            String string2 = "Consistency error - unknown variable.";
            throw new AssertionError((Object)string2);
        }
    }

    public final void emitSetLocalFrameSlot(@NotNull A_Tuple tokens, @NotNull A_Phrase localConstant) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)tokens, (String)"tokens");
        Intrinsics.checkNotNullParameter((Object)localConstant, (String)"localConstant");
        boolean bl2 = bl = localConstant.declarationKind() == DeclarationPhraseDescriptor.DeclarationKind.LOCAL_CONSTANT;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        bl = this.varMap.containsKey(localConstant);
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string3 = "Local constants can only be initialized at their definition.";
            throw new AssertionError((Object)string3);
        }
        this.decreaseDepth(1);
        Integer n = this.varMap.get(localConstant);
        Intrinsics.checkNotNull((Object)n);
        this.addInstruction(new AvailSetLocalConstant(tokens, ((Number)n).intValue()));
    }

    private final void addInstruction(AvailInstruction instruction2) {
        if (A_Tuple.Companion.getTupleSize(instruction2.getRelevantTokens()) == 0 && !this.tokensStack.isEmpty()) {
            A_Tuple a_Tuple = this.tokensStack.getLast();
            Intrinsics.checkNotNullExpressionValue((Object)a_Tuple, (String)"tokensStack.last");
            instruction2.setRelevantTokens(a_Tuple);
        }
        this.instructions.add(instruction2);
    }

    private final void fixFinalUses() {
        List localData = ArraysKt.toMutableList((Object[])new AvailVariableAccessNote[this.varMap.size()]);
        List outerData = ArraysKt.toMutableList((Object[])new AvailVariableAccessNote[this.outerMap.size()]);
        for (AvailInstruction instruction2 : this.instructions) {
            instruction2.fixUsageFlags(localData, outerData, this);
        }
        Primitive p = this.primitive;
        if (p != null) {
            int n;
            int index2;
            if (p.hasFlag(Primitive.Flag.PreserveFailureVariable)) {
                boolean instruction2;
                boolean bl = instruction2 = !p.hasFlag(Primitive.Flag.CannotFail);
                if (_Assertions.ENABLED && !instruction2) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                AvailGetLocalVariable fakeFailureVariableUse = new AvailGetLocalVariable(TupleDescriptor.Companion.getEmptyTuple(), this.getNumArgs() + 1);
                fakeFailureVariableUse.fixUsageFlags(localData, outerData, this);
            }
            if (p.hasFlag(Primitive.Flag.PreserveArguments) && (index2 = 1) <= (n = this.getNumArgs())) {
                while (true) {
                    AvailPushLocalVariable fakeArgumentUse = new AvailPushLocalVariable(TupleDescriptor.Companion.getEmptyTuple(), index2);
                    fakeArgumentUse.fixUsageFlags(localData, outerData, this);
                    if (index2 == n) break;
                    ++index2;
                }
            }
        }
    }

    public static final /* synthetic */ List access$getArgs$p(AvailCodeGenerator $this) {
        return $this.args;
    }

    public static final /* synthetic */ List access$getOuters$p(AvailCodeGenerator $this) {
        return $this.outers;
    }

    public /* synthetic */ AvailCodeGenerator(A_Module module, List args, Primitive primitive2, List locals, List constants, List labels, List outers2, A_Type resultType, A_Type resultTypeIfPrimitiveFails, A_Set exceptionSet, int startingLineNumber, DefaultConstructorMarker $constructor_marker) {
        this(module, args, primitive2, locals, constants, labels, outers2, resultType, resultTypeIfPrimitiveFails, exceptionSet, startingLineNumber);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0002\u00a8\u0006\f"}, d2={"Lavail/compiler/AvailCodeGenerator$Companion;", "", "()V", "generateFunction", "Lavail/descriptor/functions/A_RawFunction;", "module", "Lavail/descriptor/module/A_Module;", "blockPhrase", "Lavail/descriptor/phrases/A_Phrase;", "outerType", "Lavail/descriptor/types/A_Type;", "declaration", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final A_RawFunction generateFunction(@NotNull A_Module module, @NotNull A_Phrase blockPhrase) {
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)blockPhrase, (String)"blockPhrase");
            Primitive primitive2 = A_Phrase.Companion.getPrimitive(blockPhrase);
            A_Tuple $this$generateFunction_u24lambda_u2d0 = A_Phrase.Companion.getStatementsTuple(blockPhrase);
            boolean bl = false;
            A_Type resultTypeIfPrimitiveFails = primitive2 == null ? blockPhrase.resultType() : (primitive2.hasFlag(Primitive.Flag.CannotFail) ? BottomTypeDescriptor.Companion.getBottom() : (A_Tuple.Companion.getTupleSize($this$generateFunction_u24lambda_u2d0) == 0 ? (A_Type)PrimitiveTypeDescriptor.Types.TOP.getO() : A_Phrase.Companion.getPhraseExpressionType(A_Tuple.Companion.tupleAt($this$generateFunction_u24lambda_u2d0, A_Tuple.Companion.getTupleSize($this$generateFunction_u24lambda_u2d0)))));
            AvailCodeGenerator generator = new AvailCodeGenerator(module, TupleDescriptor.Companion.toList(A_Phrase.Companion.getArgumentsTuple(blockPhrase)), primitive2, BlockPhraseDescriptor.Companion.locals(blockPhrase), BlockPhraseDescriptor.Companion.constants(blockPhrase), BlockPhraseDescriptor.Companion.labels(blockPhrase), TupleDescriptor.Companion.toList(A_Phrase.Companion.getNeededVariables(blockPhrase)), blockPhrase.resultType(), resultTypeIfPrimitiveFails, A_Phrase.Companion.getDeclaredExceptions(blockPhrase), A_Phrase.Companion.getStartingLineNumber(blockPhrase), null);
            generator.stackShouldBeEmpty();
            A_Tuple statementsTuple = A_Phrase.Companion.getStatementsTuple(blockPhrase);
            int statementsCount = A_Tuple.Companion.getTupleSize(statementsTuple);
            if (statementsCount == 0 && (primitive2 == null || primitive2.canHaveNybblecodes())) {
                generator.emitPushLiteral(TupleDescriptor.Companion.getEmptyTuple(), NilDescriptor.Companion.getNil());
            } else {
                for (int index2 = 1; index2 < statementsCount; ++index2) {
                    A_Phrase.Companion.emitEffectOn(A_Tuple.Companion.tupleAt(statementsTuple, index2), generator);
                    generator.stackShouldBeEmpty();
                }
                if (statementsCount > 0) {
                    AvailObject lastStatement = A_Tuple.Companion.tupleAt(statementsTuple, statementsCount);
                    if (A_Phrase.Companion.phraseKindIsUnder(lastStatement, PhraseTypeDescriptor.PhraseKind.LABEL_PHRASE) || A_Phrase.Companion.phraseKindIsUnder(lastStatement, PhraseTypeDescriptor.PhraseKind.ASSIGNMENT_PHRASE) && A_Phrase.Companion.getPhraseExpressionType(lastStatement).isTop()) {
                        A_Phrase.Companion.emitEffectOn(lastStatement, generator);
                        generator.emitPushLiteral(TupleDescriptor.Companion.getEmptyTuple(), NilDescriptor.Companion.getNil());
                    } else {
                        A_Phrase.Companion.emitValueOn(lastStatement, generator);
                    }
                }
            }
            return generator.endBlock(blockPhrase);
        }

        private final A_Type outerType(A_Phrase declaration2) {
            return declaration2.declarationKind().isVariable() ? VariableTypeDescriptor.Companion.variableTypeFor(A_Phrase.Companion.getDeclaredType(declaration2)) : A_Phrase.Companion.getDeclaredType(declaration2);
        }

        public static final /* synthetic */ A_Type access$outerType(Companion $this, A_Phrase declaration2) {
            return $this.outerType(declaration2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

