/*
 * Decompiled with CFR 0.152.
 */
package avail.compiler;

import avail.AvailRuntime;
import avail.builder.ModuleName;
import avail.compiler.FiberTerminationException;
import avail.compiler.ModuleHeader;
import avail.compiler.problems.CompilerDiagnostics;
import avail.compiler.problems.Problem;
import avail.compiler.problems.ProblemHandler;
import avail.compiler.problems.ProblemType;
import avail.compiler.scanning.LexingState;
import avail.descriptor.atoms.AtomDescriptor;
import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.fiber.FiberDescriptor;
import avail.descriptor.functions.A_Function;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.functions.FunctionDescriptor;
import avail.descriptor.maps.A_Map;
import avail.descriptor.maps.MapDescriptor;
import avail.descriptor.module.A_Module;
import avail.descriptor.phrases.A_Phrase;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.tokens.A_Token;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.StringDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.exceptions.AvailEmergencyExitException;
import avail.exceptions.AvailRuntimeException;
import avail.interpreter.effects.LoadingEffect;
import avail.interpreter.execution.AvailLoader;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelOne.L1Decompiler;
import avail.interpreter.levelOne.L1InstructionWriter;
import avail.interpreter.levelOne.L1Operation;
import avail.io.TextInterface;
import avail.serialization.Serializer;
import avail.utility.StackPrinter;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function5;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.availlang.persistence.IndexedFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00d0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 }2\u00020\u0001:\u0001}Bu\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00126\u0010\r\u001a2\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u000b\u0012\u0004\u0012\u00020\u00130\u000ej\u0002`\u0014\u0012\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017Jf\u0010I\u001a\u00020\u00132\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020M2\f\u0010N\u001a\b\u0012\u0004\u0012\u00020P0O2\u0006\u0010Q\u001a\u00020R2\u0006\u0010S\u001a\u00020\f2\u0006\u0010T\u001a\u00020\f2\u0012\u0010U\u001a\u000e\u0012\u0004\u0012\u00020W\u0012\u0004\u0012\u00020\u00130V2\u0012\u0010X\u001a\u000e\u0012\u0004\u0012\u00020Y\u0012\u0004\u0012\u00020\u00130VH\u0002JE\u0010Z\u001a\u00020\u00132\u0006\u0010L\u001a\u00020M2\u0006\u0010[\u001a\u00020\u00122\u0012\u0010\\\u001a\u000e\u0012\u0004\u0012\u00020W\u0012\u0004\u0012\u00020\u00130V2\u0012\u0010X\u001a\u000e\u0012\u0004\u0012\u00020Y\u0012\u0004\u0012\u00020\u00130VH\u0000\u00a2\u0006\u0002\b]JN\u0010^\u001a\u00020\u00132\u0006\u0010_\u001a\u00020\u00122\u0006\u0010L\u001a\u00020M2\u0006\u0010S\u001a\u00020\f2\u0006\u0010T\u001a\u00020\f2\u0012\u0010U\u001a\u000e\u0012\u0004\u0012\u00020W\u0012\u0004\u0012\u00020\u00130V2\u0012\u0010X\u001a\u000e\u0012\u0004\u0012\u00020Y\u0012\u0004\u0012\u00020\u00130VJ\u001c\u0010`\u001a\u00020\u00132\u0006\u0010L\u001a\u00020M2\f\u0010\\\u001a\b\u0012\u0004\u0012\u00020\u00130\u000bJ\u0010\u0010a\u001a\u00020\u00132\u0006\u0010b\u001a\u00020\u001cH\u0002J\u000e\u0010c\u001a\u00020\u00132\u0006\u0010d\u001a\u00020eJ%\u0010f\u001a\u00020\u00132\u0006\u0010g\u001a\u00020\u00112\u0006\u0010h\u001a\u00020\u00112\u0006\u0010i\u001a\u00020jH\u0000\u00a2\u0006\u0002\bkJ%\u0010l\u001a\u00020\u00132\u0006\u0010g\u001a\u00020\u00112\u0006\u0010h\u001a\u00020\u00112\u0006\u0010i\u001a\u00020YH\u0000\u00a2\u0006\u0002\bmJ%\u0010n\u001a\u00020\u00132\u0006\u0010g\u001a\u00020\u00112\u0006\u0010h\u001a\u00020\u00112\u0006\u0010i\u001a\u00020YH\u0000\u00a2\u0006\u0002\boJ\u0010\u0010p\u001a\u00020\u00132\u0006\u0010J\u001a\u00020KH\u0002J\u0015\u0010q\u001a\u00020\u00132\u0006\u0010J\u001a\u00020KH\u0000\u00a2\u0006\u0002\brJ\u000e\u0010s\u001a\u00020\u00132\u0006\u0010t\u001a\u00020\u0011J>\u0010u\u001a\u000e\u0012\u0004\u0012\u0002Hv\u0012\u0004\u0012\u00020\u00130V\"\u0004\b\u0000\u0010v2\u0006\u0010L\u001a\u00020M2\b\u0010w\u001a\u0004\u0018\u00010x2\u0012\u0010\\\u001a\u000e\u0012\u0004\u0012\u0002Hv\u0012\u0004\u0012\u00020\u00130VJ;\u0010y\u001a\u00020\u0013\"\u0004\b\u0000\u0010v2\u0006\u0010L\u001a\u00020M2\u0018\u0010z\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002Hv\u0012\u0004\u0012\u00020\u00130V0O2\u0006\u0010{\u001a\u0002Hv\u00a2\u0006\u0002\u0010|R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010!\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0014\u0010)\u001a\u00020\u000f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R4\u0010-\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u000b2\u000e\u0010,\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101RA\u0010\r\u001a2\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u000b\u0012\u0004\u0012\u00020\u00130\u000ej\u0002`\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0011\u00104\u001a\u000205\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u0014\u00108\u001a\u000209X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u0011\u0010<\u001a\u00020=\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u0014\u0010\u0006\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010AR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010CR\u0011\u0010D\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\bE\u0010FR\u0011\u0010G\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\bH\u0010F\u00a8\u0006~"}, d2={"Lavail/compiler/CompilationContext;", "", "moduleHeader", "Lavail/compiler/ModuleHeader;", "module", "Lavail/descriptor/module/A_Module;", "source", "Lavail/descriptor/tuples/A_String;", "textInterface", "Lavail/io/TextInterface;", "pollForAbort", "Lkotlin/Function0;", "", "progressReporter", "Lkotlin/Function5;", "Lavail/builder/ModuleName;", "", "", "Lavail/descriptor/phrases/A_Phrase;", "", "Lavail/compiler/CompilerProgressReporter;", "problemHandler", "Lavail/compiler/problems/ProblemHandler;", "(Lavail/compiler/ModuleHeader;Lavail/descriptor/module/A_Module;Lavail/descriptor/tuples/A_String;Lavail/io/TextInterface;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function5;Lavail/compiler/problems/ProblemHandler;)V", "atomicWorkUnitsCompleted", "Ljava/util/concurrent/atomic/AtomicLong;", "atomicWorkUnitsQueued", "debugModuleName", "", "diagnostics", "Lavail/compiler/problems/CompilerDiagnostics;", "getDiagnostics", "()Lavail/compiler/problems/CompilerDiagnostics;", "loader", "Lavail/interpreter/execution/AvailLoader;", "getLoader", "()Lavail/interpreter/execution/AvailLoader;", "getModule", "()Lavail/descriptor/module/A_Module;", "getModuleHeader", "()Lavail/compiler/ModuleHeader;", "moduleName", "getModuleName$avail", "()Lavail/builder/ModuleName;", "newNoMoreWorkUnits", "noMoreWorkUnits", "getNoMoreWorkUnits", "()Lkotlin/jvm/functions/Function0;", "setNoMoreWorkUnits", "(Lkotlin/jvm/functions/Function0;)V", "getProgressReporter", "()Lkotlin/jvm/functions/Function5;", "runtime", "Lavail/AvailRuntime;", "getRuntime", "()Lavail/AvailRuntime;", "serializer", "Lavail/serialization/Serializer;", "getSerializer$avail", "()Lavail/serialization/Serializer;", "serializerOutputStream", "Lorg/availlang/persistence/IndexedFile$ByteArrayOutputStream;", "getSerializerOutputStream", "()Lorg/availlang/persistence/IndexedFile$ByteArrayOutputStream;", "getSource$avail", "()Lavail/descriptor/tuples/A_String;", "getTextInterface", "()Lavail/io/TextInterface;", "workUnitsCompleted", "getWorkUnitsCompleted", "()J", "workUnitsQueued", "getWorkUnitsQueued", "evaluateFunctionThen", "function", "Lavail/descriptor/functions/A_Function;", "lexingState", "Lavail/compiler/scanning/LexingState;", "args", "", "Lavail/descriptor/representation/A_BasicObject;", "clientParseData", "Lavail/descriptor/maps/A_Map;", "shouldSerialize", "trackTasks", "onSuccess", "Lkotlin/Function1;", "Lavail/descriptor/representation/AvailObject;", "onFailure", "", "evaluatePhraseAtThen", "expression", "continuation", "evaluatePhraseAtThen$avail", "evaluatePhraseThen", "expressionNode", "eventuallyDo", "logWorkUnits", "debugString", "recordToken", "token", "Lavail/descriptor/tokens/A_Token;", "reportEmergencyExitProblem", "lineNumber", "position", "e", "Lavail/exceptions/AvailEmergencyExitException;", "reportEmergencyExitProblem$avail", "reportExecutionProblem", "reportExecutionProblem$avail", "reportInternalProblem", "reportInternalProblem$avail", "serializeAfterRunning", "serializeWithoutSummary", "serializeWithoutSummary$avail", "startWorkUnits", "countToBeQueued", "workUnitCompletion", "ArgType", "optionalSafetyCheck", "Ljava/util/concurrent/atomic/AtomicBoolean;", "workUnitsDo", "continuations", "argument", "(Lavail/compiler/scanning/LexingState;Ljava/util/List;Ljava/lang/Object;)V", "Companion", "avail"})
public final class CompilationContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final ModuleHeader moduleHeader;
    @NotNull
    private final A_Module module;
    @NotNull
    private final A_String source;
    @NotNull
    private final TextInterface textInterface;
    @NotNull
    private final Function5<ModuleName, Long, Long, Integer, Function0<? extends A_Phrase>, Unit> progressReporter;
    @NotNull
    private final CompilerDiagnostics diagnostics;
    @NotNull
    private final AvailRuntime runtime;
    @NotNull
    private final AvailLoader loader;
    @NotNull
    private final AtomicLong atomicWorkUnitsQueued;
    @NotNull
    private final AtomicLong atomicWorkUnitsCompleted;
    @Nullable
    private volatile Function0<Unit> noMoreWorkUnits;
    @NotNull
    private final IndexedFile.ByteArrayOutputStream serializerOutputStream;
    @NotNull
    private final Serializer serializer;
    @Nullable
    private volatile String debugModuleName;
    @NotNull
    private static final Logger logger;

    /*
     * WARNING - void declaration
     */
    public CompilationContext(@Nullable ModuleHeader moduleHeader, @NotNull A_Module module, @NotNull A_String source, @NotNull TextInterface textInterface, @NotNull Function0<Boolean> pollForAbort2, @NotNull Function5<? super ModuleName, ? super Long, ? super Long, ? super Integer, ? super Function0<? extends A_Phrase>, Unit> progressReporter, @NotNull ProblemHandler problemHandler) {
        void it;
        AvailLoader availLoader;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)textInterface, (String)"textInterface");
        Intrinsics.checkNotNullParameter(pollForAbort2, (String)"pollForAbort");
        Intrinsics.checkNotNullParameter(progressReporter, (String)"progressReporter");
        Intrinsics.checkNotNullParameter((Object)problemHandler, (String)"problemHandler");
        this.moduleHeader = moduleHeader;
        this.module = module;
        this.source = source;
        this.textInterface = textInterface;
        this.progressReporter = progressReporter;
        this.diagnostics = new CompilerDiagnostics(this.source, this.getModuleName$avail(), pollForAbort2, problemHandler);
        this.runtime = AvailRuntime.Companion.currentRuntime();
        AvailLoader availLoader2 = availLoader = new AvailLoader(this.runtime, this.module, this.textInterface);
        CompilationContext compilationContext = this;
        boolean bl = false;
        it.setManifestEntries(new ArrayList());
        compilationContext.loader = availLoader;
        this.atomicWorkUnitsQueued = new AtomicLong(0L);
        this.atomicWorkUnitsCompleted = new AtomicLong(0L);
        this.serializerOutputStream = new IndexedFile.ByteArrayOutputStream(1000);
        this.serializer = new Serializer((OutputStream)this.serializerOutputStream, this.module, null, 4, null);
    }

    @Nullable
    public final ModuleHeader getModuleHeader() {
        return this.moduleHeader;
    }

    @NotNull
    public final A_Module getModule() {
        return this.module;
    }

    @NotNull
    public final A_String getSource$avail() {
        return this.source;
    }

    @NotNull
    public final TextInterface getTextInterface() {
        return this.textInterface;
    }

    @NotNull
    public final Function5<ModuleName, Long, Long, Integer, Function0<? extends A_Phrase>, Unit> getProgressReporter() {
        return this.progressReporter;
    }

    @NotNull
    public final CompilerDiagnostics getDiagnostics() {
        return this.diagnostics;
    }

    @NotNull
    public final AvailRuntime getRuntime() {
        return this.runtime;
    }

    @NotNull
    public final AvailLoader getLoader() {
        return this.loader;
    }

    @Nullable
    public final Function0<Unit> getNoMoreWorkUnits() {
        return this.noMoreWorkUnits;
    }

    /*
     * WARNING - void declaration
     */
    public final void setNoMoreWorkUnits(@Nullable Function0<Unit> newNoMoreWorkUnits) {
        boolean bl;
        boolean bl2 = bl = newNoMoreWorkUnits == null != (this.noMoreWorkUnits == null);
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-CompilationContext$noMoreWorkUnits$22 = false;
            String $i$a$-assert-CompilationContext$noMoreWorkUnits$22 = "noMoreWorkUnits must transition to or from null";
            throw new AssertionError((Object)$i$a$-assert-CompilationContext$noMoreWorkUnits$22);
        }
        if (Interpreter.Companion.getDebugWorkUnits()) {
            void $this$trim$iv;
            boolean wasNull = this.noMoreWorkUnits == null;
            boolean isNull = newNoMoreWorkUnits == null;
            String string2 = (isNull ? "\nClear" : "\nSet") + " noMoreWorkUnits (was " + (wasNull ? "null)" : "non-null)");
            System.out.println((Object)string2);
            StringBuilder builder2 = new StringBuilder();
            Throwable e = new Throwable().fillInStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)e, (String)"e");
            builder2.append(StackPrinter.Companion.trace(e));
            String string3 = builder2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"builder.toString()");
            CharSequence charSequence = string3;
            Regex regex = new Regex("\\A.*\\R((.*\\R){6})(.|\\R)*\\z");
            String string4 = "$1";
            String trace2 = regex.replace(charSequence, string4);
            charSequence = trace2;
            CompilationContext compilationContext = this;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl3 = false;
                boolean bl4 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            compilationContext.logWorkUnits("SetNoMoreWorkUnits:\n\t" + ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString());
        }
        if (newNoMoreWorkUnits == null) {
            this.noMoreWorkUnits = null;
        } else {
            AtomicBoolean ran = new AtomicBoolean(false);
            this.noMoreWorkUnits = (Function0)new Function0<Unit>(ran, this, newNoMoreWorkUnits){
                final /* synthetic */ AtomicBoolean $ran;
                final /* synthetic */ CompilationContext this$0;
                final /* synthetic */ Function0<Unit> $newNoMoreWorkUnits;
                {
                    this.$ran = $ran;
                    this.this$0 = $receiver;
                    this.$newNoMoreWorkUnits = $newNoMoreWorkUnits;
                    super(0);
                }

                public final void invoke() {
                    boolean bl;
                    boolean bl2 = bl = !this.$ran.getAndSet(true);
                    if (_Assertions.ENABLED && !bl) {
                        boolean bl3 = false;
                        String string2 = "Attempting to invoke the same noMoreWorkUnits twice";
                        throw new AssertionError((Object)string2);
                    }
                    if (Interpreter.Companion.getDebugWorkUnits()) {
                        CompilationContext.access$logWorkUnits(this.this$0, "Running noMoreWorkUnits");
                    }
                    this.$newNoMoreWorkUnits.invoke();
                }
            };
        }
    }

    @NotNull
    public final IndexedFile.ByteArrayOutputStream getSerializerOutputStream() {
        return this.serializerOutputStream;
    }

    @NotNull
    public final Serializer getSerializer$avail() {
        return this.serializer;
    }

    @NotNull
    public final ModuleName getModuleName$avail() {
        return new ModuleName(A_Module.Companion.getModuleNameNative(this.module), false, 2, null);
    }

    public final long getWorkUnitsQueued() {
        return this.atomicWorkUnitsQueued.get();
    }

    public final long getWorkUnitsCompleted() {
        return this.atomicWorkUnitsCompleted.get();
    }

    public final void recordToken(@NotNull A_Token token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        this.diagnostics.recordToken(token);
    }

    public final void eventuallyDo(@NotNull LexingState lexingState, @NotNull Function0<Unit> continuation) {
        Intrinsics.checkNotNullParameter((Object)lexingState, (String)"lexingState");
        Intrinsics.checkNotNullParameter(continuation, (String)"continuation");
        this.runtime.execute(50, (Function0<Unit>)((Function0)new Function0<Unit>(continuation, this, lexingState){
            final /* synthetic */ Function0<Unit> $continuation;
            final /* synthetic */ CompilationContext this$0;
            final /* synthetic */ LexingState $lexingState;
            {
                this.$continuation = $continuation;
                this.this$0 = $receiver;
                this.$lexingState = $lexingState;
                super(0);
            }

            public final void invoke() {
                try {
                    this.$continuation.invoke();
                }
                catch (Exception e) {
                    this.this$0.reportInternalProblem$avail(this.$lexingState.getLineNumber(), this.$lexingState.getPosition(), e);
                }
            }
        }));
    }

    private final void logWorkUnits(String debugString) {
        String moduleName2 = this.debugModuleName;
        if (moduleName2 == null) {
            this.debugModuleName = moduleName2 = this.getModuleName$avail().getLocalName();
        }
        StringBuilder builder2 = new StringBuilder();
        String[] stringArray = new String[]{"\n"};
        for (String line : StringsKt.split$default((CharSequence)debugString, (String[])stringArray, (boolean)false, (int)0, (int)6, null)) {
            builder2.append(moduleName2);
            builder2.append("   ");
            builder2.append(line);
            builder2.append('\n');
        }
        System.out.print(builder2);
    }

    /*
     * WARNING - void declaration
     */
    public final void startWorkUnits(int countToBeQueued) {
        boolean bl;
        boolean bl2 = bl = this.noMoreWorkUnits != null;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        boolean bl3 = bl = countToBeQueued > 0;
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        long queued = this.atomicWorkUnitsQueued.addAndGet(countToBeQueued);
        if (Interpreter.Companion.getDebugWorkUnits()) {
            void $this$trim$iv;
            String $this$toTypedArray$iv;
            long completed = this.getWorkUnitsCompleted();
            StringBuilder builder2 = new StringBuilder();
            Throwable e = new Throwable().fillInStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)e, (String)"e");
            builder2.append(StackPrinter.Companion.trace(e));
            String string4 = builder2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"builder.toString()");
            Object object = string4;
            Regex regex = new Regex("\n");
            int n = 7;
            object = regex.split((CharSequence)object, n);
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray = thisCollection$iv.toArray(new String[0]);
            if (objectArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            Object[] lines = objectArray;
            if (lines.length > 6) {
                String[] stringArray = Arrays.copyOf(lines, lines.length - 1);
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"copyOf(this, newSize)");
                lines = stringArray;
            }
            $this$toTypedArray$iv = ArraysKt.joinToString$default((Object[])lines, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            Object object2 = countToBeQueued > 1 ? " (bulk = +" + countToBeQueued + ")" : "";
            long l = queued - completed;
            long l2 = completed;
            long l3 = queued;
            CompilationContext compilationContext = this;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl4 = false;
                boolean bl5 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            String string5 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            compilationContext.logWorkUnits("Starting work unit: queued = " + l3 + ", completed = " + l2 + " (delta=" + l + ")" + (String)object2 + "\n\t" + string5);
        }
        if (logger.isLoggable(Level.FINEST)) {
            Object[] objectArray = new Object[]{this.getWorkUnitsCompleted(), this.getWorkUnitsQueued()};
            logger.log(Level.FINEST, String.format("Started work unit: %d/%d%n", objectArray));
        }
    }

    @NotNull
    public final <ArgType> Function1<ArgType, Unit> workUnitCompletion(@NotNull LexingState lexingState, @Nullable AtomicBoolean optionalSafetyCheck, @NotNull Function1<? super ArgType, Unit> continuation) {
        AtomicBoolean hasRunSafetyCheck;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)lexingState, (String)"lexingState");
        Intrinsics.checkNotNullParameter(continuation, (String)"continuation");
        boolean bl2 = bl = this.noMoreWorkUnits != null;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        AtomicBoolean atomicBoolean = optionalSafetyCheck;
        if (atomicBoolean == null) {
            atomicBoolean = hasRunSafetyCheck = new AtomicBoolean(false);
        }
        if (Interpreter.Companion.getDebugWorkUnits()) {
            this.logWorkUnits("Creating unit for continuation @" + continuation.hashCode());
        }
        return new Function1<ArgType, Unit>(hasRunSafetyCheck, continuation, this, lexingState){
            final /* synthetic */ AtomicBoolean $hasRunSafetyCheck;
            final /* synthetic */ Function1<ArgType, Unit> $continuation;
            final /* synthetic */ CompilationContext this$0;
            final /* synthetic */ LexingState $lexingState;
            {
                this.$hasRunSafetyCheck = $hasRunSafetyCheck;
                this.$continuation = $continuation;
                this.this$0 = $receiver;
                this.$lexingState = $lexingState;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(ArgType value) {
                boolean bl;
                long queued;
                long completed;
                boolean bl2;
                boolean hadRun = this.$hasRunSafetyCheck.getAndSet(true);
                boolean bl3 = bl2 = !hadRun;
                if (_Assertions.ENABLED && !bl2) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                try {
                    this.$continuation.invoke(value);
                    completed = CompilationContext.access$getAtomicWorkUnitsCompleted$p(this.this$0).incrementAndGet();
                    queued = this.this$0.getWorkUnitsQueued();
                    boolean bl4 = bl = completed <= queued;
                }
                catch (Exception e) {
                    boolean e22;
                    long queued2;
                    long completed2;
                    try {
                        this.this$0.reportInternalProblem$avail(this.$lexingState.getLineNumber(), this.$lexingState.getPosition(), e);
                        completed2 = CompilationContext.access$getAtomicWorkUnitsCompleted$p(this.this$0).incrementAndGet();
                        queued2 = this.this$0.getWorkUnitsQueued();
                        boolean bl5 = e22 = completed2 <= queued2;
                    }
                    catch (Throwable throwable) {
                        boolean bl6;
                        long completed3 = CompilationContext.access$getAtomicWorkUnitsCompleted$p(this.this$0).incrementAndGet();
                        long queued3 = this.this$0.getWorkUnitsQueued();
                        boolean bl7 = bl6 = completed3 <= queued3;
                        if (_Assertions.ENABLED && !bl6) {
                            String string3 = "Assertion failed";
                            throw new AssertionError((Object)string3);
                        }
                        if (Interpreter.Companion.getDebugWorkUnits()) {
                            CompilationContext.access$logWorkUnits(this.this$0, "Completed work unit: queued = " + queued3 + ", completed = " + completed3 + " (delta=" + (queued3 - completed3) + ")");
                        }
                        if (CompilationContext.Companion.getLogger().isLoggable(Level.FINEST)) {
                            Object[] objectArray = new Object[]{completed3, queued3};
                            CompilationContext.Companion.getLogger().log(Level.FINEST, String.format("Completed work unit: %d/%d%n", objectArray));
                        }
                        if (completed3 == queued3) {
                            try {
                                Function0<Unit> function0 = this.this$0.getNoMoreWorkUnits();
                                Intrinsics.checkNotNull(function0);
                                Function0<Unit> noMore = function0;
                                this.this$0.setNoMoreWorkUnits(null);
                                noMore.invoke();
                            }
                            catch (Exception e3) {
                                this.this$0.reportInternalProblem$avail(this.$lexingState.getLineNumber(), this.$lexingState.getPosition(), e3);
                            }
                        }
                        throw throwable;
                    }
                    if (_Assertions.ENABLED && !e22) {
                        String string4 = "Assertion failed";
                        throw new AssertionError((Object)string4);
                    }
                    if (Interpreter.Companion.getDebugWorkUnits()) {
                        CompilationContext.access$logWorkUnits(this.this$0, "Completed work unit: queued = " + queued2 + ", completed = " + completed2 + " (delta=" + (queued2 - completed2) + ")");
                    }
                    if (CompilationContext.Companion.getLogger().isLoggable(Level.FINEST)) {
                        Object[] e22 = new Object[]{completed2, queued2};
                        CompilationContext.Companion.getLogger().log(Level.FINEST, String.format("Completed work unit: %d/%d%n", e22));
                    }
                    if (completed2 == queued2) {
                        try {
                            Function0<Unit> function0 = this.this$0.getNoMoreWorkUnits();
                            Intrinsics.checkNotNull(function0);
                            Function0<Unit> noMore = function0;
                            this.this$0.setNoMoreWorkUnits(null);
                            noMore.invoke();
                        }
                        catch (Exception e4) {
                            this.this$0.reportInternalProblem$avail(this.$lexingState.getLineNumber(), this.$lexingState.getPosition(), e4);
                        }
                    }
                }
                if (_Assertions.ENABLED && !bl) {
                    String string5 = "Assertion failed";
                    throw new AssertionError((Object)string5);
                }
                if (Interpreter.Companion.getDebugWorkUnits()) {
                    CompilationContext.access$logWorkUnits(this.this$0, "Completed work unit: queued = " + queued + ", completed = " + completed + " (delta=" + (queued - completed) + ")");
                }
                if (CompilationContext.Companion.getLogger().isLoggable(Level.FINEST)) {
                    Object[] objectArray = new Object[]{completed, queued};
                    CompilationContext.Companion.getLogger().log(Level.FINEST, String.format("Completed work unit: %d/%d%n", objectArray));
                }
                if (completed == queued) {
                    try {
                        Function0<Unit> function0 = this.this$0.getNoMoreWorkUnits();
                        Intrinsics.checkNotNull(function0);
                        Function0<Unit> noMore = function0;
                        this.this$0.setNoMoreWorkUnits(null);
                        noMore.invoke();
                    }
                    catch (Exception e22) {
                        this.this$0.reportInternalProblem$avail(this.$lexingState.getLineNumber(), this.$lexingState.getPosition(), e22);
                    }
                }
            }
        };
    }

    public final <ArgType> void workUnitsDo(@NotNull LexingState lexingState, @NotNull List<? extends Function1<? super ArgType, Unit>> continuations, ArgType argument) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)lexingState, (String)"lexingState");
        Intrinsics.checkNotNullParameter(continuations, (String)"continuations");
        boolean bl2 = bl = !((Collection)continuations).isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        boolean bl3 = bl = this.noMoreWorkUnits != null;
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        this.startWorkUnits(continuations.size());
        Iterable $this$forEach$iv = continuations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function1 continuation = (Function1)element$iv;
            boolean bl4 = false;
            Function1<ArgType, Unit> workUnit2 = this.workUnitCompletion(lexingState, null, continuation);
            this.runtime.execute(50, (Function0<Unit>)((Function0)new Function0<Unit>(workUnit2, argument){
                final /* synthetic */ Function1<ArgType, Unit> $workUnit;
                final /* synthetic */ ArgType $argument;
                {
                    this.$workUnit = $workUnit;
                    this.$argument = $argument;
                    super(0);
                }

                public final void invoke() {
                    this.$workUnit.invoke(this.$argument);
                }
            }));
        }
    }

    private final void evaluateFunctionThen(A_Function function, LexingState lexingState, List<? extends A_BasicObject> args, A_Map clientParseData, boolean shouldSerialize, boolean trackTasks, Function1<? super AvailObject, Unit> onSuccess, Function1<? super Throwable, Unit> onFailure) {
        boolean bl;
        A_RawFunction code = function.code();
        boolean bl2 = bl = A_RawFunction.Companion.numArgs(code) == args.size();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        A_Fiber fiber2 = FiberDescriptor.Companion.newLoaderFiber(A_Type.Companion.getReturnType(function.kind()), this.loader, (Function0<? extends A_String>)((Function0)new Function0<A_String>(code){
            final /* synthetic */ A_RawFunction $code;
            {
                this.$code = $code;
                super(0);
            }

            @NotNull
            public final A_String invoke() {
                Object[] objectArray = new Object[]{A_RawFunction.Companion.getMethodName(this.$code), A_Module.Companion.getShortModuleNameNative(A_RawFunction.Companion.getModule(this.$code)), A_RawFunction.Companion.getCodeStartingLineNumber(this.$code)};
                return StringDescriptor.Companion.formatString("Eval fn=%s, in %s:%d", objectArray);
            }
        }));
        A_Fiber.Companion.setFiberGlobals(fiber2, A_Map.Companion.mapAtPuttingCanDestroy(A_Fiber.Companion.getFiberGlobals(fiber2), AtomDescriptor.SpecialAtom.CLIENT_DATA_GLOBAL_KEY.getAtom(), clientParseData, true));
        if (shouldSerialize) {
            this.loader.startRecordingEffects();
        }
        Function1 adjustedSuccess = null;
        if (shouldSerialize) {
            long before = A_Fiber.Companion.getFiberHelper(fiber2).fiberTime();
            adjustedSuccess = (Function1)new Function1<AvailObject, Unit>(fiber2, before, this, function, onSuccess){
                final /* synthetic */ A_Fiber $fiber;
                final /* synthetic */ long $before;
                final /* synthetic */ CompilationContext this$0;
                final /* synthetic */ A_Function $function;
                final /* synthetic */ Function1<AvailObject, Unit> $onSuccess;
                {
                    this.$fiber = $fiber;
                    this.$before = $before;
                    this.this$0 = $receiver;
                    this.$function = $function;
                    this.$onSuccess = $onSuccess;
                    super(1);
                }

                public final void invoke(@NotNull AvailObject successValue) {
                    Intrinsics.checkNotNullParameter((Object)successValue, (String)"successValue");
                    long after = A_Fiber.Companion.getFiberHelper(this.$fiber).fiberTime();
                    Interpreter.Companion.current().recordTopStatementEvaluation(after - this.$before, this.this$0.getModule());
                    this.this$0.getLoader().stopRecordingEffects();
                    CompilationContext.access$serializeAfterRunning(this.this$0, this.$function);
                    this.$onSuccess.invoke((Object)successValue);
                }
            };
        } else {
            adjustedSuccess = onSuccess;
        }
        if (trackTasks) {
            lexingState.setFiberContinuationsTrackingWork(fiber2, adjustedSuccess, onFailure);
        } else {
            A_Fiber.Companion.setSuccessAndFailure(fiber2, adjustedSuccess, onFailure);
        }
        this.runtime.runOutermostFunction(fiber2, function, args);
    }

    public final void evaluatePhraseThen(@NotNull A_Phrase expressionNode, @NotNull LexingState lexingState, boolean shouldSerialize, boolean trackTasks, @NotNull Function1<? super AvailObject, Unit> onSuccess, @NotNull Function1<? super Throwable, Unit> onFailure) {
        A_Function a_Function;
        Intrinsics.checkNotNullParameter((Object)expressionNode, (String)"expressionNode");
        Intrinsics.checkNotNullParameter((Object)lexingState, (String)"lexingState");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        Intrinsics.checkNotNullParameter(onFailure, (String)"onFailure");
        try {
            a_Function = FunctionDescriptor.Companion.createFunctionForPhrase(expressionNode, this.module, lexingState.getLineNumber());
        }
        catch (AvailRuntimeException e) {
            onFailure.invoke((Object)e);
            return;
        }
        A_Function function = a_Function;
        if (shouldSerialize) {
            this.loader.setTopLevelStatementBeingCompiled(A_RawFunction.Companion.getOriginatingPhrase(function.code()));
        }
        this.evaluateFunctionThen(function, lexingState, CollectionsKt.emptyList(), MapDescriptor.Companion.getEmptyMap(), shouldSerialize, trackTasks, onSuccess, onFailure);
    }

    public final void evaluatePhraseAtThen$avail(@NotNull LexingState lexingState, @NotNull A_Phrase expression, @NotNull Function1<? super AvailObject, Unit> continuation, @NotNull Function1<? super Throwable, Unit> onFailure) {
        Intrinsics.checkNotNullParameter((Object)lexingState, (String)"lexingState");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter(continuation, (String)"continuation");
        Intrinsics.checkNotNullParameter(onFailure, (String)"onFailure");
        this.evaluatePhraseThen(expression, lexingState, false, true, continuation, onFailure);
    }

    private final synchronized void serializeAfterRunning(A_Function function) {
        A_RawFunction code = function.code();
        int startingLineNumber = A_RawFunction.Companion.getCodeStartingLineNumber(code);
        if (this.loader.statementCanBeSummarized()) {
            Iterator<LoadingEffect> iterator2 = this.loader.recordedEffects().iterator();
            while (iterator2.hasNext()) {
                Object object;
                boolean bl;
                int batchCount;
                L1InstructionWriter writer = new L1InstructionWriter(this.module, startingLineNumber, A_RawFunction.Companion.getOriginatingPhrase(code));
                writer.argumentTypes(new A_Type[0]);
                writer.setReturnType(PrimitiveTypeDescriptor.Types.TOP.getO());
                writer.setReturnTypeIfPrimitiveFails(PrimitiveTypeDescriptor.Types.TOP.getO());
                for (batchCount = 0; batchCount < 100 && iterator2.hasNext(); ++batchCount) {
                    if (batchCount > 0) {
                        writer.write(startingLineNumber, L1Operation.L1_doPop, new int[0]);
                    }
                    iterator2.next().writeEffectTo(writer);
                }
                boolean bl2 = bl = batchCount > 0;
                if (_Assertions.ENABLED && !bl) {
                    object = "Assertion failed";
                    throw new AssertionError(object);
                }
                A_Function summaryFunction = FunctionDescriptor.Companion.createFunction(writer.compiledCode(), TupleDescriptor.Companion.getEmptyTuple());
                if (AvailLoader.Companion.getDebugUnsummarizedStatements()) {
                    object = A_Module.Companion.getModuleNameNative(this.module) + ":" + startingLineNumber + " Summary -- \n" + L1Decompiler.Companion.decompile(summaryFunction.code()) + "(batch = " + batchCount + ")";
                    System.out.println(object);
                }
                this.serializer.serialize(summaryFunction);
            }
        } else {
            if (AvailLoader.Companion.getDebugUnsummarizedStatements()) {
                String string2 = A_Module.Companion.getModuleNameNative(this.module) + ":" + startingLineNumber + " Unsummarized -- \n" + function;
                System.out.println((Object)string2);
            }
            this.serializer.serialize(function);
        }
    }

    public final synchronized void serializeWithoutSummary$avail(@NotNull A_Function function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        if (AvailLoader.Companion.getDebugUnsummarizedStatements()) {
            String string2 = A_Module.Companion.getModuleNameNative(this.module) + ":" + A_RawFunction.Companion.getCodeStartingLineNumber(function.code()) + " Forced -- \n" + function;
            System.out.println((Object)string2);
        }
        this.serializer.serialize(function);
    }

    public final void reportInternalProblem$avail(int lineNumber, int position, @NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.diagnostics.setCompilationIsInvalid(true);
        ModuleName moduleName2 = this.getModuleName$avail();
        long l = position;
        ProblemType problemType = ProblemType.INTERNAL;
        Object[] objectArray = new Object[2];
        Intrinsics.checkNotNull((Object)e.getMessage());
        objectArray[1] = StackPrinter.Companion.trace(e);
        Object[] objectArray2 = objectArray;
        Problem problem2 = new Problem(lineNumber, moduleName2, l, problemType, objectArray2){

            public void abortCompilation() {
            }
        };
        this.diagnostics.handleProblem(problem2);
    }

    public final void reportExecutionProblem$avail(int lineNumber, int position, @NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.diagnostics.setCompilationIsInvalid(true);
        if (e instanceof FiberTerminationException) {
            ModuleName moduleName2 = this.getModuleName$avail();
            long l = position;
            ProblemType problemType = ProblemType.EXECUTION;
            Object[] objectArray = new Object[]{};
            this.diagnostics.handleProblem(new Problem(lineNumber, moduleName2, l, problemType, objectArray){

                public void abortCompilation() {
                }
            });
        } else {
            ModuleName moduleName3 = this.getModuleName$avail();
            long l = position;
            ProblemType problemType = ProblemType.EXECUTION;
            Object[] objectArray = new Object[2];
            Intrinsics.checkNotNull((Object)e.getMessage());
            objectArray[1] = StackPrinter.Companion.trace(e);
            Object[] objectArray2 = objectArray;
            this.diagnostics.handleProblem(new Problem(lineNumber, moduleName3, l, problemType, objectArray2){

                public void abortCompilation() {
                }
            });
        }
    }

    public final void reportEmergencyExitProblem$avail(int lineNumber, int position, @NotNull AvailEmergencyExitException e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.diagnostics.setCompilationIsInvalid(true);
        ModuleName moduleName2 = this.getModuleName$avail();
        long l = position;
        ProblemType problemType = ProblemType.EXECUTION;
        Object[] objectArray = new Object[]{e.getMessage()};
        Object[] objectArray2 = objectArray;
        this.diagnostics.handleProblem(new Problem(lineNumber, moduleName2, l, problemType, objectArray2){

            public void abortCompilation() {
            }
        });
    }

    public static final /* synthetic */ void access$logWorkUnits(CompilationContext $this, String debugString) {
        $this.logWorkUnits(debugString);
    }

    public static final /* synthetic */ AtomicLong access$getAtomicWorkUnitsCompleted$p(CompilationContext $this) {
        return $this.atomicWorkUnitsCompleted;
    }

    public static final /* synthetic */ void access$serializeAfterRunning(CompilationContext $this, A_Function function) {
        $this.serializeAfterRunning(function);
    }

    static {
        Logger logger = Logger.getLogger(CompilationContext.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(\n\t\t\tCompilationContext::class.java.name)");
        CompilationContext.logger = logger;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lavail/compiler/CompilationContext$Companion;", "", "()V", "logger", "Ljava/util/logging/Logger;", "getLogger", "()Ljava/util/logging/Logger;", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

