/*
 * Decompiled with CFR 0.152.
 */
package avail.compiler.splitter;

import avail.compiler.ParsingOperation;
import avail.compiler.splitter.Expression;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.TupleDescriptor;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 +2\u00020\u0001:\u0002+,B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019J\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u000bJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019J\u001e\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u000bJ\u001e\u0010\u001f\u001a\u00020\u00162\u0006\u0010 \u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010!\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010\"\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010#\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010$\u001a\u00020\u000bJ\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0%J\u0006\u0010&\u001a\u00020\u0016J\b\u0010'\u001a\u00020\u0016H\u0002J\u0006\u0010(\u001a\u00020)J\u0006\u0010*\u001a\u00020\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006-"}, d2={"Lavail/compiler/splitter/InstructionGenerator;", "", "()V", "caseInsensitive", "", "getCaseInsensitive", "()Z", "setCaseInsensitive", "(Z)V", "delayedArgumentInstructions", "", "", "delayedExpressionList", "Lavail/compiler/splitter/Expression;", "expressionList", "instructions", "partialListsCount", "getPartialListsCount", "()I", "setPartialListsCount", "(I)V", "emit", "", "expression", "operation", "Lavail/compiler/ParsingOperation;", "label", "Lavail/compiler/splitter/InstructionGenerator$Label;", "operand", "emitBranchForward", "emitDelayed", "emitIf", "condition", "emitJumpBackward", "emitJumpForward", "emitWrapped", "listSize", "", "flushDelayed", "hoistTokenParsing", "instructionsTuple", "Lavail/descriptor/tuples/A_Tuple;", "optimizeInstructions", "Companion", "Label", "avail"})
public final class InstructionGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Integer> instructions = new ArrayList();
    @NotNull
    private final List<Expression> expressionList = new ArrayList();
    @NotNull
    private final List<Integer> delayedArgumentInstructions = new ArrayList();
    @NotNull
    private final List<Expression> delayedExpressionList = new ArrayList();
    private boolean caseInsensitive;
    private int partialListsCount = 1;
    private static final int placeholderInstruction = Integer.MIN_VALUE;

    public final boolean getCaseInsensitive() {
        return this.caseInsensitive;
    }

    public final void setCaseInsensitive(boolean bl) {
        this.caseInsensitive = bl;
    }

    public final int getPartialListsCount() {
        return this.partialListsCount;
    }

    public final void setPartialListsCount(int n) {
        this.partialListsCount = n;
    }

    public final void emit(@NotNull Expression expression, @NotNull ParsingOperation operation) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
        boolean bl2 = bl = operation != ParsingOperation.APPEND_ARGUMENT && operation != ParsingOperation.PERMUTE_LIST || this.delayedArgumentInstructions.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.expressionList.add(expression);
        this.instructions.add(operation.getEncoding());
    }

    public final void emit(@NotNull Expression expression, @NotNull ParsingOperation operation, int operand) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
        this.expressionList.add(expression);
        this.instructions.add(operation.encoding(operand));
    }

    public final void emitIf(boolean condition, @NotNull Expression expression, @NotNull ParsingOperation operation) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
        if (condition) {
            this.emit(expression, operation);
        }
    }

    public final void emit(@NotNull Expression expression, @NotNull ParsingOperation operation, @NotNull Label label) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        boolean bl2 = bl = operation != ParsingOperation.BRANCH_FORWARD && operation != ParsingOperation.JUMP_FORWARD && operation != ParsingOperation.JUMP_BACKWARD;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Use emitJumpForward() etc. to emit jumps and branches";
            throw new AssertionError((Object)string2);
        }
        this.expressionList.add(expression);
        if (label.getPosition() == -1) {
            label.getOperationsToFix().add((Pair<Integer, ParsingOperation>)TuplesKt.to((Object)(this.instructions.size() + 1), (Object)((Object)operation)));
            this.instructions.add(Integer.MIN_VALUE);
        } else {
            this.instructions.add(operation.encoding(label.getPosition()));
        }
    }

    public final void emit(@NotNull Label label) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        boolean bl2 = bl = label.getPosition() == -1;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-InstructionGenerator$emit$32 = false;
            String $i$a$-assert-InstructionGenerator$emit$32 = "Label was already emitted";
            throw new AssertionError((Object)$i$a$-assert-InstructionGenerator$emit$32);
        }
        label.setPosition(this.instructions.size() + 1);
        for (Pair<Integer, ParsingOperation> pair : label.getOperationsToFix()) {
            boolean bl3;
            boolean bl4 = bl3 = ((Number)this.instructions.get(((Number)pair.getFirst()).intValue() - 1)).intValue() == Integer.MIN_VALUE;
            if (_Assertions.ENABLED && !bl3) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            if (((Number)pair.getFirst()).intValue() + 1 == label.getPosition()) {
                System.out.println((Object)"DEBUG: Operation target falls through.");
            }
            this.instructions.set(((Number)pair.getFirst()).intValue() - 1, ((ParsingOperation)((Object)pair.getSecond())).encoding(label.getPosition()));
        }
        label.getOperationsToFix().clear();
    }

    public final void emitJumpForward(@NotNull Expression expression, @NotNull Label label) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        boolean bl2 = bl = label.getPosition() == -1;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Forward jumps must actually be forward";
            throw new AssertionError((Object)string2);
        }
        this.expressionList.add(expression);
        label.getOperationsToFix().add((Pair<Integer, ParsingOperation>)TuplesKt.to((Object)(this.instructions.size() + 1), (Object)((Object)ParsingOperation.JUMP_FORWARD)));
        this.instructions.add(Integer.MIN_VALUE);
    }

    public final void emitJumpBackward(@NotNull Expression expression, @NotNull Label label) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        boolean bl2 = bl = label.getPosition() != -1;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Backward jumps must actually be backward";
            throw new AssertionError((Object)string2);
        }
        this.expressionList.add(expression);
        this.instructions.add(ParsingOperation.JUMP_BACKWARD.encoding(label.getPosition()));
    }

    public final void emitBranchForward(@NotNull Expression expression, @NotNull Label label) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)label, (String)"label");
        boolean bl2 = bl = label.getPosition() == -1;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Branches must be forward";
            throw new AssertionError((Object)string2);
        }
        this.expressionList.add(expression);
        label.getOperationsToFix().add((Pair<Integer, ParsingOperation>)TuplesKt.to((Object)(this.instructions.size() + 1), (Object)((Object)ParsingOperation.BRANCH_FORWARD)));
        this.instructions.add(Integer.MIN_VALUE);
    }

    public final void emitDelayed(@NotNull Expression expression, @NotNull ParsingOperation operation) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
        this.delayedExpressionList.add(expression);
        this.delayedArgumentInstructions.add(operation.getEncoding());
    }

    public final void emitDelayed(@NotNull Expression expression, @NotNull ParsingOperation operation, int operand) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)((Object)operation), (String)"operation");
        this.delayedExpressionList.add(expression);
        this.delayedArgumentInstructions.add(operation.encoding(operand));
    }

    public final void flushDelayed() {
        if (!((Collection)this.delayedArgumentInstructions).isEmpty()) {
            this.expressionList.addAll((Collection<Expression>)this.delayedExpressionList);
            this.instructions.addAll((Collection<Integer>)this.delayedArgumentInstructions);
            this.delayedExpressionList.clear();
            this.delayedArgumentInstructions.clear();
        }
    }

    public final void emitWrapped(@NotNull Expression expression, int listSize) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        boolean bl = this.delayedArgumentInstructions.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        boolean bl2 = bl = listSize >= 0;
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        if (listSize == 0) {
            this.emit(expression, ParsingOperation.EMPTY_LIST);
        } else {
            this.emit(expression, ParsingOperation.WRAP_IN_LIST, listSize);
        }
    }

    public final void optimizeInstructions() {
        this.hoistTokenParsing();
    }

    private final void hoistTokenParsing() {
        int instructionsCount = this.instructions.size();
        BitSet branchTargets = new BitSet(instructionsCount);
        Iterator<Integer> iterator2 = this.instructions.iterator();
        while (iterator2.hasNext()) {
            int instruction2 = ((Number)iterator2.next()).intValue();
            ParsingOperation operation = ParsingOperation.Companion.decode(instruction2);
            if (operation != ParsingOperation.JUMP_FORWARD && operation != ParsingOperation.JUMP_BACKWARD && operation != ParsingOperation.BRANCH_FORWARD) continue;
            int target = ParsingOperation.Companion.operand(instruction2) - 1;
            branchTargets.set(target);
        }
        boolean changed = true;
        while (changed) {
            changed = false;
            for (int i = instructionsCount - 1; 0 < i; --i) {
                int priorInstruction;
                ParsingOperation priorOperation;
                int instruction3;
                ParsingOperation operation;
                if (branchTargets.get(i) || (operation = ParsingOperation.Companion.decode(instruction3 = ((Number)this.instructions.get(i)).intValue())) != ParsingOperation.PARSE_PART && operation != ParsingOperation.PARSE_PART_CASE_INSENSITIVELY || !(priorOperation = ParsingOperation.Companion.decode(priorInstruction = ((Number)this.instructions.get(i - 1)).intValue())).getCommutesWithParsePart()) continue;
                this.instructions.set(i, priorInstruction);
                this.instructions.set(i - 1, instruction3);
                Expression temp = this.expressionList.get(i);
                this.expressionList.set(i, this.expressionList.get(i - 1));
                this.expressionList.set(i - 1, temp);
                changed = true;
            }
        }
    }

    @NotNull
    public final A_Tuple instructionsTuple() {
        boolean bl;
        boolean bl2 = bl = !this.instructions.contains(Integer.MIN_VALUE);
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "A placeholder instruction using a label was not resolved";
            throw new AssertionError((Object)string2);
        }
        boolean bl4 = bl = this.instructions.size() == this.expressionList.size();
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        bl = this.delayedExpressionList.isEmpty();
        if (_Assertions.ENABLED && !bl) {
            String string4 = "Assertion failed";
            throw new AssertionError((Object)string4);
        }
        return TupleDescriptor.Companion.tupleFromIntegerList(this.instructions).makeShared();
    }

    @NotNull
    public final List<Expression> expressionList() {
        boolean bl;
        boolean bl2 = bl = this.instructions.size() == this.expressionList.size();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        List<Expression> list = Collections.unmodifiableList(this.expressionList);
        Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(expressionList)");
        return list;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005R#\u0010\u0006\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lavail/compiler/splitter/InstructionGenerator$Label;", "", "()V", "isUsed", "", "()Z", "operationsToFix", "", "Lkotlin/Pair;", "", "Lavail/compiler/ParsingOperation;", "getOperationsToFix", "()Ljava/util/List;", "position", "getPosition", "()I", "setPosition", "(I)V", "avail"})
    public static final class Label {
        private int position = -1;
        @NotNull
        private final List<Pair<Integer, ParsingOperation>> operationsToFix = new ArrayList();

        public final int getPosition() {
            return this.position;
        }

        public final void setPosition(int n) {
            this.position = n;
        }

        @NotNull
        public final List<Pair<Integer, ParsingOperation>> getOperationsToFix() {
            return this.operationsToFix;
        }

        public final boolean isUsed() {
            return this.position != -1 || !((Collection)this.operationsToFix).isEmpty();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lavail/compiler/splitter/InstructionGenerator$Companion;", "", "()V", "placeholderInstruction", "", "avail"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

