/*
 * Decompiled with CFR 0.152.
 */
package avail.compiler.splitter;

import avail.compiler.problems.CompilerDiagnostics;
import avail.compiler.splitter.MessageSplitter;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.StringDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.exceptions.MalformedMessageException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 %2\u00020\u0001:\u0001%B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\b\b\u0002\u0010\u0010\u001a\u00020\bH\u0002J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0012\u0010\u0016\u001a\u00020\u000e2\b\b\u0002\u0010\u0017\u001a\u00020\bH\u0002J\u0011\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u0019\u00a2\u0006\u0002\u0010\u001aJ\u0006\u0010\t\u001a\u00020\u001bJ\b\u0010\u001c\u001a\u00020\bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J!\u0010\u001c\u001a\u00020\u00152\u0012\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0\u0019\"\u00020\u001eH\u0002\u00a2\u0006\u0002\u0010 J\u0012\u0010!\u001a\u00020\b2\b\b\u0002\u0010\u0017\u001a\u00020\bH\u0002J\u0012\u0010\"\u001a\u00020\u000e2\b\b\u0002\u0010\u0017\u001a\u00020\bH\u0002J\u0010\u0010#\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\b\u0010$\u001a\u00020\u000eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lavail/compiler/splitter/MessageSplitterTokenizer;", "", "messageName", "Lavail/descriptor/tuples/A_String;", "(Lavail/descriptor/tuples/A_String;)V", "getMessageName", "()Lavail/descriptor/tuples/A_String;", "messageNameSize", "", "messagePartPositions", "", "messagePartsList", "positionInName", "accept", "", "start", "end", "acceptStripped", "range", "Lkotlin/ranges/IntRange;", "atEnd", "", "backup", "n", "canonicalMessageParts", "", "()[Lavail/descriptor/tuples/A_String;", "", "peek", "metacharacter", "Lavail/compiler/splitter/MessageSplitter$Metacharacter;", "metacharacters", "([Lavail/compiler/splitter/MessageSplitter$Metacharacter;)Z", "previous", "skip", "stripBackquotes", "tokenizeMessage", "Companion", "avail"})
public final class MessageSplitterTokenizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final A_String messageName;
    private final int messageNameSize;
    private int positionInName;
    @NotNull
    private final List<A_String> messagePartsList;
    @NotNull
    private final List<Integer> messagePartPositions;
    @NotNull
    private static final ReentrantReadWriteLock allCanonicalMessagePartsLock = new ReentrantReadWriteLock();
    @NotNull
    private static final Map<A_String, A_String> allCanonicalMessageParts = new LinkedHashMap();

    public MessageSplitterTokenizer(final @NotNull A_String messageName) throws MalformedMessageException {
        Intrinsics.checkNotNullParameter((Object)messageName, (String)"messageName");
        this.messageName = messageName.makeShared();
        this.messageNameSize = A_Tuple.Companion.getTupleSize(messageName);
        this.positionInName = 1;
        this.messagePartsList = new ArrayList();
        this.messagePartPositions = new ArrayList();
        try {
            this.tokenizeMessage();
        }
        catch (MalformedMessageException e) {
            throw new MalformedMessageException(e.getErrorCode(), (Function0<String>)((Function0)new Function0<String>(){

                @NotNull
                public final String invoke() {
                    StringBuilder stringBuilder;
                    A_String a_String = messageName;
                    MessageSplitterTokenizer messageSplitterTokenizer = this;
                    MalformedMessageException malformedMessageException = e;
                    StringBuilder $this$invoke_u24lambda_u2d0 = stringBuilder = new StringBuilder();
                    boolean bl = false;
                    A_Tuple annotated = A_Tuple.Companion.concatenateTuplesCanDestroy(ObjectTupleDescriptor.Companion.tuple(a_String.copyStringFromToCanDestroy(1, messageSplitterTokenizer.positionInName, false), StringDescriptor.Companion.stringFrom(CompilerDiagnostics.Companion.getErrorIndicatorSymbol()), a_String.copyStringFromToCanDestroy(messageSplitterTokenizer.positionInName + 1, messageSplitterTokenizer.messageNameSize, false)), false);
                    $this$invoke_u24lambda_u2d0.append(malformedMessageException.describeProblem());
                    $this$invoke_u24lambda_u2d0.append(". See arrow (");
                    $this$invoke_u24lambda_u2d0.append(CompilerDiagnostics.Companion.getErrorIndicatorSymbol());
                    $this$invoke_u24lambda_u2d0.append(") in: ");
                    $this$invoke_u24lambda_u2d0.append(annotated.toString());
                    String string2 = stringBuilder.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
                    return string2;
                }
            }));
        }
    }

    @NotNull
    public final A_String getMessageName() {
        return this.messageName;
    }

    @NotNull
    public final int[] messagePartPositions() {
        return CollectionsKt.toIntArray((Collection)this.messagePartPositions);
    }

    /*
     * WARNING - void declaration
     */
    private final A_String stripBackquotes(IntRange range) {
        int n;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder = new StringBuilder();
        StringDescriptor.Companion companion = StringDescriptor.Companion;
        boolean bl = false;
        int i = range.getFirst();
        if (i <= (n = range.getLast())) {
            while (true) {
                int cp;
                if ((cp = A_Tuple.Companion.tupleCodePointAt(this.messageName, i)) != 96) {
                    void $this$stripBackquotes_u24lambda_u2d0;
                    $this$stripBackquotes_u24lambda_u2d0.appendCodePoint(cp);
                }
                if (i == n) break;
                ++i;
            }
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return companion.stringFrom(string2);
    }

    private final boolean atEnd() {
        return this.positionInName > this.messageNameSize;
    }

    private final int peek() {
        return A_Tuple.Companion.tupleCodePointAt(this.messageName, this.positionInName);
    }

    private final boolean peek(MessageSplitter.Metacharacter metacharacter) {
        boolean peeked;
        boolean bl = peeked = !this.atEnd() && this.peek() == metacharacter.getCodepoint();
        if (peeked) {
            int n = this.positionInName;
            this.positionInName = n + 1;
        }
        return peeked;
    }

    private final boolean peek(MessageSplitter.Metacharacter ... metacharacters) {
        boolean bl;
        boolean bl2;
        int save2;
        block3: {
            save2 = this.positionInName;
            MessageSplitter.Metacharacter[] $this$all$iv = metacharacters;
            boolean $i$f$all = false;
            int n = $this$all$iv.length;
            for (int i = 0; i < n; ++i) {
                MessageSplitter.Metacharacter element$iv;
                MessageSplitter.Metacharacter p0 = element$iv = $this$all$iv[i];
                boolean bl3 = false;
                if (this.peek(p0)) continue;
                bl2 = false;
                break block3;
            }
            bl2 = true;
        }
        if (bl2) {
            bl = true;
        } else {
            this.positionInName = save2;
            bl = false;
        }
        return bl;
    }

    private final int previous(int n) {
        return A_Tuple.Companion.tupleCodePointAt(this.messageName, this.positionInName - n);
    }

    static /* synthetic */ int previous$default(MessageSplitterTokenizer messageSplitterTokenizer, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        return messageSplitterTokenizer.previous(n);
    }

    private final void backup(int n) {
        this.positionInName -= n;
    }

    static /* synthetic */ void backup$default(MessageSplitterTokenizer messageSplitterTokenizer, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        messageSplitterTokenizer.backup(n);
    }

    private final void skip(int n) {
        this.positionInName += n;
    }

    static /* synthetic */ void skip$default(MessageSplitterTokenizer messageSplitterTokenizer, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        messageSplitterTokenizer.skip(n);
    }

    private final void accept(int start, int end) {
        this.messagePartsList.add(this.messageName.copyStringFromToCanDestroy(start, end, false));
        this.messagePartPositions.add(start);
    }

    static /* synthetic */ void accept$default(MessageSplitterTokenizer messageSplitterTokenizer, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = n;
        }
        messageSplitterTokenizer.accept(n, n2);
    }

    private final void acceptStripped(IntRange range) {
        this.messagePartsList.add(this.stripBackquotes(range));
        this.messagePartPositions.add(range.getFirst());
    }

    private final void tokenizeMessage() throws MalformedMessageException {
        while (!this.atEnd()) {
            MessageSplitter.Metacharacter[] metacharacterArray;
            int start = this.positionInName;
            if (this.peek(MessageSplitter.Metacharacter.SPACE)) {
                if (this.messagePartsList.size() == 0 || MessageSplitter.Companion.isUnderscoreOrSpaceOrOperator(this.previous(2))) {
                    MessageSplitterTokenizer.backup$default(this, 0, 1, null);
                    MessageSplitter.Companion.throwMalformedMessageException(AvailErrorCode.E_METHOD_NAME_IS_NOT_CANONICAL, "Expected alphanumeric character before space");
                    throw new KotlinNothingValueException();
                }
                if (!this.atEnd() && !MessageSplitter.Companion.isUnderscoreOrSpaceOrOperator(this.peek())) continue;
                metacharacterArray = new MessageSplitter.Metacharacter[]{MessageSplitter.Metacharacter.BACK_QUOTE, MessageSplitter.Metacharacter.UNDERSCORE};
                if (!this.peek(metacharacterArray)) {
                    MessageSplitter.Companion.throwMalformedMessageException(AvailErrorCode.E_METHOD_NAME_IS_NOT_CANONICAL, "Expected alphanumeric character after space");
                    throw new KotlinNothingValueException();
                }
                this.backup(2);
                continue;
            }
            if (this.peek(MessageSplitter.Metacharacter.BACK_QUOTE)) {
                if (this.atEnd()) {
                    MessageSplitter.Companion.throwMalformedMessageException(AvailErrorCode.E_EXPECTED_OPERATOR_AFTER_BACKQUOTE, "Expected character after backquote");
                    throw new KotlinNothingValueException();
                }
                if (this.peek(MessageSplitter.Metacharacter.UNDERSCORE)) {
                    boolean sawRegular = false;
                    while (!this.atEnd()) {
                        if (!MessageSplitter.Companion.isUnderscoreOrSpaceOrOperator(this.peek())) {
                            sawRegular = true;
                            MessageSplitterTokenizer.skip$default(this, 0, 1, null);
                            continue;
                        }
                        MessageSplitter.Metacharacter[] metacharacterArray2 = new MessageSplitter.Metacharacter[]{MessageSplitter.Metacharacter.BACK_QUOTE, MessageSplitter.Metacharacter.UNDERSCORE};
                        if (this.peek(metacharacterArray2)) continue;
                    }
                    if (sawRegular) {
                        this.acceptStripped(RangesKt.until((int)start, (int)this.positionInName));
                        continue;
                    }
                    Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)start, (int)this.positionInName);
                    boolean $i$f$forEach = false;
                    Iterator iterator2 = $this$forEach$iv.iterator();
                    while (iterator2.hasNext()) {
                        int element$iv;
                        int p0 = element$iv = ((IntIterator)iterator2).nextInt();
                        boolean bl = false;
                        MessageSplitterTokenizer.accept$default(this, p0, 0, 2, null);
                    }
                    continue;
                }
                MessageSplitterTokenizer.accept$default(this, this.positionInName - 1, 0, 2, null);
                MessageSplitterTokenizer.accept$default(this, this.positionInName, 0, 2, null);
                MessageSplitterTokenizer.skip$default(this, 0, 1, null);
                continue;
            }
            if (MessageSplitter.Companion.isUnderscoreOrSpaceOrOperator(this.peek())) {
                MessageSplitterTokenizer.accept$default(this, this.positionInName, 0, 2, null);
                MessageSplitterTokenizer.skip$default(this, 0, 1, null);
                continue;
            }
            while (!this.atEnd()) {
                if (!MessageSplitter.Companion.isUnderscoreOrSpaceOrOperator(this.peek())) {
                    MessageSplitterTokenizer.skip$default(this, 0, 1, null);
                    continue;
                }
                metacharacterArray = new MessageSplitter.Metacharacter[]{MessageSplitter.Metacharacter.BACK_QUOTE, MessageSplitter.Metacharacter.UNDERSCORE};
                if (this.peek(metacharacterArray)) continue;
            }
            this.acceptStripped(RangesKt.until((int)start, (int)this.positionInName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final A_String[] canonicalMessageParts() {
        List list;
        Object $i$a$-read-MessageSplitterTokenizer$canonicalMessageParts$firstAttempt$22;
        A_String[] destination$iv$iv;
        boolean allPresent = false;
        allPresent = true;
        ReentrantReadWriteLock.ReadLock readLock = allCanonicalMessagePartsLock.readLock();
        readLock.lock();
        try {
            void $this$toTypedArray$iv;
            void $this$mapTo$iv$iv;
            boolean $i$a$-read-MessageSplitterTokenizer$canonicalMessageParts$firstAttempt$22 = false;
            Iterable $this$map$iv = this.messagePartsList;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            destination$iv$iv = (A_String[])new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void part;
                A_String a_String = (A_String)item$iv$iv;
                A_String[] a_StringArray = destination$iv$iv;
                boolean bl3 = false;
                A_String a_String2 = allCanonicalMessageParts.get(part);
                if (a_String2 == null) {
                    boolean bl2 = false;
                    allPresent = false;
                    a_String2 = part;
                }
                a_StringArray.add(a_String2);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            A_String[] a_StringArray = thisCollection$iv.toArray(new A_String[0]);
            if (a_StringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            $i$a$-read-MessageSplitterTokenizer$canonicalMessageParts$firstAttempt$22 = a_StringArray;
        }
        finally {
            readLock.unlock();
        }
        A_String[] firstAttempt = $i$a$-read-MessageSplitterTokenizer$canonicalMessageParts$firstAttempt$22;
        if (allPresent) {
            return firstAttempt;
        }
        ReentrantReadWriteLock $this$safeWrite$iv = allCanonicalMessagePartsLock;
        boolean $i$f$safeWrite = false;
        ReentrantReadWriteLock.WriteLock writeLock = $this$safeWrite$iv.writeLock();
        Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"this.writeLock()");
        $i$a$-read-MessageSplitterTokenizer$canonicalMessageParts$firstAttempt$22 = writeLock;
        $i$a$-read-MessageSplitterTokenizer$canonicalMessageParts$firstAttempt$22.lock();
        try {
            void $this$mapTo$iv$iv;
            boolean bl = false;
            A_String[] $this$map$iv = firstAttempt;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                A_String a_String;
                void part;
                void item$iv$iv;
                void bl3 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv2;
                boolean bl4 = false;
                Map<A_String, A_String> $this$getOrPut$iv = allCanonicalMessageParts;
                boolean $i$f$getOrPut = false;
                A_String value$iv = $this$getOrPut$iv.get(part);
                if (value$iv == null) {
                    boolean bl5 = false;
                    A_String answer$iv = part.makeShared();
                    $this$getOrPut$iv.put((A_String)part, answer$iv);
                    a_String = answer$iv;
                } else {
                    a_String = value$iv;
                }
                collection.add(a_String);
            }
            list = (List)destination$iv$iv2;
        }
        finally {
            $i$a$-read-MessageSplitterTokenizer$canonicalMessageParts$firstAttempt$22.unlock();
        }
        Collection $this$toTypedArray$iv = list;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        A_String[] a_StringArray = thisCollection$iv.toArray(new A_String[0]);
        if (a_StringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        return a_StringArray;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lavail/compiler/splitter/MessageSplitterTokenizer$Companion;", "", "()V", "allCanonicalMessageParts", "", "Lavail/descriptor/tuples/A_String;", "getAllCanonicalMessageParts", "()Ljava/util/Map;", "allCanonicalMessagePartsLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "getAllCanonicalMessagePartsLock", "()Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ReentrantReadWriteLock getAllCanonicalMessagePartsLock() {
            return allCanonicalMessagePartsLock;
        }

        @NotNull
        public final Map<A_String, A_String> getAllCanonicalMessageParts() {
            return allCanonicalMessageParts;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

