/*
 * Decompiled with CFR 0.152.
 */
package avail.descriptor.tuples;

import avail.annotations.HideFieldInDebugger;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.numbers.IntegerDescriptor;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.AvailObjectRepresentation;
import avail.descriptor.representation.BitField;
import avail.descriptor.representation.IntegerSlotsEnum;
import avail.descriptor.representation.Mutability;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ByteTupleDescriptor;
import avail.descriptor.tuples.NumericTupleDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.TreeTupleDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.optimizer.jvm.CheckedMethod;
import avail.optimizer.jvm.ReferencedInGeneratedCode;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.availlang.json.JSONWriter;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 =2\u00020\u0001:\u0002=>B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0000H\u0016J\b\u0010\b\u001a\u00020\u0000H\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016J0\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0005H\u0016J0\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0005H\u0016J \u0010\u0019\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u0005H\u0016J \u0010\u001c\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J(\u0010\u001e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u000eH\u0016J\u0018\u0010!\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\nH\u0016J\u0010\u0010\"\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010#\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010'\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\fH\u0016J(\u0010(\u001a\u00020)2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u00052\u0006\u0010,\u001a\u00020-H\u0016J\u0018\u0010.\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010/\u001a\u00020\u0005H\u0016J(\u00100\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010/\u001a\u00020\u00052\u0006\u00101\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J(\u00102\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010*\u001a\u00020\u00052\u0006\u0010+\u001a\u00020\u00052\u0006\u00103\u001a\u00020%H\u0016J\u0018\u00104\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010/\u001a\u00020\u0005H\u0016J\u0018\u00105\u001a\u0002062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010/\u001a\u00020\u0005H\u0016J\u0010\u00107\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u00108\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u00109\u001a\u00020)2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010:\u001a\u00020;H\u0016J\b\u0010<\u001a\u00020\u0000H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lavail/descriptor/tuples/ByteTupleDescriptor;", "Lavail/descriptor/tuples/NumericTupleDescriptor;", "mutability", "Lavail/descriptor/representation/Mutability;", "unusedBytesOfLastLong", "", "(Lavail/descriptor/representation/Mutability;I)V", "immutable", "mutable", "o_AppendCanDestroy", "Lavail/descriptor/tuples/A_Tuple;", "self", "Lavail/descriptor/representation/AvailObject;", "newElement", "Lavail/descriptor/representation/A_BasicObject;", "canDestroy", "", "o_BitsPerEntry", "o_CompareFromToWithByteTupleStartingAt", "startIndex1", "endIndex1", "aByteTuple", "startIndex2", "o_CompareFromToWithStartingAt", "anotherObject", "o_ComputeHashFromTo", "start", "end", "o_ConcatenateWith", "otherTuple", "o_CopyTupleFromToCanDestroy", "o_Equals", "another", "o_EqualsByteTuple", "o_IsByteTuple", "o_IsInstanceOfKind", "aType", "Lavail/descriptor/types/A_Type;", "o_MakeImmutable", "o_MakeShared", "o_TransferIntoByteBuffer", "", "startIndex", "endIndex", "outputByteBuffer", "Ljava/nio/ByteBuffer;", "o_TupleAt", "index", "o_TupleAtPuttingCanDestroy", "newValueObject", "o_TupleElementsInRangeAreInstancesOf", "type", "o_TupleIntAt", "o_TupleLongAt", "", "o_TupleReverse", "o_TupleSize", "o_WriteTo", "writer", "Lorg/availlang/json/JSONWriter;", "shared", "Companion", "IntegerSlots", "avail"})
public final class ByteTupleDescriptor
extends NumericTupleDescriptor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int unusedBytesOfLastLong;
    private static final int maximumCopySize = 64;
    @NotNull
    private static final ByteTupleDescriptor[] descriptors = new ByteTupleDescriptor[24];
    @NotNull
    private static final CheckedMethod createUninitializedByteTupleMethod;

    private ByteTupleDescriptor(Mutability mutability, int unusedBytesOfLastLong) {
        super(mutability, null, IntegerSlots.class);
        this.unusedBytesOfLastLong = unusedBytesOfLastLong;
    }

    @Override
    @NotNull
    public A_Tuple o_AppendCanDestroy(@NotNull AvailObject self, @NotNull A_BasicObject newElement, boolean canDestroy) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)newElement, (String)"newElement");
        int originalSize = A_Tuple.Companion.getTupleSize(self);
        AvailObject newElementStrong = (AvailObject)newElement;
        if (originalSize >= 64 || !A_Number.Companion.isInt(newElementStrong)) {
            return A_Tuple.Companion.concatenateWith(self, ObjectTupleDescriptor.Companion.tuple(newElement), canDestroy);
        }
        int intValue = A_Number.Companion.getExtractInt(newElementStrong);
        if ((intValue & 0xFFFFFF00) != 0) {
            return A_Tuple.Companion.concatenateWith(self, ObjectTupleDescriptor.Companion.tuple(newElement), canDestroy);
        }
        int newSize = originalSize + 1;
        if (this.isMutable() && canDestroy && (originalSize & 7) != 0) {
            self.setDescriptor(ByteTupleDescriptor.Companion.descriptorFor(Mutability.MUTABLE, newSize));
            self.setByteSlot(IntegerSlots.RAW_LONG_AT_, newSize, (short)intValue);
            self.setSlot(IntegerSlots.Companion.getHASH_OR_ZERO(), 0);
            return self;
        }
        AvailObject result2 = AvailObjectRepresentation.Companion.newLike(ByteTupleDescriptor.Companion.descriptorFor(Mutability.MUTABLE, newSize), self, 0, (originalSize & 7) == 0 ? 1 : 0);
        result2.setByteSlot(IntegerSlots.RAW_LONG_AT_, newSize, (short)intValue);
        result2.setSlot(IntegerSlots.Companion.getHASH_OR_ZERO(), 0);
        return result2;
    }

    @Override
    public int o_BitsPerEntry(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return 8;
    }

    @Override
    public boolean o_CompareFromToWithByteTupleStartingAt(@NotNull AvailObject self, int startIndex1, int endIndex1, @NotNull A_Tuple aByteTuple, int startIndex2) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)aByteTuple, (String)"aByteTuple");
        if (self.sameAddressAs(aByteTuple) && startIndex1 == startIndex2) {
            return true;
        }
        int index1 = startIndex1;
        int index2 = startIndex2;
        while (index1 <= endIndex1) {
            if (A_Tuple.Companion.tupleIntAt(self, index1) != A_Tuple.Companion.tupleIntAt(aByteTuple, index2)) {
                return false;
            }
            ++index1;
            ++index2;
        }
        return true;
    }

    @Override
    public boolean o_CompareFromToWithStartingAt(@NotNull AvailObject self, int startIndex1, int endIndex1, @NotNull A_Tuple anotherObject, int startIndex2) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)anotherObject, (String)"anotherObject");
        return A_Tuple.Companion.compareFromToWithByteTupleStartingAt(anotherObject, startIndex2, startIndex2 + endIndex1 - startIndex1, self, startIndex1);
    }

    @Override
    public int o_ComputeHashFromTo(@NotNull AvailObject self, int start, int end) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        int hash = 0;
        int index2 = end;
        if (start <= index2) {
            while (true) {
                int itemHash = IntegerDescriptor.Companion.hashOfUnsignedByte((short)A_Tuple.Companion.tupleIntAt(self, index2)) ^ 0x71E570A6;
                hash = (hash + itemHash) * 1664525;
                if (index2 == start) break;
                --index2;
            }
        }
        return hash;
    }

    @Override
    @NotNull
    public A_Tuple o_ConcatenateWith(@NotNull AvailObject self, @NotNull A_Tuple otherTuple, boolean canDestroy) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)otherTuple, (String)"otherTuple");
        int size1 = A_Tuple.Companion.getTupleSize(self);
        if (size1 == 0) {
            if (!canDestroy) {
                otherTuple.makeImmutable();
            }
            return otherTuple;
        }
        int size2 = A_Tuple.Companion.getTupleSize(otherTuple);
        if (size2 == 0) {
            if (!canDestroy) {
                self.makeImmutable();
            }
            return self;
        }
        int newSize = size1 + size2;
        if (otherTuple.isByteTuple() && newSize <= 64) {
            int newLongCount = newSize + 7 >>> 3;
            int deltaSlots = newLongCount - self.variableIntegerSlotsCount();
            AvailObject result2 = null;
            if (canDestroy && this.isMutable() && deltaSlots == 0) {
                result2 = self;
                result2.setDescriptor(ByteTupleDescriptor.Companion.descriptorFor(Mutability.MUTABLE, newSize));
            } else {
                result2 = AvailObjectRepresentation.Companion.newLike(ByteTupleDescriptor.Companion.descriptorFor(Mutability.MUTABLE, newSize), self, 0, deltaSlots);
            }
            int destination = size1 + 1;
            int source = 1;
            while (source <= size2) {
                result2.setByteSlot(IntegerSlots.RAW_LONG_AT_, destination, (short)A_Tuple.Companion.tupleIntAt(otherTuple, source));
                ++source;
                ++destination;
            }
            result2.setSlot(IntegerSlots.Companion.getHASH_OR_ZERO(), 0);
            return result2;
        }
        if (!canDestroy) {
            self.makeImmutable();
            otherTuple.makeImmutable();
        }
        return A_Tuple.Companion.getTreeTupleLevel(otherTuple) == 0 ? (A_Tuple)TreeTupleDescriptor.Companion.createTwoPartTreeTuple(self, otherTuple, 1, 0) : TreeTupleDescriptor.Companion.concatenateAtLeastOneTree(self, otherTuple, true);
    }

    @Override
    @NotNull
    public A_Tuple o_CopyTupleFromToCanDestroy(@NotNull AvailObject self, int start, int end, boolean canDestroy) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        int tupleSize = A_Tuple.Companion.getTupleSize(self);
        boolean bl2 = bl = (1 <= start ? start <= end + 1 : false) && end <= tupleSize;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        int size = end - start + 1;
        boolean bl3 = 1 <= size ? size < tupleSize : false;
        if (bl3 && size < 64) {
            AvailObject result2 = Companion.mutableObjectOfSize(size);
            int destination = 1;
            int src = start;
            while (src <= end) {
                result2.setByteSlot(IntegerSlots.RAW_LONG_AT_, destination, self.byteSlot(IntegerSlots.RAW_LONG_AT_, src));
                ++src;
                ++destination;
            }
            if (canDestroy) {
                self.assertObjectUnreachableIfMutable();
            }
            return result2;
        }
        return super.o_CopyTupleFromToCanDestroy(self, start, end, canDestroy);
    }

    @Override
    public boolean o_Equals(@NotNull AvailObject self, @NotNull A_BasicObject another) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)another, (String)"another");
        return another.equalsByteTuple(self);
    }

    @Override
    public boolean o_EqualsByteTuple(@NotNull AvailObject self, @NotNull A_Tuple aByteTuple) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)aByteTuple, (String)"aByteTuple");
        if (self.sameAddressAs(aByteTuple)) {
            return true;
        }
        if (A_Tuple.Companion.getTupleSize(self) != A_Tuple.Companion.getTupleSize(aByteTuple)) {
            return false;
        }
        if (self.hash() != aByteTuple.hash()) {
            return false;
        }
        if (!A_Tuple.Companion.compareFromToWithByteTupleStartingAt(self, 1, A_Tuple.Companion.getTupleSize(self), aByteTuple, 1)) {
            return false;
        }
        if (!this.isShared()) {
            aByteTuple.makeImmutable();
            self.becomeIndirectionTo(aByteTuple);
        } else if (!aByteTuple.descriptor().isShared()) {
            self.makeImmutable();
            aByteTuple.becomeIndirectionTo(self);
        }
        return true;
    }

    @Override
    public boolean o_IsByteTuple(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return true;
    }

    @Override
    public boolean o_IsInstanceOfKind(@NotNull AvailObject self, @NotNull A_Type aType) {
        boolean bl;
        block13: {
            Intrinsics.checkNotNullParameter((Object)self, (String)"self");
            Intrinsics.checkNotNullParameter((Object)aType, (String)"aType");
            if (A_Type.Companion.isSupertypeOfPrimitiveTypeEnum(aType, PrimitiveTypeDescriptor.Types.NONTYPE)) {
                bl = true;
            } else if (!aType.isTupleType()) {
                bl = false;
            } else if (!A_Type.Companion.rangeIncludesLong(A_Type.Companion.getSizeRange(aType), A_Tuple.Companion.getTupleSize(self))) {
                bl = false;
            } else {
                A_Tuple typeTuple2 = A_Type.Companion.getTypeTuple(aType);
                int i = 1;
                int breakIndex = RangesKt.coerceAtMost((int)A_Tuple.Companion.getTupleSize(self), (int)A_Tuple.Companion.getTupleSize(typeTuple2));
                if (i <= breakIndex) {
                    while (true) {
                        if (!A_Tuple.Companion.tupleAt(self, i).isInstanceOf(A_Type.Companion.typeAtIndex(aType, i))) {
                            return false;
                        }
                        if (i == breakIndex) break;
                        ++i;
                    }
                }
                A_Type defaultTypeObject = A_Type.Companion.getDefaultType(aType);
                if (A_Type.Companion.isSubtypeOf(IntegerRangeTypeDescriptor.Companion.getBytes(), defaultTypeObject)) {
                    return true;
                }
                Iterable $this$all$iv = (Iterable)new IntRange(breakIndex + 1, A_Tuple.Companion.getTupleSize(self));
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    Iterator iterator2 = $this$all$iv.iterator();
                    while (iterator2.hasNext()) {
                        int element$iv;
                        int i2 = element$iv = ((IntIterator)iterator2).nextInt();
                        boolean bl2 = false;
                        if (A_Tuple.Companion.tupleAt(self, i2).isInstanceOf(defaultTypeObject)) continue;
                        bl = false;
                        break block13;
                    }
                    bl = true;
                }
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public AvailObject o_MakeImmutable(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        if (this.isMutable()) {
            self.setDescriptor(ByteTupleDescriptor.Companion.descriptorFor(Mutability.IMMUTABLE, A_Tuple.Companion.getTupleSize(self)));
        }
        return self;
    }

    @Override
    @NotNull
    public AvailObject o_MakeShared(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        if (!this.isShared()) {
            self.setDescriptor(ByteTupleDescriptor.Companion.descriptorFor(Mutability.SHARED, A_Tuple.Companion.getTupleSize(self)));
        }
        return self;
    }

    @Override
    public void o_TransferIntoByteBuffer(@NotNull AvailObject self, int startIndex, int endIndex, @NotNull ByteBuffer outputByteBuffer) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)outputByteBuffer, (String)"outputByteBuffer");
        int index2 = startIndex;
        if (index2 <= endIndex) {
            while (true) {
                outputByteBuffer.put((byte)self.byteSlot(IntegerSlots.RAW_LONG_AT_, index2));
                if (index2 == endIndex) break;
                ++index2;
            }
        }
    }

    @Override
    @NotNull
    public AvailObject o_TupleAt(@NotNull AvailObject self, int index2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        boolean bl2 = bl = index2 >= 1 && index2 <= A_Tuple.Companion.getTupleSize(self);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        return IntegerDescriptor.Companion.fromUnsignedByte(self.byteSlot(IntegerSlots.RAW_LONG_AT_, index2));
    }

    @Override
    @NotNull
    public A_Tuple o_TupleAtPuttingCanDestroy(@NotNull AvailObject self, int index2, @NotNull A_BasicObject newValueObject, boolean canDestroy) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)newValueObject, (String)"newValueObject");
        boolean bl2 = bl = index2 >= 1 && index2 <= A_Tuple.Companion.getTupleSize(self);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        AvailObject newValueStrong = (AvailObject)newValueObject;
        if (!newValueObject.isUnsignedByte()) {
            return A_Number.Companion.isInt(newValueStrong) ? A_Tuple.Companion.tupleAtPuttingCanDestroy(A_Tuple.Companion.copyAsMutableIntTuple(self), index2, newValueObject, true) : A_Tuple.Companion.tupleAtPuttingCanDestroy(A_Tuple.Companion.copyAsMutableObjectTuple(self), index2, newValueObject, true);
        }
        AvailObject result2 = canDestroy && this.isMutable() ? self : AvailObjectRepresentation.Companion.newLike(this.mutable(), self, 0, 0);
        result2.setByteSlot(IntegerSlots.RAW_LONG_AT_, index2, A_Number.Companion.getExtractUnsignedByte((A_Number)newValueObject));
        result2.setHashOrZero(0);
        return result2;
    }

    @Override
    public boolean o_TupleElementsInRangeAreInstancesOf(@NotNull AvailObject self, int startIndex, int endIndex, @NotNull A_Type type) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return A_Type.Companion.isSubtypeOf(IntegerRangeTypeDescriptor.Companion.getBytes(), type) || super.o_TupleElementsInRangeAreInstancesOf(self, startIndex, endIndex, type);
    }

    @Override
    public int o_TupleIntAt(@NotNull AvailObject self, int index2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        boolean bl2 = bl = index2 >= 1 && index2 <= A_Tuple.Companion.getTupleSize(self);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        return self.byteSlot(IntegerSlots.RAW_LONG_AT_, index2);
    }

    @Override
    public long o_TupleLongAt(@NotNull AvailObject self, int index2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        boolean bl2 = bl = index2 >= 1 && index2 <= A_Tuple.Companion.getTupleSize(self);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        return self.byteSlot(IntegerSlots.RAW_LONG_AT_, index2);
    }

    @Override
    @NotNull
    public A_Tuple o_TupleReverse(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        int tupleSize = A_Tuple.Companion.getTupleSize(self);
        boolean bl = 1 <= tupleSize ? tupleSize < 64 : false;
        if (bl) {
            Ref.IntRef sourceIndex = new Ref.IntRef();
            sourceIndex.element = tupleSize;
            return Companion.generateByteTupleFrom(tupleSize, (Function1<? super Integer, Integer>)((Function1)new Function1<Integer, Integer>(self, sourceIndex){
                final /* synthetic */ AvailObject $self;
                final /* synthetic */ Ref.IntRef $sourceIndex;
                {
                    this.$self = $self;
                    this.$sourceIndex = $sourceIndex;
                    super(1);
                }

                @NotNull
                public final Integer invoke(int it) {
                    int n = this.$sourceIndex.element;
                    this.$sourceIndex.element = n + -1;
                    return this.$self.byteSlot(IntegerSlots.RAW_LONG_AT_, n);
                }
            }));
        }
        return super.o_TupleReverse(self);
    }

    @Override
    public int o_TupleSize(@NotNull AvailObject self) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        return (self.variableIntegerSlotsCount() << 3) - this.unusedBytesOfLastLong;
    }

    @Override
    public void o_WriteTo(@NotNull AvailObject self, @NotNull JSONWriter writer) {
        Intrinsics.checkNotNullParameter((Object)self, (String)"self");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        writer.startArray();
        int limit = A_Tuple.Companion.getTupleSize(self);
        for (int i = 1; i <= limit; ++i) {
            writer.write(A_Tuple.Companion.tupleIntAt(self, i));
        }
        writer.endArray();
    }

    @Override
    @NotNull
    public ByteTupleDescriptor mutable() {
        ByteTupleDescriptor byteTupleDescriptor = descriptors[(8 - this.unusedBytesOfLastLong & 7) * 3 + Mutability.MUTABLE.ordinal()];
        Intrinsics.checkNotNull((Object)byteTupleDescriptor);
        return byteTupleDescriptor;
    }

    @Override
    @NotNull
    public ByteTupleDescriptor immutable() {
        ByteTupleDescriptor byteTupleDescriptor = descriptors[(8 - this.unusedBytesOfLastLong & 7) * 3 + Mutability.IMMUTABLE.ordinal()];
        Intrinsics.checkNotNull((Object)byteTupleDescriptor);
        return byteTupleDescriptor;
    }

    @Override
    @NotNull
    public ByteTupleDescriptor shared() {
        ByteTupleDescriptor byteTupleDescriptor = descriptors[(8 - this.unusedBytesOfLastLong & 7) * 3 + Mutability.SHARED.ordinal()];
        Intrinsics.checkNotNull((Object)byteTupleDescriptor);
        return byteTupleDescriptor;
    }

    @ReferencedInGeneratedCode
    @JvmStatic
    @NotNull
    public static final AvailObject mutableObjectOfSize(int size) {
        return Companion.mutableObjectOfSize(size);
    }

    static {
        Class[] classArray = new Class[1];
        Intrinsics.checkNotNull(Integer.TYPE);
        createUninitializedByteTupleMethod = CheckedMethod.Companion.staticMethod(ByteTupleDescriptor.class, "mutableObjectOfSize", AvailObject.class, classArray);
        int i = 0;
        int[] nArray = new int[]{0, 7, 6, 5, 4, 3, 2, 1};
        for (int excess : nArray) {
            ByteTupleDescriptor.descriptors[i++] = new ByteTupleDescriptor(Mutability.MUTABLE, excess);
            ByteTupleDescriptor.descriptors[i++] = new ByteTupleDescriptor(Mutability.IMMUTABLE, excess);
            ByteTupleDescriptor.descriptors[i++] = new ByteTupleDescriptor(Mutability.SHARED, excess);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0001\u0018\u0000 \u00062\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0001\u0006B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0007"}, d2={"Lavail/descriptor/tuples/ByteTupleDescriptor$IntegerSlots;", "", "Lavail/descriptor/representation/IntegerSlotsEnum;", "(Ljava/lang/String;I)V", "HASH_AND_MORE", "RAW_LONG_AT_", "Companion", "avail"})
    public static final class IntegerSlots
    extends Enum<IntegerSlots>
    implements IntegerSlotsEnum {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private static final BitField HASH_OR_ZERO;
        @HideFieldInDebugger
        public static final /* enum */ IntegerSlots HASH_AND_MORE;
        public static final /* enum */ IntegerSlots RAW_LONG_AT_;
        private static final /* synthetic */ IntegerSlots[] $VALUES;

        public static IntegerSlots[] values() {
            return (IntegerSlots[])$VALUES.clone();
        }

        public static IntegerSlots valueOf(String value) {
            return Enum.valueOf(IntegerSlots.class, value);
        }

        static {
            boolean bl;
            HASH_AND_MORE = new IntegerSlots();
            RAW_LONG_AT_ = new IntegerSlots();
            $VALUES = integerSlotsArray = new IntegerSlots[]{IntegerSlots.HASH_AND_MORE, IntegerSlots.RAW_LONG_AT_};
            Companion = new Companion(null);
            HASH_OR_ZERO = new BitField(HASH_AND_MORE, 0, 32, (Function1<? super Integer, String>)((Function1)Companion.HASH_OR_ZERO.1.INSTANCE));
            boolean bl2 = bl = TupleDescriptor.IntegerSlots.HASH_AND_MORE.ordinal() == HASH_AND_MORE.ordinal();
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            bl = TupleDescriptor.IntegerSlots.Companion.getHASH_OR_ZERO().isSamePlaceAs(HASH_OR_ZERO);
            if (_Assertions.ENABLED && !bl) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lavail/descriptor/tuples/ByteTupleDescriptor$IntegerSlots$Companion;", "", "()V", "HASH_OR_ZERO", "Lavail/descriptor/representation/BitField;", "getHASH_OR_ZERO", "()Lavail/descriptor/representation/BitField;", "avail"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final BitField getHASH_OR_ZERO() {
                return HASH_OR_ZERO;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\fH\u0002J\"\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\f2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u0014J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\fH\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0018\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lavail/descriptor/tuples/ByteTupleDescriptor$Companion;", "", "()V", "createUninitializedByteTupleMethod", "Lavail/optimizer/jvm/CheckedMethod;", "getCreateUninitializedByteTupleMethod", "()Lavail/optimizer/jvm/CheckedMethod;", "descriptors", "", "Lavail/descriptor/tuples/ByteTupleDescriptor;", "[Lavail/descriptor/tuples/ByteTupleDescriptor;", "maximumCopySize", "", "descriptorFor", "flag", "Lavail/descriptor/representation/Mutability;", "size", "generateByteTupleFrom", "Lavail/descriptor/representation/AvailObject;", "generator", "Lkotlin/Function1;", "mutableObjectOfSize", "avail"})
    public static final class Companion {
        private Companion() {
        }

        private final ByteTupleDescriptor descriptorFor(Mutability flag, int size) {
            ByteTupleDescriptor byteTupleDescriptor = descriptors[(size & 7) * 3 + flag.ordinal()];
            Intrinsics.checkNotNull((Object)byteTupleDescriptor);
            return byteTupleDescriptor;
        }

        @ReferencedInGeneratedCode
        @JvmStatic
        @NotNull
        public final AvailObject mutableObjectOfSize(int size) {
            AvailObject availObject;
            boolean bl;
            ByteTupleDescriptor descriptor = this.descriptorFor(Mutability.MUTABLE, size);
            boolean bl2 = bl = (size + descriptor.unusedBytesOfLastLong & 7) == 0;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            int indexedSlotCount$iv = size + 7 >> 3;
            boolean $i$f$create = false;
            AvailObject $this$null = availObject = AvailObject.Companion.newIndexedDescriptor(indexedSlotCount$iv, descriptor);
            return availObject;
        }

        @NotNull
        public final CheckedMethod getCreateUninitializedByteTupleMethod() {
            return createUninitializedByteTupleMethod;
        }

        @NotNull
        public final AvailObject generateByteTupleFrom(int size, @NotNull Function1<? super Integer, Integer> generator) {
            boolean bl;
            Intrinsics.checkNotNullParameter(generator, (String)"generator");
            AvailObject result2 = this.mutableObjectOfSize(size);
            int tupleIndex = 1;
            int limit = size >>> 3;
            for (int slotIndex = 1; slotIndex <= limit; ++slotIndex) {
                long combined = 0L;
                for (int shift = 0; shift < 64; shift += 8) {
                    long c;
                    boolean bl2;
                    boolean bl3 = bl2 = ((c = (long)((Number)generator.invoke((Object)tupleIndex++)).intValue()) & 0xFFL) == c;
                    if (_Assertions.ENABLED && !bl2) {
                        String string2 = "Assertion failed";
                        throw new AssertionError((Object)string2);
                    }
                    combined += c << shift;
                }
                result2.setSlot(IntegerSlots.RAW_LONG_AT_, slotIndex, combined);
            }
            int index2 = (size & 0xFFFFFFF8) + 1;
            if (index2 <= size) {
                while (true) {
                    long c;
                    boolean bl4;
                    boolean bl5 = bl4 = ((c = (long)((Number)generator.invoke((Object)tupleIndex++)).intValue()) & 0xFFL) == c;
                    if (_Assertions.ENABLED && !bl4) {
                        String string3 = "Assertion failed";
                        throw new AssertionError((Object)string3);
                    }
                    result2.setByteSlot(IntegerSlots.RAW_LONG_AT_, index2, (short)c);
                    if (index2 == size) break;
                    ++index2;
                }
            }
            boolean bl6 = bl = tupleIndex == size + 1;
            if (_Assertions.ENABLED && !bl) {
                String string4 = "Assertion failed";
                throw new AssertionError((Object)string4);
            }
            return result2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

