/*
 * Decompiled with CFR 0.152.
 */
package avail.environment;

import avail.AvailRuntime;
import avail.builder.ModuleName;
import avail.builder.ModuleNameResolver;
import avail.environment.AvailEditor;
import avail.environment.AvailWorkbench;
import avail.environment.MenuBarBuilder;
import avail.environment.MenuBuilder;
import avail.environment.SwingHelperKt;
import avail.environment.actions.FindAction;
import avail.environment.editor.AbstractEditorAction;
import avail.error.ErrorCode;
import avail.resolver.ModuleRootResolver;
import avail.resolver.ResolverReference;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.Semaphore;
import javax.swing.GroupLayout;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\b\u0010\u0018\u001a\u00020\u0016H\u0002J\u0006\u0010\u0019\u001a\u00020\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001a"}, d2={"Lavail/environment/AvailEditor;", "Ljavax/swing/JFrame;", "workbench", "Lavail/environment/AvailWorkbench;", "moduleName", "Lavail/builder/ModuleName;", "(Lavail/environment/AvailWorkbench;Lavail/builder/ModuleName;)V", "firstUnsavedEditTime", "", "lastEditTime", "lastSaveTime", "resolverReference", "Lavail/resolver/ResolverReference;", "runtime", "Lavail/AvailRuntime;", "sourcePane", "Ljavax/swing/JTextPane;", "undoManager", "Ljavax/swing/undo/UndoManager;", "getWorkbench", "()Lavail/environment/AvailWorkbench;", "editorChanged", "", "eventuallySave", "forceWrite", "open", "avail"})
public final class AvailEditor
extends JFrame {
    @NotNull
    private final AvailWorkbench workbench;
    @NotNull
    private final AvailRuntime runtime;
    private long firstUnsavedEditTime;
    private long lastEditTime;
    private long lastSaveTime;
    @NotNull
    private final ResolverReference resolverReference;
    @NotNull
    private final UndoManager undoManager;
    @NotNull
    private final JTextPane sourcePane;

    /*
     * WARNING - void declaration
     */
    public AvailEditor(@NotNull AvailWorkbench workbench, @NotNull ModuleName moduleName2) {
        void $this$_init__u24lambda_u2d4;
        JMenuBar jMenuBar;
        void $this$sourcePane_u24lambda_u2d1;
        Serializable $this$undoManager_u24lambda_u2d0;
        Serializable serializable;
        Intrinsics.checkNotNullParameter((Object)workbench, (String)"workbench");
        Intrinsics.checkNotNullParameter((Object)moduleName2, (String)"moduleName");
        super("Avail Editor: " + moduleName2);
        this.workbench = workbench;
        this.runtime = this.workbench.getRuntime();
        this.resolverReference = ModuleNameResolver.resolve$default(this.runtime.getModuleNameResolver(), moduleName2, null, 2, null).getResolverReference();
        UndoManager undoManager = serializable = new UndoManager();
        AvailEditor availEditor = this;
        boolean bl = false;
        $this$undoManager_u24lambda_u2d0.setLimit(1000);
        availEditor.undoManager = serializable;
        serializable = KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx());
        new AbstractEditorAction((KeyStroke)serializable){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                try {
                    undoManager.undo();
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
            }
        };
        serializable = KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx() | 0x40);
        new AbstractEditorAction((KeyStroke)serializable){

            @Override
            public void actionPerformed(@NotNull ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                try {
                    undoManager.redo();
                }
                catch (CannotRedoException cannotRedoException) {
                    // empty catch block
                }
            }
        };
        $this$undoManager_u24lambda_u2d0 = serializable = SwingHelperKt.codeSuitableTextPane(this.workbench);
        availEditor = this;
        boolean bl2 = false;
        Semaphore semaphore = new Semaphore(0);
        this.resolverReference.readFileString(true, (Function2<? super String, ? super UUID, Unit>)((Function2)new Function2<String, UUID, Unit>((JTextPane)$this$sourcePane_u24lambda_u2d1, semaphore){
            final /* synthetic */ JTextPane $this_apply;
            final /* synthetic */ Semaphore $semaphore;
            {
                this.$this_apply = $receiver;
                this.$semaphore = $semaphore;
                super(2);
            }

            public final void invoke(@NotNull String string2, @Nullable UUID uUID) {
                Intrinsics.checkNotNullParameter((Object)string2, (String)"string");
                this.$this_apply.setText(string2);
                this.$semaphore.release();
            }
        }), (Function2<? super ErrorCode, ? super Throwable, Unit>)((Function2)new Function2<ErrorCode, Throwable, Unit>((JTextPane)$this$sourcePane_u24lambda_u2d1, semaphore){
            final /* synthetic */ JTextPane $this_apply;
            final /* synthetic */ Semaphore $semaphore;
            {
                this.$this_apply = $receiver;
                this.$semaphore = $semaphore;
                super(2);
            }

            public final void invoke(@NotNull ErrorCode code, @Nullable Throwable throwable) {
                Intrinsics.checkNotNullParameter((Object)code, (String)"code");
                this.$this_apply.setText("Error reading module: " + throwable + ", code=" + code);
                this.$semaphore.release();
            }
        }));
        semaphore.acquire();
        $this$sourcePane_u24lambda_u2d1.setEditable(this.resolverReference.getResolver().getCanSave());
        $this$sourcePane_u24lambda_u2d1.getDocument().addDocumentListener(new DocumentListener(this){
            final /* synthetic */ AvailEditor this$0;
            {
                this.this$0 = $receiver;
            }

            public void insertUpdate(@NotNull DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                AvailEditor.access$editorChanged(this.this$0);
            }

            public void changedUpdate(@NotNull DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                AvailEditor.access$editorChanged(this.this$0);
            }

            public void removeUpdate(@NotNull DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                AvailEditor.access$editorChanged(this.this$0);
            }
        });
        $this$sourcePane_u24lambda_u2d1.getDocument().addUndoableEditListener(this.undoManager);
        availEditor.sourcePane = serializable;
        MenuBarBuilder.Companion this_$iv = MenuBarBuilder.Companion;
        boolean $i$f$createMenuBar = false;
        JMenuBar it$iv = jMenuBar = new JMenuBar();
        boolean bl3 = false;
        MenuBarBuilder menuBarBuilder = new MenuBarBuilder(it$iv);
        availEditor = this;
        boolean bl4 = false;
        $this$_init__u24lambda_u2d4.menu("Edit", (Function1<? super MenuBuilder, Unit>)((Function1)new Function1<MenuBuilder, Unit>(this){
            final /* synthetic */ AvailEditor this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull MenuBuilder $this$menu) {
                Intrinsics.checkNotNullParameter((Object)$this$menu, (String)"$this$menu");
                $this$menu.item(new FindAction(this.this$0.getWorkbench()));
            }
        }));
        availEditor.setJMenuBar(jMenuBar);
    }

    @NotNull
    public final AvailWorkbench getWorkbench() {
        return this.workbench;
    }

    private final void editorChanged() {
        long editTime = this.lastEditTime;
        this.lastEditTime = System.currentTimeMillis();
        if (editTime <= this.lastSaveTime) {
            this.firstUnsavedEditTime = this.lastEditTime;
            this.eventuallySave();
        }
    }

    private final void eventuallySave() {
        long maximumStaleness = 10000L;
        long idleBeforeWrite = 200L;
        this.runtime.getTimer().schedule(new TimerTask(this, maximumStaleness, idleBeforeWrite){
            final /* synthetic */ AvailEditor this$0;
            final /* synthetic */ long $maximumStaleness;
            final /* synthetic */ long $idleBeforeWrite;
            {
                this.this$0 = $receiver;
                this.$maximumStaleness = $maximumStaleness;
                this.$idleBeforeWrite = $idleBeforeWrite;
            }

            public void run() {
                SwingUtilities.invokeLater(() -> eventuallySave.1.run$lambda-0(this.this$0, this.$maximumStaleness, this.$idleBeforeWrite));
            }

            private static final void run$lambda-0(AvailEditor this$0, long $maximumStaleness, long $idleBeforeWrite) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                if (AvailEditor.access$getLastEditTime$p(this$0) < AvailEditor.access$getLastSaveTime$p(this$0)) {
                    return;
                }
                long now = System.currentTimeMillis();
                if (now - AvailEditor.access$getFirstUnsavedEditTime$p(this$0) > $maximumStaleness) {
                    AvailEditor.access$forceWrite(this$0);
                } else if (now - AvailEditor.access$getLastEditTime$p(this$0) > $idleBeforeWrite) {
                    AvailEditor.access$forceWrite(this$0);
                } else {
                    AvailEditor.access$eventuallySave(this$0);
                }
            }
        }, idleBeforeWrite);
    }

    private final void forceWrite() {
        String string2 = this.sourcePane.getText();
        Semaphore semaphore = new Semaphore(0);
        Ref.ObjectRef throwable = new Ref.ObjectRef();
        ModuleRootResolver moduleRootResolver = this.resolverReference.getResolver();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"string");
        String string3 = string2;
        byte[] byArray = string3.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        moduleRootResolver.saveFile(this.resolverReference, byArray, (Function0<Unit>)((Function0)new Function0<Unit>(semaphore){
            final /* synthetic */ Semaphore $semaphore;
            {
                this.$semaphore = $semaphore;
                super(0);
            }

            public final void invoke() {
                this.$semaphore.release();
            }
        }), (Function2<? super ErrorCode, ? super Throwable, Unit>)((Function2)new Function2<ErrorCode, Throwable, Unit>((Ref.ObjectRef<Throwable>)throwable, semaphore){
            final /* synthetic */ Ref.ObjectRef<Throwable> $throwable;
            final /* synthetic */ Semaphore $semaphore;
            {
                this.$throwable = $throwable;
                this.$semaphore = $semaphore;
                super(2);
            }

            public final void invoke(@NotNull ErrorCode errorCode, @Nullable Throwable t) {
                Intrinsics.checkNotNullParameter((Object)errorCode, (String)"<anonymous parameter 0>");
                this.$throwable.element = t;
                this.$semaphore.release();
            }
        }));
        semaphore.acquire();
        this.lastSaveTime = System.currentTimeMillis();
        Throwable throwable2 = (Throwable)throwable.element;
        if (throwable2 != null) {
            Throwable it = throwable2;
            boolean bl = false;
            throw it;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void open() {
        void $this$open_u24lambda_u2d3;
        GroupLayout groupLayout;
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ AvailEditor this$0;
            {
                this.this$0 = $receiver;
            }

            public void windowClosing(@NotNull WindowEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (AvailEditor.access$getLastSaveTime$p(this.this$0) < AvailEditor.access$getLastEditTime$p(this.this$0)) {
                    AvailEditor.access$forceWrite(this.this$0);
                }
                this.this$0.getWorkbench().getOpenEditors().remove(AvailEditor.access$getResolverReference$p(this.this$0).getModuleName());
            }
        });
        JPanel panel = new JPanel(new BorderLayout(20, 20));
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setBackground(panel.getBackground());
        JScrollPane sourcePaneScroll = SwingHelperKt.scrollTextWithLineNumbers(this.sourcePane);
        GroupLayout groupLayout2 = groupLayout = new GroupLayout(panel);
        JPanel jPanel = panel;
        boolean bl = false;
        $this$open_u24lambda_u2d3.setAutoCreateGaps(true);
        $this$open_u24lambda_u2d3.setHorizontalGroup($this$open_u24lambda_u2d3.createSequentialGroup().addComponent(sourcePaneScroll));
        $this$open_u24lambda_u2d3.setVerticalGroup($this$open_u24lambda_u2d3.createSequentialGroup().addComponent(sourcePaneScroll));
        jPanel.setLayout(groupLayout);
        this.setMinimumSize(new Dimension(550, 350));
        this.setPreferredSize(new Dimension(800, 1000));
        this.add(panel);
        this.pack();
        this.setVisible(true);
    }

    public static final /* synthetic */ long access$getLastEditTime$p(AvailEditor $this) {
        return $this.lastEditTime;
    }

    public static final /* synthetic */ long access$getLastSaveTime$p(AvailEditor $this) {
        return $this.lastSaveTime;
    }

    public static final /* synthetic */ long access$getFirstUnsavedEditTime$p(AvailEditor $this) {
        return $this.firstUnsavedEditTime;
    }

    public static final /* synthetic */ void access$forceWrite(AvailEditor $this) {
        $this.forceWrite();
    }

    public static final /* synthetic */ void access$eventuallySave(AvailEditor $this) {
        $this.eventuallySave();
    }

    public static final /* synthetic */ ResolverReference access$getResolverReference$p(AvailEditor $this) {
        return $this.resolverReference;
    }

    public static final /* synthetic */ void access$editorChanged(AvailEditor $this) {
        $this.editorChanged();
    }
}

