/*
 * Decompiled with CFR 0.152.
 */
package avail.environment.actions;

import avail.builder.ModuleRoot;
import avail.builder.ModuleRoots;
import avail.environment.AvailWorkbench;
import avail.environment.actions.AbstractWorkbenchAction;
import avail.environment.actions.PreferencesAction;
import avail.persistence.cache.Repositories;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeNode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.availlang.persistence.IndexedFileException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0012H\u0002J\u0006\u0010\u0016\u001a\u00020\u0012R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0018\u0010\u000b\u001a\u00060\fR\u00020\u0000X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0018\u0010\u000f\u001a\u00060\fR\u00020\u0000X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000e\u00a8\u0006\u0018"}, d2={"Lavail/environment/actions/PreferencesAction;", "Lavail/environment/actions/AbstractWorkbenchAction;", "workbench", "Lavail/environment/AvailWorkbench;", "(Lavail/environment/AvailWorkbench;)V", "preferencesDialog", "Ljavax/swing/JDialog;", "getPreferencesDialog$avail", "()Ljavax/swing/JDialog;", "setPreferencesDialog$avail", "(Ljavax/swing/JDialog;)V", "renamesTableModel", "Lavail/environment/actions/PreferencesAction$SimpleTableModel;", "getRenamesTableModel$avail", "()Lavail/environment/actions/PreferencesAction$SimpleTableModel;", "rootsTableModel", "getRootsTableModel$avail", "actionPerformed", "", "event", "Ljava/awt/event/ActionEvent;", "createDialog", "savePreferences", "SimpleTableModel", "avail"})
public final class PreferencesAction
extends AbstractWorkbenchAction {
    @Nullable
    private JDialog preferencesDialog;
    @NotNull
    private final SimpleTableModel rootsTableModel;
    @NotNull
    private final SimpleTableModel renamesTableModel;

    public PreferencesAction(@NotNull AvailWorkbench workbench) {
        Intrinsics.checkNotNullParameter((Object)workbench, (String)"workbench");
        super(workbench, "Preferences\u2026", null, null, 12, null);
        String[] stringArray = new String[]{"root", "source"};
        this.rootsTableModel = new SimpleTableModel(stringArray);
        stringArray = new String[]{"module", "replacement path"};
        this.renamesTableModel = new SimpleTableModel(stringArray);
        this.putValue("ShortDescription", "Preferences\u2026");
    }

    @Nullable
    public final JDialog getPreferencesDialog$avail() {
        return this.preferencesDialog;
    }

    public final void setPreferencesDialog$avail(@Nullable JDialog jDialog) {
        this.preferencesDialog = jDialog;
    }

    @NotNull
    public final SimpleTableModel getRootsTableModel$avail() {
        return this.rootsTableModel;
    }

    @NotNull
    public final SimpleTableModel getRenamesTableModel$avail() {
        return this.renamesTableModel;
    }

    @Override
    public void actionPerformed(@Nullable ActionEvent event) {
        if (this.preferencesDialog == null) {
            this.createDialog();
            JDialog jDialog = this.preferencesDialog;
            Intrinsics.checkNotNull((Object)jDialog);
            jDialog.setVisible(true);
            this.preferencesDialog = null;
        } else {
            JDialog jDialog = this.preferencesDialog;
            Intrinsics.checkNotNull((Object)jDialog);
            jDialog.toFront();
        }
    }

    public final void savePreferences() {
        String string2;
        ModuleRoots roots2 = this.getWorkbench().getResolver().getModuleRoots();
        Repositories.INSTANCE.closeAllRepositories();
        roots2.clearRoots();
        for (List<String> pair : this.rootsTableModel.getRows()) {
            boolean bl;
            boolean bl2 = bl = pair.size() == 2;
            if (_Assertions.ENABLED && !bl) {
                string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            try {
                String name2 = pair.get(0);
                String uri = pair.get(1);
                Semaphore semaphore = new Semaphore(0);
                roots2.addRoot(name2, uri, (Function1<? super List<String>, Unit>)((Function1)new Function1<List<? extends String>, Unit>(semaphore){
                    final /* synthetic */ Semaphore $semaphore;
                    {
                        this.$semaphore = $semaphore;
                        super(1);
                    }

                    public final void invoke(@NotNull List<String> failures) {
                        Intrinsics.checkNotNullParameter(failures, (String)"failures");
                        Iterable $this$forEach$iv = failures;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            String failure = (String)element$iv;
                            boolean bl = false;
                            System.err.println(failure);
                        }
                        this.$semaphore.release();
                    }
                }));
                semaphore.acquire();
            }
            catch (IndexedFileException indexedFileException) {
                // empty catch block
            }
            for (ModuleRoot root : roots2) {
                root.getRepository().reopenIfNecessary();
            }
        }
        this.getWorkbench().getResolver().clearRenameRules();
        for (List<String> pair : this.renamesTableModel.getRows()) {
            boolean bl;
            boolean bl3 = bl = pair.size() == 2;
            if (_Assertions.ENABLED && !bl) {
                string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            this.getWorkbench().getResolver().addRenameRule(pair.get(0), pair.get(1));
        }
        this.getWorkbench().saveModuleConfiguration();
    }

    /*
     * WARNING - void declaration
     */
    private final void createDialog() {
        void $this$createDialog_u24lambda_u2d1_u24lambda_u2d0;
        Point point;
        Object pair;
        JPanel panel = new JPanel(new BorderLayout(20, 20));
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.preferencesDialog = new JDialog((Frame)this.getWorkbench(), "Preferences");
        JLabel rootsLabel = new JLabel("Avail module roots");
        panel.add(rootsLabel);
        this.rootsTableModel.getRows().clear();
        for (ModuleRoot root : this.getWorkbench().getResolver().getModuleRoots().getRoots()) {
            List list = new ArrayList();
            list.add(root.getName());
            String string2 = root.getResolver().getUri().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"root.resolver.uri.toString()");
            list.add(string2);
            this.rootsTableModel.getRows().add(list);
        }
        JTable rootsTable = new JTable(this.rootsTableModel);
        rootsTable.putClientProperty("terminateEditOnFocusLost", true);
        TableColumnModel rootsColumns = rootsTable.getColumnModel();
        rootsColumns.getColumn(0).setMinWidth(30);
        rootsColumns.getColumn(0).setPreferredWidth(60);
        rootsColumns.getColumn(1).setMinWidth(50);
        rootsColumns.getColumn(1).setPreferredWidth(500);
        rootsTable.setGridColor(Color.gray);
        rootsTable.setFillsViewportHeight(true);
        JScrollPane rootsScrollPane = new JScrollPane(rootsTable);
        panel.add(rootsScrollPane);
        AvailWorkbench availWorkbench = this.getWorkbench();
        AbstractWorkbenchAction addRootAction2 = new AbstractWorkbenchAction(rootsTable, this, availWorkbench){
            final /* synthetic */ JTable $rootsTable;
            final /* synthetic */ PreferencesAction this$0;
            {
                this.$rootsTable = $rootsTable;
                this.this$0 = $receiver;
                super($super_call_param$1, "+", null, null, 12, null);
            }

            public void actionPerformed(@NotNull ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                int insertionIndex = this.$rootsTable.getSelectedRow();
                if (insertionIndex == -1) {
                    insertionIndex = this.this$0.getRootsTableModel$avail().getRowCount();
                }
                Object[] objectArray = new String[]{"", ""};
                this.this$0.getRootsTableModel$avail().getRows().add(insertionIndex, CollectionsKt.mutableListOf((Object[])objectArray));
                this.this$0.getRootsTableModel$avail().fireTableDataChanged();
                this.$rootsTable.changeSelection(insertionIndex, 0, false, false);
            }
        };
        JButton addRootButton = new JButton(addRootAction2);
        panel.add(addRootButton);
        AvailWorkbench availWorkbench2 = this.getWorkbench();
        AbstractWorkbenchAction removeRootAction2 = new AbstractWorkbenchAction(rootsTable, this, availWorkbench2){
            final /* synthetic */ JTable $rootsTable;
            final /* synthetic */ PreferencesAction this$0;
            {
                this.$rootsTable = $rootsTable;
                this.this$0 = $receiver;
                super($super_call_param$1, "-", null, null, 12, null);
            }

            public void actionPerformed(@NotNull ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                int deletionIndex = this.$rootsTable.getSelectedRow();
                if (deletionIndex != -1) {
                    this.this$0.getRootsTableModel$avail().getRows().remove(deletionIndex);
                    this.this$0.getRootsTableModel$avail().fireTableDataChanged();
                    this.$rootsTable.changeSelection(this.this$0.getRootsTableModel$avail().getRows().isEmpty() ? -1 : Math.min(deletionIndex, this.this$0.getRootsTableModel$avail().getRowCount() - 1), 0, false, false);
                }
            }
        };
        JButton removeRootButton = new JButton(removeRootAction2);
        panel.add(removeRootButton);
        JLabel renamesLabel = new JLabel("Renames");
        panel.add(renamesLabel);
        this.renamesTableModel.getRows().clear();
        for (Map.Entry<String, String> entry : this.getWorkbench().getResolver().getRenameRules().entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            pair = new ArrayList();
            pair.add(key);
            pair.add(value);
            this.renamesTableModel.getRows().add((List<String>)pair);
        }
        JTable renamesTable = new JTable(this.renamesTableModel);
        renamesTable.putClientProperty("terminateEditOnFocusLost", true);
        TableColumnModel renamesColumns = renamesTable.getColumnModel();
        renamesColumns.getColumn(0).setMinWidth(50);
        renamesColumns.getColumn(0).setPreferredWidth(400);
        renamesColumns.getColumn(1).setMinWidth(50);
        renamesColumns.getColumn(1).setPreferredWidth(400);
        renamesTable.setGridColor(Color.gray);
        renamesTable.setFillsViewportHeight(true);
        JScrollPane renamesScrollPane = new JScrollPane(renamesTable);
        panel.add(renamesScrollPane);
        pair = this.getWorkbench();
        AbstractWorkbenchAction addRenameAction2 = new AbstractWorkbenchAction(renamesTable, this, (AvailWorkbench)pair){
            final /* synthetic */ JTable $renamesTable;
            final /* synthetic */ PreferencesAction this$0;
            {
                this.$renamesTable = $renamesTable;
                this.this$0 = $receiver;
                super($super_call_param$1, "+", null, null, 12, null);
            }

            public void actionPerformed(@NotNull ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                int insertionIndex = this.$renamesTable.getSelectedRow();
                if (insertionIndex == -1) {
                    insertionIndex = this.this$0.getRenamesTableModel$avail().getRowCount();
                }
                Object[] objectArray = new String[]{"", ""};
                this.this$0.getRenamesTableModel$avail().getRows().add(insertionIndex, CollectionsKt.mutableListOf((Object[])objectArray));
                this.this$0.getRenamesTableModel$avail().fireTableDataChanged();
                this.$renamesTable.changeSelection(insertionIndex, 0, false, false);
            }
        };
        JButton addRenameButton = new JButton(addRenameAction2);
        panel.add(addRenameButton);
        AvailWorkbench availWorkbench3 = this.getWorkbench();
        AbstractWorkbenchAction removeRenameAction2 = new AbstractWorkbenchAction(renamesTable, this, availWorkbench3){
            final /* synthetic */ JTable $renamesTable;
            final /* synthetic */ PreferencesAction this$0;
            {
                this.$renamesTable = $renamesTable;
                this.this$0 = $receiver;
                super($super_call_param$1, "-", null, null, 12, null);
            }

            public void actionPerformed(@NotNull ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                int deletionIndex = this.$renamesTable.getSelectedRow();
                if (deletionIndex != -1) {
                    this.this$0.getRenamesTableModel$avail().getRows().remove(deletionIndex);
                    this.this$0.getRenamesTableModel$avail().fireTableDataChanged();
                    this.$renamesTable.changeSelection(this.this$0.getRenamesTableModel$avail().getRows().isEmpty() ? -1 : Math.min(deletionIndex, this.this$0.getRenamesTableModel$avail().getRowCount() - 1), 0, false, false);
                }
            }
        };
        JButton removeRenameButton = new JButton(removeRenameAction2);
        panel.add(removeRenameButton);
        AvailWorkbench availWorkbench4 = this.getWorkbench();
        String string3 = UIManager.getString("OptionPane.okButtonText");
        AbstractWorkbenchAction okAction2 = new AbstractWorkbenchAction(this, availWorkbench4, string3){
            final /* synthetic */ PreferencesAction this$0;
            {
                this.this$0 = $receiver;
                Intrinsics.checkNotNullExpressionValue((Object)$super_call_param$2, (String)"getString(\"OptionPane.okButtonText\")");
                super($super_call_param$1, $super_call_param$2, null, null, 12, null);
            }

            public void actionPerformed(@NotNull ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.savePreferences();
                this.getWorkbench().calculateRefreshedTreesThen((Function2<? super TreeNode, ? super TreeNode, Unit>)((Function2)new Function2<TreeNode, TreeNode, Unit>(this, this.this$0){
                    final /* synthetic */ createDialog.okAction.1 this$0;
                    final /* synthetic */ PreferencesAction this$1;
                    {
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                        super(2);
                    }

                    public final void invoke(@NotNull TreeNode modules, @NotNull TreeNode entryPoints) {
                        Intrinsics.checkNotNullParameter((Object)modules, (String)"modules");
                        Intrinsics.checkNotNullParameter((Object)entryPoints, (String)"entryPoints");
                        SwingUtilities.invokeLater(() -> createDialog.okAction.actionPerformed.1.invoke$lambda-0(this.this$0, modules, entryPoints, this.this$1));
                    }

                    private static final void invoke$lambda-0(createDialog.okAction.1 this$0, TreeNode $modules, TreeNode $entryPoints, PreferencesAction this$1) {
                        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                        Intrinsics.checkNotNullParameter((Object)$modules, (String)"$modules");
                        Intrinsics.checkNotNullParameter((Object)$entryPoints, (String)"$entryPoints");
                        Intrinsics.checkNotNullParameter((Object)this$1, (String)"this$1");
                        this$0.getWorkbench().refreshFor($modules, $entryPoints);
                        JDialog jDialog = this$1.getPreferencesDialog$avail();
                        Intrinsics.checkNotNull((Object)jDialog);
                        jDialog.setVisible(false);
                    }
                }));
            }
        };
        JButton okButton = new JButton(okAction2);
        panel.add(okButton);
        AvailWorkbench availWorkbench5 = this.getWorkbench();
        String string4 = UIManager.getString("OptionPane.cancelButtonText");
        AbstractWorkbenchAction cancelAction2 = new AbstractWorkbenchAction(this, availWorkbench5, string4){
            final /* synthetic */ PreferencesAction this$0;
            {
                this.this$0 = $receiver;
                Intrinsics.checkNotNullExpressionValue((Object)$super_call_param$2, (String)"getString(\"OptionPane.cancelButtonText\")");
                super($super_call_param$1, $super_call_param$2, null, null, 12, null);
            }

            public void actionPerformed(@NotNull ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                JDialog jDialog = this.this$0.getPreferencesDialog$avail();
                Intrinsics.checkNotNull((Object)jDialog);
                jDialog.setVisible(false);
            }
        };
        JButton cancelButton = new JButton(cancelAction2);
        panel.add(cancelButton);
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(layout.createParallelGroup().addComponent(rootsLabel).addComponent(rootsScrollPane).addGroup(layout.createSequentialGroup().addComponent(addRootButton).addComponent(removeRootButton)).addComponent(renamesLabel).addComponent(renamesScrollPane).addGroup(layout.createSequentialGroup().addComponent(addRenameButton).addComponent(removeRenameButton)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(okButton).addComponent(cancelButton)));
        layout.setVerticalGroup(layout.createSequentialGroup().addComponent(rootsLabel).addComponent(rootsScrollPane).addGroup(layout.createParallelGroup().addComponent(addRootButton).addComponent(removeRootButton)).addComponent(renamesLabel).addComponent(renamesScrollPane).addGroup(layout.createParallelGroup().addComponent(addRenameButton).addComponent(removeRenameButton)).addGroup(layout.createParallelGroup().addComponent(okButton).addComponent(cancelButton)));
        Component[] componentArray = new Component[]{okButton, cancelButton};
        layout.linkSize(0, componentArray);
        JDialog jDialog = this.preferencesDialog;
        Intrinsics.checkNotNull((Object)jDialog);
        JDialog $this$createDialog_u24lambda_u2d1 = jDialog;
        boolean bl = false;
        $this$createDialog_u24lambda_u2d1.setMinimumSize(new Dimension(300, 250));
        $this$createDialog_u24lambda_u2d1.setPreferredSize(new Dimension(900, 500));
        $this$createDialog_u24lambda_u2d1.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        $this$createDialog_u24lambda_u2d1.getContentPane().add(panel);
        $this$createDialog_u24lambda_u2d1.setResizable(true);
        $this$createDialog_u24lambda_u2d1.pack();
        Point point2 = point = this.getWorkbench().getLocation();
        JDialog jDialog2 = $this$createDialog_u24lambda_u2d1;
        boolean bl2 = false;
        $this$createDialog_u24lambda_u2d1_u24lambda_u2d0.translate(22, 22);
        jDialog2.setLocation(point);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u001b\b\u0000\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\fH\u0016J\b\u0010\u000f\u001a\u00020\fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0016J \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\fH\u0016R\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u001d\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\b0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lavail/environment/actions/PreferencesAction$SimpleTableModel;", "Ljavax/swing/table/AbstractTableModel;", "columnNames", "", "", "(Lavail/environment/actions/PreferencesAction;[Ljava/lang/String;)V", "[Ljava/lang/String;", "rows", "", "getRows", "()Ljava/util/List;", "getColumnCount", "", "getColumnName", "column", "getRowCount", "getValueAt", "", "row", "isCellEditable", "", "setValueAt", "", "value", "avail"})
    public final class SimpleTableModel
    extends AbstractTableModel {
        @NotNull
        private final String[] columnNames;
        @NotNull
        private final List<List<String>> rows;

        public SimpleTableModel(String ... columnNames) {
            Intrinsics.checkNotNullParameter((Object)columnNames, (String)"columnNames");
            this.columnNames = Arrays.copyOf(columnNames, columnNames.length);
            this.rows = new ArrayList();
        }

        @NotNull
        public final List<List<String>> getRows() {
            return this.rows;
        }

        @Override
        @NotNull
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        @NotNull
        public Object getValueAt(int row, int column) {
            return this.rows.get(row).get(column);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return true;
        }

        @Override
        public void setValueAt(@NotNull Object value, int row, int column) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.rows.get(row).set(column, (String)value);
            this.fireTableCellUpdated(row, column);
        }
    }
}

