/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.execution;

import avail.AvailRuntime;
import avail.AvailThread;
import avail.compiler.CompilationContext;
import avail.compiler.ModuleManifestEntry;
import avail.compiler.SideEffectKind;
import avail.compiler.scanning.LexingState;
import avail.compiler.splitter.MessageSplitter;
import avail.descriptor.atoms.A_Atom;
import avail.descriptor.atoms.AtomDescriptor;
import avail.descriptor.bundles.A_Bundle;
import avail.descriptor.bundles.A_BundleTree;
import avail.descriptor.bundles.MessageBundleTreeDescriptor;
import avail.descriptor.character.CharacterDescriptor;
import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.fiber.FiberDescriptor;
import avail.descriptor.functions.A_Function;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.functions.FunctionDescriptor;
import avail.descriptor.functions.PrimitiveCompiledCodeDescriptor;
import avail.descriptor.maps.A_Map;
import avail.descriptor.maps.MapDescriptor;
import avail.descriptor.methods.A_Definition;
import avail.descriptor.methods.A_GrammaticalRestriction;
import avail.descriptor.methods.A_Macro;
import avail.descriptor.methods.A_Method;
import avail.descriptor.methods.A_SemanticRestriction;
import avail.descriptor.methods.A_Sendable;
import avail.descriptor.methods.AbstractDefinitionDescriptor;
import avail.descriptor.methods.ForwardDefinitionDescriptor;
import avail.descriptor.methods.GrammaticalRestrictionDescriptor;
import avail.descriptor.methods.MacroDescriptor;
import avail.descriptor.methods.MethodDefinitionDescriptor;
import avail.descriptor.methods.MethodDescriptor;
import avail.descriptor.module.A_Module;
import avail.descriptor.module.ModuleDescriptor;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.parsing.A_DefinitionParsingPlan;
import avail.descriptor.parsing.A_Lexer;
import avail.descriptor.parsing.A_ParsingPlanInProgress;
import avail.descriptor.parsing.LexerDescriptor;
import avail.descriptor.parsing.ParsingPlanInProgressDescriptor;
import avail.descriptor.phrases.A_Phrase;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.sets.A_Set;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.StringDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.EnumerationTypeDescriptor;
import avail.descriptor.types.PhraseTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.exceptions.AmbiguousNameException;
import avail.exceptions.AvailErrorCode;
import avail.exceptions.MalformedMessageException;
import avail.exceptions.SignatureException;
import avail.interpreter.Primitive;
import avail.interpreter.effects.LoadingEffect;
import avail.interpreter.effects.LoadingEffectToAddDefinition;
import avail.interpreter.effects.LoadingEffectToAddMacro;
import avail.interpreter.effects.LoadingEffectToRunPrimitive;
import avail.interpreter.primitive.bootstrap.lexing.P_BootstrapLexerKeywordBody;
import avail.interpreter.primitive.bootstrap.lexing.P_BootstrapLexerKeywordFilter;
import avail.interpreter.primitive.bootstrap.lexing.P_BootstrapLexerOperatorBody;
import avail.interpreter.primitive.bootstrap.lexing.P_BootstrapLexerOperatorFilter;
import avail.interpreter.primitive.bootstrap.lexing.P_BootstrapLexerSlashStarCommentBody;
import avail.interpreter.primitive.bootstrap.lexing.P_BootstrapLexerSlashStarCommentFilter;
import avail.interpreter.primitive.bootstrap.lexing.P_BootstrapLexerStringBody;
import avail.interpreter.primitive.bootstrap.lexing.P_BootstrapLexerStringFilter;
import avail.interpreter.primitive.bootstrap.lexing.P_BootstrapLexerWhitespaceBody;
import avail.interpreter.primitive.bootstrap.lexing.P_BootstrapLexerWhitespaceFilter;
import avail.io.TextInterface;
import avail.utility.StackPrinter;
import avail.utility.evaluation.Combinator;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 b2\u00020\u0001:\u0003bcdB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202J\u0018\u00103\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00104\u001a\u000205H\u0002J\u0016\u00106\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u000202J\u0016\u00107\u001a\u00020.2\u0006\u00108\u001a\u00020\u00192\u0006\u00109\u001a\u00020:J&\u0010;\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020:2\u0006\u0010?\u001a\u00020\nJ\u0016\u0010@\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u0010A\u001a\u00020=J\u0016\u0010B\u001a\u00020.2\u0006\u0010/\u001a\u0002002\u0006\u0010C\u001a\u00020:J\u000e\u0010D\u001a\u00020.2\u0006\u0010E\u001a\u00020FJ\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010G\u001a\u00020\u00192\u0006\u0010H\u001a\u00020IJ\u001a\u0010J\u001a\u0002002\u0006\u0010H\u001a\u00020I2\b\b\u0002\u0010K\u001a\u00020\nH\u0007J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010L\u001a\u00020.J\u0006\u0010M\u001a\u00020.J\u000e\u0010N\u001a\u00020.2\u0006\u0010O\u001a\u00020\rJ\f\u0010P\u001a\b\u0012\u0004\u0012\u00020\r0QJ\u000e\u0010R\u001a\u00020.2\u0006\u0010S\u001a\u000205J\u0010\u0010T\u001a\u00020.2\u0006\u0010U\u001a\u000205H\u0002J\u000e\u0010V\u001a\u00020.2\u0006\u0010W\u001a\u00020XJ\u0006\u0010 \u001a\u00020!J\u001c\u0010Y\u001a\u00020.2\u0006\u0010Z\u001a\u00020:2\f\u0010[\u001a\b\u0012\u0004\u0012\u00020.0\\J\u000e\u0010]\u001a\u00020.2\u0006\u0010^\u001a\u00020\u001fJ\u0006\u0010_\u001a\u00020.J\u0006\u0010$\u001a\u00020\nJ\u000e\u0010$\u001a\u00020.2\u0006\u0010`\u001a\u00020\nJ\u0006\u0010a\u001a\u00020.R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010\u0010\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u000e\u0010$\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u001c\u0010'\u001a\u0004\u0018\u00010(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,\u00a8\u0006e"}, d2={"Lavail/interpreter/execution/AvailLoader;", "", "runtime", "Lavail/AvailRuntime;", "module", "Lavail/descriptor/module/A_Module;", "textInterface", "Lavail/io/TextInterface;", "(Lavail/AvailRuntime;Lavail/descriptor/module/A_Module;Lavail/io/TextInterface;)V", "determiningSummarizability", "", "effectsAddedByTopStatement", "", "Lavail/interpreter/effects/LoadingEffect;", "lexicalScanner", "Lavail/interpreter/execution/AvailLoader$LexicalScanner;", "manifestEntries", "Lavail/compiler/ModuleManifestEntry;", "getManifestEntries", "()Ljava/util/List;", "setManifestEntries", "(Ljava/util/List;)V", "getModule", "()Lavail/descriptor/module/A_Module;", "pendingForwards", "Lavail/descriptor/sets/A_Set;", "getPendingForwards", "()Lavail/descriptor/sets/A_Set;", "setPendingForwards", "(Lavail/descriptor/sets/A_Set;)V", "phase", "Lavail/interpreter/execution/AvailLoader$Phase;", "rootBundleTree", "Lavail/descriptor/bundles/A_BundleTree;", "getRuntime", "()Lavail/AvailRuntime;", "statementCanBeSummarized", "getTextInterface", "()Lavail/io/TextInterface;", "topLevelStatementBeingCompiled", "Lavail/descriptor/phrases/A_Phrase;", "getTopLevelStatementBeingCompiled", "()Lavail/descriptor/phrases/A_Phrase;", "setTopLevelStatementBeingCompiled", "(Lavail/descriptor/phrases/A_Phrase;)V", "addAbstractSignature", "", "methodName", "Lavail/descriptor/atoms/A_Atom;", "bodySignature", "Lavail/descriptor/types/A_Type;", "addDefinition", "newDefinition", "Lavail/descriptor/methods/A_Definition;", "addForwardStub", "addGrammaticalRestrictions", "parentAtoms", "illegalArgumentMessages", "Lavail/descriptor/tuples/A_Tuple;", "addMacroBody", "macroBody", "Lavail/descriptor/functions/A_Function;", "prefixFunctions", "ignoreSeals", "addMethodBody", "bodyBlock", "addSeal", "seal", "addSemanticRestriction", "restriction", "Lavail/descriptor/methods/A_SemanticRestriction;", "lookupAtomsForName", "stringName", "Lavail/descriptor/tuples/A_String;", "lookupName", "isExplicitSubclassAtom", "prepareForCompilingModuleBody", "prepareForLoadingModuleBody", "recordEffect", "anEffect", "recordedEffects", "", "removeDefinition", "definition", "removeForward", "forwardDefinition", "removeMacro", "macro", "Lavail/descriptor/methods/A_Macro;", "runUnloadFunctions", "unloadFunctions", "afterRunning", "Lkotlin/Function0;", "setPhase", "newPhase", "startRecordingEffects", "summarizable", "stopRecordingEffects", "Companion", "LexicalScanner", "Phase", "avail"})
public final class AvailLoader {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final AvailRuntime runtime;
    @NotNull
    private final A_Module module;
    @NotNull
    private final TextInterface textInterface;
    @NotNull
    private volatile Phase phase;
    @Nullable
    private LexicalScanner lexicalScanner;
    @NotNull
    private A_BundleTree rootBundleTree;
    @Nullable
    private A_Phrase topLevelStatementBeingCompiled;
    @Nullable
    private List<ModuleManifestEntry> manifestEntries;
    private volatile boolean statementCanBeSummarized;
    private boolean determiningSummarizability;
    @NotNull
    private final List<LoadingEffect> effectsAddedByTopStatement;
    @NotNull
    private A_Set pendingForwards;
    private static boolean debugUnsummarizedStatements;
    private static boolean debugLoadedStatements;
    private static boolean enableFastLoader;
    @NotNull
    private static final A_BundleTree moduleHeaderBundleRoot;
    @NotNull
    private static final LexicalScanner moduleHeaderLexicalScanner;

    public AvailLoader(@NotNull AvailRuntime runtime, @NotNull A_Module module, @NotNull TextInterface textInterface) {
        Intrinsics.checkNotNullParameter((Object)runtime, (String)"runtime");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)textInterface, (String)"textInterface");
        this.runtime = runtime;
        this.module = module;
        this.textInterface = textInterface;
        this.phase = Phase.INITIALIZING;
        this.lexicalScanner = moduleHeaderLexicalScanner;
        this.rootBundleTree = moduleHeaderBundleRoot;
        this.statementCanBeSummarized = true;
        this.effectsAddedByTopStatement = new ArrayList();
        this.pendingForwards = SetDescriptor.Companion.getEmptySet();
    }

    @NotNull
    public final AvailRuntime getRuntime() {
        return this.runtime;
    }

    @NotNull
    public final A_Module getModule() {
        return this.module;
    }

    @NotNull
    public final TextInterface getTextInterface() {
        return this.textInterface;
    }

    @NotNull
    public final Phase phase() {
        return this.phase;
    }

    public final void setPhase(@NotNull Phase newPhase) {
        Intrinsics.checkNotNullParameter((Object)((Object)newPhase), (String)"newPhase");
        this.phase = newPhase;
    }

    @NotNull
    public final LexicalScanner lexicalScanner() {
        LexicalScanner lexicalScanner = this.lexicalScanner;
        Intrinsics.checkNotNull((Object)lexicalScanner);
        return lexicalScanner;
    }

    @NotNull
    public final A_BundleTree rootBundleTree() {
        return this.rootBundleTree;
    }

    @Nullable
    public final A_Phrase getTopLevelStatementBeingCompiled() {
        return this.topLevelStatementBeingCompiled;
    }

    public final void setTopLevelStatementBeingCompiled(@Nullable A_Phrase a_Phrase) {
        this.topLevelStatementBeingCompiled = a_Phrase;
    }

    @Nullable
    public final List<ModuleManifestEntry> getManifestEntries() {
        return this.manifestEntries;
    }

    public final void setManifestEntries(@Nullable List<ModuleManifestEntry> list) {
        this.manifestEntries = list;
    }

    public final synchronized void statementCanBeSummarized(boolean summarizable) {
        if (this.determiningSummarizability) {
            if (debugUnsummarizedStatements && !summarizable && this.statementCanBeSummarized) {
                Throwable e = new Throwable().fillInStackTrace();
                Intrinsics.checkNotNullExpressionValue((Object)e, (String)"e");
                System.out.println((Object)("Disabled summary:\n" + StackPrinter.Companion.trace(e)));
            }
            this.statementCanBeSummarized = summarizable;
        }
    }

    public final boolean statementCanBeSummarized() {
        return this.statementCanBeSummarized;
    }

    public final synchronized void recordEffect(@NotNull LoadingEffect anEffect) {
        Intrinsics.checkNotNullParameter((Object)anEffect, (String)"anEffect");
        if (this.determiningSummarizability) {
            this.effectsAddedByTopStatement.add(anEffect);
        }
    }

    public final synchronized void startRecordingEffects() {
        boolean bl;
        boolean bl2 = bl = !this.determiningSummarizability;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.determiningSummarizability = true;
        this.statementCanBeSummarized = enableFastLoader;
        this.effectsAddedByTopStatement.clear();
    }

    public final synchronized void stopRecordingEffects() {
        boolean bl = this.determiningSummarizability;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.determiningSummarizability = false;
    }

    @NotNull
    public final synchronized List<LoadingEffect> recordedEffects() {
        return CollectionsKt.toList((Iterable)this.effectsAddedByTopStatement);
    }

    public final void prepareForCompilingModuleBody() {
        this.rootBundleTree = A_Module.Companion.buildFilteredBundleTree(this.module);
        this.lexicalScanner = A_Module.Companion.createLexicalScanner(this.module);
    }

    public final void prepareForLoadingModuleBody() {
        this.rootBundleTree = NilDescriptor.Companion.getNil();
        this.lexicalScanner = null;
    }

    @NotNull
    public final A_Set getPendingForwards() {
        return this.pendingForwards;
    }

    public final void setPendingForwards(@NotNull A_Set a_Set) {
        Intrinsics.checkNotNullParameter((Object)a_Set, (String)"<set-?>");
        this.pendingForwards = a_Set;
    }

    private final void removeForward(A_Definition forwardDefinition) {
        A_Method method = A_Definition.Companion.getDefinitionMethod(forwardDefinition);
        if (!A_Set.Companion.hasElement(this.pendingForwards, forwardDefinition)) {
            AvailObject.Companion.error("Inconsistent forward declaration handling code", new Object[0]);
            throw new KotlinNothingValueException();
        }
        if (!A_Method.Companion.includesDefinition(method, forwardDefinition)) {
            AvailObject.Companion.error("Inconsistent forward declaration handling code", new Object[0]);
            throw new KotlinNothingValueException();
        }
        this.pendingForwards = A_Set.Companion.setWithoutElementCanDestroy(this.pendingForwards, forwardDefinition, true).makeShared();
        A_Method.Companion.removeDefinition(method, forwardDefinition);
        A_Module.Companion.resolveForward(this.module, forwardDefinition);
    }

    public final void addForwardStub(@NotNull A_Atom methodName, @NotNull A_Type bodySignature) throws MalformedMessageException, SignatureException {
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter((Object)bodySignature, (String)"bodySignature");
        methodName.makeShared();
        bodySignature.makeShared();
        A_Bundle bundle = A_Atom.Companion.bundleOrCreate(methodName);
        MessageSplitter splitter = A_Bundle.Companion.getMessageSplitter(bundle);
        MessageSplitter.checkImplementationSignature$default(splitter, bodySignature, 0, 2, null);
        A_Type bodyArgsTupleType = A_Type.Companion.getArgsTupleType(bodySignature);
        A_Method method = A_Bundle.Companion.getBundleMethod(bundle);
        Iterable $this$forEach$iv = A_Method.Companion.getDefinitionsTuple(method);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AvailObject definition = (AvailObject)element$iv;
            boolean bl = false;
            A_Type existingType = A_Sendable.Companion.bodySignature(definition);
            if (A_Type.Companion.getArgsTupleType(existingType).equals(bodyArgsTupleType)) {
                throw new SignatureException(AvailErrorCode.E_REDEFINED_WITH_SAME_ARGUMENT_TYPES);
            }
            if (A_Type.Companion.acceptsArgTypesFromFunctionType(existingType, bodySignature) && !A_Type.Companion.isSubtypeOf(A_Type.Companion.getReturnType(bodySignature), A_Type.Companion.getReturnType(existingType))) {
                throw new SignatureException(AvailErrorCode.E_RESULT_TYPE_SHOULD_COVARY_WITH_ARGUMENTS);
            }
            if (!A_Type.Companion.acceptsArgTypesFromFunctionType(bodySignature, existingType) || A_Type.Companion.isSubtypeOf(A_Type.Companion.getReturnType(existingType), A_Type.Companion.getReturnType(bodySignature))) continue;
            throw new SignatureException(AvailErrorCode.E_RESULT_TYPE_SHOULD_COVARY_WITH_ARGUMENTS);
        }
        if (this.phase == Phase.EXECUTING_FOR_COMPILE) {
            A_Definition newForward = ForwardDefinitionDescriptor.Companion.newForwardDefinition(method, this.module, bodySignature);
            A_Method.Companion.methodAddDefinition(method, newForward);
            this.recordEffect(new LoadingEffectToAddDefinition(bundle, newForward));
            A_Module theModule = this.module;
            A_BundleTree root = this.rootBundleTree();
            theModule.lock((Function0)new Function0<Unit>(theModule, newForward, this, bundle, root){
                final /* synthetic */ A_Module $theModule;
                final /* synthetic */ A_Definition $newForward;
                final /* synthetic */ AvailLoader this$0;
                final /* synthetic */ A_Bundle $bundle;
                final /* synthetic */ A_BundleTree $root;
                {
                    this.$theModule = $theModule;
                    this.$newForward = $newForward;
                    this.this$0 = $receiver;
                    this.$bundle = $bundle;
                    this.$root = $root;
                    super(0);
                }

                public final void invoke() {
                    A_Module.Companion.moduleAddDefinition(this.$theModule, this.$newForward);
                    this.this$0.setPendingForwards(A_Set.Companion.setWithElementCanDestroy(this.this$0.getPendingForwards(), this.$newForward, true).makeShared());
                    AvailObject plan = A_Map.Companion.mapAt(A_Bundle.Companion.getDefinitionParsingPlans(this.$bundle), this.$newForward);
                    A_ParsingPlanInProgress planInProgress = ParsingPlanInProgressDescriptor.Companion.newPlanInProgress(plan, 1);
                    A_BundleTree.Companion.addPlanInProgress(this.$root, planInProgress);
                }
            });
        }
    }

    public final void addMethodBody(@NotNull A_Atom methodName, @NotNull A_Function bodyBlock) throws MalformedMessageException, SignatureException {
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter((Object)bodyBlock, (String)"bodyBlock");
        boolean bl = methodName.isAtom();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        bl = bodyBlock.isFunction();
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        A_Bundle bundle = A_Atom.Companion.bundleOrCreate(methodName);
        MessageSplitter splitter = A_Bundle.Companion.getMessageSplitter(bundle);
        MessageSplitter.checkImplementationSignature$default(splitter, bodyBlock.kind(), 0, 2, null);
        int numArgs = splitter.getNumberOfArguments();
        if (A_RawFunction.Companion.numArgs(bodyBlock.code()) != numArgs) {
            throw new SignatureException(AvailErrorCode.E_INCORRECT_NUMBER_OF_ARGUMENTS);
        }
        this.addDefinition(methodName.makeShared(), MethodDefinitionDescriptor.Companion.newMethodDefinition(A_Bundle.Companion.getBundleMethod(bundle), this.module, bodyBlock.makeShared()));
    }

    public final void addAbstractSignature(@NotNull A_Atom methodName, @NotNull A_Type bodySignature) throws MalformedMessageException, SignatureException {
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter((Object)bodySignature, (String)"bodySignature");
        A_Bundle bundle = A_Atom.Companion.bundleOrCreate(methodName);
        MessageSplitter splitter = A_Bundle.Companion.getMessageSplitter(bundle);
        int numArgs = splitter.getNumberOfArguments();
        A_Type bodyArgsSizes = A_Type.Companion.getSizeRange(A_Type.Companion.getArgsTupleType(bodySignature));
        if (!A_Number.Companion.equalsInt(A_Type.Companion.getLowerBound(bodyArgsSizes), numArgs) || !A_Number.Companion.equalsInt(A_Type.Companion.getUpperBound(bodyArgsSizes), numArgs)) {
            throw new SignatureException(AvailErrorCode.E_INCORRECT_NUMBER_OF_ARGUMENTS);
        }
        boolean bl = A_Number.Companion.equalsInt(A_Type.Companion.getUpperBound(bodyArgsSizes), numArgs);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string2 = "Wrong number of arguments in abstract method signature";
            throw new AssertionError((Object)string2);
        }
        this.addDefinition(methodName.makeShared(), AbstractDefinitionDescriptor.Companion.newAbstractDefinition(A_Bundle.Companion.getBundleMethod(bundle), this.module, bodySignature.makeShared()));
    }

    private final void addDefinition(A_Atom methodName, A_Definition newDefinition) throws SignatureException {
        A_Method method = A_Definition.Companion.getDefinitionMethod(newDefinition);
        A_Type bodySignature = A_Sendable.Companion.bodySignature(newDefinition);
        A_Type argsTupleType = A_Type.Companion.getArgsTupleType(bodySignature);
        Ref.ObjectRef forward = new Ref.ObjectRef();
        Iterable $this$forEach$iv = A_Method.Companion.getDefinitionsTuple(method);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AvailObject existingDefinition = (AvailObject)element$iv;
            boolean bl = false;
            A_Type existingType = A_Sendable.Companion.bodySignature(existingDefinition);
            boolean same = A_Type.Companion.getArgsTupleType(existingType).equals(argsTupleType);
            if (same) {
                if (!A_Sendable.Companion.isForwardDefinition(existingDefinition)) {
                    throw new SignatureException(AvailErrorCode.E_REDEFINED_WITH_SAME_ARGUMENT_TYPES);
                }
                if (!A_Type.Companion.getReturnType(existingType).equals(A_Type.Companion.getReturnType(bodySignature))) {
                    throw new SignatureException(AvailErrorCode.E_METHOD_RETURN_TYPE_NOT_AS_FORWARD_DECLARED);
                }
                forward.element = existingDefinition;
            }
            if (A_Type.Companion.acceptsArgTypesFromFunctionType(existingType, bodySignature) && !A_Type.Companion.isSubtypeOf(A_Type.Companion.getReturnType(bodySignature), A_Type.Companion.getReturnType(existingType))) {
                throw new SignatureException(AvailErrorCode.E_RESULT_TYPE_SHOULD_COVARY_WITH_ARGUMENTS);
            }
            if (!A_Type.Companion.acceptsArgTypesFromFunctionType(bodySignature, existingType) || A_Type.Companion.isSubtypeOf(A_Type.Companion.getReturnType(existingType), A_Type.Companion.getReturnType(bodySignature))) continue;
            throw new SignatureException(AvailErrorCode.E_RESULT_TYPE_SHOULD_COVARY_WITH_ARGUMENTS);
        }
        if (this.phase == Phase.EXECUTING_FOR_COMPILE) {
            this.module.lock((Function0)new Function0<Unit>(this, (Ref.ObjectRef<A_Definition>)forward, method, newDefinition, methodName){
                final /* synthetic */ AvailLoader this$0;
                final /* synthetic */ Ref.ObjectRef<A_Definition> $forward;
                final /* synthetic */ A_Method $method;
                final /* synthetic */ A_Definition $newDefinition;
                final /* synthetic */ A_Atom $methodName;
                {
                    this.this$0 = $receiver;
                    this.$forward = $forward;
                    this.$method = $method;
                    this.$newDefinition = $newDefinition;
                    this.$methodName = $methodName;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    ModuleManifestEntry moduleManifestEntry;
                    void $this$forEach$iv;
                    A_BasicObject a_BasicObject;
                    Object object;
                    A_BundleTree root = this.this$0.rootBundleTree();
                    A_Definition a_Definition = (A_Definition)this.$forward.element;
                    if (a_Definition != null) {
                        object = a_Definition;
                        a_BasicObject = this.$method;
                        AvailLoader availLoader = this.this$0;
                        A_Definition forward = object;
                        boolean bl = false;
                        Iterable $this$forEach$iv2 = A_Method.Companion.getBundles((A_Method)a_BasicObject);
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv2) {
                            AvailObject bundle = (AvailObject)element$iv;
                            boolean bl2 = false;
                            if (!A_Module.Companion.hasAncestor(availLoader.getModule(), A_Atom.Companion.getIssuingModule(A_Bundle.Companion.getMessage(bundle)))) continue;
                            A_DefinitionParsingPlan plan = A_Map.Companion.mapAt(A_Bundle.Companion.getDefinitionParsingPlans(bundle), forward);
                            A_ParsingPlanInProgress planInProgress = ParsingPlanInProgressDescriptor.Companion.newPlanInProgress(plan, 1);
                            A_BundleTree.Companion.removePlanInProgress(root, planInProgress);
                        }
                        AvailLoader.access$removeForward(availLoader, forward);
                    }
                    try {
                        A_Method.Companion.methodAddDefinition(this.$method, this.$newDefinition);
                    }
                    catch (SignatureException e) {
                        if (_Assertions.ENABLED) {
                            boolean bl = false;
                            String string2 = "Signature was already vetted";
                            throw new AssertionError((Object)string2);
                        }
                        return;
                    }
                    this.this$0.recordEffect(new LoadingEffectToAddDefinition(A_Atom.Companion.bundleOrCreate(this.$methodName), this.$newDefinition));
                    Iterable e = A_Method.Companion.getBundles(this.$method);
                    object = this.this$0;
                    a_BasicObject = this.$newDefinition;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        AvailObject bundle = (AvailObject)element$iv;
                        boolean bl = false;
                        if (!A_Module.Companion.hasAncestor(((AvailLoader)object).getModule(), A_Atom.Companion.getIssuingModule(A_Bundle.Companion.getMessage(bundle)))) continue;
                        A_DefinitionParsingPlan plan = A_Map.Companion.mapAt(A_Bundle.Companion.getDefinitionParsingPlans(bundle), a_BasicObject);
                        A_ParsingPlanInProgress planInProgress = ParsingPlanInProgressDescriptor.Companion.newPlanInProgress(plan, 1);
                        A_BundleTree.Companion.addPlanInProgress(root, planInProgress);
                    }
                    A_Module.Companion.moduleAddDefinition(this.this$0.getModule(), this.$newDefinition);
                    A_Phrase a_Phrase = this.this$0.getTopLevelStatementBeingCompiled();
                    Intrinsics.checkNotNull((Object)a_Phrase);
                    int topStart = A_Phrase.Companion.getStartingLineNumber(a_Phrase);
                    List<ModuleManifestEntry> list = this.this$0.getManifestEntries();
                    Intrinsics.checkNotNull(list);
                    if (A_Sendable.Companion.isMethodDefinition(this.$newDefinition)) {
                        A_Function body2 = A_Sendable.Companion.bodyBlock(this.$newDefinition);
                        moduleManifestEntry = new ModuleManifestEntry(SideEffectKind.METHOD_DEFINITION_KIND, A_Atom.Companion.getAtomName(this.$methodName).asNativeString(), topStart, A_RawFunction.Companion.getCodeStartingLineNumber(body2.code()), body2, 0, 32, null);
                    } else if (A_Sendable.Companion.isForwardDefinition(this.$newDefinition)) {
                        moduleManifestEntry = new ModuleManifestEntry(SideEffectKind.FORWARD_METHOD_DEFINITION_KIND, A_Atom.Companion.getAtomName(this.$methodName).asNativeString(), topStart, topStart, null, 0, 48, null);
                    } else if (A_Sendable.Companion.isAbstractDefinition(this.$newDefinition)) {
                        moduleManifestEntry = new ModuleManifestEntry(SideEffectKind.ABSTRACT_METHOD_DEFINITION_KIND, A_Atom.Companion.getAtomName(this.$methodName).asNativeString(), topStart, topStart, null, 0, 48, null);
                    } else {
                        throw new UnsupportedOperationException("Unknown definition kind");
                    }
                    list.add(moduleManifestEntry);
                }
            });
        } else {
            try {
                A_Method.Companion.methodAddDefinition(method, newDefinition);
            }
            catch (SignatureException e) {
                if (_Assertions.ENABLED) {
                    boolean bl = false;
                    String string2 = "Signature was already vetted";
                    throw new AssertionError((Object)string2);
                }
                return;
            }
            A_Module.Companion.moduleAddDefinition(this.module, newDefinition);
        }
    }

    public final void addMacroBody(@NotNull A_Atom methodName, @NotNull A_Function macroBody, @NotNull A_Tuple prefixFunctions, boolean ignoreSeals) throws MalformedMessageException, SignatureException {
        boolean bl;
        A_Macro macroDefinition;
        A_RawFunction macroCode;
        A_Bundle bundle;
        block9: {
            Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
            Intrinsics.checkNotNullParameter((Object)macroBody, (String)"macroBody");
            Intrinsics.checkNotNullParameter((Object)prefixFunctions, (String)"prefixFunctions");
            boolean bl2 = methodName.isAtom();
            if (_Assertions.ENABLED && !bl2) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            bl2 = macroBody.isFunction();
            if (_Assertions.ENABLED && !bl2) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            bundle = A_Atom.Companion.bundleOrCreate(methodName);
            MessageSplitter splitter = A_Bundle.Companion.getMessageSplitter(bundle);
            int numArgs = splitter.getNumberOfArguments();
            macroCode = macroBody.code();
            if (A_RawFunction.Companion.numArgs(macroCode) != numArgs) {
                throw new SignatureException(AvailErrorCode.E_INCORRECT_NUMBER_OF_ARGUMENTS);
            }
            if (!A_Type.Companion.isSubtypeOf(A_Type.Companion.getReturnType(macroCode.functionType()), PhraseTypeDescriptor.PhraseKind.PARSE_PHRASE.getMostGeneralType())) {
                throw new SignatureException(AvailErrorCode.E_MACRO_MUST_RETURN_A_PHRASE);
            }
            methodName.makeShared();
            macroBody.makeShared();
            macroDefinition = MacroDescriptor.Companion.newMacroDefinition(bundle, this.module, macroBody, prefixFunctions);
            A_Type macroBodyType = macroBody.kind();
            A_Type argsType = A_Type.Companion.getArgsTupleType(macroBodyType);
            Iterable $this$any$iv = A_Bundle.Companion.getMacrosTuple(bundle);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    AvailObject existingDef = (AvailObject)element$iv;
                    boolean bl3 = false;
                    if (!argsType.equals(A_Type.Companion.getArgsTupleType(A_Sendable.Companion.bodySignature(existingDef)))) continue;
                    bl = true;
                    break block9;
                }
                bl = false;
            }
        }
        if (bl) {
            throw new SignatureException(AvailErrorCode.E_REDEFINED_WITH_SAME_ARGUMENT_TYPES);
        }
        A_Bundle.Companion.bundleAddMacro(bundle, macroDefinition, ignoreSeals);
        A_Module.Companion.moduleAddMacro(this.module, macroDefinition);
        if (this.phase == Phase.EXECUTING_FOR_COMPILE) {
            this.recordEffect(new LoadingEffectToAddMacro(bundle, macroDefinition));
            this.module.lock((Function0)new Function0<Unit>(this, methodName, macroCode, macroBody, bundle, macroDefinition){
                final /* synthetic */ AvailLoader this$0;
                final /* synthetic */ A_Atom $methodName;
                final /* synthetic */ A_RawFunction $macroCode;
                final /* synthetic */ A_Function $macroBody;
                final /* synthetic */ A_Bundle $bundle;
                final /* synthetic */ A_Macro $macroDefinition;
                {
                    this.this$0 = $receiver;
                    this.$methodName = $methodName;
                    this.$macroCode = $macroCode;
                    this.$macroBody = $macroBody;
                    this.$bundle = $bundle;
                    this.$macroDefinition = $macroDefinition;
                    super(0);
                }

                public final void invoke() {
                    List<ModuleManifestEntry> list = this.this$0.getManifestEntries();
                    Intrinsics.checkNotNull(list);
                    String string2 = A_Atom.Companion.getAtomName(this.$methodName).asNativeString();
                    A_Phrase a_Phrase = this.this$0.getTopLevelStatementBeingCompiled();
                    Intrinsics.checkNotNull((Object)a_Phrase);
                    list.add(new ModuleManifestEntry(SideEffectKind.MACRO_DEFINITION_KIND, string2, A_Phrase.Companion.getStartingLineNumber(a_Phrase), A_RawFunction.Companion.getCodeStartingLineNumber(this.$macroCode), this.$macroBody, 0, 32, null));
                    A_DefinitionParsingPlan plan = A_Map.Companion.mapAt(A_Bundle.Companion.getDefinitionParsingPlans(this.$bundle), this.$macroDefinition);
                    A_ParsingPlanInProgress planInProgress = ParsingPlanInProgressDescriptor.Companion.newPlanInProgress(plan, 1);
                    A_BundleTree.Companion.addPlanInProgress(this.this$0.rootBundleTree(), planInProgress);
                }
            });
        }
    }

    public final void addSemanticRestriction(@NotNull A_SemanticRestriction restriction) throws SignatureException {
        Intrinsics.checkNotNullParameter((Object)restriction, (String)"restriction");
        A_Method method = restriction.definitionMethod();
        A_Function function = restriction.function();
        if (A_RawFunction.Companion.numArgs(function.code()) != A_Method.Companion.getNumArgs(method)) {
            throw new SignatureException(AvailErrorCode.E_INCORRECT_NUMBER_OF_ARGUMENTS);
        }
        this.runtime.addSemanticRestriction(restriction);
        A_Atom atom = A_Bundle.Companion.getMessage(A_Method.Companion.chooseBundle(method, this.module));
        A_BasicObject[] a_BasicObjectArray = new A_BasicObject[]{atom, function};
        this.recordEffect(new LoadingEffectToRunPrimitive(MethodDescriptor.SpecialMethodAtom.SEMANTIC_RESTRICTION.getBundle(), a_BasicObjectArray));
        A_Module theModule = this.module;
        A_RawFunction code = function.code();
        theModule.lock((Function0)new Function0<Unit>(theModule, restriction, this, atom, code, function){
            final /* synthetic */ A_Module $theModule;
            final /* synthetic */ A_SemanticRestriction $restriction;
            final /* synthetic */ AvailLoader this$0;
            final /* synthetic */ A_Atom $atom;
            final /* synthetic */ A_RawFunction $code;
            final /* synthetic */ A_Function $function;
            {
                this.$theModule = $theModule;
                this.$restriction = $restriction;
                this.this$0 = $receiver;
                this.$atom = $atom;
                this.$code = $code;
                this.$function = $function;
                super(0);
            }

            public final void invoke() {
                A_Module.Companion.moduleAddSemanticRestriction(this.$theModule, this.$restriction);
                if (AvailLoader.access$getPhase$p(this.this$0) == Phase.EXECUTING_FOR_COMPILE) {
                    List<ModuleManifestEntry> list = this.this$0.getManifestEntries();
                    Intrinsics.checkNotNull(list);
                    String string2 = A_Atom.Companion.getAtomName(this.$atom).asNativeString();
                    A_Phrase a_Phrase = this.this$0.getTopLevelStatementBeingCompiled();
                    Intrinsics.checkNotNull((Object)a_Phrase);
                    list.add(new ModuleManifestEntry(SideEffectKind.SEMANTIC_RESTRICTION_KIND, string2, A_Phrase.Companion.getStartingLineNumber(a_Phrase), A_RawFunction.Companion.getCodeStartingLineNumber(this.$code), this.$function, 0, 32, null));
                }
            }
        });
    }

    public final void addSeal(@NotNull A_Atom methodName, @NotNull A_Tuple seal) throws MalformedMessageException, SignatureException {
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        Intrinsics.checkNotNullParameter((Object)seal, (String)"seal");
        boolean bl = methodName.isAtom();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        bl = seal.isTuple();
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        A_Bundle bundle = A_Atom.Companion.bundleOrCreate(methodName);
        MessageSplitter splitter = A_Bundle.Companion.getMessageSplitter(bundle);
        if (A_Tuple.Companion.getTupleSize(seal) != splitter.getNumberOfArguments()) {
            throw new SignatureException(AvailErrorCode.E_INCORRECT_NUMBER_OF_ARGUMENTS);
        }
        methodName.makeShared();
        seal.makeShared();
        this.runtime.addSeal(methodName, seal);
        A_Module.Companion.addSeal(this.module, methodName, seal);
        A_BasicObject[] a_BasicObjectArray = new A_BasicObject[]{methodName, seal};
        this.recordEffect(new LoadingEffectToRunPrimitive(MethodDescriptor.SpecialMethodAtom.SEAL.getBundle(), a_BasicObjectArray));
        if (this.phase == Phase.EXECUTING_FOR_COMPILE) {
            List<ModuleManifestEntry> list = this.manifestEntries;
            Intrinsics.checkNotNull(list);
            String string4 = A_Atom.Companion.getAtomName(methodName).asNativeString();
            A_Phrase a_Phrase = this.topLevelStatementBeingCompiled;
            Intrinsics.checkNotNull((Object)a_Phrase);
            int n = A_Phrase.Companion.getStartingLineNumber(a_Phrase);
            A_Phrase a_Phrase2 = this.topLevelStatementBeingCompiled;
            Intrinsics.checkNotNull((Object)a_Phrase2);
            list.add(new ModuleManifestEntry(SideEffectKind.SEAL_KIND, string4, n, A_Phrase.Companion.getStartingLineNumber(a_Phrase2), null, 0, 48, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void addGrammaticalRestrictions(@NotNull A_Set parentAtoms, @NotNull A_Tuple illegalArgumentMessages) throws MalformedMessageException, SignatureException {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)parentAtoms, (String)"parentAtoms");
        Intrinsics.checkNotNullParameter((Object)illegalArgumentMessages, (String)"illegalArgumentMessages");
        parentAtoms.makeShared();
        illegalArgumentMessages.makeShared();
        Iterable $this$map$iv = illegalArgumentMessages;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void atomsSet;
            AvailObject availObject = (AvailObject)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            A_Set bundleSet = null;
            bundleSet = SetDescriptor.Companion.getEmptySet();
            Iterable $this$forEach$iv = (Iterable)atomsSet;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AvailObject atom = (AvailObject)element$iv;
                boolean bl2 = false;
                bundleSet = A_Set.Companion.setWithElementCanDestroy(bundleSet, A_Atom.Companion.bundleOrCreate(atom), true);
            }
            collection.add(bundleSet.makeShared());
        }
        List bundleSetList = (List)destination$iv$iv;
        A_Tuple bundleSetTuple = ObjectTupleDescriptor.Companion.tupleFromList(bundleSetList);
        Iterable $this$forEach$iv = parentAtoms;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AvailObject parentAtom = (AvailObject)element$iv;
            boolean bl = false;
            A_Bundle bundle = A_Atom.Companion.bundleOrCreate(parentAtom);
            MessageSplitter splitter = A_Bundle.Companion.getMessageSplitter(bundle);
            int numArgs = splitter.getLeafArgumentCount();
            if (A_Tuple.Companion.getTupleSize(illegalArgumentMessages) != numArgs) {
                throw new SignatureException(AvailErrorCode.E_INCORRECT_NUMBER_OF_ARGUMENTS);
            }
            A_GrammaticalRestriction grammaticalRestriction = GrammaticalRestrictionDescriptor.Companion.newGrammaticalRestriction(bundleSetTuple, bundle, this.module);
            A_BundleTree root = this.rootBundleTree();
            A_Module theModule = this.module;
            theModule.lock((Function0)new Function0<Unit>(bundle, grammaticalRestriction, theModule, this, parentAtom, root){
                final /* synthetic */ A_Bundle $bundle;
                final /* synthetic */ A_GrammaticalRestriction $grammaticalRestriction;
                final /* synthetic */ A_Module $theModule;
                final /* synthetic */ AvailLoader this$0;
                final /* synthetic */ AvailObject $parentAtom;
                final /* synthetic */ A_BundleTree $root;
                {
                    this.$bundle = $bundle;
                    this.$grammaticalRestriction = $grammaticalRestriction;
                    this.$theModule = $theModule;
                    this.this$0 = $receiver;
                    this.$parentAtom = $parentAtom;
                    this.$root = $root;
                    super(0);
                }

                public final void invoke() {
                    A_Bundle.Companion.addGrammaticalRestriction(this.$bundle, this.$grammaticalRestriction);
                    A_Module.Companion.moduleAddGrammaticalRestriction(this.$theModule, this.$grammaticalRestriction);
                    if (AvailLoader.access$getPhase$p(this.this$0) != Phase.EXECUTING_FOR_COMPILE) {
                        return;
                    }
                    ArrayDeque<Pair<A_BundleTree, A_ParsingPlanInProgress>> treesToVisit = new ArrayDeque<Pair<A_BundleTree, A_ParsingPlanInProgress>>();
                    A_Map.Companion.forEach(A_Bundle.Companion.getDefinitionParsingPlans(this.$bundle), (Function2<? super AvailObject, ? super AvailObject, Unit>)((Function2)new Function2<AvailObject, A_DefinitionParsingPlan, Unit>(treesToVisit, this.$root){
                        final /* synthetic */ ArrayDeque<Pair<A_BundleTree, A_ParsingPlanInProgress>> $treesToVisit;
                        final /* synthetic */ A_BundleTree $root;
                        {
                            this.$treesToVisit = $treesToVisit;
                            this.$root = $root;
                            super(2);
                        }

                        public final void invoke(@NotNull AvailObject availObject, @NotNull A_DefinitionParsingPlan plan) {
                            Intrinsics.checkNotNullParameter((Object)availObject, (String)"<anonymous parameter 0>");
                            Intrinsics.checkNotNullParameter((Object)plan, (String)"plan");
                            this.$treesToVisit.addLast((Pair<A_BundleTree, A_ParsingPlanInProgress>)TuplesKt.to((Object)this.$root, (Object)ParsingPlanInProgressDescriptor.Companion.newPlanInProgress(plan, 1)));
                            while (!((Collection)this.$treesToVisit).isEmpty()) {
                                Pair<A_BundleTree, A_ParsingPlanInProgress> pair = this.$treesToVisit.removeLast();
                                A_BundleTree tree = (A_BundleTree)pair.component1();
                                A_ParsingPlanInProgress planInProgress = (A_ParsingPlanInProgress)pair.component2();
                                A_BundleTree.Companion.updateForNewGrammaticalRestriction(tree, planInProgress, (Deque<Pair<A_BundleTree, A_ParsingPlanInProgress>>)this.$treesToVisit);
                            }
                        }
                    }));
                    if (AvailLoader.access$getPhase$p(this.this$0) == Phase.EXECUTING_FOR_COMPILE) {
                        List<ModuleManifestEntry> list = this.this$0.getManifestEntries();
                        Intrinsics.checkNotNull(list);
                        String string2 = A_Atom.Companion.getAtomName(this.$parentAtom).asNativeString();
                        A_Phrase a_Phrase = this.this$0.getTopLevelStatementBeingCompiled();
                        Intrinsics.checkNotNull((Object)a_Phrase);
                        int n = A_Phrase.Companion.getStartingLineNumber(a_Phrase);
                        A_Phrase a_Phrase2 = this.this$0.getTopLevelStatementBeingCompiled();
                        Intrinsics.checkNotNull((Object)a_Phrase2);
                        list.add(new ModuleManifestEntry(SideEffectKind.GRAMMATICAL_RESTRICTION_KIND, string2, n, A_Phrase.Companion.getStartingLineNumber(a_Phrase2), null, 0, 48, null));
                    }
                }
            });
        }
        A_BasicObject[] a_BasicObjectArray = new A_BasicObject[]{parentAtoms, illegalArgumentMessages};
        this.recordEffect(new LoadingEffectToRunPrimitive(MethodDescriptor.SpecialMethodAtom.GRAMMATICAL_RESTRICTION.getBundle(), a_BasicObjectArray));
    }

    public final void removeDefinition(@NotNull A_Definition definition) {
        Intrinsics.checkNotNullParameter((Object)definition, (String)"definition");
        if (A_Sendable.Companion.isForwardDefinition(definition)) {
            this.pendingForwards = A_Set.Companion.setWithoutElementCanDestroy(this.pendingForwards, definition, true);
        }
        this.runtime.removeDefinition(definition);
    }

    public final void removeMacro(@NotNull A_Macro macro) {
        Intrinsics.checkNotNullParameter((Object)macro, (String)"macro");
        this.runtime.removeMacro(macro);
    }

    public final void runUnloadFunctions(@NotNull A_Tuple unloadFunctions, @NotNull Function0<Unit> afterRunning) {
        Intrinsics.checkNotNullParameter((Object)unloadFunctions, (String)"unloadFunctions");
        Intrinsics.checkNotNullParameter(afterRunning, (String)"afterRunning");
        int size = A_Tuple.Companion.getTupleSize(unloadFunctions);
        if (size == 0) {
            this.runtime.execute(50, afterRunning);
        } else {
            Ref.IntRef index2 = new Ref.IntRef();
            index2.element = 1;
            Combinator.INSTANCE.recurse((Function1<? super Function0<Unit>, Unit>)((Function1)new Function1<Function0<? extends Unit>, Unit>(index2, size, unloadFunctions, this, afterRunning){
                final /* synthetic */ Ref.IntRef $index;
                final /* synthetic */ int $size;
                final /* synthetic */ A_Tuple $unloadFunctions;
                final /* synthetic */ AvailLoader this$0;
                final /* synthetic */ Function0<Unit> $afterRunning;
                {
                    this.$index = $index;
                    this.$size = $size;
                    this.$unloadFunctions = $unloadFunctions;
                    this.this$0 = $receiver;
                    this.$afterRunning = $afterRunning;
                    super(1);
                }

                public final void invoke(@NotNull Function0<Unit> again) {
                    Intrinsics.checkNotNullParameter(again, (String)"again");
                    if (this.$index.element <= this.$size) {
                        int n = this.$index.element;
                        this.$index.element = n + 1;
                        int currentIndex = n;
                        A_Function unloadFunction = A_Tuple.Companion.tupleAt(this.$unloadFunctions, currentIndex);
                        A_Fiber fiber2 = FiberDescriptor.Companion.newFiber$default(FiberDescriptor.Companion, PrimitiveTypeDescriptor.Types.TOP.getO(), this.this$0.getRuntime(), this.this$0.getTextInterface(), 50, null, (Function0)new Function0<A_String>(currentIndex, this.$size, this.this$0){
                            final /* synthetic */ int $currentIndex;
                            final /* synthetic */ int $size;
                            final /* synthetic */ AvailLoader this$0;
                            {
                                this.$currentIndex = $currentIndex;
                                this.$size = $size;
                                this.this$0 = $receiver;
                                super(0);
                            }

                            @NotNull
                            public final A_String invoke() {
                                Object[] objectArray = new Object[]{this.$currentIndex, this.$size, A_Module.Companion.getShortModuleNameNative(this.this$0.getModule())};
                                return StringDescriptor.Companion.formatString("Unload function #%d/%d for module %s", objectArray);
                            }
                        }, 16, null);
                        A_Fiber.Companion.setSuccessAndFailure(fiber2, (Function1<? super AvailObject, Unit>)((Function1)new Function1<AvailObject, Unit>(again){
                            final /* synthetic */ Function0<Unit> $again;
                            {
                                this.$again = $again;
                                super(1);
                            }

                            public final void invoke(@NotNull AvailObject it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                this.$again.invoke();
                            }
                        }), (Function1<? super Throwable, Unit>)((Function1)new Function1<Throwable, Unit>(again){
                            final /* synthetic */ Function0<Unit> $again;
                            {
                                this.$again = $again;
                                super(1);
                            }

                            public final void invoke(@NotNull Throwable it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                this.$again.invoke();
                            }
                        }));
                        this.this$0.getRuntime().runOutermostFunction(fiber2, unloadFunction, CollectionsKt.emptyList());
                    } else {
                        this.this$0.getRuntime().execute(50, this.$afterRunning);
                    }
                }
            }));
        }
    }

    @JvmOverloads
    @NotNull
    public final A_Atom lookupName(@NotNull A_String stringName, boolean isExplicitSubclassAtom) throws AmbiguousNameException {
        Intrinsics.checkNotNullParameter((Object)stringName, (String)"stringName");
        return (A_Atom)this.module.lock((Function0)new Function0<AvailObject>(this, stringName, isExplicitSubclassAtom){
            final /* synthetic */ AvailLoader this$0;
            final /* synthetic */ A_String $stringName;
            final /* synthetic */ boolean $isExplicitSubclassAtom;
            {
                this.this$0 = $receiver;
                this.$stringName = $stringName;
                this.$isExplicitSubclassAtom = $isExplicitSubclassAtom;
                super(0);
            }

            @NotNull
            public final AvailObject invoke() {
                A_Set who = A_Module.Companion.trueNamesForStringName(this.this$0.getModule(), this.$stringName);
                return switch (A_Set.Companion.getSetSize(who)) {
                    case 1 -> (AvailObject)CollectionsKt.single((Iterable)who);
                    case 0 -> {
                        void var2_2;
                        AvailObject trueName = AtomDescriptor.Companion.createAtom(this.$stringName, this.this$0.getModule());
                        if (AvailLoader.access$getPhase$p(this.this$0) == Phase.EXECUTING_FOR_COMPILE) {
                            A_Phrase v1 = this.this$0.getTopLevelStatementBeingCompiled();
                            Intrinsics.checkNotNull((Object)v1);
                            int topStart = A_Phrase.Companion.getStartingLineNumber(v1);
                            List<ModuleManifestEntry> v2 = this.this$0.getManifestEntries();
                            Intrinsics.checkNotNull(v2);
                            v2.add(new ModuleManifestEntry(SideEffectKind.ATOM_DEFINITION_KIND, this.$stringName.asNativeString(), topStart, topStart, null, 0, 48, null));
                        }
                        if (this.$isExplicitSubclassAtom) {
                            A_Atom.Companion.setAtomProperty(trueName, AtomDescriptor.SpecialAtom.EXPLICIT_SUBCLASSING_KEY.getAtom(), AtomDescriptor.Companion.getTrueObject());
                        }
                        trueName.makeShared();
                        A_Module.Companion.addPrivateName(this.this$0.getModule(), trueName);
                        yield var2_2;
                    }
                    default -> throw new AmbiguousNameException();
                };
            }
        });
    }

    public static /* synthetic */ A_Atom lookupName$default(AvailLoader availLoader, A_String a_String, boolean bl, int n, Object object) throws AmbiguousNameException {
        if ((n & 2) != 0) {
            bl = false;
        }
        return availLoader.lookupName(a_String, bl);
    }

    @NotNull
    public final A_Set lookupAtomsForName(@NotNull A_String stringName) {
        Intrinsics.checkNotNullParameter((Object)stringName, (String)"stringName");
        return (A_Set)this.module.lock((Function0)new Function0<A_Set>(this, stringName){
            final /* synthetic */ AvailLoader this$0;
            final /* synthetic */ A_String $stringName;
            {
                this.this$0 = $receiver;
                this.$stringName = $stringName;
                super(0);
            }

            @NotNull
            public final A_Set invoke() {
                AvailObject name2 = A_Map.Companion.mapAtOrNull(A_Module.Companion.getNewNames(this.this$0.getModule()), this.$stringName);
                A_Set newNames = name2 == null ? SetDescriptor.Companion.getEmptySet() : SetDescriptor.Companion.singletonSet(name2);
                AvailObject availObject = A_Map.Companion.mapAtOrNull(A_Module.Companion.getImportedNames(this.this$0.getModule()), this.$stringName);
                A_Set publicNames = availObject != null ? (A_Set)availObject : SetDescriptor.Companion.getEmptySet();
                AvailObject availObject2 = A_Map.Companion.mapAtOrNull(A_Module.Companion.getPrivateNames(this.this$0.getModule()), this.$stringName);
                A_Set privateNames = availObject2 != null ? (A_Set)availObject2 : SetDescriptor.Companion.getEmptySet();
                return A_Set.Companion.setUnionCanDestroy(A_Set.Companion.setUnionCanDestroy(newNames, publicNames, true), privateNames, true);
            }
        });
    }

    @JvmOverloads
    @NotNull
    public final A_Atom lookupName(@NotNull A_String stringName) throws AmbiguousNameException {
        Intrinsics.checkNotNullParameter((Object)stringName, (String)"stringName");
        return AvailLoader.lookupName$default(this, stringName, false, 2, null);
    }

    public static final /* synthetic */ void access$removeForward(AvailLoader $this, A_Definition forwardDefinition) {
        $this.removeForward(forwardDefinition);
    }

    public static final /* synthetic */ Phase access$getPhase$p(AvailLoader $this) {
        return $this.phase;
    }

    static {
        A_Bundle a_Bundle;
        Companion = new Companion(null);
        enableFastLoader = true;
        Object object = MessageBundleTreeDescriptor.Companion.newBundleTree(NilDescriptor.Companion.getNil());
        A_BundleTree $this$moduleHeaderBundleRoot_u24lambda_u2d9 = object;
        boolean bl = false;
        try {
            a_Bundle = A_Atom.Companion.bundleOrCreate(MethodDescriptor.SpecialMethodAtom.MODULE_HEADER.getAtom());
        }
        catch (MalformedMessageException e) {
            if (_Assertions.ENABLED) {
                boolean bl2 = false;
                String string2 = "Malformed module header method name";
                throw new AssertionError((Object)string2);
            }
            throw new RuntimeException(e);
        }
        A_Bundle headerMethodBundle = a_Bundle;
        A_DefinitionParsingPlan headerPlan = ((MapDescriptor.Entry)A_Map.Companion.getMapIterable(A_Bundle.Companion.getDefinitionParsingPlans(headerMethodBundle)).next()).value();
        A_BundleTree.Companion.addPlanInProgress($this$moduleHeaderBundleRoot_u24lambda_u2d9, ParsingPlanInProgressDescriptor.Companion.newPlanInProgress(headerPlan, 1));
        moduleHeaderBundleRoot = object;
        Object $this$moduleHeaderLexicalScanner_u24lambda_u2d10 = object = new LexicalScanner();
        boolean bl3 = false;
        AvailLoader.Companion.createPrimitiveLexerForHeaderParsing((LexicalScanner)$this$moduleHeaderLexicalScanner_u24lambda_u2d10, P_BootstrapLexerStringFilter.INSTANCE, P_BootstrapLexerStringBody.INSTANCE, "string token lexer");
        AvailLoader.Companion.createPrimitiveLexerForHeaderParsing((LexicalScanner)$this$moduleHeaderLexicalScanner_u24lambda_u2d10, P_BootstrapLexerKeywordFilter.INSTANCE, P_BootstrapLexerKeywordBody.INSTANCE, "keyword token lexer");
        AvailLoader.Companion.createPrimitiveLexerForHeaderParsing((LexicalScanner)$this$moduleHeaderLexicalScanner_u24lambda_u2d10, P_BootstrapLexerOperatorFilter.INSTANCE, P_BootstrapLexerOperatorBody.INSTANCE, "operator token lexer");
        AvailLoader.Companion.createPrimitiveLexerForHeaderParsing((LexicalScanner)$this$moduleHeaderLexicalScanner_u24lambda_u2d10, P_BootstrapLexerWhitespaceFilter.INSTANCE, P_BootstrapLexerWhitespaceBody.INSTANCE, "whitespace lexer");
        AvailLoader.Companion.createPrimitiveLexerForHeaderParsing((LexicalScanner)$this$moduleHeaderLexicalScanner_u24lambda_u2d10, P_BootstrapLexerSlashStarCommentFilter.INSTANCE, P_BootstrapLexerSlashStarCommentBody.INSTANCE, "comment lexer");
        ((LexicalScanner)$this$moduleHeaderLexicalScanner_u24lambda_u2d10).freezeFromChanges();
        moduleHeaderLexicalScanner = object;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0003\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\nH\u0002J\u0006\u0010\u001c\u001a\u00020\u0018JJ\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00162\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00180\"2\u001e\u0010#\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020%0$\u0012\u0004\u0012\u00020\u00180\"J>\u0010&\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00162$\u0010!\u001a \u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020%0$\u0012\u0004\u0012\u00020\u00180'H\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u000b0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lavail/interpreter/execution/AvailLoader$LexicalScanner;", "", "()V", "allVisibleLexers", "", "Lavail/descriptor/parsing/A_Lexer;", "getAllVisibleLexers", "()Ljava/util/List;", "canonicalLexerTuples", "", "Lavail/descriptor/sets/A_Set;", "Lavail/descriptor/tuples/A_Tuple;", "frozen", "", "getFrozen", "()Z", "setFrozen", "(Z)V", "latin1ApplicableLexers", "Ljava/util/concurrent/atomic/AtomicReferenceArray;", "nonLatin1Lexers", "Ljava/util/concurrent/ConcurrentHashMap;", "", "addLexer", "", "lexer", "canonicalTupleOfLexers", "applicable", "freezeFromChanges", "getLexersForCodePointThen", "lexingState", "Lavail/compiler/scanning/LexingState;", "codePoint", "continuation", "Lkotlin/Function1;", "onFailure", "", "", "selectLexersPassingFilterThen", "Lkotlin/Function2;", "avail"})
    public static final class LexicalScanner {
        @NotNull
        private final List<A_Lexer> allVisibleLexers = new ArrayList();
        private volatile boolean frozen;
        @NotNull
        private final AtomicReferenceArray<A_Tuple> latin1ApplicableLexers = new AtomicReferenceArray(256);
        @NotNull
        private final ConcurrentHashMap<Integer, A_Tuple> nonLatin1Lexers = new ConcurrentHashMap();
        @NotNull
        private final Map<A_Set, A_Tuple> canonicalLexerTuples = new LinkedHashMap();

        @NotNull
        public final List<A_Lexer> getAllVisibleLexers() {
            return this.allVisibleLexers;
        }

        public final boolean getFrozen() {
            return this.frozen;
        }

        public final void setFrozen(boolean bl) {
            this.frozen = bl;
        }

        public final void freezeFromChanges() {
            boolean bl;
            boolean bl2 = bl = !this.frozen;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            this.frozen = true;
        }

        public final synchronized void addLexer(@NotNull A_Lexer lexer) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)lexer, (String)"lexer");
            boolean bl2 = bl = !this.frozen;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            A_Method.Companion.setLexer(A_Lexer.Companion.getLexerMethod(lexer), lexer);
            A_Module module = A_Lexer.Companion.getDefinitionModule(lexer);
            if (module.getNotNil() && A_Module.Companion.getModuleState(module) == ModuleDescriptor.State.Loading) {
                A_Module.Companion.addLexer(module, lexer);
            }
            this.allVisibleLexers.add(lexer);
            if (!this.canonicalLexerTuples.isEmpty()) {
                for (int i = 0; i < 256; ++i) {
                    this.latin1ApplicableLexers.set(i, null);
                }
                this.nonLatin1Lexers.clear();
                this.canonicalLexerTuples.clear();
            }
        }

        public final void getLexersForCodePointThen(@NotNull LexingState lexingState, int codePoint, @NotNull Function1<? super A_Tuple, Unit> continuation, @NotNull Function1<? super Map<A_Lexer, ? extends Throwable>, Unit> onFailure) {
            A_Tuple tuple2;
            Intrinsics.checkNotNullParameter((Object)lexingState, (String)"lexingState");
            Intrinsics.checkNotNullParameter(continuation, (String)"continuation");
            Intrinsics.checkNotNullParameter(onFailure, (String)"onFailure");
            if ((codePoint & 0xFFFFFF00) == 0) {
                A_Tuple a_Tuple = this.latin1ApplicableLexers.get(codePoint);
                if (a_Tuple != null) {
                    A_Tuple it = a_Tuple;
                    boolean bl = false;
                    continuation.invoke((Object)it);
                    return;
                }
                this.selectLexersPassingFilterThen(lexingState, codePoint, (Function2<? super A_Set, ? super Map<A_Lexer, ? extends Throwable>, Unit>)((Function2)new Function2<A_Set, Map<A_Lexer, ? extends Throwable>, Unit>(onFailure, this, codePoint, continuation){
                    final /* synthetic */ Function1<Map<A_Lexer, ? extends Throwable>, Unit> $onFailure;
                    final /* synthetic */ LexicalScanner this$0;
                    final /* synthetic */ int $codePoint;
                    final /* synthetic */ Function1<A_Tuple, Unit> $continuation;
                    {
                        this.$onFailure = $onFailure;
                        this.this$0 = $receiver;
                        this.$codePoint = $codePoint;
                        this.$continuation = $continuation;
                        super(2);
                    }

                    public final void invoke(@NotNull A_Set applicable, @NotNull Map<A_Lexer, ? extends Throwable> failures) {
                        Intrinsics.checkNotNullParameter((Object)applicable, (String)"applicable");
                        Intrinsics.checkNotNullParameter(failures, (String)"failures");
                        if (!failures.isEmpty()) {
                            this.$onFailure.invoke(failures);
                        } else {
                            A_Tuple lexers = LexicalScanner.access$canonicalTupleOfLexers(this.this$0, applicable);
                            LexicalScanner.access$getLatin1ApplicableLexers$p(this.this$0).set(this.$codePoint, lexers);
                            this.$continuation.invoke((Object)lexers);
                        }
                    }
                }));
                return;
            }
            A_Tuple a_Tuple = tuple2 = this.nonLatin1Lexers.get(codePoint);
            if (a_Tuple != null) {
                continuation.invoke((Object)a_Tuple);
                return;
            }
            this.selectLexersPassingFilterThen(lexingState, codePoint, (Function2<? super A_Set, ? super Map<A_Lexer, ? extends Throwable>, Unit>)((Function2)new Function2<A_Set, Map<A_Lexer, ? extends Throwable>, Unit>(onFailure, this, codePoint, continuation){
                final /* synthetic */ Function1<Map<A_Lexer, ? extends Throwable>, Unit> $onFailure;
                final /* synthetic */ LexicalScanner this$0;
                final /* synthetic */ int $codePoint;
                final /* synthetic */ Function1<A_Tuple, Unit> $continuation;
                {
                    this.$onFailure = $onFailure;
                    this.this$0 = $receiver;
                    this.$codePoint = $codePoint;
                    this.$continuation = $continuation;
                    super(2);
                }

                public final void invoke(@NotNull A_Set applicable, @NotNull Map<A_Lexer, ? extends Throwable> failures) {
                    Intrinsics.checkNotNullParameter((Object)applicable, (String)"applicable");
                    Intrinsics.checkNotNullParameter(failures, (String)"failures");
                    if (!failures.isEmpty()) {
                        this.$onFailure.invoke(failures);
                        return;
                    }
                    A_Tuple lexers = LexicalScanner.access$canonicalTupleOfLexers(this.this$0, applicable);
                    ((Map)LexicalScanner.access$getNonLatin1Lexers$p(this.this$0)).put(this.$codePoint, lexers);
                    this.$continuation.invoke((Object)lexers);
                }
            }));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final A_Tuple canonicalTupleOfLexers(A_Set applicable) {
            A_Tuple a_Tuple;
            Map<A_Set, A_Tuple> map = this.canonicalLexerTuples;
            synchronized (map) {
                boolean bl = false;
                A_Tuple a_Tuple2 = this.canonicalLexerTuples.get(applicable);
                if (a_Tuple2 == null) {
                    LexicalScanner $this$canonicalTupleOfLexers_u24lambda_u2d2_u24lambda_u2d1 = this;
                    boolean bl2 = false;
                    AvailObject tuple2 = A_Set.Companion.getAsTuple(applicable).makeShared();
                    $this$canonicalTupleOfLexers_u24lambda_u2d2_u24lambda_u2d1.canonicalLexerTuples.put(applicable.makeShared(), tuple2);
                    a_Tuple2 = tuple2;
                }
                a_Tuple = a_Tuple2;
            }
            return a_Tuple;
        }

        /*
         * WARNING - void declaration
         */
        private final void selectLexersPassingFilterThen(LexingState lexingState, int codePoint, Function2<? super A_Set, ? super Map<A_Lexer, ? extends Throwable>, Unit> continuation) {
            void $this$mapTo$iv$iv;
            List applicableLexers = new ArrayList();
            List undecidedLexers = new ArrayList();
            int n = codePoint;
            boolean bl = 0 <= n ? n < 256 : false;
            if (bl) {
                Iterable $this$forEach$iv = this.allVisibleLexers;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    A_Lexer it = (A_Lexer)element$iv;
                    boolean bl2 = false;
                    Boolean bl3 = A_Lexer.Companion.lexerApplicability(it, codePoint);
                    if (bl3 == null) {
                        undecidedLexers.add(it);
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)bl3, (Object)true)) {
                        applicableLexers.add(it);
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)bl3, (Object)false)) continue;
                }
            } else {
                undecidedLexers.addAll((Collection)this.allVisibleLexers);
            }
            Ref.IntRef countdown = new Ref.IntRef();
            countdown.element = undecidedLexers.size();
            if (countdown.element == 0) {
                continuation.invoke((Object)SetDescriptor.Companion.setFromCollection(applicableLexers), (Object)MapsKt.emptyMap());
                return;
            }
            List argsList = CollectionsKt.listOf((Object)CharacterDescriptor.Companion.fromCodePoint(codePoint));
            CompilationContext compilationContext = lexingState.getCompilationContext();
            AvailLoader loader = compilationContext.getLoader();
            ReentrantLock joinLock = new ReentrantLock();
            Map failureMap = new LinkedHashMap();
            Iterable $this$map$iv = undecidedLexers;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void lexer;
                A_Lexer a_Lexer = (A_Lexer)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                A_Fiber fiber2 = FiberDescriptor.Companion.newLoaderFiber(EnumerationTypeDescriptor.Companion.getBooleanType(), loader, (Function0<? extends A_String>)((Function0)new Function0<A_String>((A_Lexer)lexer, loader, codePoint){
                    final /* synthetic */ A_Lexer $lexer;
                    final /* synthetic */ AvailLoader $loader;
                    final /* synthetic */ int $codePoint;
                    {
                        this.$lexer = $lexer;
                        this.$loader = $loader;
                        this.$codePoint = $codePoint;
                        super(0);
                    }

                    @NotNull
                    public final A_String invoke() {
                        Object[] objectArray = new Object[]{A_Atom.Companion.getAtomName(A_Bundle.Companion.getMessage(A_Method.Companion.chooseBundle(A_Lexer.Companion.getLexerMethod(this.$lexer), this.$loader.getModule()))), this.$codePoint};
                        return StringDescriptor.Companion.formatString("Check lexer filter %s for U+%06x", objectArray);
                    }
                }));
                lexingState.setFiberContinuationsTrackingWork(fiber2, (Function1<? super AvailObject, Unit>)((Function1)new Function1<AvailObject, Unit>(codePoint, (A_Lexer)lexer, joinLock, continuation, (List<A_Lexer>)applicableLexers, (Map<A_Lexer, Throwable>)failureMap, countdown){
                    final /* synthetic */ int $codePoint;
                    final /* synthetic */ A_Lexer $lexer;
                    final /* synthetic */ ReentrantLock $joinLock;
                    final /* synthetic */ Function2<A_Set, Map<A_Lexer, ? extends Throwable>, Unit> $continuation;
                    final /* synthetic */ List<A_Lexer> $applicableLexers;
                    final /* synthetic */ Map<A_Lexer, Throwable> $failureMap;
                    final /* synthetic */ Ref.IntRef $countdown;
                    {
                        this.$codePoint = $codePoint;
                        this.$lexer = $lexer;
                        this.$joinLock = $joinLock;
                        this.$continuation = $continuation;
                        this.$applicableLexers = $applicableLexers;
                        this.$failureMap = $failureMap;
                        this.$countdown = $countdown;
                        super(1);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void invoke(@NotNull AvailObject boolObject) {
                        boolean bl;
                        Intrinsics.checkNotNullParameter((Object)boolObject, (String)"boolObject");
                        boolean boolValue = A_Atom.Companion.getExtractBoolean(boolObject);
                        boolean bl2 = 0 <= this.$codePoint ? this.$codePoint < 256 : false;
                        if (bl2) {
                            A_Lexer.Companion.setLexerApplicability(this.$lexer, this.$codePoint, boolValue);
                        }
                        Lock lock = this.$joinLock;
                        List<A_Lexer> list = this.$applicableLexers;
                        A_Lexer a_Lexer = this.$lexer;
                        Ref.IntRef intRef = this.$countdown;
                        lock.lock();
                        try {
                            boolean bl3 = false;
                            if (boolValue) {
                                list.add(a_Lexer);
                            }
                            int n = intRef.element;
                            intRef.element = n + -1;
                            int n2 = n = intRef.element >= 0 ? 1 : 0;
                            if (_Assertions.ENABLED && n == 0) {
                                String string2 = "Assertion failed";
                                throw new AssertionError((Object)string2);
                            }
                            bl = intRef.element == 0;
                        }
                        finally {
                            lock.unlock();
                        }
                        boolean countdownHitZero = bl;
                        if (countdownHitZero) {
                            this.$continuation.invoke((Object)SetDescriptor.Companion.setFromCollection((Collection<? extends A_BasicObject>)this.$applicableLexers), this.$failureMap);
                        }
                    }
                }), (Function1<? super Throwable, Unit>)((Function1)new Function1<Throwable, Unit>(joinLock, continuation, (List<A_Lexer>)applicableLexers, (Map<A_Lexer, Throwable>)failureMap, (A_Lexer)lexer, countdown){
                    final /* synthetic */ ReentrantLock $joinLock;
                    final /* synthetic */ Function2<A_Set, Map<A_Lexer, ? extends Throwable>, Unit> $continuation;
                    final /* synthetic */ List<A_Lexer> $applicableLexers;
                    final /* synthetic */ Map<A_Lexer, Throwable> $failureMap;
                    final /* synthetic */ A_Lexer $lexer;
                    final /* synthetic */ Ref.IntRef $countdown;
                    {
                        this.$joinLock = $joinLock;
                        this.$continuation = $continuation;
                        this.$applicableLexers = $applicableLexers;
                        this.$failureMap = $failureMap;
                        this.$lexer = $lexer;
                        this.$countdown = $countdown;
                        super(1);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public final void invoke(@NotNull Throwable throwable) {
                        boolean bl;
                        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                        Lock lock = this.$joinLock;
                        Map<A_Lexer, Throwable> map = this.$failureMap;
                        A_Lexer a_Lexer = this.$lexer;
                        Ref.IntRef intRef = this.$countdown;
                        lock.lock();
                        try {
                            boolean bl2 = false;
                            map.put(a_Lexer, throwable);
                            int n = intRef.element;
                            intRef.element = n + -1;
                            int n2 = n = intRef.element >= 0 ? 1 : 0;
                            if (_Assertions.ENABLED && n == 0) {
                                String string2 = "Assertion failed";
                                throw new AssertionError((Object)string2);
                            }
                            bl = intRef.element == 0;
                        }
                        finally {
                            lock.unlock();
                        }
                        boolean countdownHitZero = bl;
                        if (countdownHitZero) {
                            this.$continuation.invoke((Object)SetDescriptor.Companion.setFromCollection((Collection<? extends A_BasicObject>)this.$applicableLexers), this.$failureMap);
                        }
                    }
                }));
                collection.add(fiber2);
            }
            List fibers2 = (List)destination$iv$iv;
            Iterable $this$forEachIndexed$iv = fibers2;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void fiber3;
                int n2;
                Object item$iv$iv;
                if ((n2 = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                item$iv$iv = (A_Fiber)item$iv;
                int i = n2;
                boolean bl5 = false;
                loader.getRuntime().runOutermostFunction((A_Fiber)fiber3, A_Lexer.Companion.getLexerFilterFunction((A_Lexer)undecidedLexers.get(i)), argsList);
            }
        }

        public static final /* synthetic */ A_Tuple access$canonicalTupleOfLexers(LexicalScanner $this, A_Set applicable) {
            return $this.canonicalTupleOfLexers(applicable);
        }

        public static final /* synthetic */ AtomicReferenceArray access$getLatin1ApplicableLexers$p(LexicalScanner $this) {
            return $this.latin1ApplicableLexers;
        }

        public static final /* synthetic */ ConcurrentHashMap access$getNonLatin1Lexers$p(LexicalScanner $this) {
            return $this.nonLatin1Lexers;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lavail/interpreter/execution/AvailLoader$Phase;", "", "isExecuting", "", "(Ljava/lang/String;IZ)V", "()Z", "INITIALIZING", "COMPILING", "LOADING", "EXECUTING_FOR_COMPILE", "EXECUTING_FOR_LOAD", "UNLOADING", "COMPILING_FOR_EVAL", "avail"})
    public static final class Phase
    extends Enum<Phase> {
        private final boolean isExecuting;
        public static final /* enum */ Phase INITIALIZING = new Phase("INITIALIZING", 0, false, 1, null);
        public static final /* enum */ Phase COMPILING = new Phase("COMPILING", 1, false, 1, null);
        public static final /* enum */ Phase LOADING = new Phase("LOADING", 2, false, 1, null);
        public static final /* enum */ Phase EXECUTING_FOR_COMPILE = new Phase(true);
        public static final /* enum */ Phase EXECUTING_FOR_LOAD = new Phase(true);
        public static final /* enum */ Phase UNLOADING = new Phase("UNLOADING", 5, false, 1, null);
        public static final /* enum */ Phase COMPILING_FOR_EVAL = new Phase(false);
        private static final /* synthetic */ Phase[] $VALUES;

        private Phase(boolean isExecuting) {
            this.isExecuting = isExecuting;
        }

        /* synthetic */ Phase(String string2, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                bl = false;
            }
            this(bl);
        }

        public final boolean isExecuting() {
            return this.isExecuting;
        }

        public static Phase[] values() {
            return (Phase[])$VALUES.clone();
        }

        public static Phase valueOf(String value) {
            return Enum.valueOf(Phase.class, value);
        }

        static {
            $VALUES = phaseArray = new Phase[]{Phase.INITIALIZING, Phase.COMPILING, Phase.LOADING, Phase.EXECUTING_FOR_COMPILE, Phase.EXECUTING_FOR_LOAD, Phase.UNLOADING, Phase.COMPILING_FOR_EVAL};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014J\u001e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ$\u0010\u001c\u001a\u00020\u001d*\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"H\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\bR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lavail/interpreter/execution/AvailLoader$Companion;", "", "()V", "debugLoadedStatements", "", "getDebugLoadedStatements", "()Z", "setDebugLoadedStatements", "(Z)V", "debugUnsummarizedStatements", "getDebugUnsummarizedStatements", "setDebugUnsummarizedStatements", "enableFastLoader", "getEnableFastLoader", "setEnableFastLoader", "moduleHeaderBundleRoot", "Lavail/descriptor/bundles/A_BundleTree;", "moduleHeaderLexicalScanner", "Lavail/interpreter/execution/AvailLoader$LexicalScanner;", "currentLoaderOrNull", "Lavail/interpreter/execution/AvailLoader;", "forUnloading", "runtime", "Lavail/AvailRuntime;", "module", "Lavail/descriptor/module/A_Module;", "textInterface", "Lavail/io/TextInterface;", "createPrimitiveLexerForHeaderParsing", "", "filterPrimitive", "Lavail/interpreter/Primitive;", "bodyPrimitive", "atomName", "", "avail"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean getDebugUnsummarizedStatements() {
            return debugUnsummarizedStatements;
        }

        public final void setDebugUnsummarizedStatements(boolean bl) {
            debugUnsummarizedStatements = bl;
        }

        public final boolean getDebugLoadedStatements() {
            return debugLoadedStatements;
        }

        public final void setDebugLoadedStatements(boolean bl) {
            debugLoadedStatements = bl;
        }

        public final boolean getEnableFastLoader() {
            return enableFastLoader;
        }

        public final void setEnableFastLoader(boolean bl) {
            enableFastLoader = bl;
        }

        @Nullable
        public final AvailLoader currentLoaderOrNull() {
            Thread thread = Thread.currentThread();
            AvailThread availThread = thread instanceof AvailThread ? (AvailThread)thread : null;
            if (availThread == null) {
                return null;
            }
            AvailThread availThread2 = availThread;
            return availThread2.getInterpreter().availLoaderOrNull();
        }

        @NotNull
        public final AvailLoader forUnloading(@NotNull AvailRuntime runtime, @NotNull A_Module module, @NotNull TextInterface textInterface) {
            Intrinsics.checkNotNullParameter((Object)runtime, (String)"runtime");
            Intrinsics.checkNotNullParameter((Object)module, (String)"module");
            Intrinsics.checkNotNullParameter((Object)textInterface, (String)"textInterface");
            AvailLoader loader = new AvailLoader(runtime, module, textInterface);
            loader.setPendingForwards(NilDescriptor.Companion.getNil());
            loader.phase = Phase.UNLOADING;
            return loader;
        }

        private final void createPrimitiveLexerForHeaderParsing(LexicalScanner $this$createPrimitiveLexerForHeaderParsing, Primitive filterPrimitive, Primitive bodyPrimitive, String atomName) {
            A_Bundle a_Bundle;
            A_Function stringLexerFilter = FunctionDescriptor.Companion.createFunction(PrimitiveCompiledCodeDescriptor.Companion.newPrimitiveRawFunction(filterPrimitive, NilDescriptor.Companion.getNil(), 0), TupleDescriptor.Companion.getEmptyTuple());
            A_Function stringLexerBody = FunctionDescriptor.Companion.createFunction(PrimitiveCompiledCodeDescriptor.Companion.newPrimitiveRawFunction(bodyPrimitive, NilDescriptor.Companion.getNil(), 0), TupleDescriptor.Companion.getEmptyTuple());
            try {
                a_Bundle = A_Atom.Companion.bundleOrCreate(AtomDescriptor.Companion.createSpecialAtom(atomName));
            }
            catch (MalformedMessageException e) {
                if (_Assertions.ENABLED) {
                    boolean bl = false;
                    String string2 = "Invalid special lexer name: " + atomName;
                    throw new AssertionError((Object)string2);
                }
                throw new RuntimeException(e);
            }
            A_Bundle bundle = a_Bundle;
            A_Lexer lexer = LexerDescriptor.Companion.newLexer(stringLexerFilter, stringLexerBody, A_Bundle.Companion.getBundleMethod(bundle), NilDescriptor.Companion.getNil());
            $this$createPrimitiveLexerForHeaderParsing.addLexer(lexer);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

