/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.levelTwo;

import avail.AvailDebuggerModel;
import avail.AvailRuntime;
import avail.AvailRuntimeSupport;
import avail.descriptor.atoms.A_Atom;
import avail.descriptor.bundles.A_Bundle;
import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.fiber.FiberDescriptor;
import avail.descriptor.functions.A_Continuation;
import avail.descriptor.functions.A_Function;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.functions.CompiledCodeDescriptor;
import avail.descriptor.functions.ContinuationDescriptor;
import avail.descriptor.functions.FunctionDescriptor;
import avail.descriptor.methods.A_Definition;
import avail.descriptor.methods.A_Method;
import avail.descriptor.methods.A_Sendable;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AbstractDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.representation.ObjectSlotsEnum;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.variables.A_Variable;
import avail.descriptor.variables.VariableDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.exceptions.MethodDefinitionException;
import avail.exceptions.VariableGetException;
import avail.exceptions.VariableSetException;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelOne.L1OperandType;
import avail.interpreter.levelOne.L1Operation;
import avail.interpreter.levelTwo.L2Chunk;
import avail.optimizer.StackReifier;
import avail.optimizer.jvm.CheckedMethod;
import avail.optimizer.jvm.ReferencedInGeneratedCode;
import avail.performance.Statistic;
import avail.performance.StatisticReport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 ?2\u00020\u0001:\u0001?B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J'\u0010\u001d\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0000\u00a2\u0006\u0002\b#J\u0010\u0010$\u001a\u00020\u00012\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\u00012\u0006\u0010%\u001a\u00020&H\u0002J\u0006\u0010(\u001a\u00020\u0014J\u000e\u0010)\u001a\u00020\r2\u0006\u0010*\u001a\u00020\u0014J\u0016\u0010+\u001a\u00020,2\u0006\u0010*\u001a\u00020\u00142\u0006\u0010-\u001a\u00020.J\b\u0010/\u001a\u00020\rH\u0002J\u0010\u00100\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J\u0018\u00101\u001a\u00020\u001a2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0002J \u00106\u001a\u00020,2\u0006\u00107\u001a\u00020\u001a2\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;H\u0002J\n\u0010<\u001a\u0004\u0018\u00010\u001aH\u0007J\u001a\u0010=\u001a\u0004\u0018\u00010\u001a2\u0006\u0010%\u001a\u00020&2\u0006\u0010-\u001a\u00020\rH\u0002J\u0006\u0010>\u001a\u00020,R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\"\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0012\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0013\u001a\u00020\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006@"}, d2={"Lavail/interpreter/levelTwo/L1InstructionStepper;", "", "interpreter", "Lavail/interpreter/execution/Interpreter;", "(Lavail/interpreter/execution/Interpreter;)V", "instructionDecoder", "Lavail/descriptor/functions/CompiledCodeDescriptor$L1InstructionDecoder;", "getInstructionDecoder", "()Lavail/descriptor/functions/CompiledCodeDescriptor$L1InstructionDecoder;", "getInterpreter", "()Lavail/interpreter/execution/Interpreter;", "pointers", "", "Lavail/descriptor/representation/AvailObject;", "getPointers", "()[Lavail/descriptor/representation/AvailObject;", "setPointers", "([Lavail/descriptor/representation/AvailObject;)V", "[Lavail/descriptor/representation/AvailObject;", "stackp", "", "getStackp", "()I", "setStackp", "(I)V", "callMethodAfterLookup", "Lavail/optimizer/StackReifier;", "matching", "Lavail/descriptor/methods/A_Definition;", "checkReturnType", "result", "expectedReturnType", "Lavail/descriptor/types/A_Type;", "returnee", "Lavail/descriptor/functions/A_Function;", "checkReturnType$avail", "getVariable", "variable", "Lavail/descriptor/variables/A_Variable;", "getVariableClearingIfMutable", "pc", "pointerAt", "index", "pointerAtPut", "", "value", "Lavail/descriptor/representation/A_BasicObject;", "pop", "push", "reifyAndReportFailedLookup", "method", "Lavail/descriptor/methods/A_Method;", "errorCode", "Lavail/exceptions/AvailErrorCode;", "reifyCurrentFrame", "reifier", "entryPoint", "Lavail/interpreter/levelTwo/L2Chunk$ChunkEntryPoint;", "logMessage", "", "run", "setVariable", "wipeRegisters", "Companion", "avail"})
public final class L1InstructionStepper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Interpreter interpreter;
    @NotNull
    private final CompiledCodeDescriptor.L1InstructionDecoder instructionDecoder;
    private int stackp;
    @NotNull
    private AvailObject[] pointers;
    @NotNull
    private static final Statistic reificationBeforeLabelCreationStat = new Statistic(StatisticReport.REIFICATIONS, "Reification before label creation in L1");
    @NotNull
    private static final AvailObject[] emptyPointersArray = new AvailObject[0];
    private static final Pattern whitespaces = Pattern.compile("\\s+");
    @NotNull
    private static final CheckedMethod runMethod = CheckedMethod.Companion.instanceMethod(L1InstructionStepper.class, "run", StackReifier.class, new Class[0]);

    public L1InstructionStepper(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        this.interpreter = interpreter;
        this.instructionDecoder = new CompiledCodeDescriptor.L1InstructionDecoder();
        this.pointers = emptyPointersArray;
    }

    @NotNull
    public final Interpreter getInterpreter() {
        return this.interpreter;
    }

    @NotNull
    public final CompiledCodeDescriptor.L1InstructionDecoder getInstructionDecoder() {
        return this.instructionDecoder;
    }

    public final int getStackp() {
        return this.stackp;
    }

    public final void setStackp(int n) {
        this.stackp = n;
    }

    @NotNull
    public final AvailObject[] getPointers() {
        return this.pointers;
    }

    public final void setPointers(@NotNull AvailObject[] availObjectArray) {
        Intrinsics.checkNotNullParameter((Object)availObjectArray, (String)"<set-?>");
        this.pointers = availObjectArray;
    }

    public final int pc() {
        return this.instructionDecoder.pc();
    }

    @NotNull
    public final AvailObject pointerAt(int index2) {
        return this.pointers[index2];
    }

    public final void pointerAtPut(int index2, @NotNull A_BasicObject value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.pointers[index2] = (AvailObject)value;
    }

    public final void wipeRegisters() {
        this.pointers = emptyPointersArray;
    }

    private final void push(A_BasicObject value) {
        this.stackp += -1;
        this.pointerAtPut(this.stackp, value);
    }

    private final AvailObject pop() {
        AvailObject popped = this.pointerAt(this.stackp);
        int n = this.stackp;
        this.stackp = n + 1;
        this.pointerAtPut(n, NilDescriptor.Companion.getNil());
        return popped;
    }

    /*
     * WARNING - void declaration
     */
    @ReferencedInGeneratedCode
    @Nullable
    public final StackReifier run() {
        boolean bl;
        A_Function a_Function = this.interpreter.function;
        Intrinsics.checkNotNull((Object)a_Function);
        A_Function function = a_Function;
        A_RawFunction code = function.code();
        if (Interpreter.Companion.getDebugL1()) {
            Logger logger = Interpreter.Companion.getLoggerDebugL1();
            Level level = Level.FINER;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"FINER");
            Object[] objectArray = new Object[]{this.interpreter.getDebugModeString(), new Object(function){
                final /* synthetic */ A_Function $function;
                {
                    this.$function = $function;
                }

                @NotNull
                public String toString() {
                    String string2 = L1InstructionStepper.access$getWhitespaces$cp().matcher(this.$function.toString()).replaceAll(" ");
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"whitespaces.matcher(func\u2026String()).replaceAll(\" \")");
                    return string2;
                }
            }};
            Interpreter.Companion.log(logger, level, "{0}Started L1 run: {1}", objectArray);
        }
        AvailDebuggerModel debugger = this.interpreter.getDebugger();
        code.setUpInstructionDecoder(this.instructionDecoder);
        block8: while (!this.instructionDecoder.atEnd()) {
            Object value;
            Object valueOrReifier2;
            AvailObject result22;
            int n4;
            int i;
            A_Type expectedReturnType;
            int n2;
            Object object;
            void $this$mapTo$iv$iv2;
            boolean $i$f$mapTo;
            Object destination$iv$iv;
            boolean $i$f$map2;
            Object $this$map$iv;
            if (debugger != null) {
                A_Fiber f = this.interpreter.fiber();
                Function1<A_Fiber, Boolean> function1 = this.interpreter.getDebuggerRunCondition();
                Intrinsics.checkNotNull(function1);
                if (!((Boolean)function1.invoke((Object)f)).booleanValue()) {
                    AvailObject[] availObjectArray = this.pointers;
                    AvailObject mutableContinuation = ContinuationDescriptor.Companion.createContinuationWithFrame(function, NilDescriptor.Companion.getNil(), NilDescriptor.Companion.getNil(), this.pc(), this.stackp, L2Chunk.unoptimizedChunk, L2Chunk.ChunkEntryPoint.TO_RESUME.getOffsetInDefaultChunk(), CollectionsKt.listOf((Object[])Arrays.copyOf(availObjectArray, availObjectArray.length)), 1);
                    this.interpreter.setReifying(true);
                    return new StackReifier(true, AvailDebuggerModel.Companion.getReificationForDebuggerStat(), (Function0<Unit>)((Function0)new Function0<Unit>(this, f, mutableContinuation, debugger){
                        final /* synthetic */ L1InstructionStepper this$0;
                        final /* synthetic */ A_Fiber $f;
                        final /* synthetic */ AvailObject $mutableContinuation;
                        final /* synthetic */ AvailDebuggerModel $debugger;
                        {
                            this.this$0 = $receiver;
                            this.$f = $f;
                            this.$mutableContinuation = $mutableContinuation;
                            this.$debugger = $debugger;
                            super(0);
                        }

                        public final void invoke() {
                            Interpreter interpreter = this.this$0.getInterpreter();
                            A_Fiber a_Fiber = this.$f;
                            AvailObject availObject = this.$mutableContinuation;
                            L1InstructionStepper l1InstructionStepper = this.this$0;
                            AvailDebuggerModel availDebuggerModel = this.$debugger;
                            Interpreter $this$invoke_u24lambda_u2d0 = interpreter;
                            boolean bl = false;
                            $this$invoke_u24lambda_u2d0.returnNow = false;
                            A_Continuation a_Continuation = availObject;
                            AvailObject availObject2 = $this$invoke_u24lambda_u2d0.getReifiedContinuation();
                            Intrinsics.checkNotNull((Object)availObject2);
                            A_Fiber.Companion.setContinuation(a_Fiber, A_Continuation.Companion.replacingCaller(a_Continuation, availObject2));
                            l1InstructionStepper.getInterpreter().setReifiedContinuation(null);
                            $this$invoke_u24lambda_u2d0.setReifying(false);
                            $this$invoke_u24lambda_u2d0.returnNow = false;
                            $this$invoke_u24lambda_u2d0.setExitNow(true);
                            $this$invoke_u24lambda_u2d0.offset = Integer.MAX_VALUE;
                            $this$invoke_u24lambda_u2d0.setLatestResult(null);
                            $this$invoke_u24lambda_u2d0.levelOneStepper.wipeRegisters();
                            a_Fiber.lock((Function0)new Function0<Unit>(a_Fiber, $this$invoke_u24lambda_u2d0){
                                final /* synthetic */ A_Fiber $f;
                                final /* synthetic */ Interpreter $this_apply;
                                {
                                    this.$f = $f;
                                    this.$this_apply = $receiver;
                                    super(0);
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public final void invoke() {
                                    A_Fiber a_Fiber = this.$f;
                                    A_Fiber a_Fiber2 = this.$f;
                                    Interpreter interpreter = this.$this_apply;
                                    A_Fiber a_Fiber3 = a_Fiber;
                                    synchronized (a_Fiber3) {
                                        boolean bl;
                                        boolean bl2 = false;
                                        boolean bl3 = bl = A_Fiber.Companion.getExecutionState(a_Fiber2) == FiberDescriptor.ExecutionState.RUNNING;
                                        if (_Assertions.ENABLED && !bl) {
                                            String string2 = "Assertion failed";
                                            throw new AssertionError((Object)string2);
                                        }
                                        A_Fiber.Companion.setExecutionState(a_Fiber2, FiberDescriptor.ExecutionState.PAUSED);
                                        boolean bound = A_Fiber.Companion.getAndSetSynchronizationFlag(a_Fiber2, FiberDescriptor.SynchronizationFlag.BOUND, false);
                                        A_Fiber.Companion.getFiberHelper(a_Fiber2).stopCountingCPU();
                                        if (_Assertions.ENABLED && !bound) {
                                            String string3 = "Assertion failed";
                                            throw new AssertionError((Object)string3);
                                        }
                                        interpreter.fiber(null, "debug pause");
                                        Unit unit = Unit.INSTANCE;
                                    }
                                }
                            });
                            $this$invoke_u24lambda_u2d0.postExitContinuation((Function0<Unit>)((Function0)new Function0<Unit>(availDebuggerModel, a_Fiber){
                                final /* synthetic */ AvailDebuggerModel $debugger;
                                final /* synthetic */ A_Fiber $f;
                                {
                                    this.$debugger = $debugger;
                                    this.$f = $f;
                                    super(0);
                                }

                                public final void invoke() {
                                    this.$debugger.justPaused(this.$f);
                                }
                            }));
                        }
                    }));
                }
            }
            int operationOrdinal = this.instructionDecoder.getOperationOrdinal();
            if (Interpreter.Companion.getDebugL1()) {
                int savePc = this.pc();
                L1Operation operation = L1Operation.Companion.lookup(operationOrdinal);
                $this$map$iv = operation.getOperandTypes();
                $i$f$map2 = false;
                L1OperandType[] l1OperandTypeArray = $this$map$iv;
                destination$iv$iv = new ArrayList(((L1OperandType[])$this$map$iv).length);
                $i$f$mapTo = false;
                int n3 = ((void)$this$mapTo$iv$iv2).length;
                for (int j = 0; j < n3; ++j) {
                    void item$iv$iv;
                    void var16_80 = item$iv$iv = $this$mapTo$iv$iv2[j];
                    object = destination$iv$iv;
                    boolean bl2 = false;
                    object.add(this.instructionDecoder.getOperand());
                }
                List operands = (List)destination$iv$iv;
                Logger logger = Interpreter.Companion.getLoggerDebugL1();
                Level level = Level.FINER;
                Intrinsics.checkNotNullExpressionValue((Object)level, (String)"FINER");
                $this$map$iv = new Object[]{this.interpreter.getDebugModeString(), operands.isEmpty() ? operation : operation + " " + operands};
                Interpreter.Companion.log(logger, level, "{0}L1 step: {1}", (Object[])$this$map$iv);
                this.instructionDecoder.pc(savePc);
            }
            if ((n2 = operationOrdinal) == L1Operation.L1_doCall.ordinal()) {
                boolean reifier2;
                StackReifier returnCheckReifier;
                A_Bundle bundle = A_RawFunction.Companion.literalAt(code, this.instructionDecoder.getOperand());
                expectedReturnType = A_RawFunction.Companion.literalAt(code, this.instructionDecoder.getOperand());
                int numArgs = A_Method.Companion.getNumArgs(A_Bundle.Companion.getBundleMethod(bundle));
                if (Interpreter.Companion.getDebugL1()) {
                    Logger logger = Interpreter.Companion.getLoggerDebugL1();
                    Level level = Level.FINER;
                    Intrinsics.checkNotNullExpressionValue((Object)level, (String)"FINER");
                    Object[] $i$f$map2 = new Object[]{this.interpreter.getDebugModeString(), A_Atom.Companion.getAtomName(A_Bundle.Companion.getMessage(bundle))};
                    Interpreter.Companion.log(logger, level, "{0}         L1 call ({1})", $i$f$map2);
                }
                this.interpreter.argsBuffer.clear();
                i = this.stackp + numArgs - 1;
                int $this$mapTo$iv$iv2 = this.stackp;
                if ($this$mapTo$iv$iv2 <= i) {
                    while (true) {
                        this.interpreter.argsBuffer.add(this.pointerAt(i));
                        this.pointerAtPut(i, NilDescriptor.Companion.getNil());
                        if (i == $this$mapTo$iv$iv2) break;
                        --i;
                    }
                }
                this.stackp += numArgs;
                this.push(expectedReturnType);
                A_Method method = A_Bundle.Companion.getBundleMethod(bundle);
                try {
                    destination$iv$iv = A_Method.Companion.lookupByValuesFromList(method, this.interpreter.argsBuffer);
                }
                catch (MethodDefinitionException e) {
                    return this.reifyAndReportFailedLookup(method, e.getErrorCode());
                }
                Object matching = destination$iv$iv;
                destination$iv$iv = this.callMethodAfterLookup((A_Definition)matching);
                if (destination$iv$iv != null) {
                    Object reifier2 = destination$iv$iv;
                    n4 = 0;
                    return reifier2;
                }
                result22 = this.interpreter.getLatestResult();
                if (Interpreter.Companion.getDebugL1()) {
                    Logger logger = Interpreter.Companion.getLoggerDebugL1();
                    Level level = Level.FINER;
                    Intrinsics.checkNotNullExpressionValue((Object)level, (String)"FINER");
                    Object[] e = new Object[]{this.interpreter.getDebugModeString(), result22.getTypeTag().name()};
                    Interpreter.Companion.log(logger, level, "{0}Call returned: {1}", e);
                }
                if ((returnCheckReifier = this.checkReturnType$avail(result22, expectedReturnType, function)) != null) {
                    return returnCheckReifier;
                }
                boolean bl3 = reifier2 = this.stackp <= A_RawFunction.Companion.getNumSlots(code);
                if (_Assertions.ENABLED && !reifier2) {
                    String n4 = "Assertion failed";
                    throw new AssertionError((Object)n4);
                }
                this.pointerAtPut(this.stackp, result22);
                continue;
            }
            if (n2 == L1Operation.L1_doPushLiteral.ordinal()) {
                this.push(A_RawFunction.Companion.literalAt(code, this.instructionDecoder.getOperand()));
                continue;
            }
            if (n2 == L1Operation.L1_doPushLastLocal.ordinal()) {
                int localIndex = this.instructionDecoder.getOperand();
                AvailObject local2 = this.pointerAt(localIndex);
                boolean numArgs = local2.getNotNil();
                if (_Assertions.ENABLED && !numArgs) {
                    String method = "Assertion failed";
                    throw new AssertionError((Object)method);
                }
                this.pointerAtPut(localIndex, NilDescriptor.Companion.getNil());
                this.push(local2);
                continue;
            }
            if (n2 == L1Operation.L1_doPushLocal.ordinal()) {
                AvailObject local = this.pointerAt(this.instructionDecoder.getOperand());
                boolean local2 = local.getNotNil();
                if (_Assertions.ENABLED && !local2) {
                    String numArgs = "Assertion failed";
                    throw new AssertionError((Object)numArgs);
                }
                this.push(local.makeImmutable());
                continue;
            }
            if (n2 == L1Operation.L1_doPushLastOuter.ordinal()) {
                int outerIndex = this.instructionDecoder.getOperand();
                A_BasicObject outer = function.outerVarAt(outerIndex);
                boolean numArgs = outer.getNotNil();
                if (_Assertions.ENABLED && !numArgs) {
                    String method = "Assertion failed";
                    throw new AssertionError((Object)method);
                }
                if (A_Function.Companion.optionallyNilOuterVar(function, outerIndex)) {
                    this.push(outer);
                    continue;
                }
                this.push(outer.makeImmutable());
                continue;
            }
            if (n2 == L1Operation.L1_doClose.ordinal()) {
                int numCopiedVars = this.instructionDecoder.getOperand();
                AvailObject codeToClose = A_RawFunction.Companion.literalAt(code, this.instructionDecoder.getOperand());
                A_Function newFunction = FunctionDescriptor.Companion.createExceptOuters(codeToClose, numCopiedVars);
                for (i = numCopiedVars; i >= 1; --i) {
                    AvailObject value2 = this.pop();
                    boolean result22 = value2.getNotNil();
                    if (_Assertions.ENABLED && !result22) {
                        String returnCheckReifier = "Assertion failed";
                        throw new AssertionError((Object)returnCheckReifier);
                    }
                    newFunction.outerVarAtPut(i, value2);
                }
                this.push(newFunction);
                continue;
            }
            if (n2 == L1Operation.L1_doSetLocal.ordinal()) {
                StackReifier reifier = this.setVariable(this.pointerAt(this.instructionDecoder.getOperand()), this.pop());
                if (reifier == null) continue;
                return reifier;
            }
            if (n2 == L1Operation.L1_doGetLocalClearing.ordinal()) {
                A_Variable localVariable = this.pointerAt(this.instructionDecoder.getOperand());
                valueOrReifier2 = this.getVariableClearingIfMutable(localVariable);
                if (valueOrReifier2 instanceof StackReifier) {
                    return (StackReifier)valueOrReifier2;
                }
                value = (AvailObject)valueOrReifier2;
                this.push((A_BasicObject)value);
                continue;
            }
            if (n2 == L1Operation.L1_doPushOuter.ordinal()) {
                AvailObject outer = function.outerVarAt(this.instructionDecoder.getOperand());
                boolean valueOrReifier2 = outer.getNotNil();
                if (_Assertions.ENABLED && !valueOrReifier2) {
                    value = "Assertion failed";
                    throw new AssertionError(value);
                }
                this.push(outer.makeImmutable());
                continue;
            }
            if (n2 == L1Operation.L1_doPop.ordinal()) {
                this.pop();
                continue;
            }
            if (n2 == L1Operation.L1_doGetOuterClearing.ordinal()) {
                A_Variable outerVariable = function.outerVarAt(this.instructionDecoder.getOperand());
                valueOrReifier2 = this.getVariableClearingIfMutable(outerVariable);
                if (valueOrReifier2 instanceof StackReifier) {
                    return (StackReifier)valueOrReifier2;
                }
                value = (AvailObject)valueOrReifier2;
                this.push(((AvailObject)value).makeImmutable());
                continue;
            }
            if (n2 == L1Operation.L1_doSetOuter.ordinal()) {
                StackReifier reifier = this.setVariable(function.outerVarAt(this.instructionDecoder.getOperand()), this.pop());
                if (reifier == null) continue;
                return reifier;
            }
            if (n2 == L1Operation.L1_doGetLocal.ordinal()) {
                Object valueOrReifier3 = this.getVariable(this.pointerAt(this.instructionDecoder.getOperand()));
                if (valueOrReifier3 instanceof StackReifier) {
                    return (StackReifier)valueOrReifier3;
                }
                this.push((AvailObject)valueOrReifier3);
                continue;
            }
            if (n2 == L1Operation.L1_doMakeTuple.ordinal()) {
                int size = this.instructionDecoder.getOperand();
                switch (size) {
                    case 0: {
                        this.push(TupleDescriptor.Companion.getEmptyTuple());
                        Unit unit = Unit.INSTANCE;
                        break;
                    }
                    case 1: {
                        this.push(ObjectTupleDescriptor.Companion.tuple(this.pop()));
                        Unit unit = Unit.INSTANCE;
                        break;
                    }
                    default: {
                        void this_$iv;
                        valueOrReifier2 = ObjectTupleDescriptor.Companion;
                        object = this;
                        boolean $i$f$generateReversedFrom = false;
                        AbstractDescriptor this_$iv$iv = this_$iv.getMutable();
                        boolean $i$f$create = false;
                        AvailObject $this$null$iv = result22 = AvailObject.Companion.newIndexedDescriptor(size, this_$iv$iv);
                        AvailObject result$iv = result22;
                        int i$iv = size;
                        while (0 < i$iv) {
                            n4 = i$iv;
                            int n5 = i$iv--;
                            ObjectSlotsEnum objectSlotsEnum = ObjectTupleDescriptor.ObjectSlots.TUPLE_AT_;
                            AvailObject availObject = result$iv;
                            boolean bl4 = false;
                            A_BasicObject a_BasicObject = this.pop();
                            availObject.setSlot(objectSlotsEnum, n5, a_BasicObject);
                        }
                        super.push(result$iv);
                        Unit unit = Unit.INSTANCE;
                    }
                }
                continue;
            }
            if (n2 == L1Operation.L1_doGetOuter.ordinal()) {
                Object valueOrReifier4 = this.getVariable(function.outerVarAt(this.instructionDecoder.getOperand()));
                if (valueOrReifier4 instanceof StackReifier) {
                    return (StackReifier)valueOrReifier4;
                }
                this.push((AvailObject)valueOrReifier4);
                continue;
            }
            if (n2 == L1Operation.L1_doExtension.ordinal()) {
                if (!_Assertions.ENABLED) continue;
                boolean $i$a$-assert-L1InstructionStepper$run$62 = false;
                String $i$a$-assert-L1InstructionStepper$run$62 = "Illegal dispatch nybblecode";
                throw new AssertionError((Object)$i$a$-assert-L1InstructionStepper$run$62);
            }
            if (n2 == L1Operation.L1Ext_doPushLabel.ordinal()) {
                boolean $i$a$-assert-L1InstructionStepper$run$62;
                int numArgs = A_RawFunction.Companion.numArgs(code);
                boolean bl5 = $i$a$-assert-L1InstructionStepper$run$62 = code.codePrimitive() == null;
                if (_Assertions.ENABLED && !$i$a$-assert-L1InstructionStepper$run$62) {
                    String $i$f$generateReversedFrom = "Assertion failed";
                    throw new AssertionError((Object)$i$f$generateReversedFrom);
                }
                $this$map$iv = (Iterable)new IntRange(1, numArgs);
                $i$f$map2 = false;
                Object $i$f$create = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                Iterator result$iv = $this$mapTo$iv$iv2.iterator();
                while (result$iv.hasNext()) {
                    void it;
                    int item$iv$iv;
                    int bl4 = item$iv$iv = ((IntIterator)result$iv).nextInt();
                    object = destination$iv$iv;
                    boolean bl6 = false;
                    AvailObject arg = this.pointerAt((int)it);
                    boolean bl7 = arg.getNotNil();
                    if (_Assertions.ENABLED && !bl7) {
                        String string2 = "Assertion failed";
                        throw new AssertionError((Object)string2);
                    }
                    object.add(arg);
                }
                List args = (List)destination$iv$iv;
                boolean $this$map$iv2 = Intrinsics.areEqual((Object)this.interpreter.chunk, (Object)L2Chunk.unoptimizedChunk);
                if (_Assertions.ENABLED && !$this$map$iv2) {
                    String $i$f$map3 = "Assertion failed";
                    throw new AssertionError((Object)$i$f$map3);
                }
                A_Function a_Function2 = this.interpreter.function;
                Intrinsics.checkNotNull((Object)a_Function2);
                A_Function savedFunction = a_Function2;
                AvailObject[] savedPointers = this.pointers;
                int savedPc = this.pc();
                int savedStackp = this.stackp;
                this.interpreter.setReifying(true);
                return new StackReifier(true, reificationBeforeLabelCreationStat, (Function0<Unit>)((Function0)new Function0<Unit>(this, savedFunction, savedPointers, savedPc, savedStackp, (List<AvailObject>)args){
                    final /* synthetic */ L1InstructionStepper this$0;
                    final /* synthetic */ A_Function $savedFunction;
                    final /* synthetic */ AvailObject[] $savedPointers;
                    final /* synthetic */ int $savedPc;
                    final /* synthetic */ int $savedStackp;
                    final /* synthetic */ List<AvailObject> $args;
                    {
                        this.this$0 = $receiver;
                        this.$savedFunction = $savedFunction;
                        this.$savedPointers = $savedPointers;
                        this.$savedPc = $savedPc;
                        this.$savedStackp = $savedStackp;
                        this.$args = $args;
                        super(0);
                    }

                    public final void invoke() {
                        boolean bl;
                        this.this$0.getInterpreter().function = this.$savedFunction;
                        this.this$0.getInterpreter().chunk = L2Chunk.unoptimizedChunk;
                        this.this$0.getInterpreter().setOffset(L2Chunk.ChunkEntryPoint.AFTER_REIFICATION.getOffsetInDefaultChunk());
                        this.this$0.setPointers(this.$savedPointers);
                        this.$savedFunction.code().setUpInstructionDecoder(this.this$0.getInstructionDecoder());
                        this.this$0.getInstructionDecoder().pc(this.$savedPc);
                        this.this$0.setStackp(this.$savedStackp);
                        AvailObject availObject = this.this$0.getInterpreter().getReifiedContinuation();
                        Intrinsics.checkNotNull((Object)availObject);
                        A_Continuation newContinuation = ContinuationDescriptor.Companion.createLabelContinuation(this.$savedFunction, availObject, L2Chunk.unoptimizedChunk, L2Chunk.ChunkEntryPoint.TO_RESTART.getOffsetInDefaultChunk(), this.$args);
                        newContinuation.makeSubobjectsImmutable();
                        boolean bl2 = bl = A_Continuation.Companion.caller(newContinuation).isNil() || !A_Continuation.Companion.caller(newContinuation).descriptor().isMutable();
                        if (_Assertions.ENABLED && !bl) {
                            boolean bl3 = false;
                            String string2 = "Caller should freeze because two continuations can see it";
                            throw new AssertionError((Object)string2);
                        }
                        L1InstructionStepper.access$push(this.this$0, newContinuation);
                        this.this$0.getInterpreter().returnNow = false;
                        this.this$0.getInterpreter().setReifying(false);
                    }
                }));
            }
            if (n2 == L1Operation.L1Ext_doGetLiteral.ordinal()) {
                Object valueOrReifier5 = this.getVariable(A_RawFunction.Companion.literalAt(code, this.instructionDecoder.getOperand()));
                if (valueOrReifier5 instanceof StackReifier) {
                    return (StackReifier)valueOrReifier5;
                }
                this.push((AvailObject)valueOrReifier5);
                continue;
            }
            if (n2 == L1Operation.L1Ext_doSetLiteral.ordinal()) {
                this.setVariable(A_RawFunction.Companion.literalAt(code, this.instructionDecoder.getOperand()), this.pop());
                continue;
            }
            if (n2 == L1Operation.L1Ext_doDuplicate.ordinal()) {
                this.push(this.pointerAt(this.stackp).makeImmutable());
                continue;
            }
            if (n2 == L1Operation.L1Ext_doPermute.ordinal()) {
                A_Tuple permutation = A_RawFunction.Companion.literalAt(code, this.instructionDecoder.getOperand());
                int size = A_Tuple.Companion.getTupleSize(permutation);
                AvailObject[] values = new AvailObject[size];
                i = 1;
                if (i <= size) {
                    while (true) {
                        values[A_Tuple.Companion.tupleIntAt((A_Tuple)permutation, (int)i) - 1] = this.pointerAt(this.stackp + size - i);
                        if (i == size) break;
                        ++i;
                    }
                }
                if ((i = 1) > size) continue;
                while (true) {
                    AvailObject availObject = values[i - 1];
                    Intrinsics.checkNotNull((Object)availObject);
                    this.pointerAtPut(this.stackp + size - i, availObject);
                    if (i == size) continue block8;
                    ++i;
                }
            }
            if (n2 == L1Operation.L1Ext_doSuperCall.ordinal()) {
                boolean bl8;
                StackReifier returnCheckReifier;
                Object item$iv$iv;
                A_Bundle bundle = A_RawFunction.Companion.literalAt(code, this.instructionDecoder.getOperand());
                expectedReturnType = A_RawFunction.Companion.literalAt(code, this.instructionDecoder.getOperand());
                A_Type superUnionType = A_RawFunction.Companion.literalAt(code, this.instructionDecoder.getOperand());
                int numArgs = A_Method.Companion.getNumArgs(A_Bundle.Companion.getBundleMethod(bundle));
                if (Interpreter.Companion.getDebugL1()) {
                    Logger logger = Interpreter.Companion.getLoggerDebugL1();
                    Level level = Level.FINER;
                    Intrinsics.checkNotNullExpressionValue((Object)level, (String)"FINER");
                    Object[] savedPc = new Object[]{this.interpreter.getDebugModeString(), A_Atom.Companion.getAtomName(A_Bundle.Companion.getMessage(bundle))};
                    Interpreter.Companion.log(logger, level, "{0}L1 supercall: {1}", savedPc);
                }
                this.interpreter.argsBuffer.clear();
                Ref.IntRef reversedStackp = new Ref.IntRef();
                reversedStackp.element = this.stackp + numArgs;
                A_Tuple typesTuple2 = ObjectTupleDescriptor.Companion.generateObjectTupleFrom(numArgs, (Function1<? super Integer, ? extends A_BasicObject>)((Function1)new Function1<Integer, A_BasicObject>(this, reversedStackp, superUnionType){
                    final /* synthetic */ L1InstructionStepper this$0;
                    final /* synthetic */ Ref.IntRef $reversedStackp;
                    final /* synthetic */ A_Type $superUnionType;
                    {
                        this.this$0 = $receiver;
                        this.$reversedStackp = $reversedStackp;
                        this.$superUnionType = $superUnionType;
                        super(1);
                    }

                    @NotNull
                    public final A_BasicObject invoke(int index2) {
                        this.$reversedStackp.element += -1;
                        AvailObject arg = this.this$0.pointerAt(this.$reversedStackp.element);
                        this.this$0.getInterpreter().argsBuffer.add(arg);
                        return A_Type.Companion.typeUnion(AbstractEnumerationTypeDescriptor.Companion.instanceTypeOrMetaOn(arg), A_Type.Companion.typeAtIndex(this.$superUnionType, index2));
                    }
                }));
                this.stackp += numArgs;
                this.push(expectedReturnType);
                A_Method method = A_Bundle.Companion.getBundleMethod(bundle);
                try {
                    item$iv$iv = A_Method.Companion.lookupByTypesFromTuple(method, typesTuple2);
                }
                catch (MethodDefinitionException e) {
                    return this.reifyAndReportFailedLookup(method, e.getErrorCode());
                }
                A_Definition matching = item$iv$iv;
                item$iv$iv = this.callMethodAfterLookup(matching);
                if (item$iv$iv != null) {
                    Object reifier = item$iv$iv;
                    boolean bl9 = false;
                    return reifier;
                }
                AvailObject result3 = this.interpreter.getLatestResult();
                if (Interpreter.Companion.getDebugL1()) {
                    Logger logger = Interpreter.Companion.getLoggerDebugL1();
                    Level level = Level.FINER;
                    Intrinsics.checkNotNullExpressionValue((Object)level, (String)"FINER");
                    Object[] e = new Object[]{this.interpreter.getDebugModeString(), result3.getTypeTag().name()};
                    Interpreter.Companion.log(logger, level, "{0}Call returned: {1}", e);
                }
                if ((returnCheckReifier = this.checkReturnType$avail(result3, expectedReturnType, function)) != null) {
                    return returnCheckReifier;
                }
                boolean bl10 = bl8 = this.stackp <= A_RawFunction.Companion.getNumSlots(code);
                if (_Assertions.ENABLED && !bl8) {
                    String string3 = "Assertion failed";
                    throw new AssertionError((Object)string3);
                }
                this.pointerAtPut(this.stackp, result3);
                continue;
            }
            if (n2 != L1Operation.L1Ext_doSetLocalSlot.ordinal()) continue;
            this.pointerAtPut(this.instructionDecoder.getOperand(), this.pop());
        }
        this.interpreter.setLatestResult(this.pop());
        boolean bl11 = bl = this.stackp == this.pointers.length;
        if (_Assertions.ENABLED && !bl) {
            String string4 = "Assertion failed";
            throw new AssertionError((Object)string4);
        }
        this.interpreter.returnNow = true;
        this.interpreter.returningFunction = function;
        if (Interpreter.Companion.getDebugL1()) {
            Logger logger = Interpreter.Companion.getLoggerDebugL1();
            Level level = Level.FINER;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"FINER");
            Object[] objectArray = new Object[]{this.interpreter.getDebugModeString()};
            Interpreter.Companion.log(logger, level, "{0}L1 return", objectArray);
        }
        return null;
    }

    private final void reifyCurrentFrame(StackReifier reifier, L2Chunk.ChunkEntryPoint entryPoint, String logMessage) {
        A_Function a_Function = this.interpreter.function;
        Intrinsics.checkNotNull((Object)a_Function);
        A_Function function = a_Function;
        Object[] objectArray = this.pointers;
        A_Continuation continuation = ContinuationDescriptor.Companion.createContinuationWithFrame(function, NilDescriptor.Companion.getNil(), NilDescriptor.Companion.getNil(), this.pc(), this.stackp, L2Chunk.unoptimizedChunk, entryPoint.getOffsetInDefaultChunk(), CollectionsKt.listOf((Object[])Arrays.copyOf(objectArray, objectArray.length)), 1);
        if (Interpreter.Companion.getDebugL2()) {
            Logger logger = Interpreter.Companion.getLoggerDebugL2();
            Level level = Level.FINER;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"FINER");
            objectArray = new Object[]{this.interpreter.getDebugModeString(), A_RawFunction.Companion.getMethodName(A_Continuation.Companion.function(continuation).code())};
            Interpreter.Companion.log(logger, level, logMessage, objectArray);
        }
        reifier.pushAction((Function1<? super Interpreter, Unit>)((Function1)new Function1<Interpreter, Unit>(continuation){
            final /* synthetic */ A_Continuation $continuation;
            {
                this.$continuation = $continuation;
                super(1);
            }

            public final void invoke(@NotNull Interpreter theInterpreter) {
                Intrinsics.checkNotNullParameter((Object)theInterpreter, (String)"theInterpreter");
                AvailObject availObject = theInterpreter.getReifiedContinuation();
                Intrinsics.checkNotNull((Object)availObject);
                theInterpreter.setReifiedContinuation(A_Continuation.Companion.replacingCaller(this.$continuation, availObject));
            }
        }));
    }

    private final Object getVariable(A_Variable variable) {
        Object object;
        try {
            object = variable.getValue();
        }
        catch (VariableGetException e) {
            boolean bl = e.getNumericCode().equals(AvailErrorCode.E_CANNOT_READ_UNASSIGNED_VARIABLE.numericCode());
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            A_Function a_Function = this.interpreter.function;
            Intrinsics.checkNotNull((Object)a_Function);
            A_Function savedFunction = a_Function;
            AvailObject[] savedPointers = this.pointers;
            int savedOffset = this.interpreter.offset;
            int savedPc = this.pc();
            int savedStackp = this.stackp;
            A_Function implicitObserveFunction = AvailRuntime.HookType.READ_UNASSIGNED_VARIABLE.get(this.interpreter.runtime);
            this.interpreter.argsBuffer.clear();
            StackReifier stackReifier = this.interpreter.invokeFunction(implicitObserveFunction);
            Intrinsics.checkNotNull((Object)stackReifier);
            StackReifier reifier = stackReifier;
            this.pointers = savedPointers;
            this.interpreter.chunk = L2Chunk.unoptimizedChunk;
            this.interpreter.setOffset(savedOffset);
            this.interpreter.function = savedFunction;
            savedFunction.code().setUpInstructionDecoder(this.instructionDecoder);
            this.instructionDecoder.pc(savedPc);
            this.stackp = savedStackp;
            if (reifier.actuallyReify()) {
                this.reifyCurrentFrame(reifier, L2Chunk.ChunkEntryPoint.UNREACHABLE, "{0}Push reified continuation for L1 getVar failure: {1}");
            }
            object = reifier;
        }
        return object;
    }

    private final Object getVariableClearingIfMutable(A_Variable variable) {
        Object object;
        try {
            object = variable.traversed().descriptor().isMutable() ? variable.getValueClearing() : variable.getValue();
        }
        catch (VariableGetException e) {
            boolean bl = e.getNumericCode().equals(AvailErrorCode.E_CANNOT_READ_UNASSIGNED_VARIABLE.numericCode());
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            A_Function a_Function = this.interpreter.function;
            Intrinsics.checkNotNull((Object)a_Function);
            A_Function savedFunction = a_Function;
            AvailObject[] savedPointers = this.pointers;
            int savedOffset = this.interpreter.offset;
            int savedPc = this.pc();
            int savedStackp = this.stackp;
            A_Function implicitObserveFunction = AvailRuntime.HookType.READ_UNASSIGNED_VARIABLE.get(this.interpreter.runtime);
            this.interpreter.argsBuffer.clear();
            StackReifier stackReifier = this.interpreter.invokeFunction(implicitObserveFunction);
            Intrinsics.checkNotNull((Object)stackReifier);
            StackReifier reifier = stackReifier;
            this.pointers = savedPointers;
            this.interpreter.chunk = L2Chunk.unoptimizedChunk;
            this.interpreter.setOffset(savedOffset);
            this.interpreter.function = savedFunction;
            savedFunction.code().setUpInstructionDecoder(this.instructionDecoder);
            this.instructionDecoder.pc(savedPc);
            this.stackp = savedStackp;
            if (reifier.actuallyReify()) {
                this.reifyCurrentFrame(reifier, L2Chunk.ChunkEntryPoint.UNREACHABLE, "{0}Push reified continuation for L1 getVarClearing failure: {1}");
            }
            object = reifier;
        }
        return object;
    }

    private final StackReifier setVariable(A_Variable variable, AvailObject value) {
        block4: {
            try {
                variable.setValueNoCheck(value);
            }
            catch (VariableSetException e) {
                boolean bl = e.getNumericCode().equals(AvailErrorCode.E_OBSERVED_VARIABLE_WRITTEN_WHILE_UNTRACED.numericCode());
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                A_Function a_Function = this.interpreter.function;
                Intrinsics.checkNotNull((Object)a_Function);
                A_Function savedFunction = a_Function;
                AvailObject[] savedPointers = this.pointers;
                int savedOffset = this.interpreter.offset;
                int savedPc = this.pc();
                int savedStackp = this.stackp;
                A_Function implicitObserveFunction = this.interpreter.runtime.implicitObserveFunction();
                this.interpreter.argsBuffer.clear();
                this.interpreter.argsBuffer.add((AvailObject)Interpreter.Companion.assignmentFunction());
                this.interpreter.argsBuffer.add((AvailObject)ObjectTupleDescriptor.Companion.tuple(variable, value));
                StackReifier reifier = this.interpreter.invokeFunction(implicitObserveFunction);
                this.pointers = savedPointers;
                this.interpreter.chunk = L2Chunk.unoptimizedChunk;
                this.interpreter.setOffset(savedOffset);
                this.interpreter.function = savedFunction;
                savedFunction.code().setUpInstructionDecoder(this.instructionDecoder);
                this.instructionDecoder.pc(savedPc);
                this.stackp = savedStackp;
                if (reifier == null) break block4;
                if (reifier.actuallyReify()) {
                    this.reifyCurrentFrame(reifier, L2Chunk.ChunkEntryPoint.TO_RESUME, "{0}Push reified continuation for L1 setVar failure: {1}");
                }
                return reifier;
            }
        }
        return null;
    }

    private final StackReifier callMethodAfterLookup(A_Definition matching) {
        if (A_Sendable.Companion.isForwardDefinition(matching)) {
            return this.reifyAndReportFailedLookup(A_Definition.Companion.getDefinitionMethod(matching), AvailErrorCode.E_FORWARD_METHOD_DEFINITION);
        }
        if (A_Sendable.Companion.isAbstractDefinition(matching)) {
            return this.reifyAndReportFailedLookup(A_Definition.Companion.getDefinitionMethod(matching), AvailErrorCode.E_ABSTRACT_METHOD_DEFINITION);
        }
        A_Function a_Function = this.interpreter.function;
        Intrinsics.checkNotNull((Object)a_Function);
        A_Function savedFunction = a_Function;
        boolean bl = Intrinsics.areEqual((Object)this.interpreter.chunk, (Object)L2Chunk.unoptimizedChunk);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        int savedOffset = this.interpreter.offset;
        AvailObject[] savedPointers = this.pointers;
        int savedPc = this.pc();
        int savedStackp = this.stackp;
        A_Function functionToInvoke = A_Sendable.Companion.bodyBlock(matching);
        StackReifier reifier = this.interpreter.invokeFunction(functionToInvoke);
        this.pointers = savedPointers;
        this.interpreter.chunk = L2Chunk.unoptimizedChunk;
        this.interpreter.setOffset(savedOffset);
        this.interpreter.function = savedFunction;
        savedFunction.code().setUpInstructionDecoder(this.instructionDecoder);
        this.instructionDecoder.pc(savedPc);
        this.stackp = savedStackp;
        if (reifier != null) {
            if (Interpreter.Companion.getDebugL2()) {
                Logger logger = Interpreter.Companion.getLoggerDebugL2();
                Level level = Level.FINER;
                Intrinsics.checkNotNullExpressionValue((Object)level, (String)"FINER");
                Object[] objectArray = new Object[]{this.interpreter.getDebugModeString(), reifier.actuallyReify()};
                Interpreter.Companion.log(logger, level, "{0}Reifying call from L1 ({1})", objectArray);
            }
            if (reifier.actuallyReify()) {
                this.reifyCurrentFrame(reifier, L2Chunk.ChunkEntryPoint.TO_RETURN_INTO, "{0}Push reified continuation for L1 call: {1}");
            }
        }
        return reifier;
    }

    @Nullable
    public final StackReifier checkReturnType$avail(@NotNull AvailObject result2, @NotNull A_Type expectedReturnType, @NotNull A_Function returnee) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        Intrinsics.checkNotNullParameter((Object)expectedReturnType, (String)"expectedReturnType");
        Intrinsics.checkNotNullParameter((Object)returnee, (String)"returnee");
        long before = AvailRuntimeSupport.INSTANCE.captureNanos();
        boolean checkOk = result2.isInstanceOf(expectedReturnType);
        long after = AvailRuntimeSupport.INSTANCE.captureNanos();
        A_Function a_Function = this.interpreter.returningFunction;
        Intrinsics.checkNotNull((Object)a_Function);
        A_Function returner = a_Function;
        Primitive calledPrimitive = returner.code().codePrimitive();
        if (calledPrimitive != null) {
            calledPrimitive.addNanosecondsCheckingResultType(after - before, this.interpreter.getInterpreterIndex());
        } else {
            A_RawFunction.Companion.getReturnerCheckStat(returner.code()).record(after - before, this.interpreter.getInterpreterIndex());
            A_RawFunction.Companion.getReturneeCheckStat(returnee.code()).record(after - before, this.interpreter.getInterpreterIndex());
        }
        if (!checkOk) {
            A_Function a_Function2 = this.interpreter.function;
            Intrinsics.checkNotNull((Object)a_Function2);
            A_Function savedFunction = a_Function2;
            boolean bl = Intrinsics.areEqual((Object)this.interpreter.chunk, (Object)L2Chunk.unoptimizedChunk);
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            int savedOffset = this.interpreter.offset;
            AvailObject[] savedPointers = this.pointers;
            int savedPc = this.pc();
            int savedStackp = this.stackp;
            AvailObject reportedResult = VariableDescriptor.Companion.newVariableWithContentType(PrimitiveTypeDescriptor.Types.ANY.getO());
            reportedResult.setValueNoCheck(result2);
            List<AvailObject> argsBuffer = this.interpreter.argsBuffer;
            argsBuffer.clear();
            argsBuffer.add((AvailObject)returner);
            argsBuffer.add((AvailObject)expectedReturnType);
            argsBuffer.add(reportedResult);
            StackReifier stackReifier = this.interpreter.invokeFunction(this.interpreter.runtime.resultDisagreedWithExpectedTypeFunction());
            Intrinsics.checkNotNull((Object)stackReifier);
            StackReifier reifier = stackReifier;
            this.pointers = savedPointers;
            this.interpreter.chunk = L2Chunk.unoptimizedChunk;
            this.interpreter.setOffset(savedOffset);
            this.interpreter.function = savedFunction;
            savedFunction.code().setUpInstructionDecoder(this.instructionDecoder);
            this.instructionDecoder.pc(savedPc);
            this.stackp = savedStackp;
            if (reifier.actuallyReify()) {
                this.reifyCurrentFrame(reifier, L2Chunk.ChunkEntryPoint.UNREACHABLE, "{0}Push reified continuation for L1 check return type failure: {1}");
            }
            return reifier;
        }
        return null;
    }

    private final StackReifier reifyAndReportFailedLookup(A_Method method, AvailErrorCode errorCode) {
        A_Tuple arguments = ObjectTupleDescriptor.Companion.tupleFromList(this.interpreter.argsBuffer);
        A_Function a_Function = this.interpreter.function;
        Intrinsics.checkNotNull((Object)a_Function);
        A_Function savedFunction = a_Function;
        boolean bl = Intrinsics.areEqual((Object)this.interpreter.chunk, (Object)L2Chunk.unoptimizedChunk);
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        int savedOffset = this.interpreter.offset;
        AvailObject[] savedPointers = this.pointers;
        int savedPc = this.pc();
        int savedStackp = this.stackp;
        List<AvailObject> $this$reifyAndReportFailedLookup_u24lambda_u2d6 = this.interpreter.argsBuffer;
        boolean bl2 = false;
        $this$reifyAndReportFailedLookup_u24lambda_u2d6.clear();
        A_BasicObject $this$cast$iv = errorCode.numericCode();
        boolean $i$f$cast = false;
        $this$reifyAndReportFailedLookup_u24lambda_u2d6.add((AvailObject)$this$cast$iv);
        $this$cast$iv = method;
        $i$f$cast = false;
        $this$reifyAndReportFailedLookup_u24lambda_u2d6.add((AvailObject)$this$cast$iv);
        $this$cast$iv = arguments;
        $i$f$cast = false;
        $this$reifyAndReportFailedLookup_u24lambda_u2d6.add((AvailObject)$this$cast$iv);
        StackReifier stackReifier = this.interpreter.invokeFunction(this.interpreter.runtime.invalidMessageSendFunction());
        Intrinsics.checkNotNull((Object)stackReifier);
        StackReifier reifier = stackReifier;
        this.pointers = savedPointers;
        this.interpreter.chunk = L2Chunk.unoptimizedChunk;
        this.interpreter.setOffset(savedOffset);
        this.interpreter.function = savedFunction;
        savedFunction.code().setUpInstructionDecoder(this.instructionDecoder);
        this.instructionDecoder.pc(savedPc);
        this.stackp = savedStackp;
        if (reifier.actuallyReify()) {
            this.reifyCurrentFrame(reifier, L2Chunk.ChunkEntryPoint.UNREACHABLE, "{0}Push reified continuation for failed lookup handler: {1}");
        }
        return reifier;
    }

    public static final /* synthetic */ Pattern access$getWhitespaces$cp() {
        return whitespaces;
    }

    public static final /* synthetic */ void access$push(L1InstructionStepper $this, A_BasicObject value) {
        $this.push(value);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lavail/interpreter/levelTwo/L1InstructionStepper$Companion;", "", "()V", "emptyPointersArray", "", "Lavail/descriptor/representation/AvailObject;", "[Lavail/descriptor/representation/AvailObject;", "reificationBeforeLabelCreationStat", "Lavail/performance/Statistic;", "runMethod", "Lavail/optimizer/jvm/CheckedMethod;", "getRunMethod", "()Lavail/optimizer/jvm/CheckedMethod;", "whitespaces", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CheckedMethod getRunMethod() {
            return runMethod;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

