/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.levelTwo;

import avail.AvailRuntime;
import avail.AvailRuntimeSupport;
import avail.builder.ModuleName;
import avail.builder.ResolvedModuleName;
import avail.builder.UnresolvedDependencyException;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.module.A_Module;
import avail.descriptor.pojos.RawPojoDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.A_Set;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_String;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelTwo.L2Instruction;
import avail.optimizer.L1Translator;
import avail.optimizer.L2BasicBlock;
import avail.optimizer.L2ControlFlowGraph;
import avail.optimizer.jvm.JVMChunk;
import avail.optimizer.jvm.JVMTranslator;
import avail.optimizer.jvm.ReferencedInGeneratedCode;
import avail.performance.Statistic;
import avail.performance.StatisticReport;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.GuardedBy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 ;2\u00020\u0001:\u0004:;<=BW\b\u0002\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u000e\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u0006\u0010\f\u001a\u00020\rJ\u0006\u00103\u001a\u000204J\u000e\u00105\u001a\u0002012\u0006\u00106\u001a\u000207J\u0006\u00108\u001a\u000204J\u0006\u0010\b\u001a\u00020\u0005J\b\u00109\u001a\u000204H\u0016R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0019\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0!\u00a2\u0006\n\n\u0002\u0010$\u001a\u0004\b\"\u0010#R \u0010'\u001a\u00020&2\u0006\u0010%\u001a\u00020&8G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010+\u001a\u0010\u0012\f\u0012\n -*\u0004\u0018\u00010\u00000\u00000,\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/\u00a8\u0006>"}, d2={"Lavail/interpreter/levelTwo/L2Chunk;", "", "code", "Lavail/descriptor/functions/A_RawFunction;", "numObjects", "", "numIntegers", "numDoubles", "offsetAfterInitialTryPrimitive", "instructions", "", "Lavail/interpreter/levelTwo/L2Instruction;", "controlFlowGraph", "Lavail/optimizer/L2ControlFlowGraph;", "contingentValues", "Lavail/descriptor/sets/A_Set;", "executableChunk", "Lavail/optimizer/jvm/JVMChunk;", "(Lavail/descriptor/functions/A_RawFunction;IIIILjava/util/List;Lavail/optimizer/L2ControlFlowGraph;Lavail/descriptor/sets/A_Set;Lavail/optimizer/jvm/JVMChunk;)V", "chunkPojo", "Lavail/descriptor/representation/AvailObject;", "getChunkPojo", "()Lavail/descriptor/representation/AvailObject;", "getCode", "()Lavail/descriptor/functions/A_RawFunction;", "getExecutableChunk", "()Lavail/optimizer/jvm/JVMChunk;", "generation", "Lavail/interpreter/levelTwo/L2Chunk$Generation;", "getGeneration", "()Lavail/interpreter/levelTwo/L2Chunk$Generation;", "setGeneration", "(Lavail/interpreter/levelTwo/L2Chunk$Generation;)V", "", "getInstructions", "()[Lavail/interpreter/levelTwo/L2Instruction;", "[Lavail/interpreter/levelTwo/L2Instruction;", "<set-?>", "", "isValid", "()Z", "getNumIntegers", "()I", "weakReference", "Ljava/lang/ref/WeakReference;", "kotlin.jvm.PlatformType", "getWeakReference", "()Ljava/lang/ref/WeakReference;", "beforeRunChunk", "", "offset", "dumpChunk", "", "invalidate", "reason", "Lavail/interpreter/levelTwo/L2Chunk$InvalidationReason;", "name", "toString", "ChunkEntryPoint", "Companion", "Generation", "InvalidationReason", "avail"})
public final class L2Chunk {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final A_RawFunction code;
    private final int numObjects;
    private final int numIntegers;
    private final int numDoubles;
    private final int offsetAfterInitialTryPrimitive;
    @NotNull
    private final L2ControlFlowGraph controlFlowGraph;
    @NotNull
    private A_Set contingentValues;
    @NotNull
    private final JVMChunk executableChunk;
    @NotNull
    private final WeakReference<L2Chunk> weakReference;
    @Nullable
    private volatile Generation generation;
    private boolean isValid;
    @NotNull
    private final L2Instruction[] instructions;
    @NotNull
    private final AvailObject chunkPojo;
    public static final long countdownForNewCode = 10000L;
    public static final long decrementForPolledActiveCode = 1000L;
    public static final long countdownForNewlyOptimizedCode = 1000000000000000000L;
    @NotNull
    private static final ReentrantLock invalidationLock = new ReentrantLock();
    @ReferencedInGeneratedCode
    @JvmField
    @NotNull
    public static final L2Chunk unoptimizedChunk = avail.interpreter.levelTwo.L2Chunk$Companion.access$createDefaultChunk(Companion);

    private L2Chunk(A_RawFunction code, int numObjects, int numIntegers, int numDoubles, int offsetAfterInitialTryPrimitive, List<L2Instruction> instructions, L2ControlFlowGraph controlFlowGraph, A_Set contingentValues, JVMChunk executableChunk) {
        this.code = code;
        this.numObjects = numObjects;
        this.numIntegers = numIntegers;
        this.numDoubles = numDoubles;
        this.offsetAfterInitialTryPrimitive = offsetAfterInitialTryPrimitive;
        this.controlFlowGraph = controlFlowGraph;
        this.contingentValues = contingentValues;
        this.executableChunk = executableChunk;
        this.weakReference = new WeakReference<L2Chunk>(this);
        this.generation = Generation.Companion.getNewest();
        this.isValid = true;
        Collection $this$toTypedArray$iv = instructions;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        L2Instruction[] l2InstructionArray = thisCollection$iv.toArray(new L2Instruction[0]);
        if (l2InstructionArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        this.instructions = l2InstructionArray;
        this.chunkPojo = RawPojoDescriptor.Companion.identityPojo(this).makeShared();
    }

    @Nullable
    public final A_RawFunction getCode() {
        return this.code;
    }

    public final int getNumIntegers() {
        return this.numIntegers;
    }

    @NotNull
    public final JVMChunk getExecutableChunk() {
        return this.executableChunk;
    }

    private final A_Set contingentValues() {
        return this.contingentValues;
    }

    @NotNull
    public final WeakReference<L2Chunk> getWeakReference() {
        return this.weakReference;
    }

    @Nullable
    public final Generation getGeneration() {
        return this.generation;
    }

    public final void setGeneration(@Nullable Generation generation) {
        this.generation = generation;
    }

    @ReferencedInGeneratedCode
    public final boolean isValid() {
        return this.isValid;
    }

    @NotNull
    public final L2Instruction[] getInstructions() {
        return this.instructions;
    }

    @NotNull
    public final AvailObject getChunkPojo() {
        return this.chunkPojo;
    }

    @NotNull
    public final String name() {
        return L2Chunk.Companion.name(this.code);
    }

    @NotNull
    public String toString() {
        if (Intrinsics.areEqual((Object)this, (Object)unoptimizedChunk)) {
            return "Default chunk";
        }
        StringBuilder builder2 = new StringBuilder();
        if (!this.isValid) {
            builder2.append("[INVALID] ");
        }
        String string2 = "Chunk #%08x";
        Object[] objectArray = new Object[]{System.identityHashCode(this)};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
        builder2.append(string3);
        A_RawFunction a_RawFunction = this.code;
        if (a_RawFunction != null) {
            A_RawFunction it = a_RawFunction;
            boolean bl = false;
            A_String codeName = A_RawFunction.Companion.getMethodName(it);
            builder2.append(" for ");
            builder2.append(codeName);
        }
        String string4 = builder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"builder.toString()");
        return string4;
    }

    public final int offsetAfterInitialTryPrimitive() {
        return this.offsetAfterInitialTryPrimitive;
    }

    @NotNull
    public final L2ControlFlowGraph controlFlowGraph() {
        return this.controlFlowGraph;
    }

    public final void beforeRunChunk(int offset) {
        if (Interpreter.Companion.getDebugL2()) {
            Logger logger = Interpreter.Companion.getLoggerDebugL2();
            Level level = Level.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"INFO");
            Object[] objectArray = new Object[]{this.name(), offset};
            Interpreter.Companion.log(logger, level, "Running chunk {0} at offset {1}.", objectArray);
        }
    }

    public final void invalidate(@NotNull InvalidationReason reason) {
        Intrinsics.checkNotNullParameter((Object)((Object)reason), (String)"reason");
        long before = AvailRuntimeSupport.INSTANCE.captureNanos();
        boolean bl = invalidationLock.isHeldByCurrentThread();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        AvailRuntime.Companion.currentRuntime().assertInSafePoint();
        boolean bl2 = bl = this != unoptimizedChunk;
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        this.isValid = false;
        A_Set contingents = this.contingentValues.makeImmutable();
        this.contingentValues = SetDescriptor.Companion.getEmptySet();
        for (AvailObject value : contingents) {
            value.removeDependentChunk(this);
        }
        A_RawFunction a_RawFunction = this.code;
        if (a_RawFunction != null) {
            A_RawFunction.Companion.setStartingChunkAndReoptimizationCountdown(a_RawFunction, unoptimizedChunk, reason.getCountdownToNextOptimization());
        }
        Generation.Companion.removeInvalidatedChunk(this);
        long after = AvailRuntimeSupport.INSTANCE.captureNanos();
        reason.getStatistic().record(after - before, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String dumpChunk() {
        JVMTranslator translator = new JVMTranslator(this.code, this.name(), null, this.controlFlowGraph, this.instructions);
        boolean savedDebugFlag = JVMTranslator.Companion.getDebugJVM();
        JVMTranslator.Companion.setDebugJVM(true);
        try {
            translator.translate();
        }
        finally {
            JVMTranslator.Companion.setDebugJVM(savedDebugFlag);
        }
        return translator.getClassName();
    }

    public /* synthetic */ L2Chunk(A_RawFunction code, int numObjects, int numIntegers, int numDoubles, int offsetAfterInitialTryPrimitive, List instructions, L2ControlFlowGraph controlFlowGraph, A_Set contingentValues, JVMChunk executableChunk, DefaultConstructorMarker $constructor_marker) {
        this(code, numObjects, numIntegers, numDoubles, offsetAfterInitialTryPrimitive, instructions, controlFlowGraph, contingentValues, executableChunk);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0016RJ\u0010\u0003\u001a>\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0006 \u0007*\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00050\u0005 \u0007*\u001e\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0006 \u0007*\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00050\u0005\u0018\u00010\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lavail/interpreter/levelTwo/L2Chunk$Generation;", "", "()V", "chunks", "", "Ljava/lang/ref/WeakReference;", "Lavail/interpreter/levelTwo/L2Chunk;", "kotlin.jvm.PlatformType", "", "toString", "", "Companion", "avail"})
    public static final class Generation {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final Set<WeakReference<L2Chunk>> chunks = Collections.synchronizedSet(new HashSet());
        @GuardedBy(value="generationsLock")
        @NotNull
        private static final Deque<Generation> generations = new ArrayDeque();
        @NotNull
        private static final ReentrantReadWriteLock generationsLock = new ReentrantReadWriteLock();
        @NotNull
        private static volatile Generation newest = new Generation();
        private static final int maximumNewestGenerationSize = 1000;
        private static final int maximumTotalChunkCount = 10000;

        @NotNull
        public String toString() {
            return super.toString() + " (size=" + this.chunks.size() + ")";
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0013J\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0013R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lavail/interpreter/levelTwo/L2Chunk$Generation$Companion;", "", "()V", "generations", "Ljava/util/Deque;", "Lavail/interpreter/levelTwo/L2Chunk$Generation;", "generationsLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "maximumNewestGenerationSize", "", "maximumTotalChunkCount", "newest", "getNewest", "()Lavail/interpreter/levelTwo/L2Chunk$Generation;", "setNewest", "(Lavail/interpreter/levelTwo/L2Chunk$Generation;)V", "addNewChunk", "", "newChunk", "Lavail/interpreter/levelTwo/L2Chunk;", "removeInvalidatedChunk", "chunk", "usedChunk", "avail"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Generation getNewest() {
                return newest;
            }

            public final void setNewest(@NotNull Generation generation) {
                Intrinsics.checkNotNullParameter((Object)generation, (String)"<set-?>");
                newest = generation;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void addNewChunk(@NotNull L2Chunk newChunk) {
                Intrinsics.checkNotNullParameter((Object)newChunk, (String)"newChunk");
                newChunk.setGeneration(this.getNewest());
                this.getNewest().chunks.add(newChunk.getWeakReference());
                if (this.getNewest().chunks.size() > 1000) {
                    ReentrantReadWriteLock $this$safeWrite$iv = generationsLock;
                    boolean $i$f$safeWrite = false;
                    ReentrantReadWriteLock.WriteLock writeLock = $this$safeWrite$iv.writeLock();
                    Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"this.writeLock()");
                    Lock lock = writeLock;
                    lock.lock();
                    try {
                        void $this$filterTo$iv$iv;
                        boolean bl = false;
                        Generation lastGenerationToKeep = Companion.getNewest();
                        generations.addFirst(Companion.getNewest());
                        Companion.setNewest(new Generation());
                        int liveCount = 0;
                        for (Generation gen : generations) {
                            Intrinsics.checkNotNullExpressionValue((Object)gen, (String)"gen");
                            int genSize = gen.chunks.size();
                            if ((liveCount += genSize) >= 10000) break;
                            lastGenerationToKeep = gen;
                        }
                        List chunksToInvalidate = new ArrayList();
                        while (generations.getLast() != lastGenerationToKeep) {
                            Object e = generations.removeLast();
                            Intrinsics.checkNotNullExpressionValue(e, (String)"generations.removeLast()");
                            Set set2 = ((Generation)e).chunks;
                            Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"generations.removeLast().chunks");
                            chunksToInvalidate.addAll(set2);
                        }
                        Iterable $this$filter$iv = generations;
                        boolean $i$f$filter = false;
                        Iterable iterable = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList();
                        boolean $i$f$filterTo = false;
                        for (Object element$iv$iv : $this$filterTo$iv$iv) {
                            Generation it = (Generation)element$iv$iv;
                            boolean bl2 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                            Set set3 = it.chunks;
                            Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"it.chunks");
                            boolean bl3 = !((Collection)set3).isEmpty();
                            if (!bl3) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        List toKeep = (List)destination$iv$iv;
                        generations.clear();
                        generations.addAll(toKeep);
                        if (!((Collection)chunksToInvalidate).isEmpty()) {
                            AvailRuntime.Companion.currentRuntime().whenSafePointDo(90, (Function0<Unit>)((Function0)new Function0<Unit>((List<WeakReference<L2Chunk>>)chunksToInvalidate){
                                final /* synthetic */ List<WeakReference<L2Chunk>> $chunksToInvalidate;
                                {
                                    this.$chunksToInvalidate = $chunksToInvalidate;
                                    super(0);
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public final void invoke() {
                                    Lock lock = L2Chunk.Companion.getInvalidationLock();
                                    List<WeakReference<L2Chunk>> list = this.$chunksToInvalidate;
                                    lock.lock();
                                    try {
                                        boolean bl = false;
                                        Iterable $this$forEach$iv = list;
                                        boolean $i$f$forEach = false;
                                        for (T element$iv : $this$forEach$iv) {
                                            WeakReference it = (WeakReference)element$iv;
                                            boolean bl2 = false;
                                            L2Chunk l2Chunk = (L2Chunk)it.get();
                                            if (l2Chunk == null) continue;
                                            l2Chunk.invalidate(InvalidationReason.EVICTION);
                                        }
                                        Unit unit = Unit.INSTANCE;
                                    }
                                    finally {
                                        lock.unlock();
                                    }
                                }
                            }));
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        lock.unlock();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void usedChunk(@NotNull L2Chunk chunk) {
                Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
                Generation theNewest = this.getNewest();
                Generation oldGen = chunk.getGeneration();
                if (oldGen == theNewest) {
                    return;
                }
                Object object = oldGen;
                if (object != null && (object = ((Generation)object).chunks) != null) {
                    object.remove(chunk.getWeakReference());
                }
                theNewest.chunks.add(chunk.getWeakReference());
                chunk.setGeneration(theNewest);
                if (theNewest.chunks.size() > 1000) {
                    ReentrantReadWriteLock $this$safeWrite$iv = generationsLock;
                    boolean $i$f$safeWrite = false;
                    ReentrantReadWriteLock.WriteLock writeLock = $this$safeWrite$iv.writeLock();
                    Intrinsics.checkNotNullExpressionValue((Object)writeLock, (String)"this.writeLock()");
                    Lock lock = writeLock;
                    lock.lock();
                    try {
                        boolean bl = false;
                        generations.add(Companion.getNewest());
                        Companion.setNewest(new Generation());
                        if (generations.size() > 10000) {
                            void $this$filterTo$iv$iv;
                            Iterable $this$filter$iv = generations;
                            boolean $i$f$filter = false;
                            Iterable iterable = $this$filter$iv;
                            Collection destination$iv$iv = new ArrayList();
                            boolean $i$f$filterTo = false;
                            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                                Generation it = (Generation)element$iv$iv;
                                boolean bl2 = false;
                                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                                Set set2 = it.chunks;
                                Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"it.chunks");
                                boolean bl3 = !((Collection)set2).isEmpty();
                                if (!bl3) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            List nonemptyGenerations = (List)destination$iv$iv;
                            generations.clear();
                            generations.addAll(nonemptyGenerations);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    finally {
                        lock.unlock();
                    }
                }
            }

            public final void removeInvalidatedChunk(@NotNull L2Chunk chunk) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)chunk, (String)"chunk");
                    Generation generation = chunk.getGeneration();
                    if (generation == null) break block0;
                    Generation it = generation;
                    boolean bl = false;
                    it.chunks.remove(chunk.getWeakReference());
                    chunk.setGeneration(null);
                }
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lavail/interpreter/levelTwo/L2Chunk$ChunkEntryPoint;", "", "offsetInDefaultChunk", "", "(Ljava/lang/String;II)V", "getOffsetInDefaultChunk", "()I", "AFTER_TRY_PRIMITIVE", "AFTER_REIFICATION", "TO_RETURN_INTO", "TO_RESUME", "UNREACHABLE", "TO_RESTART", "TRANSIENT", "avail"})
    public static final class ChunkEntryPoint
    extends Enum<ChunkEntryPoint> {
        private final int offsetInDefaultChunk;
        public static final /* enum */ ChunkEntryPoint AFTER_TRY_PRIMITIVE = new ChunkEntryPoint(1);
        public static final /* enum */ ChunkEntryPoint AFTER_REIFICATION = new ChunkEntryPoint(3);
        public static final /* enum */ ChunkEntryPoint TO_RETURN_INTO = new ChunkEntryPoint(4);
        public static final /* enum */ ChunkEntryPoint TO_RESUME = new ChunkEntryPoint(6);
        public static final /* enum */ ChunkEntryPoint UNREACHABLE = new ChunkEntryPoint(8);
        public static final /* enum */ ChunkEntryPoint TO_RESTART = new ChunkEntryPoint(1);
        public static final /* enum */ ChunkEntryPoint TRANSIENT = new ChunkEntryPoint(-1);
        private static final /* synthetic */ ChunkEntryPoint[] $VALUES;

        private ChunkEntryPoint(int offsetInDefaultChunk) {
            this.offsetInDefaultChunk = offsetInDefaultChunk;
        }

        public final int getOffsetInDefaultChunk() {
            return this.offsetInDefaultChunk;
        }

        public static ChunkEntryPoint[] values() {
            return (ChunkEntryPoint[])$VALUES.clone();
        }

        public static ChunkEntryPoint valueOf(String value) {
            return Enum.valueOf(ChunkEntryPoint.class, value);
        }

        static {
            $VALUES = chunkEntryPointArray = new ChunkEntryPoint[]{ChunkEntryPoint.AFTER_TRY_PRIMITIVE, ChunkEntryPoint.AFTER_REIFICATION, ChunkEntryPoint.TO_RETURN_INTO, ChunkEntryPoint.TO_RESUME, ChunkEntryPoint.UNREACHABLE, ChunkEntryPoint.TO_RESTART, ChunkEntryPoint.TRANSIENT};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lavail/interpreter/levelTwo/L2Chunk$InvalidationReason;", "", "countdownToNextOptimization", "", "(Ljava/lang/String;IJ)V", "getCountdownToNextOptimization", "()J", "statistic", "Lavail/performance/Statistic;", "getStatistic", "()Lavail/performance/Statistic;", "DEPENDENCY_CHANGED", "SLOW_VARIABLE", "EVICTION", "CODE_COVERAGE", "avail"})
    public static final class InvalidationReason
    extends Enum<InvalidationReason> {
        private final long countdownToNextOptimization;
        @NotNull
        private final Statistic statistic;
        public static final /* enum */ InvalidationReason DEPENDENCY_CHANGED = new InvalidationReason(200L);
        public static final /* enum */ InvalidationReason SLOW_VARIABLE = new InvalidationReason(10000L);
        public static final /* enum */ InvalidationReason EVICTION = new InvalidationReason(20000L);
        public static final /* enum */ InvalidationReason CODE_COVERAGE = new InvalidationReason(200L);
        private static final /* synthetic */ InvalidationReason[] $VALUES;

        private InvalidationReason(long countdownToNextOptimization) {
            this.countdownToNextOptimization = countdownToNextOptimization;
            this.statistic = new Statistic(StatisticReport.L2_OPTIMIZATION_TIME, "(invalidation from " + this.name() + ")");
        }

        public final long getCountdownToNextOptimization() {
            return this.countdownToNextOptimization;
        }

        @NotNull
        public final Statistic getStatistic() {
            return this.statistic;
        }

        public static InvalidationReason[] values() {
            return (InvalidationReason[])$VALUES.clone();
        }

        public static InvalidationReason valueOf(String value) {
            return Enum.valueOf(InvalidationReason.class, value);
        }

        static {
            $VALUES = invalidationReasonArray = new InvalidationReason[]{InvalidationReason.DEPENDENCY_CHANGED, InvalidationReason.SLOW_VARIABLE, InvalidationReason.EVICTION, InvalidationReason.CODE_COVERAGE};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JN\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001c\u001a\u00020\fH\u0002J\u0012\u0010\u001d\u001a\u00020\u001e2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lavail/interpreter/levelTwo/L2Chunk$Companion;", "", "()V", "countdownForNewCode", "", "countdownForNewlyOptimizedCode", "decrementForPolledActiveCode", "invalidationLock", "Ljava/util/concurrent/locks/ReentrantLock;", "getInvalidationLock", "()Ljava/util/concurrent/locks/ReentrantLock;", "unoptimizedChunk", "Lavail/interpreter/levelTwo/L2Chunk;", "allocate", "code", "Lavail/descriptor/functions/A_RawFunction;", "numObjects", "", "numIntegers", "numFloats", "offsetAfterInitialTryPrimitive", "theInstructions", "", "Lavail/interpreter/levelTwo/L2Instruction;", "controlFlowGraph", "Lavail/optimizer/L2ControlFlowGraph;", "contingentValues", "Lavail/descriptor/sets/A_Set;", "createDefaultChunk", "name", "", "avail"})
    public static final class Companion {
        private Companion() {
        }

        private final String name(A_RawFunction code) {
            Object object = code;
            if (object == null || (object = A_RawFunction.Companion.getMethodName((A_RawFunction)object)) == null || (object = object.asNativeString()) == null) {
                object = "\u00abdefault\u00bb";
            }
            return object;
        }

        @NotNull
        public final ReentrantLock getInvalidationLock() {
            return invalidationLock;
        }

        @NotNull
        public final L2Chunk allocate(@Nullable A_RawFunction code, int numObjects, int numIntegers, int numFloats, int offsetAfterInitialTryPrimitive, @NotNull List<L2Instruction> theInstructions, @NotNull L2ControlFlowGraph controlFlowGraph, @NotNull A_Set contingentValues) {
            L2Chunk chunk;
            block8: {
                boolean bl;
                Intrinsics.checkNotNullParameter(theInstructions, (String)"theInstructions");
                Intrinsics.checkNotNullParameter((Object)controlFlowGraph, (String)"controlFlowGraph");
                Intrinsics.checkNotNullParameter((Object)contingentValues, (String)"contingentValues");
                boolean bl2 = bl = offsetAfterInitialTryPrimitive >= 0;
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                String sourceFileName = null;
                A_RawFunction a_RawFunction = code;
                if (a_RawFunction != null) {
                    A_RawFunction it = a_RawFunction;
                    boolean bl3 = false;
                    A_Module module = A_RawFunction.Companion.getModule(it);
                    if (module.getNotNil()) {
                        try {
                            ResolvedModuleName resolved = AvailRuntime.Companion.currentRuntime().getModuleNameResolver().resolve(new ModuleName(A_Module.Companion.getModuleNameNative(module), false, 2, null), null);
                            sourceFileName = resolved.getResolverReference().getUri().toString();
                        }
                        catch (UnresolvedDependencyException resolved) {
                        }
                    }
                }
                Collection $this$toTypedArray$iv = theInstructions;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                L2Instruction[] l2InstructionArray = thisCollection$iv.toArray(new L2Instruction[0]);
                if (l2InstructionArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                }
                JVMTranslator jvmTranslator = new JVMTranslator(code, this.name(code), sourceFileName, controlFlowGraph, l2InstructionArray);
                jvmTranslator.translate();
                chunk = new L2Chunk(code, numObjects, numIntegers, numFloats, offsetAfterInitialTryPrimitive, theInstructions, controlFlowGraph, contingentValues, jvmTranslator.jvmChunk(), null);
                A_RawFunction a_RawFunction2 = code;
                if (a_RawFunction2 != null) {
                    A_RawFunction.Companion.setStartingChunkAndReoptimizationCountdown(a_RawFunction2, chunk, 1000000000000000000L);
                }
                for (AvailObject value : contingentValues) {
                    value.addDependentChunk(chunk);
                }
                A_RawFunction a_RawFunction3 = code;
                if (a_RawFunction3 == null) break block8;
                A_RawFunction it = a_RawFunction3;
                boolean bl4 = false;
                Generation.Companion.addNewChunk(chunk);
            }
            return chunk;
        }

        private final L2Chunk createDefaultChunk() {
            boolean bl;
            L2ControlFlowGraph.Zone returnFromCallZone = L2ControlFlowGraph.ZoneType.PROPAGATE_REIFICATION_FOR_INVOKE.createZone("Return into L1 reified continuation from call");
            L2ControlFlowGraph.Zone resumeAfterInterruptZone = L2ControlFlowGraph.ZoneType.PROPAGATE_REIFICATION_FOR_INVOKE.createZone("Resume L1 reified continuation after interrupt");
            L2BasicBlock initialBlock = new L2BasicBlock("Default entry", false, null, 6, null);
            L2BasicBlock reenterFromRestartBlock = new L2BasicBlock("Default restart", false, null, 6, null);
            L2BasicBlock loopBlock = new L2BasicBlock("Default loop", true, null);
            L2BasicBlock reenterFromCallBlock = new L2BasicBlock("Default return from call", false, returnFromCallZone);
            L2BasicBlock reenterFromInterruptBlock = new L2BasicBlock("Default reentry from interrupt", false, resumeAfterInterruptZone);
            L2BasicBlock unreachableBlock = new L2BasicBlock("unreachable", false, null, 6, null);
            L2ControlFlowGraph controlFlowGraph = L1Translator.Companion.generateDefaultChunkControlFlowGraph(initialBlock, reenterFromRestartBlock, loopBlock, reenterFromCallBlock, reenterFromInterruptBlock, unreachableBlock);
            List instructions = new ArrayList();
            controlFlowGraph.generateOn(instructions);
            L2Chunk defaultChunk = this.allocate(null, 0, 0, 0, reenterFromRestartBlock.offset(), instructions, controlFlowGraph, SetDescriptor.Companion.getEmptySet());
            boolean bl2 = bl = initialBlock.offset() == 0;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            boolean bl3 = bl = reenterFromRestartBlock.offset() == ChunkEntryPoint.TO_RESTART.getOffsetInDefaultChunk();
            if (_Assertions.ENABLED && !bl) {
                String string3 = "Assertion failed";
                throw new AssertionError((Object)string3);
            }
            boolean bl4 = bl = loopBlock.offset() == 3;
            if (_Assertions.ENABLED && !bl) {
                String string4 = "Assertion failed";
                throw new AssertionError((Object)string4);
            }
            boolean bl5 = bl = reenterFromCallBlock.offset() == ChunkEntryPoint.TO_RETURN_INTO.getOffsetInDefaultChunk();
            if (_Assertions.ENABLED && !bl) {
                String string5 = "Assertion failed";
                throw new AssertionError((Object)string5);
            }
            boolean bl6 = bl = reenterFromInterruptBlock.offset() == ChunkEntryPoint.TO_RESUME.getOffsetInDefaultChunk();
            if (_Assertions.ENABLED && !bl) {
                String string6 = "Assertion failed";
                throw new AssertionError((Object)string6);
            }
            boolean bl7 = bl = unreachableBlock.offset() == ChunkEntryPoint.UNREACHABLE.getOffsetInDefaultChunk();
            if (_Assertions.ENABLED && !bl) {
                String string7 = "Assertion failed";
                throw new AssertionError((Object)string7);
            }
            return defaultChunk;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ L2Chunk access$createDefaultChunk(Companion $this) {
            return $this.createDefaultChunk();
        }
    }
}

