/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.levelTwo.operation;

import avail.descriptor.representation.AvailObject;
import avail.descriptor.tuples.TupleDescriptor;
import avail.interpreter.levelTwo.L2Instruction;
import avail.interpreter.levelTwo.L2NamedOperandType;
import avail.interpreter.levelTwo.L2OperandType;
import avail.interpreter.levelTwo.L2Operation;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedVectorOperand;
import avail.interpreter.levelTwo.operand.L2WriteBoxedOperand;
import avail.interpreter.levelTwo.register.L2Register;
import avail.optimizer.jvm.JVMTranslator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\n\u0010\n\u001a\u00060\u000bj\u0002`\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00040\u000eH\u0016J \u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0015"}, d2={"Lavail/interpreter/levelTwo/operation/L2_CONCATENATE_TUPLES;", "Lavail/interpreter/levelTwo/L2Operation;", "()V", "appendToWithWarnings", "", "instruction", "Lavail/interpreter/levelTwo/L2Instruction;", "desiredTypes", "", "Lavail/interpreter/levelTwo/L2OperandType;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "warningStyleChange", "Lkotlin/Function1;", "", "translateToJVM", "translator", "Lavail/optimizer/jvm/JVMTranslator;", "method", "Lorg/objectweb/asm/MethodVisitor;", "avail"})
public final class L2_CONCATENATE_TUPLES
extends L2Operation {
    @NotNull
    public static final L2_CONCATENATE_TUPLES INSTANCE = new L2_CONCATENATE_TUPLES();

    private L2_CONCATENATE_TUPLES() {
        L2NamedOperandType[] l2NamedOperandTypeArray = new L2NamedOperandType[]{L2OperandType.READ_BOXED_VECTOR.named("tuples to concatenate"), L2OperandType.WRITE_BOXED.named("concatenated tuple")};
        super(l2NamedOperandTypeArray);
    }

    @Override
    public void appendToWithWarnings(@NotNull L2Instruction instruction2, @NotNull Set<? extends L2OperandType> desiredTypes, @NotNull StringBuilder builder2, @NotNull Function1<? super Boolean, Unit> warningStyleChange) {
        Intrinsics.checkNotNullParameter((Object)instruction2, (String)"instruction");
        Intrinsics.checkNotNullParameter(desiredTypes, (String)"desiredTypes");
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter(warningStyleChange, (String)"warningStyleChange");
        boolean bl = Intrinsics.areEqual((Object)this, (Object)instruction2.getOperation());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        L2ReadBoxedVectorOperand tuples = (L2ReadBoxedVectorOperand)instruction2.operand(0);
        L2WriteBoxedOperand output = (L2WriteBoxedOperand)instruction2.operand(1);
        this.renderPreamble(instruction2, builder2);
        builder2.append(' ');
        builder2.append(output.registerString());
        builder2.append(" \u2190 ");
        int limit = tuples.elements().size();
        for (int i = 0; i < limit; ++i) {
            if (i > 0) {
                builder2.append(" ++ ");
            }
            L2ReadBoxedOperand element = (L2ReadBoxedOperand)tuples.elements().get(i);
            builder2.append(element.registerString());
        }
    }

    @Override
    public void translateToJVM(@NotNull JVMTranslator translator, @NotNull MethodVisitor method, @NotNull L2Instruction instruction2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)translator, (String)"translator");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)instruction2, (String)"instruction");
        L2ReadBoxedVectorOperand tuples = (L2ReadBoxedVectorOperand)instruction2.operand(0);
        L2WriteBoxedOperand output = (L2WriteBoxedOperand)instruction2.operand(1);
        List elements = tuples.elements();
        int tupleCount = elements.size();
        boolean bl2 = bl = tupleCount > 0;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        translator.load(method, (L2Register)((L2ReadBoxedOperand)elements.get(0)).register());
        for (int i = 1; i < tupleCount; ++i) {
            translator.load(method, (L2Register)((L2ReadBoxedOperand)elements.get(i)).register());
            translator.intConstant(method, 1);
            TupleDescriptor.Companion.getConcatenateTupleMethod().generateCall(method);
        }
        method.visitTypeInsn(192, Type.getInternalName(AvailObject.class));
        translator.store(method, (L2Register)output.register());
    }
}

