/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.levelTwo.operation;

import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.types.A_Type;
import avail.interpreter.levelTwo.L2Instruction;
import avail.interpreter.levelTwo.L2NamedOperandType;
import avail.interpreter.levelTwo.L2OperandType;
import avail.interpreter.levelTwo.L2Operation;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operand.L2WriteBoxedOperand;
import avail.interpreter.levelTwo.register.L2Register;
import avail.optimizer.L2Generator;
import avail.optimizer.L2ValueManifest;
import avail.optimizer.jvm.JVMTranslator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.MethodVisitor;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\n\u0010\n\u001a\u00060\u000bj\u0002`\f2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00040\u000eH\u0016J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006J0\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u000e\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u0006J \u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006$"}, d2={"Lavail/interpreter/levelTwo/operation/L2_MAKE_IMMUTABLE;", "Lavail/interpreter/levelTwo/L2Operation;", "()V", "appendToWithWarnings", "", "instruction", "Lavail/interpreter/levelTwo/L2Instruction;", "desiredTypes", "", "Lavail/interpreter/levelTwo/L2OperandType;", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "warningStyleChange", "Lkotlin/Function1;", "", "destinationOfImmutable", "Lavail/interpreter/levelTwo/operand/L2WriteBoxedOperand;", "extractFunctionOuter", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedOperand;", "functionRegister", "outerIndex", "", "outerType", "Lavail/descriptor/types/A_Type;", "generator", "Lavail/optimizer/L2Generator;", "instructionWasAdded", "manifest", "Lavail/optimizer/L2ValueManifest;", "sourceOfImmutable", "translateToJVM", "translator", "Lavail/optimizer/jvm/JVMTranslator;", "method", "Lorg/objectweb/asm/MethodVisitor;", "avail"})
public final class L2_MAKE_IMMUTABLE
extends L2Operation {
    @NotNull
    public static final L2_MAKE_IMMUTABLE INSTANCE = new L2_MAKE_IMMUTABLE();

    private L2_MAKE_IMMUTABLE() {
        L2NamedOperandType[] l2NamedOperandTypeArray = new L2NamedOperandType[]{L2OperandType.READ_BOXED.named("input"), L2OperandType.WRITE_BOXED.named("output")};
        super(l2NamedOperandTypeArray);
    }

    @Override
    @NotNull
    public L2ReadBoxedOperand extractFunctionOuter(@NotNull L2Instruction instruction2, @NotNull L2ReadBoxedOperand functionRegister, int outerIndex, @NotNull A_Type outerType, @NotNull L2Generator generator) {
        Intrinsics.checkNotNullParameter((Object)instruction2, (String)"instruction");
        Intrinsics.checkNotNullParameter((Object)functionRegister, (String)"functionRegister");
        Intrinsics.checkNotNullParameter((Object)outerType, (String)"outerType");
        Intrinsics.checkNotNullParameter((Object)generator, (String)"generator");
        boolean bl = Intrinsics.areEqual((Object)this, (Object)instruction2.getOperation());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        L2ReadBoxedOperand read2 = (L2ReadBoxedOperand)instruction2.operand(0);
        L2Instruction earlierInstruction = read2.definitionSkippingMoves(true);
        return earlierInstruction.getOperation().extractFunctionOuter(earlierInstruction, functionRegister, outerIndex, outerType, generator);
    }

    @Override
    public void instructionWasAdded(@NotNull L2Instruction instruction2, @NotNull L2ValueManifest manifest2) {
        Intrinsics.checkNotNullParameter((Object)instruction2, (String)"instruction");
        Intrinsics.checkNotNullParameter((Object)manifest2, (String)"manifest");
        L2ReadBoxedOperand read2 = (L2ReadBoxedOperand)instruction2.operand(0);
        L2WriteBoxedOperand write2 = (L2WriteBoxedOperand)instruction2.operand(1);
        read2.instructionWasAdded(manifest2);
        write2.instructionWasAddedForMakeImmutable(read2.semanticValue(), manifest2);
    }

    @Override
    public void appendToWithWarnings(@NotNull L2Instruction instruction2, @NotNull Set<? extends L2OperandType> desiredTypes, @NotNull StringBuilder builder2, @NotNull Function1<? super Boolean, Unit> warningStyleChange) {
        Intrinsics.checkNotNullParameter((Object)instruction2, (String)"instruction");
        Intrinsics.checkNotNullParameter(desiredTypes, (String)"desiredTypes");
        Intrinsics.checkNotNullParameter((Object)builder2, (String)"builder");
        Intrinsics.checkNotNullParameter(warningStyleChange, (String)"warningStyleChange");
        boolean bl = Intrinsics.areEqual((Object)this, (Object)instruction2.getOperation());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        L2ReadBoxedOperand read2 = (L2ReadBoxedOperand)instruction2.operand(0);
        L2WriteBoxedOperand write2 = (L2WriteBoxedOperand)instruction2.operand(1);
        this.renderPreamble(instruction2, builder2);
        builder2.append(' ');
        builder2.append(write2.registerString());
        builder2.append(" \u2190 ");
        builder2.append(read2.registerString());
    }

    @Override
    public void translateToJVM(@NotNull JVMTranslator translator, @NotNull MethodVisitor method, @NotNull L2Instruction instruction2) {
        Intrinsics.checkNotNullParameter((Object)translator, (String)"translator");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)instruction2, (String)"instruction");
        L2ReadBoxedOperand read2 = (L2ReadBoxedOperand)instruction2.operand(0);
        L2WriteBoxedOperand write2 = (L2WriteBoxedOperand)instruction2.operand(1);
        translator.load(method, (L2Register)read2.register());
        A_BasicObject.Companion.getMakeImmutableMethod().generateCall(method);
        translator.store(method, (L2Register)write2.register());
    }

    @NotNull
    public final L2ReadBoxedOperand sourceOfImmutable(@NotNull L2Instruction instruction2) {
        Intrinsics.checkNotNullParameter((Object)instruction2, (String)"instruction");
        boolean bl = instruction2.getOperation() instanceof L2_MAKE_IMMUTABLE;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-L2_MAKE_IMMUTABLE$sourceOfImmutable$22 = false;
            String $i$a$-assert-L2_MAKE_IMMUTABLE$sourceOfImmutable$22 = instruction2 + " is an  " + instruction2.getOperation();
            throw new AssertionError((Object)$i$a$-assert-L2_MAKE_IMMUTABLE$sourceOfImmutable$22);
        }
        Object $this$cast$iv = instruction2.operand(0);
        boolean $i$f$cast = false;
        return (L2ReadBoxedOperand)$this$cast$iv;
    }

    @NotNull
    public final L2WriteBoxedOperand destinationOfImmutable(@NotNull L2Instruction instruction2) {
        Intrinsics.checkNotNullParameter((Object)instruction2, (String)"instruction");
        boolean bl = instruction2.getOperation() instanceof L2_MAKE_IMMUTABLE;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        Object $this$cast$iv = instruction2.operand(1);
        boolean $i$f$cast = false;
        return (L2WriteBoxedOperand)$this$cast$iv;
    }
}

