/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.bootstrap.lexing;

import avail.compiler.AvailRejectedParseException;
import avail.compiler.problems.CompilerDiagnostics;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.parsing.LexerDescriptor;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tokens.A_Token;
import avail.descriptor.tokens.LiteralTokenDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.StringDescriptor;
import avail.descriptor.types.A_Type;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fJ\u001c\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u00060\u0013j\u0002`\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0014\u00a8\u0006\u0018"}, d2={"Lavail/interpreter/primitive/bootstrap/lexing/P_BootstrapLexerStringBody;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "parseString", "Lavail/descriptor/tokens/A_Token;", "source", "Lavail/descriptor/tuples/A_String;", "startPosition", "", "startLineNumber", "parseUnicodeEscapes", "", "scanner", "Lavail/interpreter/primitive/bootstrap/lexing/P_BootstrapLexerStringBody$Scanner;", "stringBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "Scanner", "avail"})
public final class P_BootstrapLexerStringBody
extends Primitive {
    @NotNull
    public static final P_BootstrapLexerStringBody INSTANCE = new P_BootstrapLexerStringBody();

    private P_BootstrapLexerStringBody() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CannotFail, Primitive.Flag.CanFold, Primitive.Flag.CanInline, Primitive.Flag.Bootstrap};
        super(3, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(3);
        AvailObject source = interpreter.argument(0);
        AvailObject sourcePositionInteger = interpreter.argument(1);
        AvailObject lineNumberInteger = interpreter.argument(2);
        int startPosition = A_Number.Companion.getExtractInt(sourcePositionInteger);
        int startLineNumber = A_Number.Companion.getExtractInt(lineNumberInteger);
        A_Token token = this.parseString(source, startPosition, startLineNumber);
        A_BasicObject[] a_BasicObjectArray = new A_BasicObject[]{ObjectTupleDescriptor.Companion.tuple(token)};
        return interpreter.primitiveSuccess(SetDescriptor.Companion.set(a_BasicObjectArray));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public final A_Token parseString(@NotNull A_String source, int startPosition, int startLineNumber) throws AvailRejectedParseException {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Scanner scanner = new Scanner(source, startPosition + 1, startLineNumber);
        StringBuilder builder2 = new StringBuilder(32);
        boolean canErase = true;
        int erasurePosition = 0;
        while (scanner.hasNext()) {
            char c = (char)scanner.next();
            char c2 = c;
            if (c2 == '\"') {
                A_String a_String = source.copyStringFromToCanDestroy(startPosition, scanner.getPosition() - 1, false);
                String string2 = builder2.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"builder.toString()");
                return LiteralTokenDescriptor.Companion.literalToken(a_String, startPosition, startLineNumber, StringDescriptor.Companion.stringFrom(string2));
            }
            if (c2 == '\\') {
                if (!scanner.hasNext()) {
                    throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, "more characters after backslash in string literal", new Object[0]);
                }
                c = (char)scanner.next();
                char c3 = c;
                if (c3 == 'n') {
                    builder2.append('\n');
                } else if (c3 == 'r') {
                    builder2.append('\r');
                } else if (c3 == 't') {
                    builder2.append('\t');
                } else if (c3 == '\\') {
                    builder2.append('\\');
                } else if (c3 == '\"') {
                    builder2.append('\"');
                } else if (c3 == '\r') {
                    if (scanner.hasNext() && scanner.peek() == 10) {
                        scanner.next();
                    }
                    canErase = true;
                } else if ((((c3 == '\f' ? true : c3 == '\n') ? true : c3 == '\u0085') ? true : c3 == '\u2028') ? true : c3 == '\u2029') {
                    canErase = true;
                } else if (c3 == '|') {
                    if (!canErase) throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, "only whitespace characters on line before \"\\|\" ", new Object[0]);
                    builder2.setLength(erasurePosition);
                    canErase = false;
                } else if (c3 == '(') {
                    this.parseUnicodeEscapes(scanner, builder2);
                } else {
                    if (c3 != '[') throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, "Backslash escape should be followed by one of n, r, t, \\, \", (, [, |, or a line break, not Unicode character " + c, new Object[0]);
                    throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.WEAK, "something other than \"\\[\", because power strings are not yet supported", new Object[0]);
                }
                erasurePosition = builder2.length();
                continue;
            }
            if (c2 == '\r') {
                if (scanner.hasNext() && scanner.peek() == 10) {
                    scanner.next();
                }
                builder2.appendCodePoint(10);
                canErase = true;
                erasurePosition = builder2.length();
                continue;
            }
            if (c2 == '\n') {
                builder2.appendCodePoint(c);
                canErase = true;
                erasurePosition = builder2.length();
                continue;
            }
            builder2.appendCodePoint(c);
            if (!canErase || Character.isWhitespace(c)) continue;
            canErase = false;
        }
        throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, "close-quote (\") for string literal", new Object[0]);
    }

    private final void parseUnicodeEscapes(Scanner scanner, StringBuilder stringBuilder) {
        if (!scanner.hasNext()) {
            throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, "Unicode escape sequence in string literal", new Object[0]);
        }
        int c = scanner.next();
        while (c != 41) {
            int value = 0;
            int digitCount = 0;
            while (c != 44 && c != 41) {
                int n = c;
                int n2 = 48;
                boolean bl = n <= 57 ? n2 <= n : false;
                if (bl) {
                    value = (value << 4) + c - 48;
                } else {
                    n2 = 65;
                    boolean bl2 = n <= 70 ? n2 <= n : false;
                    if (bl2) {
                        value = (value << 4) + c - 65 + 10;
                    } else {
                        n2 = 97;
                        boolean bl3 = n <= 102 ? n2 <= n : false;
                        if (bl3) {
                            value = (value << 4) + c - 97 + 10;
                        } else {
                            throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, "a hex digit or comma or closing parenthesis", new Object[0]);
                        }
                    }
                }
                if (++digitCount > 6) {
                    throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, "at most six hex digits per comma-separated Unicode entry", new Object[0]);
                }
                c = scanner.next();
            }
            if (digitCount == 0) {
                throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, "a comma-separated list of Unicode code points, each being one to six (upper case) hexadecimal digits", new Object[0]);
            }
            if (value > 0x10FFFF) {
                throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, "A valid Unicode code point, which must be <= U+10FFFF", new Object[0]);
            }
            stringBuilder.appendCodePoint(value);
            if (c != 44) continue;
            c = scanner.next();
            while (scanner.hasNext() && Character.isWhitespace(scanner.peek())) {
                scanner.next();
            }
        }
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return LexerDescriptor.Companion.lexerBodyFunctionType();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u000f\u001a\u00020\u0010H\u0086\u0002J\t\u0010\u0011\u001a\u00020\u0005H\u0086\u0002J\u0006\u0010\u0012\u001a\u00020\u0005R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\t\"\u0004\b\r\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lavail/interpreter/primitive/bootstrap/lexing/P_BootstrapLexerStringBody$Scanner;", "", "source", "Lavail/descriptor/tuples/A_String;", "position", "", "lineNumber", "(Lavail/descriptor/tuples/A_String;II)V", "getLineNumber", "()I", "setLineNumber", "(I)V", "getPosition", "setPosition", "sourceSize", "hasNext", "", "next", "peek", "avail"})
    public static final class Scanner {
        @NotNull
        private final A_String source;
        private int position;
        private int lineNumber;
        private final int sourceSize;

        public Scanner(@NotNull A_String source, int position, int lineNumber) {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            this.source = source;
            this.position = position;
            this.lineNumber = lineNumber;
            this.sourceSize = A_Tuple.Companion.getTupleSize(this.source);
        }

        public final int getPosition() {
            return this.position;
        }

        public final void setPosition(int n) {
            this.position = n;
        }

        public final int getLineNumber() {
            return this.lineNumber;
        }

        public final void setLineNumber(int n) {
            this.lineNumber = n;
        }

        public final boolean hasNext() {
            return this.position <= this.sourceSize;
        }

        public final int peek() {
            return A_Tuple.Companion.tupleCodePointAt(this.source, this.position);
        }

        public final int next() {
            int n = this.position;
            this.position = n + 1;
            int c = A_Tuple.Companion.tupleCodePointAt(this.source, n);
            if (c == 10) {
                n = this.lineNumber;
                this.lineNumber = n + 1;
            }
            return c;
        }
    }
}

