/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.bootstrap.syntax;

import avail.compiler.AvailRejectedParseException;
import avail.compiler.problems.CompilerDiagnostics;
import avail.descriptor.atoms.A_Atom;
import avail.descriptor.atoms.AtomDescriptor;
import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.maps.A_Map;
import avail.descriptor.module.A_Module;
import avail.descriptor.phrases.A_Phrase;
import avail.descriptor.phrases.AssignmentPhraseDescriptor;
import avail.descriptor.phrases.DeclarationPhraseDescriptor;
import avail.descriptor.phrases.ExpressionAsStatementPhraseDescriptor;
import avail.descriptor.phrases.VariableUsePhraseDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.tokens.A_Token;
import avail.descriptor.tokens.TokenDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.StringDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.PhraseTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.AvailLoader;
import avail.interpreter.execution.Interpreter;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lavail/interpreter/primitive/bootstrap/syntax/P_BootstrapAssignmentStatementMacro;", "Lavail/interpreter/Primitive;", "()V", "staticTokensKey", "Lavail/descriptor/atoms/A_Atom;", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "avail"})
public final class P_BootstrapAssignmentStatementMacro
extends Primitive {
    @NotNull
    public static final P_BootstrapAssignmentStatementMacro INSTANCE = new P_BootstrapAssignmentStatementMacro();
    @NotNull
    private static final A_Atom staticTokensKey = AtomDescriptor.SpecialAtom.STATIC_TOKENS_KEY.getAtom();

    private P_BootstrapAssignmentStatementMacro() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CannotFail, Primitive.Flag.CanInline, Primitive.Flag.Bootstrap};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        A_Phrase a_Phrase;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(2);
        AvailObject variableNameLiteral = interpreter.argument(0);
        AvailObject valueExpression = interpreter.argument(1);
        AvailLoader availLoader = A_Fiber.Companion.getAvailLoader(interpreter.fiber());
        if (availLoader == null) {
            return interpreter.primitiveFailure(AvailErrorCode.E_LOADING_IS_OVER);
        }
        AvailLoader loader = availLoader;
        boolean bl2 = variableNameLiteral.isInstanceOf(PhraseTypeDescriptor.PhraseKind.LITERAL_PHRASE.getMostGeneralType());
        if (_Assertions.ENABLED && !bl2) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        A_Token literalToken = A_Phrase.Companion.getToken(variableNameLiteral);
        boolean bl3 = bl = literalToken.tokenType() == TokenDescriptor.TokenType.LITERAL;
        if (_Assertions.ENABLED && !bl) {
            String string3 = "Assertion failed";
            throw new AssertionError((Object)string3);
        }
        AvailObject actualToken = literalToken.literal();
        boolean bl4 = actualToken.isInstanceOf(PrimitiveTypeDescriptor.Types.TOKEN.getO());
        if (_Assertions.ENABLED && !bl4) {
            String string4 = "Assertion failed";
            throw new AssertionError((Object)string4);
        }
        A_String variableNameString = actualToken.string();
        if (actualToken.tokenType() != TokenDescriptor.TokenType.KEYWORD) {
            throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, "variable name for assignment to be alphanumeric, not " + variableNameString, new Object[0]);
        }
        A_Map fiberGlobals = A_Fiber.Companion.getFiberGlobals(interpreter.fiber());
        AvailObject clientData = A_Map.Companion.mapAt(fiberGlobals, AtomDescriptor.SpecialAtom.CLIENT_DATA_GLOBAL_KEY.getAtom());
        AvailObject scopeMap = A_Map.Companion.mapAt(clientData, AtomDescriptor.SpecialAtom.COMPILER_SCOPE_MAP_KEY.getAtom());
        A_Module module = loader.getModule();
        AvailObject availObject = A_Map.Companion.mapAtOrNull(scopeMap, variableNameString);
        if (availObject != null) {
            a_Phrase = availObject;
        } else {
            A_Phrase a_Phrase2;
            AvailObject availObject2 = A_Map.Companion.mapAtOrNull(A_Module.Companion.getVariableBindings(module), variableNameString);
            if (availObject2 != null) {
                AvailObject it = availObject2;
                boolean bl5 = false;
                a_Phrase2 = DeclarationPhraseDescriptor.Companion.newModuleVariable(actualToken, it, NilDescriptor.Companion.getNil(), NilDescriptor.Companion.getNil());
            } else {
                a_Phrase2 = a_Phrase = null;
            }
            if (a_Phrase2 == null) {
                A_Phrase a_Phrase3;
                AvailObject availObject3 = A_Map.Companion.mapAtOrNull(A_Module.Companion.getConstantBindings(module), variableNameString);
                if (availObject3 != null) {
                    AvailObject it = availObject3;
                    boolean bl6 = false;
                    a_Phrase3 = DeclarationPhraseDescriptor.Companion.newModuleConstant(actualToken, it, NilDescriptor.Companion.getNil());
                } else {
                    a_Phrase3 = a_Phrase = null;
                }
                if (a_Phrase3 == null) {
                    throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, (Function0<? extends A_String>)((Function0)new Function0<A_String>(variableNameString){
                        final /* synthetic */ A_String $variableNameString;
                        {
                            this.$variableNameString = $variableNameString;
                            super(0);
                        }

                        @NotNull
                        public final A_String invoke() {
                            Object[] objectArray = new Object[]{this.$variableNameString};
                            return StringDescriptor.Companion.formatString("variable (%s) for assignment to be in scope", objectArray);
                        }
                    }));
                }
            }
        }
        A_Phrase declaration2 = a_Phrase;
        if (!declaration2.declarationKind().isVariable()) {
            throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, (Function0<? extends A_String>)((Function0)new Function0<A_String>(declaration2){
                final /* synthetic */ A_Phrase $declaration;
                {
                    this.$declaration = $declaration;
                    super(0);
                }

                @NotNull
                public final A_String invoke() {
                    Object[] objectArray = new Object[]{this.$declaration.declarationKind().nativeKindName()};
                    return StringDescriptor.Companion.formatString("a name of a variable, not a(n) %s", objectArray);
                }
            }));
        }
        if (!A_Type.Companion.isSubtypeOf(A_Phrase.Companion.getPhraseExpressionType(valueExpression), A_Phrase.Companion.getDeclaredType(declaration2))) {
            throw new AvailRejectedParseException(CompilerDiagnostics.ParseNotificationLevel.STRONG, (Function0<? extends A_String>)((Function0)new Function0<A_String>(valueExpression, declaration2){
                final /* synthetic */ AvailObject $valueExpression;
                final /* synthetic */ A_Phrase $declaration;
                {
                    this.$valueExpression = $valueExpression;
                    this.$declaration = $declaration;
                    super(0);
                }

                @NotNull
                public final A_String invoke() {
                    Object[] objectArray = new Object[]{A_Phrase.Companion.getPhraseExpressionType(this.$valueExpression), A_Phrase.Companion.getDeclaredType(this.$declaration)};
                    return StringDescriptor.Companion.formatString("assignment expression's type (%s) to match variable type (%s)", objectArray);
                }
            }));
        }
        AvailObject tokens = A_Map.Companion.mapAt(clientData, staticTokensKey);
        A_Phrase assignment = AssignmentPhraseDescriptor.Companion.newAssignment(VariableUsePhraseDescriptor.Companion.newUse(actualToken, declaration2), valueExpression, tokens, false);
        assignment.makeImmutable();
        A_Phrase assignmentAsStatement = ExpressionAsStatementPhraseDescriptor.Companion.newExpressionAsStatement(assignment);
        return interpreter.primitiveSuccess(assignmentAsStatement);
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(PhraseTypeDescriptor.PhraseKind.LITERAL_PHRASE.create(PrimitiveTypeDescriptor.Types.TOKEN.getO()), PhraseTypeDescriptor.PhraseKind.EXPRESSION_PHRASE.create(PrimitiveTypeDescriptor.Types.ANY.getO())), PhraseTypeDescriptor.PhraseKind.EXPRESSION_AS_STATEMENT_PHRASE.getMostGeneralType(), null, 4, null);
    }
}

