/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.files;

import avail.AvailRuntime;
import avail.descriptor.atoms.A_Atom;
import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.fiber.FiberDescriptor;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.StringDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.EnumerationTypeDescriptor;
import avail.descriptor.types.FiberTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.io.IOSystem;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lavail/interpreter/primitive/files/P_FileRename;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_FileRename
extends Primitive {
    @NotNull
    public static final P_FileRename INSTANCE = new P_FileRename();

    private P_FileRename() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline, Primitive.Flag.HasSideEffect};
        super(6, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Pair pair;
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(6);
        AvailObject source = interpreter.argument(0);
        AvailObject destination = interpreter.argument(1);
        AvailObject replaceExisting = interpreter.argument(2);
        AvailObject succeed2 = interpreter.argument(3);
        AvailObject fail2 = interpreter.argument(4);
        AvailObject priority = interpreter.argument(5);
        AvailRuntime runtime = interpreter.runtime;
        try {
            pair = new Pair((Object)IOSystem.Companion.getFileSystem().getPath(source.asNativeString(), new String[0]), (Object)IOSystem.Companion.getFileSystem().getPath(destination.asNativeString(), new String[0]));
        }
        catch (InvalidPathException e) {
            return interpreter.primitiveFailure(AvailErrorCode.E_INVALID_PATH);
        }
        Pair pair2 = pair;
        Path sourcePath = (Path)pair2.component1();
        Path destinationPath = (Path)pair2.component2();
        int priorityInt = A_Number.Companion.getExtractInt(priority);
        A_Fiber current = interpreter.fiber();
        A_Fiber newFiber2 = FiberDescriptor.Companion.newFiber$default(FiberDescriptor.Companion, A_Type.Companion.typeUnion(A_Type.Companion.getReturnType(succeed2.kind()), A_Type.Companion.getReturnType(fail2.kind())), runtime, A_Fiber.Companion.getTextInterface(current), priorityInt, null, (Function0)new Function0<A_String>(sourcePath, destinationPath){
            final /* synthetic */ Path $sourcePath;
            final /* synthetic */ Path $destinationPath;
            {
                this.$sourcePath = $sourcePath;
                this.$destinationPath = $destinationPath;
                super(0);
            }

            @NotNull
            public final A_String invoke() {
                return StringDescriptor.Companion.stringFrom("Asynchronous file rename, " + this.$sourcePath + " \u2192 " + this.$destinationPath);
            }
        }, 16, null);
        A_Fiber.Companion.setAvailLoader(newFiber2, A_Fiber.Companion.getAvailLoader(current));
        A_Fiber.Companion.setHeritableFiberGlobals(newFiber2, A_Fiber.Companion.getHeritableFiberGlobals(current).makeShared());
        newFiber2.makeShared();
        succeed2.makeShared();
        fail2.makeShared();
        boolean replace = A_Atom.Companion.getExtractBoolean(replaceExisting);
        runtime.getIoSystem().executeFileTask(() -> P_FileRename.attempt$lambda-0(replace, sourcePath, destinationPath, runtime, newFiber2, fail2, succeed2));
        return interpreter.primitiveSuccess(newFiber2);
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        A_BasicObject[] a_BasicObjectArray = new A_BasicObject[6];
        a_BasicObjectArray[0] = TupleTypeDescriptor.Companion.getStringType();
        a_BasicObjectArray[1] = TupleTypeDescriptor.Companion.getStringType();
        a_BasicObjectArray[2] = EnumerationTypeDescriptor.Companion.getBooleanType();
        a_BasicObjectArray[3] = FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, TupleDescriptor.Companion.getEmptyTuple(), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null);
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_PERMISSION_DENIED, AvailErrorCode.E_FILE_EXISTS, AvailErrorCode.E_NO_FILE, AvailErrorCode.E_IO_ERROR};
        a_BasicObjectArray[4] = FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray))), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null);
        a_BasicObjectArray[5] = IntegerRangeTypeDescriptor.Companion.getBytes();
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tupleFromArray(a_BasicObjectArray), FiberTypeDescriptor.Companion.fiberType(PrimitiveTypeDescriptor.Types.TOP.getO()), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_INVALID_PATH};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }

    private static final void attempt$lambda-0(boolean $replace, Path $sourcePath, Path $destinationPath, AvailRuntime $runtime, A_Fiber $newFiber, AvailObject $fail, AvailObject $succeed) {
        Intrinsics.checkNotNullParameter((Object)$runtime, (String)"$runtime");
        Intrinsics.checkNotNullParameter((Object)$newFiber, (String)"$newFiber");
        Intrinsics.checkNotNullParameter((Object)$fail, (String)"$fail");
        Intrinsics.checkNotNullParameter((Object)$succeed, (String)"$succeed");
        List options = new ArrayList();
        if ($replace) {
            options.add(StandardCopyOption.REPLACE_EXISTING);
        }
        try {
            Collection $this$toTypedArray$iv = options;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            CopyOption[] copyOptionArray = thisCollection$iv.toArray(new CopyOption[0]);
            if (copyOptionArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            CopyOption[] copyOptionArray2 = copyOptionArray;
            Files.move($sourcePath, $destinationPath, Arrays.copyOf(copyOptionArray2, copyOptionArray2.length));
        }
        catch (Exception e) {
            AvailErrorCode availErrorCode;
            Exception exception = e;
            if (exception instanceof SecurityException) {
                availErrorCode = AvailErrorCode.E_PERMISSION_DENIED;
            } else if (exception instanceof AccessDeniedException) {
                availErrorCode = AvailErrorCode.E_PERMISSION_DENIED;
            } else if (exception instanceof NoSuchFileException) {
                availErrorCode = AvailErrorCode.E_NO_FILE;
            } else if (exception instanceof FileAlreadyExistsException) {
                availErrorCode = AvailErrorCode.E_FILE_EXISTS;
            } else if (exception instanceof IOException) {
                availErrorCode = AvailErrorCode.E_IO_ERROR;
            } else {
                throw e;
            }
            AvailErrorCode errorCode = availErrorCode;
            $runtime.runOutermostFunction($newFiber, $fail, CollectionsKt.listOf((Object)errorCode.numericCode()));
            return;
        }
        $runtime.runOutermostFunction($newFiber, $succeed, CollectionsKt.emptyList());
    }
}

