/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.numbers;

import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.numbers.AbstractNumberDescriptor;
import avail.descriptor.numbers.InfinityDescriptor;
import avail.descriptor.numbers.IntegerDescriptor;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.A_Set;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.BottomTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.IntegerRangeTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.exceptions.ArithmeticException;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.optimizer.L1Translator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016J\b\u0010\f\u001a\u00020\u000bH\u0014J\b\u0010\r\u001a\u00020\u000bH\u0014J\u001e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0016JH\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\n2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0016\u001a\u00020\u00172\n\u0010\u0018\u001a\u00060\u0019R\u00020\u0017H\u0016\u00a8\u0006\u001a"}, d2={"Lavail/interpreter/primitive/numbers/P_Division;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "fallibilityForArgumentTypes", "Lavail/interpreter/Primitive$Fallibility;", "argumentTypes", "", "Lavail/descriptor/types/A_Type;", "privateBlockTypeRestriction", "privateFailureVariableType", "returnTypeGuaranteedByVM", "rawFunction", "Lavail/descriptor/functions/A_RawFunction;", "tryToGenerateSpecialPrimitiveInvocation", "", "functionToCallReg", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedOperand;", "arguments", "translator", "Lavail/optimizer/L1Translator;", "callSiteHelper", "Lavail/optimizer/L1Translator$CallSiteHelper;", "avail"})
public final class P_Division
extends Primitive {
    @NotNull
    public static final P_Division INSTANCE = new P_Division();

    private P_Division() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanFold, Primitive.Flag.CanInline};
        super(2, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        Primitive.Result result2;
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        interpreter.checkArgumentCount(2);
        AvailObject a = interpreter.argument(0);
        AvailObject b = interpreter.argument(1);
        if (A_Number.Companion.equalsInt(b, 0) && a.isInstanceOf(IntegerRangeTypeDescriptor.Companion.getIntegers())) {
            return interpreter.primitiveFailure(AvailErrorCode.E_CANNOT_DIVIDE_BY_ZERO);
        }
        try {
            result2 = interpreter.primitiveSuccess(A_Number.Companion.divideCanDestroy(a, b, true));
        }
        catch (ArithmeticException e) {
            result2 = interpreter.primitiveFailure(e);
        }
        return result2;
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(PrimitiveTypeDescriptor.Types.NUMBER.getO(), PrimitiveTypeDescriptor.Types.NUMBER.getO()), PrimitiveTypeDescriptor.Types.NUMBER.getO(), null, 4, null);
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_CANNOT_DIVIDE_BY_ZERO, AvailErrorCode.E_CANNOT_DIVIDE_INFINITIES};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public A_Type returnTypeGuaranteedByVM(@NotNull A_RawFunction rawFunction, @NotNull List<? extends A_Type> argumentTypes) {
        void $this$forEach$iv;
        void $this$forEach$iv2;
        Intrinsics.checkNotNullParameter((Object)rawFunction, (String)"rawFunction");
        Intrinsics.checkNotNullParameter(argumentTypes, (String)"argumentTypes");
        A_Type aType = argumentTypes.get(0);
        A_Type bType = argumentTypes.get(1);
        if (!A_Type.Companion.isSubtypeOf(aType, IntegerRangeTypeDescriptor.Companion.getIntegers()) || !A_Type.Companion.isSubtypeOf(bType, IntegerRangeTypeDescriptor.Companion.getIntegers())) {
            return AbstractNumberDescriptor.Companion.binaryNumericOperationTypeBound(argumentTypes.get(0), argumentTypes.get(1));
        }
        if (aType.isEnumeration() && bType.isEnumeration() && A_Number.Companion.getExtractInt(A_Type.Companion.getInstanceCount(aType)) * A_Number.Companion.getExtractInt(A_Type.Companion.getInstanceCount(bType)) < 100) {
            A_Set values = null;
            values = SetDescriptor.Companion.getEmptySet();
            A_Set bInstances = A_Set.Companion.setWithoutElementCanDestroy(A_Type.Companion.getInstances(bType), IntegerDescriptor.Companion.getZero(), false);
            Iterable $this$forEach$iv3 = A_Type.Companion.getInstances(aType);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv3) {
                AvailObject aValue = (AvailObject)element$iv;
                boolean bl = false;
                Iterable $this$forEach$iv4 = bInstances;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv4) {
                    AvailObject bValue = (AvailObject)element$iv2;
                    boolean bl2 = false;
                    if (!aValue.isFinite() && !bValue.isFinite()) continue;
                    values = A_Set.Companion.setWithElementCanDestroy(values, A_Number.Companion.divideCanDestroy(aValue, bValue, false), true);
                }
            }
            return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(values).makeImmutable();
        }
        Set aBoundaries = new LinkedHashSet();
        Object bInstances = new A_Type[]{IntegerRangeTypeDescriptor.Companion.getNaturalNumbers(), IntegerRangeTypeDescriptor.Companion.singleInt(0), IntegerRangeTypeDescriptor.Companion.inclusive(InfinityDescriptor.Companion.getNegativeInfinity(), IntegerDescriptor.Companion.negativeOne())};
        bInstances = CollectionsKt.listOf((Object[])bInstances);
        boolean $i$f$forEach22 = false;
        for (Object element$iv : $this$forEach$iv2) {
            A_Type range = (A_Type)element$iv;
            boolean bl = false;
            A_Type clipped = A_Type.Companion.typeIntersection(aType, range);
            if (clipped.isBottom()) continue;
            aBoundaries.add(A_Type.Companion.getLowerBound(clipped));
            aBoundaries.add(A_Type.Companion.getUpperBound(clipped));
        }
        Set bBoundaries = new LinkedHashSet();
        Object $i$f$forEach22 = new A_Type[]{IntegerRangeTypeDescriptor.Companion.getNaturalNumbers(), IntegerRangeTypeDescriptor.Companion.inclusive(InfinityDescriptor.Companion.getNegativeInfinity(), IntegerDescriptor.Companion.negativeOne())};
        $i$f$forEach22 = CollectionsKt.listOf((Object[])$i$f$forEach22);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            A_Type range = (A_Type)element$iv;
            boolean bl = false;
            A_Type clipped = A_Type.Companion.typeIntersection(bType, range);
            if (clipped.isBottom()) continue;
            bBoundaries.add(A_Type.Companion.getLowerBound(clipped));
            bBoundaries.add(A_Type.Companion.getUpperBound(clipped));
        }
        Set quotients = new LinkedHashSet();
        Iterable $this$forEach$iv5 = aBoundaries;
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv5) {
            A_Number aValue = (A_Number)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv6 = bBoundaries;
            boolean $i$f$forEach4 = false;
            for (Object element$iv3 : $this$forEach$iv6) {
                A_Number bValue = (A_Number)element$iv3;
                boolean bl3 = false;
                if (!aValue.isFinite() && !bValue.isFinite()) continue;
                quotients.add(A_Number.Companion.divideCanDestroy(aValue, bValue, false));
            }
        }
        if (quotients.isEmpty()) {
            return BottomTypeDescriptor.Companion.getBottom();
        }
        A_Number min = (A_Number)CollectionsKt.minWithOrNull((Iterable)quotients, P_Division::returnTypeGuaranteedByVM$lambda-6);
        A_Number max = (A_Number)CollectionsKt.maxWithOrNull((Iterable)quotients, P_Division::returnTypeGuaranteedByVM$lambda-7);
        A_Number a_Number = min;
        Intrinsics.checkNotNull((Object)a_Number);
        A_Number a_Number2 = max;
        Intrinsics.checkNotNull((Object)a_Number2);
        return A_Type.Companion.typeIntersection(IntegerRangeTypeDescriptor.Companion.inclusive(a_Number, a_Number2), IntegerRangeTypeDescriptor.Companion.getIntegers()).makeImmutable();
    }

    @Override
    @NotNull
    public Primitive.Fallibility fallibilityForArgumentTypes(@NotNull List<? extends A_Type> argumentTypes) {
        Intrinsics.checkNotNullParameter(argumentTypes, (String)"argumentTypes");
        A_Type aType = argumentTypes.get(0);
        A_Type bType = argumentTypes.get(1);
        boolean bTypeIncludesZero = IntegerDescriptor.Companion.getZero().isInstanceOf(bType);
        if (bTypeIncludesZero) {
            A_Type $this$fallibilityForArgumentTypes_u24lambda_u2d8 = A_Type.Companion.typeIntersection(bType, IntegerRangeTypeDescriptor.Companion.getIntegers());
            boolean bl = false;
            return A_Number.Companion.equalsInt(A_Type.Companion.getLowerBound($this$fallibilityForArgumentTypes_u24lambda_u2d8), 0) && A_Number.Companion.equalsInt(A_Type.Companion.getUpperBound($this$fallibilityForArgumentTypes_u24lambda_u2d8), 0) ? Primitive.Fallibility.CallSiteMustFail : Primitive.Fallibility.CallSiteCanFail;
        }
        boolean aTypeIncludesInfinity = InfinityDescriptor.Companion.getNegativeInfinity().isInstanceOf(aType) || InfinityDescriptor.Companion.getPositiveInfinity().isInstanceOf(aType);
        boolean bTypeIncludesInfinity = InfinityDescriptor.Companion.getNegativeInfinity().isInstanceOf(bType) || InfinityDescriptor.Companion.getPositiveInfinity().isInstanceOf(bType);
        return aTypeIncludesInfinity && bTypeIncludesInfinity ? Primitive.Fallibility.CallSiteCanFail : Primitive.Fallibility.CallSiteCannotFail;
    }

    @Override
    public boolean tryToGenerateSpecialPrimitiveInvocation(@NotNull L2ReadBoxedOperand functionToCallReg, @NotNull A_RawFunction rawFunction, @NotNull List<L2ReadBoxedOperand> arguments, @NotNull List<? extends A_Type> argumentTypes, @NotNull L1Translator translator, @NotNull L1Translator.CallSiteHelper callSiteHelper) {
        Intrinsics.checkNotNullParameter((Object)functionToCallReg, (String)"functionToCallReg");
        Intrinsics.checkNotNullParameter((Object)rawFunction, (String)"rawFunction");
        Intrinsics.checkNotNullParameter(arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter(argumentTypes, (String)"argumentTypes");
        Intrinsics.checkNotNullParameter((Object)translator, (String)"translator");
        Intrinsics.checkNotNullParameter((Object)callSiteHelper, (String)"callSiteHelper");
        translator.generateGeneralFunctionInvocation(functionToCallReg, arguments, false, callSiteHelper);
        return true;
    }

    private static final int returnTypeGuaranteedByVM$lambda-6(A_Number a, A_Number b) {
        Intrinsics.checkNotNullExpressionValue((Object)a, (String)"a");
        Intrinsics.checkNotNullExpressionValue((Object)b, (String)"b");
        return A_Number.Companion.lessThan(a, b) ? -1 : 1;
    }

    private static final int returnTypeGuaranteedByVM$lambda-7(A_Number a, A_Number b) {
        Intrinsics.checkNotNullExpressionValue((Object)a, (String)"a");
        Intrinsics.checkNotNullExpressionValue((Object)b, (String)"b");
        return A_Number.Companion.lessThan(a, b) ? -1 : 1;
    }
}

