/*
 * Decompiled with CFR 0.152.
 */
package avail.optimizer;

import avail.AvailRuntimeSupport;
import avail.descriptor.functions.A_Continuation;
import avail.descriptor.representation.AvailObject;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelTwo.L2Chunk;
import avail.optimizer.jvm.CheckedMethod;
import avail.optimizer.jvm.ReferencedInGeneratedCode;
import avail.performance.Statistic;
import java.util.ArrayDeque;
import java.util.Deque;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000  2\u00020\u0001:\u0001 B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u0002\u001a\u00020\u0003J\u001a\u0010\u0016\u001a\u00020\b2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\b0\fJ\u0010\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u000e\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\rR \u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\b0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006!"}, d2={"Lavail/optimizer/StackReifier;", "", "actuallyReify", "", "reificationStatistic", "Lavail/performance/Statistic;", "postReificationAction", "Lkotlin/Function0;", "", "(ZLavail/performance/Statistic;Lkotlin/jvm/functions/Function0;)V", "actionStack", "Ljava/util/Deque;", "Lkotlin/Function1;", "Lavail/interpreter/execution/Interpreter;", "getPostReificationAction", "()Lkotlin/jvm/functions/Function0;", "getReificationStatistic", "()Lavail/performance/Statistic;", "startNanos", "", "getStartNanos", "()J", "pushAction", "action", "pushContinuationAction", "dummyContinuation", "Lavail/descriptor/representation/AvailObject;", "recordCompletedReification", "interpreterIndex", "", "runActions", "interpreter", "Companion", "avail"})
public final class StackReifier {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean actuallyReify;
    @NotNull
    private final Statistic reificationStatistic;
    @NotNull
    private final Function0<Unit> postReificationAction;
    @NotNull
    private final Deque<Function1<Interpreter, Unit>> actionStack;
    private final long startNanos;
    @NotNull
    private static final CheckedMethod pushContinuationActionMethod;

    public StackReifier(boolean actuallyReify, @NotNull Statistic reificationStatistic, @NotNull Function0<Unit> postReificationAction) {
        Intrinsics.checkNotNullParameter((Object)reificationStatistic, (String)"reificationStatistic");
        Intrinsics.checkNotNullParameter(postReificationAction, (String)"postReificationAction");
        this.actuallyReify = actuallyReify;
        this.reificationStatistic = reificationStatistic;
        this.postReificationAction = postReificationAction;
        this.actionStack = new ArrayDeque();
        this.startNanos = AvailRuntimeSupport.INSTANCE.captureNanos();
    }

    @NotNull
    public final Statistic getReificationStatistic() {
        return this.reificationStatistic;
    }

    @NotNull
    public final Function0<Unit> getPostReificationAction() {
        return this.postReificationAction;
    }

    public final long getStartNanos() {
        return this.startNanos;
    }

    public final boolean actuallyReify() {
        return this.actuallyReify;
    }

    public final void runActions(@NotNull Interpreter interpreter) {
        Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
        while (!this.actionStack.isEmpty()) {
            this.actionStack.removeLast().invoke((Object)interpreter);
        }
    }

    public final void pushAction(@NotNull Function1<? super Interpreter, Unit> action2) {
        Intrinsics.checkNotNullParameter(action2, (String)"action");
        this.actionStack.addLast(action2);
    }

    @ReferencedInGeneratedCode
    @NotNull
    public final StackReifier pushContinuationAction(@NotNull AvailObject dummyContinuation) {
        Intrinsics.checkNotNullParameter((Object)dummyContinuation, (String)"dummyContinuation");
        boolean bl = A_Continuation.Companion.caller(dummyContinuation).isNil();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.actionStack.addLast(new Function1<Interpreter, Unit>(dummyContinuation){
            final /* synthetic */ AvailObject $dummyContinuation;
            {
                this.$dummyContinuation = $dummyContinuation;
                super(1);
            }

            public final void invoke(@NotNull Interpreter interpreter) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)interpreter, (String)"interpreter");
                if (Interpreter.Companion.getDebugL2()) {
                    Interpreter.Companion.traceL2(A_Continuation.Companion.levelTwoChunk(this.$dummyContinuation).getExecutableChunk(), A_Continuation.Companion.levelTwoOffset(this.$dummyContinuation), "Starting a reifier action", "");
                }
                A_Continuation a_Continuation = this.$dummyContinuation;
                AvailObject availObject = interpreter.getReifiedContinuation();
                Intrinsics.checkNotNull((Object)availObject);
                A_Continuation newDummy = A_Continuation.Companion.replacingCaller(a_Continuation, availObject);
                interpreter.setReifiedContinuation(newDummy);
                interpreter.function = A_Continuation.Companion.function(newDummy);
                interpreter.chunk = A_Continuation.Companion.levelTwoChunk(newDummy);
                interpreter.setOffset(A_Continuation.Companion.levelTwoOffset(newDummy));
                L2Chunk l2Chunk = interpreter.chunk;
                Intrinsics.checkNotNull((Object)l2Chunk);
                l2Chunk.beforeRunChunk(interpreter.offset);
                L2Chunk l2Chunk2 = interpreter.chunk;
                Intrinsics.checkNotNull((Object)l2Chunk2);
                StackReifier result2 = l2Chunk2.getExecutableChunk().runChunk(interpreter, interpreter.offset);
                boolean bl2 = bl = result2 == null;
                if (_Assertions.ENABLED && !bl) {
                    boolean bl3 = false;
                    String string2 = "Must not reify in dummy continuation!";
                    throw new AssertionError((Object)string2);
                }
                if (Interpreter.Companion.getDebugL2()) {
                    Interpreter.Companion.traceL2(A_Continuation.Companion.levelTwoChunk(this.$dummyContinuation).getExecutableChunk(), A_Continuation.Companion.levelTwoOffset(this.$dummyContinuation), "Finished a reifier action (offset is for instruction that queued it)", "");
                }
            }
        });
        return this;
    }

    public final void recordCompletedReification(int interpreterIndex) {
        long endNanos = AvailRuntimeSupport.INSTANCE.captureNanos();
        this.reificationStatistic.record(endNanos - this.startNanos, interpreterIndex);
    }

    static {
        Class[] classArray = new Class[]{AvailObject.class};
        pushContinuationActionMethod = CheckedMethod.Companion.instanceMethod(StackReifier.class, "pushContinuationAction", StackReifier.class, classArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lavail/optimizer/StackReifier$Companion;", "", "()V", "pushContinuationActionMethod", "Lavail/optimizer/jvm/CheckedMethod;", "getPushContinuationActionMethod", "()Lavail/optimizer/jvm/CheckedMethod;", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CheckedMethod getPushContinuationActionMethod() {
            return pushContinuationActionMethod;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

