/*
 * Decompiled with CFR 0.152.
 */
package avail.optimizer.jvm;

import avail.AvailRuntimeSupport;
import avail.AvailThread;
import avail.descriptor.atoms.A_Atom;
import avail.descriptor.bundles.A_Bundle;
import avail.descriptor.functions.A_RawFunction;
import avail.descriptor.functions.ContinuationDescriptor;
import avail.descriptor.module.A_Module;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.types.CompiledCodeTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.interpreter.JavaLibrary;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import avail.interpreter.levelOne.L1Disassembler;
import avail.interpreter.levelTwo.L2Instruction;
import avail.interpreter.levelTwo.L2OperandDispatcher;
import avail.interpreter.levelTwo.operand.L2ArbitraryConstantOperand;
import avail.interpreter.levelTwo.operand.L2CommentOperand;
import avail.interpreter.levelTwo.operand.L2ConstantOperand;
import avail.interpreter.levelTwo.operand.L2FloatImmediateOperand;
import avail.interpreter.levelTwo.operand.L2IntImmediateOperand;
import avail.interpreter.levelTwo.operand.L2Operand;
import avail.interpreter.levelTwo.operand.L2PcOperand;
import avail.interpreter.levelTwo.operand.L2PcVectorOperand;
import avail.interpreter.levelTwo.operand.L2PrimitiveOperand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedOperand;
import avail.interpreter.levelTwo.operand.L2ReadBoxedVectorOperand;
import avail.interpreter.levelTwo.operand.L2ReadFloatOperand;
import avail.interpreter.levelTwo.operand.L2ReadFloatVectorOperand;
import avail.interpreter.levelTwo.operand.L2ReadIntOperand;
import avail.interpreter.levelTwo.operand.L2ReadIntVectorOperand;
import avail.interpreter.levelTwo.operand.L2SelectorOperand;
import avail.interpreter.levelTwo.operand.L2WriteBoxedOperand;
import avail.interpreter.levelTwo.operand.L2WriteFloatOperand;
import avail.interpreter.levelTwo.operand.L2WriteIntOperand;
import avail.interpreter.levelTwo.register.L2BoxedRegister;
import avail.interpreter.levelTwo.register.L2FloatRegister;
import avail.interpreter.levelTwo.register.L2IntRegister;
import avail.interpreter.levelTwo.register.L2Register;
import avail.optimizer.L2ControlFlowGraph;
import avail.optimizer.L2ControlFlowGraphVisualizer;
import avail.optimizer.StackReifier;
import avail.optimizer.jvm.CheckedMethod;
import avail.optimizer.jvm.JVMChunk;
import avail.optimizer.jvm.JVMChunkClassLoader;
import avail.optimizer.jvm.JVMChunkL1Source;
import avail.optimizer.jvm.JVMChunkL2Source;
import avail.performance.Statistic;
import avail.performance.StatisticReport;
import avail.utility.Strings;
import avail.utility.structures.EnumMap;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.LongAdder;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.util.CheckClassAdapter;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00dc\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 \u0084\u00012\u00020\u0001:\b\u0084\u0001\u0085\u0001\u0086\u0001\u0087\u0001B7\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ>\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u000b2\u0006\u0010<\u001a\u00020\u001c2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020>2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020AJ\u0006\u0010C\u001a\u000208J\u0006\u0010D\u001a\u000208J\u0016\u0010E\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010F\u001a\u00020GJ\b\u0010H\u001a\u000208H\u0002J\u0012\u0010I\u001a\u0004\u0018\u00010\u00052\u0006\u0010J\u001a\u00020KH\u0002J\u0012\u0010L\u001a\u0004\u0018\u00010\u00052\u0006\u0010J\u001a\u00020KH\u0002J\u0012\u0010M\u001a\u0004\u0018\u00010\u00052\u0006\u0010N\u001a\u00020OH\u0002J\u0016\u0010P\u001a\u0002082\u0006\u0010Q\u001a\u00020\u001c2\u0006\u0010R\u001a\u00020SJ\u0010\u0010T\u001a\u0002082\u0006\u00109\u001a\u00020:H\u0002J\u0016\u0010U\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010F\u001a\u00020VJ0\u0010W\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010X\u001a\u00020\u001c2\u0006\u0010Y\u001a\u00020A2\u0006\u0010Z\u001a\u00020A2\u0006\u0010[\u001a\u00020>H\u0002J\u0006\u0010\\\u001a\u000208J\u0006\u0010]\u001a\u000208J\u0016\u0010^\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010_\u001a\u00020>J\u0006\u0010`\u001a\u000208J\u0006\u0010a\u001a\u000208J\u0016\u0010b\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010F\u001a\u00020\u001cJ\u001e\u0010c\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\u000b2\u0006\u0010d\u001a\u00020>J\u0016\u0010c\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010d\u001a\u00020>J\u001e\u0010e\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010X\u001a\u00020\u001c2\u0006\u0010f\u001a\u00020>J\u0006\u0010$\u001a\u00020%J\u000e\u0010g\u001a\u00020\u001d2\u0006\u0010h\u001a\u00020\u001cJ\u0010\u0010i\u001a\u00020\u001d2\u0006\u00109\u001a\u00020:H\u0002J\u0016\u0010j\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010k\u001a\u00020\u0001J\u001a\u0010j\u001a\u0002082\b\u00109\u001a\u0004\u0018\u00010:2\u0006\u0010d\u001a\u00020lH\u0007J\u001c\u0010j\u001a\u0002082\b\u00109\u001a\u0004\u0018\u00010:2\b\u0010m\u001a\u0004\u0018\u00010nH\u0007J\u0016\u0010o\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010p\u001a\u00020nJ\u0006\u0010q\u001a\u000208J\u000e\u0010r\u001a\u0002082\u0006\u00109\u001a\u00020:J\u000e\u0010s\u001a\u0002082\u0006\u00109\u001a\u00020:J\u000e\u0010t\u001a\u00020\u001c2\u0006\u0010p\u001a\u00020nJ\u0016\u0010u\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010F\u001a\u00020vJ\u000e\u00106\u001a\u00020\u001c2\u0006\u0010R\u001a\u00020SJ,\u0010w\u001a\u0002082\u0006\u00109\u001a\u00020:2\f\u0010x\u001a\b\u0012\u0004\u0012\u00020z0y2\u000e\u0010{\u001a\n\u0012\u0006\b\u0001\u0012\u00020}0|J\u0006\u0010~\u001a\u00020\u001cJ\u0006\u0010\u007f\u001a\u000208J\u0007\u0010\u0080\u0001\u001a\u00020\u001cJ\u000f\u0010\u0081\u0001\u001a\u00020\u001c2\u0006\u0010<\u001a\u00020\u001cJ\u0017\u0010\u0082\u0001\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010p\u001a\u00020nJ\u0007\u0010\u0083\u0001\u001a\u000208R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\n\n\u0002\u0010 \u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010!\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u001d\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020*0\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010(R/\u0010,\u001a \u0012\u0004\u0012\u00020\u000b\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020.\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0/0-0\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u0010(R)\u00101\u001a\u001a\u0012\u0004\u0012\u00020.\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001c0\u001b0-\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0011\u00104\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010#R\u000e\u00106\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0088\u0001"}, d2={"Lavail/optimizer/jvm/JVMTranslator;", "", "code", "Lavail/descriptor/functions/A_RawFunction;", "chunkName", "", "sourceFileName", "controlFlowGraph", "Lavail/optimizer/L2ControlFlowGraph;", "instructions", "", "Lavail/interpreter/levelTwo/L2Instruction;", "(Lavail/descriptor/functions/A_RawFunction;Ljava/lang/String;Ljava/lang/String;Lavail/optimizer/L2ControlFlowGraph;[Lavail/interpreter/levelTwo/L2Instruction;)V", "classBytes", "", "classInternalName", "getClassInternalName", "()Ljava/lang/String;", "className", "getClassName", "classNode", "Lorg/objectweb/asm/tree/ClassNode;", "getClassNode", "()Lorg/objectweb/asm/tree/ClassNode;", "getCode", "()Lavail/descriptor/functions/A_RawFunction;", "entryPoints", "", "", "Lorg/objectweb/asm/Label;", "getInstructions", "()[Lavail/interpreter/levelTwo/L2Instruction;", "[Lavail/interpreter/levelTwo/L2Instruction;", "jumper", "getJumper", "()Lorg/objectweb/asm/Label;", "jvmChunk", "Lavail/optimizer/jvm/JVMChunk;", "labels", "getLabels", "()Ljava/util/Map;", "literals", "Lavail/optimizer/jvm/JVMTranslator$LiteralAccessor;", "getLiterals", "liveLocalNumbersByKindPerEntryPoint", "Lavail/utility/structures/EnumMap;", "Lavail/interpreter/levelTwo/register/L2Register$RegisterKind;", "", "getLiveLocalNumbersByKindPerEntryPoint", "locals", "getLocals", "()Lavail/utility/structures/EnumMap;", "methodHead", "getMethodHead", "nextLocal", "branch", "", "method", "Lorg/objectweb/asm/MethodVisitor;", "instruction", "opcode", "success", "Lavail/interpreter/levelTwo/operand/L2PcOperand;", "failure", "successCounter", "Ljava/util/concurrent/atomic/LongAdder;", "failureCounter", "classVisitEnd", "createClassBytes", "doubleConstant", "value", "", "dumpClassBytesToFile", "dumpL1SourceToFile", "fileName", "Ljava/nio/file/Path;", "dumpL2SourceToFile", "dumpTraceToFile", "e", "", "endLocal", "localNumber", "type", "Lorg/objectweb/asm/Type;", "finishMethod", "floatConstant", "", "generateBranch", "branchOpcode", "takenCounter", "notTakenCounter", "takenEdge", "generateConstructorV", "generateName", "generateReificationPreamble", "onReification", "generateRunChunk", "generateStaticInitializer", "intConstant", "jump", "operand", "jumpIf", "edge", "labelFor", "offset", "labelHere", "literal", "any", "Lavail/interpreter/levelTwo/operand/L2Operand;", "reg", "Lavail/interpreter/levelTwo/register/L2Register;", "load", "register", "loadClass", "loadInterpreter", "loadReceiver", "localNumberFromRegister", "longConstant", "", "objectArray", "operands", "", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedOperand;", "arrayClass", "Ljava/lang/Class;", "Lavail/descriptor/representation/A_BasicObject;", "offsetLocal", "prepare", "reifierLocal", "reverseOpcode", "store", "translate", "Companion", "GenerationPhase", "JVMTranslationPreparer", "LiteralAccessor", "avail"})
public final class JVMTranslator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @org.jetbrains.annotations.Nullable
    private final A_RawFunction code;
    @NotNull
    private final String chunkName;
    @org.jetbrains.annotations.Nullable
    private final String sourceFileName;
    @NotNull
    private final L2ControlFlowGraph controlFlowGraph;
    @NotNull
    private final L2Instruction[] instructions;
    @NotNull
    private final ClassNode classNode;
    @NotNull
    private final String className;
    @NotNull
    private final String classInternalName;
    @org.jetbrains.annotations.Nullable
    private byte[] classBytes;
    @NotNull
    private final Map<Integer, Label> entryPoints;
    @NotNull
    private final Map<L2Instruction, EnumMap<L2Register.RegisterKind, List<Integer>>> liveLocalNumbersByKindPerEntryPoint;
    @NotNull
    private final Map<Object, LiteralAccessor> literals;
    @NotNull
    private final Label methodHead;
    @NotNull
    private final Label jumper;
    @NotNull
    private final Map<Integer, Label> labels;
    @NotNull
    private final EnumMap<L2Register.RegisterKind, Map<Integer, Integer>> locals;
    private int nextLocal;
    @org.jetbrains.annotations.Nullable
    private JVMChunk jvmChunk;
    public static final boolean debugNicerJavaDecompilation = true;
    private static final Pattern subblockRewriter = Pattern.compile("\\[(\\d+)]");
    private static final Pattern classNameUnquoter = Pattern.compile("^[\"](.*)[\"]([^\"]*)$");
    private static final Pattern classNameForbiddenCharacters = Pattern.compile("[\\[\\]\\\\/.:;\"'\\p{Cntrl}]+");
    private static final Pattern moduleNameStripper = Pattern.compile("^.*/([^/]+)$");
    public static final boolean callTraceL2AfterEveryInstruction = false;
    @NotNull
    private static final Pattern tagEndPattern;
    private static boolean debugJVM;
    private static boolean debugJVMCodeGeneration;

    public JVMTranslator(@org.jetbrains.annotations.Nullable A_RawFunction code, @NotNull String chunkName, @org.jetbrains.annotations.Nullable String sourceFileName, @NotNull L2ControlFlowGraph controlFlowGraph, @NotNull L2Instruction[] instructions) {
        A_BasicObject module;
        int n;
        Intrinsics.checkNotNullParameter((Object)chunkName, (String)"chunkName");
        Intrinsics.checkNotNullParameter((Object)controlFlowGraph, (String)"controlFlowGraph");
        Intrinsics.checkNotNullParameter((Object)instructions, (String)"instructions");
        this.code = code;
        this.chunkName = chunkName;
        this.sourceFileName = sourceFileName;
        this.controlFlowGraph = controlFlowGraph;
        this.instructions = (L2Instruction[])instructions.clone();
        this.classNode = new ClassNode(589824);
        this.entryPoints = new LinkedHashMap();
        this.liveLocalNumbersByKindPerEntryPoint = new LinkedHashMap();
        this.literals = new LinkedHashMap();
        this.methodHead = new Label();
        this.jumper = new Label();
        this.labels = new LinkedHashMap();
        EnumMap.Companion companion = EnumMap.Companion;
        JVMTranslator jVMTranslator = this;
        boolean $i$f$enumMap = false;
        Enum[] keys$iv = (Enum[])L2Register.RegisterKind.class.getEnumConstants();
        Intrinsics.checkNotNullExpressionValue((Object)keys$iv, (String)"keys");
        EnumMap map$iv = new EnumMap(keys$iv);
        Object $this$forEach$iv$iv = keys$iv;
        boolean $i$f$forEach = false;
        int n2 = ((Enum[])$this$forEach$iv$iv).length;
        for (n = 0; n < n2; ++n) {
            Enum element$iv$iv;
            Enum key$iv = element$iv$iv = $this$forEach$iv$iv[n];
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)key$iv, (String)"key");
            L2Register.RegisterKind cfr_ignored_0 = (L2Register.RegisterKind)key$iv;
            boolean bl2 = false;
            Map value$iv = new LinkedHashMap();
            boolean bl3 = false;
            map$iv.set(key$iv, value$iv);
        }
        jVMTranslator.locals = map$iv;
        this.nextLocal = 4;
        A_BasicObject a_BasicObject = this.code;
        if (a_BasicObject == null || (a_BasicObject = A_RawFunction.Companion.getModule((A_RawFunction)a_BasicObject)) == null) {
            a_BasicObject = NilDescriptor.Companion.getNil();
        }
        String moduleName2 = (module = a_BasicObject) == NilDescriptor.Companion.getNil() ? "NoModule" : moduleNameStripper.matcher(A_Module.Companion.getModuleNameNative((A_Module)module)).replaceAll("$1");
        String originalFunctionName = this.code == null ? "DEFAULT" : A_RawFunction.Companion.getMethodName(this.code).asNativeString();
        Object cleanFunctionName = subblockRewriter.matcher(originalFunctionName).replaceAll("#$1");
        cleanFunctionName = classNameUnquoter.matcher((CharSequence)cleanFunctionName).replaceAll("$1$2");
        if (((String)(cleanFunctionName = classNameForbiddenCharacters.matcher((CharSequence)cleanFunctionName).replaceAll("\\%"))).length() > 100) {
            String string2 = cleanFunctionName;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"cleanFunctionName");
            $this$forEach$iv$iv = string2;
            int n3 = 0;
            n = 100;
            String string3 = ((String)$this$forEach$iv$iv).substring(n3, n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            cleanFunctionName = string3 + "%%%";
        }
        String string4 = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"randomUUID().toString()");
        String safeUID = StringsKt.replace$default((String)string4, (char)'-', (char)'_', (boolean)false, (int)4, null);
        this.className = "avail.optimizer.jvm.generated." + moduleName2 + "." + (String)cleanFunctionName + " - " + safeUID + "." + moduleName2 + " - " + (String)cleanFunctionName;
        this.classInternalName = StringsKt.replace$default((String)this.className, (char)'.', (char)'/', (boolean)false, (int)4, null);
    }

    @org.jetbrains.annotations.Nullable
    public final A_RawFunction getCode() {
        return this.code;
    }

    @NotNull
    public final L2Instruction[] getInstructions() {
        return this.instructions;
    }

    @NotNull
    public final ClassNode getClassNode() {
        return this.classNode;
    }

    @NotNull
    public final String getClassName() {
        return this.className;
    }

    @NotNull
    public final String getClassInternalName() {
        return this.classInternalName;
    }

    @NotNull
    public final Map<L2Instruction, EnumMap<L2Register.RegisterKind, List<Integer>>> getLiveLocalNumbersByKindPerEntryPoint() {
        return this.liveLocalNumbersByKindPerEntryPoint;
    }

    public final void generateReificationPreamble(@NotNull MethodVisitor method, @NotNull L2PcOperand onReification) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)onReification, (String)"onReification");
        method.visitVarInsn(25, this.reifierLocal());
        this.loadInterpreter(method);
        Interpreter.Companion.getInterpreterFunctionField().generateRead(method);
        onReification.createAndPushRegisterDumpArrays(this, method);
        this.loadInterpreter(method);
        Interpreter.Companion.getChunkField().generateRead(method);
        this.intConstant(method, onReification.offset());
        ContinuationDescriptor.Companion.getCreateDummyContinuationMethod().generateCall(method);
        StackReifier.Companion.getPushContinuationActionMethod().generateCall(method);
        method.visitInsn(176);
    }

    @NotNull
    public final Map<Object, LiteralAccessor> getLiterals() {
        return this.literals;
    }

    public final void literal(@NotNull MethodVisitor method, @NotNull Object any) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)any, (String)"any");
        LiteralAccessor literalAccessor = this.literals.get(any);
        Intrinsics.checkNotNull((Object)literalAccessor);
        literalAccessor.getGetter().invoke((Object)method);
    }

    @Deprecated(message="")
    public final void literal(@org.jetbrains.annotations.Nullable MethodVisitor method, @NotNull L2Operand operand) {
        Intrinsics.checkNotNullParameter((Object)operand, (String)"operand");
        throw new UnsupportedOperationException();
    }

    @Deprecated(message="")
    public final void literal(@org.jetbrains.annotations.Nullable MethodVisitor method, @org.jetbrains.annotations.Nullable L2Register reg) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public final Label getMethodHead() {
        return this.methodHead;
    }

    @NotNull
    public final Label getJumper() {
        return this.jumper;
    }

    @NotNull
    public final Map<Integer, Label> getLabels() {
        return this.labels;
    }

    @NotNull
    public final Label labelFor(int offset) {
        Label label = this.labels.get(offset);
        Intrinsics.checkNotNull((Object)label);
        return label;
    }

    @NotNull
    public final EnumMap<L2Register.RegisterKind, Map<Integer, Integer>> getLocals() {
        return this.locals;
    }

    public final int nextLocal(@NotNull Type type) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        boolean bl2 = bl = type != Type.VOID_TYPE;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        int local = this.nextLocal;
        this.nextLocal += type.getSize();
        return local;
    }

    public final void endLocal(int localNumber, @NotNull Type type) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.nextLocal -= type.getSize();
        boolean bl2 = bl = this.nextLocal == localNumber;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
    }

    public final int localNumberFromRegister(@NotNull L2Register register) {
        Intrinsics.checkNotNullParameter((Object)register, (String)"register");
        Map<Integer, Integer> map = this.locals.get((Object)register.getRegisterKind());
        Intrinsics.checkNotNull(map);
        Integer n = map.get(register.finalIndex());
        Intrinsics.checkNotNull((Object)n);
        return ((Number)n).intValue();
    }

    public final void load(@NotNull MethodVisitor method, @NotNull L2Register register) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)register, (String)"register");
        method.visitVarInsn(register.getRegisterKind().getLoadInstruction(), this.localNumberFromRegister(register));
    }

    public final void store(@NotNull MethodVisitor method, @NotNull L2Register register) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)register, (String)"register");
        method.visitVarInsn(register.getRegisterKind().getStoreInstruction(), this.localNumberFromRegister(register));
    }

    public final void prepare() {
        JVMTranslationPreparer preparer = new JVMTranslationPreparer();
        L2Instruction[] $this$forEach$iv = this.instructions;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            L2Instruction element$iv;
            L2Instruction instruction2 = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            boolean include = instruction2.isEntryPoint();
            if (!include) {
                boolean bl2 = include = instruction2.getOffset() == instruction2.basicBlock().offset();
            }
            if (include) {
                Label label = new Label();
                this.entryPoints.put(instruction2.getOffset(), label);
                this.labels.put(instruction2.getOffset(), label);
            }
            L2Operand[] $this$forEach$iv2 = instruction2.getOperands();
            boolean $i$f$forEach2 = false;
            int n2 = $this$forEach$iv2.length;
            for (int j = 0; j < n2; ++j) {
                L2Operand element$iv2;
                L2Operand it = element$iv2 = $this$forEach$iv2[j];
                boolean bl3 = false;
                it.dispatchOperand(preparer);
            }
        }
    }

    private final String dumpTraceToFile(Throwable e) {
        String string2;
        try {
            int lastSlash = StringsKt.lastIndexOf$default((CharSequence)this.classInternalName, (char)'/', (int)0, (boolean)false, (int)6, null);
            String string3 = this.classInternalName.substring(0, lastSlash);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String pkg = string3;
            String[] stringArray = new String[]{"jvm"};
            Path tempDir = Paths.get("debug", stringArray);
            Path dir = tempDir.resolve(Paths.get(pkg, new String[0]));
            Files.createDirectories(dir, new FileAttribute[0]);
            String string4 = this.classInternalName.substring(lastSlash + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
            String base = string4;
            Path traceFile = dir.resolve(base + ".trace");
            CharSequence charSequence = Strings.INSTANCE.traceFor(e);
            Regex regex = new Regex(" {6,}");
            String string5 = "     ";
            String trace2 = regex.replace(charSequence, string5);
            ByteBuffer buffer = StandardCharsets.UTF_8.encode(trace2);
            byte[] bytes = new byte[buffer.limit()];
            buffer.get(bytes);
            Files.write(traceFile, bytes, new OpenOption[0]);
            string2 = ((Object)traceFile.toAbsolutePath()).toString();
        }
        catch (IOException x) {
            Logger logger = Interpreter.Companion.getLoggerDebugJVM();
            Level level = Level.WARNING;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"WARNING");
            Object[] objectArray = new Object[]{this.classInternalName};
            Interpreter.Companion.log(logger, level, "unable to write trace for failed generated class {0}", objectArray);
            string2 = null;
        }
        return string2;
    }

    private final void finishMethod(MethodVisitor method) {
        method.visitMaxs(0, 0);
        method.visitEnd();
        if (debugJVMCodeGeneration) {
            MethodNode methodNode = (MethodNode)method;
            ClassWriter classWriter = new ClassWriter(2);
            int n = this.classNode.version;
            int n2 = this.classNode.access;
            String string2 = this.classNode.name;
            String string3 = this.classNode.signature;
            String string4 = this.classNode.superName;
            List list = this.classNode.interfaces;
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"classNode.interfaces");
            Collection $this$toTypedArray$iv = list;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            classWriter.visit(n, n2, string2, string3, string4, stringArray);
            int n3 = methodNode.access;
            String string5 = methodNode.name;
            String string6 = methodNode.desc;
            String string7 = methodNode.signature;
            List list2 = methodNode.exceptions;
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"methodNode.exceptions");
            Collection $this$toTypedArray$iv2 = list2;
            boolean $i$f$toTypedArray2 = false;
            Collection thisCollection$iv2 = $this$toTypedArray$iv2;
            String[] stringArray2 = thisCollection$iv2.toArray(new String[0]);
            if (stringArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            MethodVisitor methodWriter = classWriter.visitMethod(n3, string5, string6, string7, stringArray2);
            try {
                methodNode.accept(methodWriter);
            }
            catch (Exception e) {
                if (debugJVM) {
                    Logger logger = Interpreter.Companion.getLoggerDebugJVM();
                    Level level = Level.SEVERE;
                    Intrinsics.checkNotNullExpressionValue((Object)level, (String)"SEVERE");
                    Object[] objectArray = new Object[]{this.className};
                    Interpreter.Companion.log(logger, level, "stack map frame computation failed for {0}", objectArray);
                    this.dumpTraceToFile(e);
                }
                throw e;
            }
            MethodVisitor methodVisitor = methodWriter;
            if (methodVisitor == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.objectweb.asm.tree.MethodNode");
            }
            MethodNode methodWriterAsNode = (MethodNode)methodVisitor;
            method.visitMaxs(methodWriterAsNode.maxStack, methodWriterAsNode.maxLocals);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void generateStaticInitializer() {
        void $this$filterTo$iv$iv;
        List rawAccessors;
        MethodVisitor method = this.classNode.visitMethod(9, "<clinit>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), null, null);
        method.visitCode();
        method.visitLdcInsn((Object)Type.getType((String)("L" + this.classInternalName + ";")));
        CheckedMethod checkedMethod = JavaLibrary.INSTANCE.getGetClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method");
        checkedMethod.generateCall(method);
        method.visitTypeInsn(192, Type.getInternalName(JVMChunkClassLoader.class));
        List $this$sortBy$iv = rawAccessors = CollectionsKt.toMutableList(this.literals.values());
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    LiteralAccessor it = (LiteralAccessor)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getClassLoaderIndex());
                    it = (LiteralAccessor)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getClassLoaderIndex()));
                }
            });
        }
        Iterable $this$filter$iv = rawAccessors;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LiteralAccessor accessor = (LiteralAccessor)element$iv$iv;
            boolean bl = false;
            if (!(accessor.getSetter() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List accessors = (List)destination$iv$iv;
        if (!((Collection)accessors).isEmpty()) {
            method.visitInsn(89);
            JVMChunkClassLoader.Companion.getParametersField().generateRead(method);
            int limit = accessors.size();
            Iterator iterator2 = accessors.iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                int i = n++;
                LiteralAccessor accessor = (LiteralAccessor)iterator2.next();
                if (i < limit - 1) {
                    method.visitInsn(89);
                }
                this.intConstant(method, accessor.getClassLoaderIndex());
                method.visitInsn(50);
                Function1<MethodVisitor, Unit> function1 = accessor.getSetter();
                Intrinsics.checkNotNull(function1);
                function1.invoke((Object)method);
            }
        }
        method.visitInsn(1);
        JVMChunkClassLoader.Companion.getParametersField().generateWrite(method);
        method.visitInsn(177);
        this.finishMethod(method);
    }

    public final void loadReceiver(@NotNull MethodVisitor method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        method.visitVarInsn(25, JVMTranslator.Companion.receiverLocal());
    }

    public final void loadInterpreter(@NotNull MethodVisitor method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        method.visitVarInsn(25, Companion.interpreterLocal());
    }

    public final int offsetLocal() {
        return 2;
    }

    public final int reifierLocal() {
        return 3;
    }

    public final void intConstant(@NotNull MethodVisitor method, int value) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        int n = value;
        if (n == -1) {
            method.visitInsn(2);
        } else if (n == 0) {
            method.visitInsn(3);
        } else if (n == 1) {
            method.visitInsn(4);
        } else if (n == 2) {
            method.visitInsn(5);
        } else if (n == 3) {
            method.visitInsn(6);
        } else if (n == 4) {
            method.visitInsn(7);
        } else if (n == 5) {
            method.visitInsn(8);
        } else {
            boolean bl = -128 <= n ? n <= 127 : false;
            if (bl) {
                method.visitIntInsn(16, value);
            } else {
                boolean bl2 = Short.MIN_VALUE <= n ? n <= Short.MAX_VALUE : false;
                if (bl2) {
                    method.visitIntInsn(17, value);
                } else {
                    method.visitLdcInsn((Object)value);
                }
            }
        }
    }

    public final void longConstant(@NotNull MethodVisitor method, long value) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        long l = value;
        if (l == 0L) {
            method.visitInsn(9);
        } else if (l == 1L) {
            method.visitInsn(10);
        } else {
            boolean bl = Integer.MIN_VALUE <= l ? l <= Integer.MAX_VALUE : false;
            if (bl) {
                this.intConstant(method, (int)value);
                method.visitInsn(133);
            } else {
                method.visitLdcInsn((Object)value);
            }
        }
    }

    public final void floatConstant(@NotNull MethodVisitor method, float value) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        float f = value;
        if (f == 0.0f) {
            method.visitInsn(11);
        } else if (f == 1.0f) {
            method.visitInsn(12);
        } else if (f == 2.0f) {
            method.visitInsn(13);
        } else {
            method.visitLdcInsn((Object)Float.valueOf(value));
        }
    }

    public final void doubleConstant(@NotNull MethodVisitor method, double value) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        double d = value;
        if (d == 0.0) {
            method.visitInsn(14);
        } else if (d == 1.0) {
            method.visitInsn(15);
        } else {
            method.visitLdcInsn((Object)value);
        }
    }

    public final void objectArray(@NotNull MethodVisitor method, @NotNull List<L2ReadBoxedOperand> operands, @NotNull Class<? extends A_BasicObject> arrayClass) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(operands, (String)"operands");
        Intrinsics.checkNotNullParameter(arrayClass, (String)"arrayClass");
        if (operands.isEmpty()) {
            JVMChunk.Companion.getNoObjectsField().generateRead(method);
        } else {
            int limit = operands.size();
            this.intConstant(method, limit);
            method.visitTypeInsn(189, Type.getInternalName(arrayClass));
            for (int i = 0; i < limit; ++i) {
                method.visitInsn(89);
                this.intConstant(method, i);
                this.load(method, (L2Register)operands.get(i).register());
                method.visitInsn(83);
            }
        }
    }

    public final int reverseOpcode(int opcode) {
        return switch (opcode) {
            case 153 -> 154;
            case 154 -> 153;
            case 155 -> 156;
            case 158 -> 157;
            case 156 -> 155;
            case 157 -> 158;
            case 159 -> 160;
            case 160 -> 159;
            case 161 -> 162;
            case 164 -> 163;
            case 162 -> 161;
            case 163 -> 164;
            case 165 -> 166;
            case 166 -> 165;
            case 198 -> 199;
            case 199 -> 198;
            default -> {
                if (_Assertions.ENABLED) {
                    boolean $i$a$-assert-JVMTranslator$reverseOpcode$1 = false;
                    String var2_3 = "bad opcode (" + opcode + ")";
                    throw new AssertionError((Object)var2_3);
                }
                throw new RuntimeException("bad opcode (" + opcode + ")");
            }
        };
    }

    public final void jump(@NotNull MethodVisitor method, @NotNull L2Instruction instruction2, @NotNull L2PcOperand operand) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)instruction2, (String)"instruction");
        Intrinsics.checkNotNullParameter((Object)operand, (String)"operand");
        if (operand.offset() != instruction2.getOffset() + 1) {
            this.jump(method, operand);
        }
    }

    public final void jump(@NotNull MethodVisitor method, @NotNull L2PcOperand operand) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)operand, (String)"operand");
        int pc = operand.offset();
        this.intConstant(method, pc);
        method.visitVarInsn(54, this.offsetLocal());
        method.visitJumpInsn(167, this.jumper);
    }

    public final void jumpIf(@NotNull MethodVisitor method, int branchOpcode, @NotNull L2PcOperand edge2) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)edge2, (String)"edge");
        Label tempLabel = new Label();
        method.visitJumpInsn(this.reverseOpcode(branchOpcode), tempLabel);
        this.intConstant(method, edge2.offset());
        method.visitVarInsn(54, this.offsetLocal());
        method.visitJumpInsn(167, this.jumper);
        method.visitLabel(tempLabel);
    }

    public final void branch(@NotNull MethodVisitor method, @NotNull L2Instruction instruction2, int opcode, @NotNull L2PcOperand success2, @NotNull L2PcOperand failure, @NotNull LongAdder successCounter, @NotNull LongAdder failureCounter) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)instruction2, (String)"instruction");
        Intrinsics.checkNotNullParameter((Object)success2, (String)"success");
        Intrinsics.checkNotNullParameter((Object)failure, (String)"failure");
        Intrinsics.checkNotNullParameter((Object)successCounter, (String)"successCounter");
        Intrinsics.checkNotNullParameter((Object)failureCounter, (String)"failureCounter");
        int offset = instruction2.getOffset();
        if (offset + 1 == failure.offset()) {
            this.generateBranch(method, opcode, successCounter, failureCounter, success2);
        } else {
            this.generateBranch(method, this.reverseOpcode(opcode), failureCounter, successCounter, failure);
            this.jump(method, instruction2, success2);
        }
    }

    private final void generateBranch(MethodVisitor method, int branchOpcode, LongAdder takenCounter, LongAdder notTakenCounter, L2PcOperand takenEdge) {
        Label logNotTaken = new Label();
        method.visitJumpInsn(this.reverseOpcode(branchOpcode), logNotTaken);
        this.literal(method, takenCounter);
        JavaLibrary.INSTANCE.getLongAdderIncrement().generateCall(method);
        this.jump(method, takenEdge);
        method.visitLabel(logNotTaken);
        this.literal(method, notTakenCounter);
        JavaLibrary.INSTANCE.getLongAdderIncrement().generateCall(method);
    }

    public final void generateConstructorV() {
        MethodVisitor method = this.classNode.visitMethod(32769, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), null, null);
        method.visitCode();
        Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method");
        this.loadReceiver(method);
        JVMChunk.Companion.getChunkConstructor().generateCall(method);
        method.visitInsn(177);
        this.finishMethod(method);
    }

    public final void generateName() {
        MethodVisitor method = this.classNode.visitMethod(1, "name", Type.getMethodDescriptor((Type)Type.getType(String.class), (Type[])new Type[0]), null, null);
        method.visitCode();
        method.visitLdcInsn((Object)this.chunkName);
        method.visitInsn(176);
        Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method");
        this.finishMethod(method);
    }

    private final String dumpL1SourceToFile(Path fileName) {
        String string2;
        try {
            StringBuilder builder2 = new StringBuilder();
            builder2.append(this.chunkName);
            builder2.append(":\n\n");
            A_RawFunction a_RawFunction = this.code;
            Intrinsics.checkNotNull((Object)a_RawFunction);
            L1Disassembler disassembler = new L1Disassembler(a_RawFunction);
            L1Disassembler.print$default(disassembler, builder2, new IdentityHashMap(), 0, 0, 8, null);
            ByteBuffer buffer = StandardCharsets.UTF_8.encode(builder2.toString());
            byte[] bytes = new byte[buffer.limit()];
            buffer.get(bytes);
            Files.write(fileName, bytes, new OpenOption[0]);
            string2 = ((Object)fileName.toAbsolutePath()).toString();
        }
        catch (IOException e) {
            Logger logger = Interpreter.Companion.getLoggerDebugJVM();
            Level level = Level.WARNING;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"WARNING");
            Object[] objectArray = new Object[]{this.classInternalName};
            Interpreter.Companion.log(logger, level, "unable to write L1 for generated class {0}", objectArray);
            string2 = null;
        }
        return string2;
    }

    private final String dumpL2SourceToFile(Path fileName) {
        String string2;
        try {
            int lastSlash = StringsKt.lastIndexOf$default((CharSequence)this.classInternalName, (char)'/', (int)0, (boolean)false, (int)6, null);
            StringBuilder builder2 = new StringBuilder();
            String string3 = this.classInternalName.substring(lastSlash + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            L2ControlFlowGraphVisualizer visualizer = new L2ControlFlowGraphVisualizer(string3, this.chunkName, 80, this.controlFlowGraph, true, false, true, builder2);
            visualizer.visualize();
            ByteBuffer buffer = StandardCharsets.UTF_8.encode(builder2.toString());
            byte[] bytes = new byte[buffer.limit()];
            buffer.get(bytes);
            Files.write(fileName, bytes, new OpenOption[0]);
            string2 = ((Object)fileName.toAbsolutePath()).toString();
        }
        catch (IOException e) {
            Logger logger = Interpreter.Companion.getLoggerDebugJVM();
            Level level = Level.WARNING;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"WARNING");
            Object[] objectArray = new Object[]{this.classInternalName};
            Interpreter.Companion.log(logger, level, "unable to write L2 for generated class {0}", objectArray);
            string2 = null;
        }
        catch (UncheckedIOException e) {
            Logger logger = Interpreter.Companion.getLoggerDebugJVM();
            Level level = Level.WARNING;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"WARNING");
            Object[] objectArray = new Object[]{this.classInternalName};
            Interpreter.Companion.log(logger, level, "unable to write L2 for generated class {0}", objectArray);
            string2 = null;
        }
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    public final void generateRunChunk() {
        Iterator $this$flatMapTo$iv$iv;
        AnnotationVisitor annotation;
        Object dir;
        Type[] typeArray = new Type[]{Type.getType(Interpreter.class), Type.INT_TYPE};
        MethodVisitor method = this.classNode.visitMethod(1, "runChunk", Type.getMethodDescriptor((Type)Type.getType(StackReifier.class), (Type[])typeArray), null, null);
        method.visitParameter("interpreter", 16);
        method.visitParameterAnnotation(0, Type.getDescriptor(Nonnull.class), true);
        method.visitParameter("offset", 0);
        if (debugJVM) {
            int lastSlash = StringsKt.lastIndexOf$default((CharSequence)this.classInternalName, (char)'/', (int)0, (boolean)false, (int)6, null);
            String string2 = this.classInternalName.substring(0, lastSlash);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String pkg = string2;
            String[] stringArray = new String[]{"jvm"};
            Path tempDir = Paths.get("debug", stringArray);
            dir = tempDir.resolve(Paths.get(pkg, new String[0]));
            Files.createDirectories((Path)dir, new FileAttribute[0]);
            String string3 = this.classInternalName.substring(lastSlash + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            Object baseFileName = string3;
            if (((String)baseFileName).length() > 100) {
                String string4 = ((String)baseFileName).substring(0, 100);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                baseFileName = string4 + "\u2026";
            }
            if (this.code != null) {
                Path path = dir.resolve((String)baseFileName + ".l1");
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"dir.resolve(\"$baseFileName.l1\")");
                String l1Path = this.dumpL1SourceToFile(path);
                if (l1Path != null) {
                    annotation = method.visitAnnotation(Type.getDescriptor(JVMChunkL1Source.class), true);
                    annotation.visit("sourcePath", (Object)l1Path);
                    annotation.visitEnd();
                }
            }
            Path path = dir.resolve((String)baseFileName + ".dot");
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"dir.resolve(\"$baseFileName.dot\")");
            String l2Path = this.dumpL2SourceToFile(path);
            if (l2Path != null) {
                annotation = method.visitAnnotation(Type.getDescriptor(JVMChunkL2Source.class), true);
                annotation.visit("sourcePath", (Object)l2Path);
                annotation.visitEnd();
            }
        }
        Label endLabel = new Label();
        method.visitAnnotation(Type.getDescriptor(Nullable.class), true);
        method.visitLocalVariable("interpreter", Type.getDescriptor(Interpreter.class), null, this.methodHead, endLabel, Companion.interpreterLocal());
        method.visitLocalVariable("offset", Type.INT_TYPE.getDescriptor(), null, this.methodHead, endLabel, this.offsetLocal());
        method.visitInsn(1);
        method.visitVarInsn(58, this.reifierLocal());
        String string5 = Type.getDescriptor(StackReifier.class);
        Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method");
        method.visitLocalVariable("reifier", string5, null, this.labelHere(method), endLabel, this.reifierLocal());
        Map $this$flatMap$iv = this.locals;
        boolean $i$f$flatMap = false;
        dir = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        annotation = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (annotation.hasNext()) {
            void $this$mapTo$iv$iv;
            Map value;
            Map.Entry element$iv$iv;
            Map.Entry entry = element$iv$iv = (Map.Entry)annotation.next();
            boolean bl = false;
            L2Register.RegisterKind kind = (L2Register.RegisterKind)((Object)entry.getKey());
            Map $this$map$iv = value = (Map)entry.getValue();
            boolean $i$f$map = false;
            Map map = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry entry2 = item$iv$iv = iterator2.next();
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                int finalIndex = ((Number)entry2.getKey()).intValue();
                int localIndex = ((Number)entry2.getValue()).intValue();
                collection.add(new Triple((Object)kind, (Object)finalIndex, (Object)localIndex));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Triple p0 = (Triple)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(((Number)p0.getThird()).intValue());
                p0 = (Triple)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(((Number)p0.getThird()).intValue()));
            }
        });
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Triple $i$f$flatMapTo2 = (Triple)element$iv;
            boolean bl = false;
            L2Register.RegisterKind kind = (L2Register.RegisterKind)((Object)$i$f$flatMapTo2.component1());
            int finalIndex = ((Number)$i$f$flatMapTo2.component2()).intValue();
            int localIndex = ((Number)$i$f$flatMapTo2.component3()).intValue();
            switch (WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
                case 1: {
                    method.visitInsn(1);
                    method.visitVarInsn(58, localIndex);
                    break;
                }
                case 2: {
                    this.intConstant(method, 0);
                    method.visitVarInsn(54, localIndex);
                    break;
                }
                case 3: {
                    this.doubleConstant(method, 0.0);
                    method.visitVarInsn(57, localIndex);
                }
            }
            method.visitLocalVariable(kind.getPrefix() + finalIndex, kind.getJvmTypeString(), null, this.labelHere(method), endLabel, localIndex);
        }
        method.visitLabel(this.methodHead);
        int[] offsets = new int[this.entryPoints.size()];
        Label[] entries2 = new Label[this.entryPoints.size()];
        Iterable $this$forEachIndexed$iv = this.entryPoints.entrySet();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            int finalIndex;
            if ((finalIndex = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Map.Entry entry = (Map.Entry)item$iv;
            int i = finalIndex;
            boolean bl = false;
            int key = ((Number)entry.getKey()).intValue();
            Label value = (Label)entry.getValue();
            offsets[i] = key;
            entries2[i] = value;
        }
        method.visitCode();
        method.visitVarInsn(21, this.offsetLocal());
        Label badOffsetLabel = new Label();
        method.visitLookupSwitchInsn(badOffsetLabel, offsets, entries2);
        for (L2Instruction instruction2 : this.instructions) {
            Label label = this.labels.get(instruction2.getOffset());
            if (label != null) {
                method.visitLabel(label);
                method.visitLineNumber(instruction2.getOffset(), label);
            }
            instruction2.translateToJVM(this, method);
        }
        method.visitLabel(badOffsetLabel);
        method.visitVarInsn(21, this.offsetLocal());
        JVMChunk.Companion.getBadOffsetMethod().generateCall(method);
        method.visitInsn(191);
        method.visitLabel(this.jumper);
        method.visitJumpInsn(167, this.methodHead);
        method.visitLabel(endLabel);
        this.finishMethod(method);
    }

    private final Label labelHere(MethodVisitor method) {
        Label label;
        Label it = label = new Label();
        boolean bl = false;
        method.visitLabel(it);
        return label;
    }

    public final void classVisitEnd() {
        this.classNode.visitEnd();
    }

    @NotNull
    public final JVMChunk jvmChunk() {
        JVMChunk jVMChunk = this.jvmChunk;
        Intrinsics.checkNotNull((Object)jVMChunk);
        return jVMChunk;
    }

    private final void dumpClassBytesToFile() {
        try {
            int lastSlash = StringsKt.lastIndexOf$default((CharSequence)this.classInternalName, (char)'/', (int)0, (boolean)false, (int)6, null);
            String string2 = this.classInternalName.substring(0, lastSlash);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String pkg = string2;
            String[] stringArray = new String[]{"jvm"};
            Path tempDir = Paths.get("debug", stringArray);
            Path dir = tempDir.resolve(Paths.get(pkg, new String[0]));
            Files.createDirectories(dir, new FileAttribute[0]);
            String string3 = this.classInternalName.substring(lastSlash + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            String base = string3;
            Path classFile = dir.resolve(base + ".class");
            Intrinsics.checkNotNull((Object)this.classBytes);
            Files.write(classFile, this.classBytes, new OpenOption[0]);
        }
        catch (IOException e) {
            Logger logger = Interpreter.Companion.getLoggerDebugJVM();
            Level level = Level.WARNING;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"WARNING");
            Object[] objectArray = new Object[]{this.classInternalName};
            Interpreter.Companion.log(logger, level, "unable to write class bytes for generated class {0}", objectArray);
        }
    }

    public final void createClassBytes() {
        ClassWriter writer = new ClassWriter(2);
        this.classNode.accept((ClassVisitor)writer);
        if (debugJVMCodeGeneration) {
            CheckClassAdapter checker = new CheckClassAdapter((ClassVisitor)writer);
            this.classNode.accept((ClassVisitor)checker);
        }
        this.classBytes = writer.toByteArray();
        if (debugJVM) {
            this.dumpClassBytesToFile();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void loadClass() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.literals.entrySet();
        int $i$f$filter = 0;
        Iterable iterable = $this$filter$iv;
        Object[] destination$iv$iv = (Object[])new ArrayList();
        int $i$f$filterTo = 0;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Map.Entry it = (Map.Entry)element$iv$iv;
            boolean bl = false;
            if (!(((LiteralAccessor)it.getValue()).getClassLoaderIndex() > -1)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List validParamSet = (List)destination$iv$iv;
        $i$f$filter = 0;
        int n = validParamSet.size();
        destination$iv$iv = new Object[n];
        while ($i$f$filter < n) {
            $i$f$filterTo = $i$f$filter++;
            destination$iv$iv[$i$f$filterTo] = NilDescriptor.Companion.getNil();
        }
        Object[] parameters = destination$iv$iv;
        for (Map.Entry entry : validParamSet) {
            Object key = entry.getKey();
            LiteralAccessor value = (LiteralAccessor)entry.getValue();
            parameters[value.getClassLoaderIndex()] = key;
        }
        JVMChunkClassLoader loader = new JVMChunkClassLoader();
        Intrinsics.checkNotNull((Object)this.classBytes);
        this.jvmChunk = loader.newJVMChunkFrom(this.chunkName, this.className, this.classBytes, parameters);
    }

    public final void translate() {
        String string2 = JVMChunk.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"JVMChunk::class.java.name");
        this.classNode.visit(55, 17, this.classInternalName, null, StringsKt.replace$default((String)string2, (char)'.', (char)'/', (boolean)false, (int)4, null), null);
        this.classNode.visitSource(this.sourceFileName, null);
        GenerationPhase.Companion.executeAll(this);
    }

    static {
        Pattern pattern = Pattern.compile("_TAG$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(\"_TAG$\")");
        tagEndPattern = pattern;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\f\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0013\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001f\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011\u00a8\u0006\u0015"}, d2={"Lavail/optimizer/jvm/JVMTranslator$LiteralAccessor;", "", "classLoaderIndex", "", "fieldName", "", "getter", "Lkotlin/Function1;", "Lorg/objectweb/asm/MethodVisitor;", "", "setter", "(ILjava/lang/String;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "getClassLoaderIndex", "()I", "getFieldName", "()Ljava/lang/String;", "getGetter", "()Lkotlin/jvm/functions/Function1;", "getSetter", "toString", "Companion", "avail"})
    public static final class LiteralAccessor {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int classLoaderIndex;
        @org.jetbrains.annotations.Nullable
        private final String fieldName;
        @NotNull
        private final Function1<MethodVisitor, Unit> getter;
        @org.jetbrains.annotations.Nullable
        private final Function1<MethodVisitor, Unit> setter;
        public static final int invalidIndex = -1;

        public LiteralAccessor(int classLoaderIndex, @org.jetbrains.annotations.Nullable String fieldName, @NotNull Function1<? super MethodVisitor, Unit> getter, @org.jetbrains.annotations.Nullable Function1<? super MethodVisitor, Unit> setter) {
            Intrinsics.checkNotNullParameter(getter, (String)"getter");
            this.classLoaderIndex = classLoaderIndex;
            this.fieldName = fieldName;
            this.getter = getter;
            this.setter = setter;
        }

        public final int getClassLoaderIndex() {
            return this.classLoaderIndex;
        }

        @org.jetbrains.annotations.Nullable
        public final String getFieldName() {
            return this.fieldName;
        }

        @NotNull
        public final Function1<MethodVisitor, Unit> getGetter() {
            return this.getter;
        }

        @org.jetbrains.annotations.Nullable
        public final Function1<MethodVisitor, Unit> getSetter() {
            return this.setter;
        }

        @NotNull
        public String toString() {
            return "Field: " + this.fieldName + " (" + this.classLoaderIndex + ")";
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lavail/optimizer/jvm/JVMTranslator$LiteralAccessor$Companion;", "", "()V", "invalidIndex", "", "avail"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\tH\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\nH\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000bH\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\fH\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\rH\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000eH\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u000fH\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0010H\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0013H\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0014H\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0015H\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0016H\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0017H\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0018H\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0019H\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lavail/optimizer/jvm/JVMTranslator$JVMTranslationPreparer;", "Lavail/interpreter/levelTwo/L2OperandDispatcher;", "(Lavail/optimizer/jvm/JVMTranslator;)V", "nextClassLoaderIndex", "", "doOperand", "", "operand", "Lavail/interpreter/levelTwo/operand/L2ArbitraryConstantOperand;", "Lavail/interpreter/levelTwo/operand/L2CommentOperand;", "Lavail/interpreter/levelTwo/operand/L2ConstantOperand;", "Lavail/interpreter/levelTwo/operand/L2FloatImmediateOperand;", "Lavail/interpreter/levelTwo/operand/L2IntImmediateOperand;", "Lavail/interpreter/levelTwo/operand/L2PcOperand;", "Lavail/interpreter/levelTwo/operand/L2PcVectorOperand;", "Lavail/interpreter/levelTwo/operand/L2PrimitiveOperand;", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedOperand;", "vector", "Lavail/interpreter/levelTwo/operand/L2ReadBoxedVectorOperand;", "Lavail/interpreter/levelTwo/operand/L2ReadFloatOperand;", "Lavail/interpreter/levelTwo/operand/L2ReadFloatVectorOperand;", "Lavail/interpreter/levelTwo/operand/L2ReadIntOperand;", "Lavail/interpreter/levelTwo/operand/L2ReadIntVectorOperand;", "Lavail/interpreter/levelTwo/operand/L2SelectorOperand;", "Lavail/interpreter/levelTwo/operand/L2WriteBoxedOperand;", "Lavail/interpreter/levelTwo/operand/L2WriteFloatOperand;", "Lavail/interpreter/levelTwo/operand/L2WriteIntOperand;", "recordLiteralObject", "value", "", "tidy", "", "string", "Lavail/descriptor/tuples/A_String;", "avail"})
    public final class JVMTranslationPreparer
    implements L2OperandDispatcher {
        private int nextClassLoaderIndex;

        @Override
        public void doOperand(@NotNull L2ArbitraryConstantOperand operand) {
            Intrinsics.checkNotNullParameter((Object)operand, (String)"operand");
            this.recordLiteralObject(operand.getConstant());
        }

        @Override
        public void doOperand(@NotNull L2CommentOperand operand) {
            Intrinsics.checkNotNullParameter((Object)operand, (String)"operand");
        }

        @Override
        public void doOperand(@NotNull L2ConstantOperand operand) {
            Intrinsics.checkNotNullParameter((Object)operand, (String)"operand");
            this.recordLiteralObject(operand.getConstant());
        }

        @Override
        public void doOperand(@NotNull L2IntImmediateOperand operand) {
            Intrinsics.checkNotNullParameter((Object)operand, (String)"operand");
            JVMTranslator.this.getLiterals().computeIfAbsent(operand.getValue(), arg_0 -> JVMTranslationPreparer.doOperand$lambda-0(JVMTranslator.this, arg_0));
        }

        @Override
        public void doOperand(@NotNull L2FloatImmediateOperand operand) {
            Intrinsics.checkNotNullParameter((Object)operand, (String)"operand");
            JVMTranslator.this.getLiterals().computeIfAbsent(operand.getValue(), arg_0 -> JVMTranslationPreparer.doOperand$lambda-1(JVMTranslator.this, arg_0));
        }

        @Override
        public void doOperand(@NotNull L2PcOperand operand) {
            Intrinsics.checkNotNullParameter((Object)operand, (String)"operand");
            LongAdder longAdder = operand.getCounter();
            if (longAdder != null) {
                LongAdder p0 = longAdder;
                boolean bl = false;
                this.recordLiteralObject(p0);
            }
            JVMTranslator.this.getLabels().computeIfAbsent(operand.offset(), JVMTranslationPreparer::doOperand$lambda-2);
        }

        @Override
        public void doOperand(@NotNull L2PrimitiveOperand operand) {
            Intrinsics.checkNotNullParameter((Object)operand, (String)"operand");
            this.recordLiteralObject(operand.getPrimitive());
        }

        @Override
        public void doOperand(@NotNull L2ReadIntOperand operand) {
            Intrinsics.checkNotNullParameter((Object)operand, (String)"operand");
            Map<Integer, Integer> map = JVMTranslator.this.getLocals().get((Object)L2Register.RegisterKind.INTEGER_KIND);
            Intrinsics.checkNotNull(map);
            map.computeIfAbsent(((L2IntRegister)operand.register()).finalIndex(), arg_0 -> JVMTranslationPreparer.doOperand$lambda-3(JVMTranslator.this, arg_0));
        }

        @Override
        public void doOperand(@NotNull L2ReadFloatOperand operand) {
            Intrinsics.checkNotNullParameter((Object)operand, (String)"operand");
            Map<Integer, Integer> map = JVMTranslator.this.getLocals().get((Object)L2Register.RegisterKind.FLOAT_KIND);
            Intrinsics.checkNotNull(map);
            map.computeIfAbsent(((L2FloatRegister)operand.register()).finalIndex(), arg_0 -> JVMTranslationPreparer.doOperand$lambda-4(JVMTranslator.this, arg_0));
        }

        @Override
        public void doOperand(@NotNull L2ReadBoxedOperand operand) {
            Intrinsics.checkNotNullParameter((Object)operand, (String)"operand");
            Map<Integer, Integer> map = JVMTranslator.this.getLocals().get((Object)L2Register.RegisterKind.BOXED_KIND);
            Intrinsics.checkNotNull(map);
            map.computeIfAbsent(((L2BoxedRegister)operand.register()).finalIndex(), arg_0 -> JVMTranslationPreparer.doOperand$lambda-5(JVMTranslator.this, arg_0));
        }

        @Override
        public void doOperand(@NotNull L2ReadBoxedVectorOperand vector) {
            Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
            Iterable $this$forEach$iv = vector.elements();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                L2ReadBoxedOperand p0 = (L2ReadBoxedOperand)element$iv;
                boolean bl = false;
                this.doOperand(p0);
            }
        }

        @Override
        public void doOperand(@NotNull L2ReadIntVectorOperand vector) {
            Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
            Iterable $this$forEach$iv = vector.elements();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                L2ReadIntOperand p0 = (L2ReadIntOperand)element$iv;
                boolean bl = false;
                this.doOperand(p0);
            }
        }

        @Override
        public void doOperand(@NotNull L2ReadFloatVectorOperand vector) {
            Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
            Iterable $this$forEach$iv = vector.elements();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                L2ReadFloatOperand p0 = (L2ReadFloatOperand)element$iv;
                boolean bl = false;
                this.doOperand(p0);
            }
        }

        @Override
        public void doOperand(@NotNull L2SelectorOperand operand) {
            Intrinsics.checkNotNullParameter((Object)operand, (String)"operand");
            this.recordLiteralObject(operand.getBundle());
        }

        @Override
        public void doOperand(@NotNull L2WriteIntOperand operand) {
            Intrinsics.checkNotNullParameter((Object)operand, (String)"operand");
            Map<Integer, Integer> map = JVMTranslator.this.getLocals().get((Object)L2Register.RegisterKind.INTEGER_KIND);
            Intrinsics.checkNotNull(map);
            map.computeIfAbsent(((L2IntRegister)operand.register()).finalIndex(), arg_0 -> JVMTranslationPreparer.doOperand$lambda-9(JVMTranslator.this, arg_0));
        }

        @Override
        public void doOperand(@NotNull L2WriteFloatOperand operand) {
            Intrinsics.checkNotNullParameter((Object)operand, (String)"operand");
            Map<Integer, Integer> map = JVMTranslator.this.getLocals().get((Object)L2Register.RegisterKind.FLOAT_KIND);
            Intrinsics.checkNotNull(map);
            map.computeIfAbsent(((L2FloatRegister)operand.register()).finalIndex(), arg_0 -> JVMTranslationPreparer.doOperand$lambda-10(JVMTranslator.this, arg_0));
        }

        @Override
        public void doOperand(@NotNull L2WriteBoxedOperand operand) {
            Intrinsics.checkNotNullParameter((Object)operand, (String)"operand");
            Map<Integer, Integer> map = JVMTranslator.this.getLocals().get((Object)L2Register.RegisterKind.BOXED_KIND);
            Intrinsics.checkNotNull(map);
            map.computeIfAbsent(((L2BoxedRegister)operand.register()).finalIndex(), arg_0 -> JVMTranslationPreparer.doOperand$lambda-11(JVMTranslator.this, arg_0));
        }

        @Override
        public void doOperand(@NotNull L2PcVectorOperand operand) {
            Intrinsics.checkNotNullParameter((Object)operand, (String)"operand");
            Iterable $this$forEach$iv = operand.getEdges();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                L2PcOperand p0 = (L2PcOperand)element$iv;
                boolean bl = false;
                this.doOperand(p0);
            }
        }

        private final String tidy(A_String string2) {
            return this.tidy(string2.asNativeString());
        }

        private final String tidy(String string2) {
            StringBuilder stringBuilder;
            String trimmed = string2.length() > 30 ? StringsKt.take((String)string2, (int)30) + "\u2026" : string2;
            StringBuilder $this$tidy_u24lambda_u2d14 = stringBuilder = new StringBuilder();
            boolean bl = false;
            CharSequence $this$forEach$iv = trimmed;
            boolean $i$f$forEach = false;
            for (int i = 0; i < $this$forEach$iv.length(); ++i) {
                char element$iv;
                char c = element$iv = $this$forEach$iv.charAt(i);
                boolean bl2 = false;
                char c2 = c;
                if (c2 == '.') {
                    $this$tidy_u24lambda_u2d14.append("dot");
                    continue;
                }
                if (c2 == ';') {
                    $this$tidy_u24lambda_u2d14.append("semicolon");
                    continue;
                }
                if (c2 == '[') {
                    $this$tidy_u24lambda_u2d14.append("opensquare");
                    continue;
                }
                if (c2 == '/') {
                    $this$tidy_u24lambda_u2d14.append("slash");
                    continue;
                }
                if (c2 == '\\') {
                    $this$tidy_u24lambda_u2d14.append("backslash");
                    continue;
                }
                boolean bl3 = '\u0000' <= c2 ? c2 < '!' : false;
                if (bl3) {
                    $this$tidy_u24lambda_u2d14.append("__");
                    continue;
                }
                $this$tidy_u24lambda_u2d14.append(c);
            }
            String string3 = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringBuilder().apply(builderAction).toString()");
            return string3;
        }

        private final void recordLiteralObject(Object value) {
            JVMTranslator.this.getLiterals().computeIfAbsent(value, arg_0 -> JVMTranslationPreparer.recordLiteralObject$lambda-15(this, value, JVMTranslator.this, arg_0));
        }

        private static final LiteralAccessor doOperand$lambda-0(JVMTranslator this$0, Object it) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new LiteralAccessor(-1, null, (Function1<? super MethodVisitor, Unit>)((Function1)new Function1<MethodVisitor, Unit>(this$0, it){
                final /* synthetic */ JVMTranslator this$0;
                final /* synthetic */ Object $it;
                {
                    this.this$0 = $receiver;
                    this.$it = $it;
                    super(1);
                }

                public final void invoke(@NotNull MethodVisitor method) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    this.this$0.intConstant(method, (Integer)this.$it);
                }
            }), null);
        }

        private static final LiteralAccessor doOperand$lambda-1(JVMTranslator this$0, Object constant) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)constant, (String)"constant");
            return new LiteralAccessor(-1, null, (Function1<? super MethodVisitor, Unit>)((Function1)new Function1<MethodVisitor, Unit>(this$0, constant){
                final /* synthetic */ JVMTranslator this$0;
                final /* synthetic */ Object $constant;
                {
                    this.this$0 = $receiver;
                    this.$constant = $constant;
                    super(1);
                }

                public final void invoke(@NotNull MethodVisitor method) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    this.this$0.doubleConstant(method, (Double)this.$constant);
                }
            }), null);
        }

        private static final Label doOperand$lambda-2(Integer it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new Label();
        }

        private static final Integer doOperand$lambda-3(JVMTranslator this$0, Integer it) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Type type = Type.INT_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"INT_TYPE");
            return this$0.nextLocal(type);
        }

        private static final Integer doOperand$lambda-4(JVMTranslator this$0, Integer it) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Type type = Type.DOUBLE_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"DOUBLE_TYPE");
            return this$0.nextLocal(type);
        }

        private static final Integer doOperand$lambda-5(JVMTranslator this$0, Integer it) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Type type = Type.getType(AvailObject.class);
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getType(AvailObject::class.java)");
            return this$0.nextLocal(type);
        }

        private static final Integer doOperand$lambda-9(JVMTranslator this$0, Integer it) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Type type = Type.INT_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"INT_TYPE");
            return this$0.nextLocal(type);
        }

        private static final Integer doOperand$lambda-10(JVMTranslator this$0, Integer it) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Type type = Type.DOUBLE_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"DOUBLE_TYPE");
            return this$0.nextLocal(type);
        }

        private static final Integer doOperand$lambda-11(JVMTranslator this$0, Integer it) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Type type = Type.getType(AvailObject.class);
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"getType(AvailObject::class.java)");
            return this$0.nextLocal(type);
        }

        private static final LiteralAccessor recordLiteralObject$lambda-15(JVMTranslationPreparer this$0, Object $value, JVMTranslator this$1, Object constant) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$value, (String)"$value");
            Intrinsics.checkNotNullParameter((Object)this$1, (String)"this$1");
            Intrinsics.checkNotNullParameter((Object)constant, (String)"constant");
            int n = this$0.nextClassLoaderIndex;
            this$0.nextClassLoaderIndex = n + 1;
            int index2 = n;
            Ref.ObjectRef name2 = new Ref.ObjectRef();
            if ($value instanceof Primitive) {
                object = ((Primitive)$value).getName();
            } else if (!($value instanceof AvailObject)) {
                String string2 = $value.getClass().getSimpleName();
                object = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"value.javaClass.simpleName");
            } else {
                object = ((AvailObject)$value).isInstanceOf(TupleTypeDescriptor.Companion.getStringType()) ? "STRING_" + this$0.tidy(((AvailObject)$value).asNativeString()) : (((AvailObject)$value).isInstanceOfKind(PrimitiveTypeDescriptor.Types.ATOM.getO()) ? "ATOM_" + this$0.tidy(A_Atom.Companion.getAtomName((A_Atom)$value)) : (((AvailObject)$value).isInstanceOfKind(PrimitiveTypeDescriptor.Types.MESSAGE_BUNDLE.getO()) ? "BUNDLE_" + this$0.tidy(A_Atom.Companion.getAtomName(A_Bundle.Companion.getMessage((A_Bundle)$value))) : (((AvailObject)$value).isInstanceOfKind(FunctionTypeDescriptor.Companion.mostGeneralFunctionType()) ? "FUNCTION_" + this$0.tidy(A_RawFunction.Companion.getMethodName(((AvailObject)$value).code())) : (((AvailObject)$value).isInstanceOfKind(CompiledCodeTypeDescriptor.Companion.mostGeneralCompiledCodeType()) ? "CODE_" + this$0.tidy(A_RawFunction.Companion.getMethodName((A_RawFunction)$value)) : "literal_" + Companion.getTagEndPattern().matcher(((AvailObject)$value).makeShared().getTypeTag().name()).replaceAll("")))));
            }
            name2.element = object;
            name2.element = name2.element + "_" + index2;
            Class<?> type = constant.getClass();
            FieldVisitor field = this$1.getClassNode().visitField(26, (String)name2.element, Type.getDescriptor(type), null, null);
            field.visitAnnotation(Type.getDescriptor(Nonnull.class), true);
            field.visitEnd();
            return new LiteralAccessor(index2, (String)name2.element, (Function1<? super MethodVisitor, Unit>)((Function1)new Function1<MethodVisitor, Unit>(this$1, (Ref.ObjectRef<String>)name2, type){
                final /* synthetic */ JVMTranslator this$0;
                final /* synthetic */ Ref.ObjectRef<String> $name;
                final /* synthetic */ Class<?> $type;
                {
                    this.this$0 = $receiver;
                    this.$name = $name;
                    this.$type = $type;
                    super(1);
                }

                public final void invoke(@NotNull MethodVisitor method) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    method.visitFieldInsn(178, this.this$0.getClassInternalName(), (String)this.$name.element, Type.getDescriptor(this.$type));
                }
            }), (Function1<? super MethodVisitor, Unit>)((Function1)new Function1<MethodVisitor, Unit>(type, this$1, (Ref.ObjectRef<String>)name2){
                final /* synthetic */ Class<?> $type;
                final /* synthetic */ JVMTranslator this$0;
                final /* synthetic */ Ref.ObjectRef<String> $name;
                {
                    this.$type = $type;
                    this.this$0 = $receiver;
                    this.$name = $name;
                    super(1);
                }

                public final void invoke(@NotNull MethodVisitor method) {
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    method.visitTypeInsn(192, Type.getInternalName(this.$type));
                    method.visitFieldInsn(179, this.this$0.getClassInternalName(), (String)this.$name.element, Type.getDescriptor(this.$type));
                }
            }));
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0080\u0001\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0011B\u001b\b\u0002\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010\u00a8\u0006\u0012"}, d2={"Lavail/optimizer/jvm/JVMTranslator$GenerationPhase;", "", "action", "Lkotlin/Function1;", "Lavail/optimizer/jvm/JVMTranslator;", "", "(Ljava/lang/String;ILkotlin/jvm/functions/Function1;)V", "statistic", "Lavail/performance/Statistic;", "PREPARE", "GENERATE_STATIC_INITIALIZER", "GENERATE_CONSTRUCTOR_V", "GENERATE_NAME", "GENERATE_RUN_CHUNK", "VISIT_END", "CREATE_CLASS_BYTES", "LOAD_CLASS", "Companion", "avail"})
    public static final class GenerationPhase
    extends Enum<GenerationPhase> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final Function1<JVMTranslator, Unit> action;
        @NotNull
        private final Statistic statistic;
        @NotNull
        private static final GenerationPhase[] all;
        public static final /* enum */ GenerationPhase PREPARE;
        public static final /* enum */ GenerationPhase GENERATE_STATIC_INITIALIZER;
        public static final /* enum */ GenerationPhase GENERATE_CONSTRUCTOR_V;
        public static final /* enum */ GenerationPhase GENERATE_NAME;
        public static final /* enum */ GenerationPhase GENERATE_RUN_CHUNK;
        public static final /* enum */ GenerationPhase VISIT_END;
        public static final /* enum */ GenerationPhase CREATE_CLASS_BYTES;
        public static final /* enum */ GenerationPhase LOAD_CLASS;
        private static final /* synthetic */ GenerationPhase[] $VALUES;

        private GenerationPhase(Function1<? super JVMTranslator, Unit> action2) {
            this.action = action2;
            this.statistic = new Statistic(StatisticReport.FINAL_JVM_TRANSLATION_TIME, this.name());
        }

        public static GenerationPhase[] values() {
            return (GenerationPhase[])$VALUES.clone();
        }

        public static GenerationPhase valueOf(String value) {
            return Enum.valueOf(GenerationPhase.class, value);
        }

        static {
            PREPARE = new GenerationPhase((Function1<? super JVMTranslator, Unit>)((Function1)1.INSTANCE));
            GENERATE_STATIC_INITIALIZER = new GenerationPhase((Function1<? super JVMTranslator, Unit>)((Function1)2.INSTANCE));
            GENERATE_CONSTRUCTOR_V = new GenerationPhase((Function1<? super JVMTranslator, Unit>)((Function1)3.INSTANCE));
            GENERATE_NAME = new GenerationPhase((Function1<? super JVMTranslator, Unit>)((Function1)4.INSTANCE));
            GENERATE_RUN_CHUNK = new GenerationPhase((Function1<? super JVMTranslator, Unit>)((Function1)5.INSTANCE));
            VISIT_END = new GenerationPhase((Function1<? super JVMTranslator, Unit>)((Function1)6.INSTANCE));
            CREATE_CLASS_BYTES = new GenerationPhase((Function1<? super JVMTranslator, Unit>)((Function1)7.INSTANCE));
            LOAD_CLASS = new GenerationPhase((Function1<? super JVMTranslator, Unit>)((Function1)8.INSTANCE));
            $VALUES = generationPhaseArray = new GenerationPhase[]{GenerationPhase.PREPARE, GenerationPhase.GENERATE_STATIC_INITIALIZER, GenerationPhase.GENERATE_CONSTRUCTOR_V, GenerationPhase.GENERATE_NAME, GenerationPhase.GENERATE_RUN_CHUNK, GenerationPhase.VISIT_END, GenerationPhase.CREATE_CLASS_BYTES, GenerationPhase.LOAD_CLASS};
            Companion = new Companion(null);
            all = GenerationPhase.values();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lavail/optimizer/jvm/JVMTranslator$GenerationPhase$Companion;", "", "()V", "all", "", "Lavail/optimizer/jvm/JVMTranslator$GenerationPhase;", "[Lavail/optimizer/jvm/JVMTranslator$GenerationPhase;", "executeAll", "", "jvmTranslator", "Lavail/optimizer/jvm/JVMTranslator;", "avail"})
        public static final class Companion {
            private Companion() {
            }

            public final void executeAll(@NotNull JVMTranslator jvmTranslator) {
                AvailThread thread;
                Intrinsics.checkNotNullParameter((Object)jvmTranslator, (String)"jvmTranslator");
                AvailThread availThread = thread = AvailThread.Companion.currentOrNull();
                Interpreter interpreter = availThread != null ? availThread.getInterpreter() : null;
                for (GenerationPhase phase : all) {
                    long before = AvailRuntimeSupport.INSTANCE.captureNanos();
                    phase.action.invoke((Object)jvmTranslator);
                    if (interpreter == null) continue;
                    phase.statistic.record(AvailRuntimeSupport.INSTANCE.captureNanos() - before, interpreter.getInterpreterIndex());
                }
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u00020\u0019H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0002R\u0016\u0010\t\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000eR\u000e\u0010\u0012\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \u0007*\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001b"}, d2={"Lavail/optimizer/jvm/JVMTranslator$Companion;", "", "()V", "callTraceL2AfterEveryInstruction", "", "classNameForbiddenCharacters", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getClassNameForbiddenCharacters$annotations", "classNameUnquoter", "debugJVM", "getDebugJVM", "()Z", "setDebugJVM", "(Z)V", "debugJVMCodeGeneration", "getDebugJVMCodeGeneration", "setDebugJVMCodeGeneration", "debugNicerJavaDecompilation", "moduleNameStripper", "subblockRewriter", "tagEndPattern", "getTagEndPattern", "()Ljava/util/regex/Pattern;", "interpreterLocal", "", "receiverLocal", "avail"})
    public static final class Companion {
        private Companion() {
        }

        private static /* synthetic */ void getClassNameForbiddenCharacters$annotations() {
        }

        @NotNull
        public final Pattern getTagEndPattern() {
            return tagEndPattern;
        }

        private final int receiverLocal() {
            return 0;
        }

        public final int interpreterLocal() {
            return 1;
        }

        public final boolean getDebugJVM() {
            return debugJVM;
        }

        public final void setDebugJVM(boolean bl) {
            debugJVM = bl;
        }

        public final boolean getDebugJVMCodeGeneration() {
            return debugJVMCodeGeneration;
        }

        public final void setDebugJVMCodeGeneration(boolean bl) {
            debugJVMCodeGeneration = bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[L2Register.RegisterKind.values().length];
            nArray[L2Register.RegisterKind.BOXED_KIND.ordinal()] = 1;
            nArray[L2Register.RegisterKind.INTEGER_KIND.ordinal()] = 2;
            nArray[L2Register.RegisterKind.FLOAT_KIND.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

