/*
 * Decompiled with CFR 0.152.
 */
package avail.persistence.cache;

import avail.builder.ResolvedModuleName;
import avail.compiler.ModuleManifestEntry;
import avail.error.ErrorCode;
import avail.persistence.cache.Repository;
import avail.resolver.ResolverReference;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Formatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.availlang.persistence.IndexedFile;
import org.availlang.persistence.IndexedFileBuilder;
import org.availlang.persistence.IndexedFileException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0015\u0018\u0000 ,2\u00020\u0001:\b,-./0123B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0003J\u0006\u0010!\u001a\u00020\u001fJ\b\u0010\"\u001a\u00020\u001fH\u0016J\u0006\u0010#\u001a\u00020\u001fJ\u000e\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020\rJ\u0012\u0010&\u001a\u00060\tR\u00020\u00002\u0006\u0010'\u001a\u00020\u0003J\u0006\u0010(\u001a\u00020\u001fJ\b\u0010)\u001a\u00020\u001fH\u0002J\u0006\u0010*\u001a\u00020\u001fJ\b\u0010+\u001a\u00020\u0003H\u0016R\u001e\u0010\u0007\u001a\f\u0012\b\u0012\u00060\tR\u00020\u00000\b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\b\u0012\u00060\tR\u00020\u00000\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lavail/persistence/cache/Repository;", "Ljava/io/Closeable;", "rootName", "", "fileName", "Ljava/io/File;", "(Ljava/lang/String;Ljava/io/File;)V", "allArchives", "", "Lavail/persistence/cache/Repository$ModuleArchive;", "getAllArchives$avail", "()Ljava/util/List;", "dirtySince", "", "getFileName", "()Ljava/io/File;", "isOpen", "", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "getLock$avail", "()Ljava/util/concurrent/locks/ReentrantLock;", "moduleMap", "", "repository", "Lorg/availlang/persistence/IndexedFile;", "getRepository$avail", "()Lorg/availlang/persistence/IndexedFile;", "setRepository$avail", "(Lorg/availlang/persistence/IndexedFile;)V", "cleanModulesUnder", "", "rootRelativePath", "clear", "close", "commit", "commitIfStaleChanges", "maximumChangeAgeMs", "getArchive", "rootRelativeName", "markDirty", "openOrCreate", "reopenIfNecessary", "toString", "Companion", "IndexedRepositoryBuilder", "LimitedCache", "ModuleArchive", "ModuleCompilation", "ModuleCompilationKey", "ModuleVersion", "ModuleVersionKey", "avail"})
public final class Repository
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String rootName;
    @NotNull
    private final File fileName;
    @NotNull
    private final ReentrantLock lock;
    @Nullable
    private IndexedFile repository;
    private long dirtySince;
    @NotNull
    private final Map<String, ModuleArchive> moduleMap;
    private boolean isOpen;
    private static final Logger logger = Logger.getLogger(Repository.class.getName());
    private static final int MAX_RECORDED_VERSIONS_PER_MODULE = 10;
    private static final int MAX_RECORDED_DIGESTS_PER_MODULE = 20;
    private static final int MAX_HISTORICAL_VERSION_COMPILATIONS = 10;
    private static final boolean DEBUG_REPOSITORY = false;
    private static final int DIGEST_SIZE = 32;
    @NotNull
    private static final Function2<Integer, Integer, Boolean> versionCheck = Companion.versionCheck.1.INSTANCE;

    public Repository(@NotNull String rootName, @NotNull File fileName) {
        Intrinsics.checkNotNullParameter((Object)rootName, (String)"rootName");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        this.rootName = rootName;
        this.fileName = fileName;
        this.lock = new ReentrantLock();
        this.moduleMap = new LinkedHashMap();
        this.openOrCreate();
    }

    @NotNull
    public final File getFileName() {
        return this.fileName;
    }

    @NotNull
    public final ReentrantLock getLock$avail() {
        return this.lock;
    }

    @Nullable
    public final IndexedFile getRepository$avail() {
        return this.repository;
    }

    public final void setRepository$avail(@Nullable IndexedFile indexedFile) {
        this.repository = indexedFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<ModuleArchive> getAllArchives$avail() {
        List<ModuleArchive> list;
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            list = this.moduleMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Repository::_get_allArchives_$lambda-1$lambda-0).toList();
        }
        finally {
            lock.unlock();
        }
        List<ModuleArchive> list2 = Collections.unmodifiableList(list);
        Intrinsics.checkNotNullExpressionValue(list2, (String)"unmodifiableList(\n\t\t\tloc\u2026ue }\n\t\t\t\t\t.toList()\n\t\t\t})");
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ModuleArchive getArchive(@NotNull String rootRelativeName2) {
        ModuleArchive moduleArchive;
        Intrinsics.checkNotNullParameter((Object)rootRelativeName2, (String)"rootRelativeName");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl;
            boolean bl2 = false;
            boolean bl3 = bl = !StringsKt.startsWith$default((String)rootRelativeName2, (String)"/", (boolean)false, (int)2, null);
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            ModuleArchive moduleArchive2 = this.moduleMap.computeIfAbsent(rootRelativeName2, arg_0 -> ModuleArchive.new(this, arg_0));
            moduleArchive = moduleArchive2;
        }
        finally {
            lock.unlock();
        }
        Intrinsics.checkNotNullExpressionValue((Object)moduleArchive, (String)"lock.withLock {\n\t\t\tasser\u2026 this::ModuleArchive)\n\t\t}");
        return moduleArchive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() throws IndexedFileException {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            Level level = Level.INFO;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"INFO");
            Object[] objectArray = new Object[]{this.rootName};
            Companion.log(level, "Clear: %s%n", objectArray);
            this.moduleMap.clear();
            IndexedFile indexedFile = this.repository;
            Intrinsics.checkNotNull((Object)indexedFile);
            IndexedFile repo = indexedFile;
            repo.close();
            this.repository = null;
            try {
                this.fileName.delete();
                this.repository = IndexedFileBuilder.openOrCreate$default((IndexedFileBuilder)IndexedRepositoryBuilder.INSTANCE, (File)this.fileName, (boolean)true, null, (int)0, (int)0, (int)0, (int)0, (int)0, null, (int)508, null);
                this.isOpen = true;
            }
            catch (Exception e) {
                throw new IndexedFileException((Throwable)e);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void cleanModulesUnder(@NotNull String rootRelativePath) {
        Intrinsics.checkNotNullParameter((Object)rootRelativePath, (String)"rootRelativePath");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            for (Map.Entry<String, ModuleArchive> entry : this.moduleMap.entrySet()) {
                String moduleKey = entry.getKey();
                ModuleArchive archive = entry.getValue();
                if (!Intrinsics.areEqual((Object)moduleKey, (Object)rootRelativePath) && !StringsKt.startsWith$default((String)moduleKey, (String)(rootRelativePath + "/"), (boolean)false, (int)2, null)) continue;
                archive.cleanCompilations();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    public final void markDirty() {
        if (this.dirtySince == 0L) {
            this.dirtySince = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void commit() throws IndexedFileException {
        Lock lock = this.lock;
        lock.lock();
        try {
            block12: {
                boolean bl = false;
                try {
                    if (this.dirtySince == 0L) break block12;
                    Level level = Level.FINER;
                    Intrinsics.checkNotNullExpressionValue((Object)level, (String)"FINER");
                    Object[] objectArray = new Object[]{this.rootName};
                    Companion.log(level, "Commit: %s%n", objectArray);
                    IndexedFile.ByteArrayOutputStream byteStream = new IndexedFile.ByteArrayOutputStream(131072);
                    Closeable closeable = new DataOutputStream((OutputStream)byteStream);
                    Throwable throwable = null;
                    try {
                        DataOutputStream binaryStream = (DataOutputStream)closeable;
                        boolean bl2 = false;
                        binaryStream.writeInt(this.moduleMap.size());
                        for (ModuleArchive moduleArchive : this.moduleMap.values()) {
                            moduleArchive.write(binaryStream);
                        }
                        Level level2 = Level.FINEST;
                        Intrinsics.checkNotNullExpressionValue((Object)level2, (String)"FINEST");
                        Object[] objectArray2 = new Object[]{byteStream.size()};
                        Companion.log(level2, "Commit size = %d%n", objectArray2);
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    this.reopenIfNecessary();
                    IndexedFile indexedFile = this.repository;
                    Intrinsics.checkNotNull((Object)indexedFile);
                    IndexedFile repo = indexedFile;
                    repo.setMetadata(byteStream.toByteArray());
                    repo.commit();
                    this.dirtySince = 0L;
                }
                catch (IndexedFileException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IndexedFileException((Throwable)e);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void commitIfStaleChanges(long maximumChangeAgeMs) {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            if (this.dirtySince != 0L && System.currentTimeMillis() - this.dirtySince > maximumChangeAgeMs) {
                this.commit();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            Level level = Level.FINE;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"FINE");
            Object[] objectArray = new Object[]{this.rootName};
            Companion.log(level, "Close: %s%n", objectArray);
            this.isOpen = false;
            IndexedFile indexedFile = this.repository;
            if (indexedFile != null) {
                indexedFile.close();
            }
            this.moduleMap.clear();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void openOrCreate() throws IndexedFileException {
        boolean bl;
        boolean bl2 = bl = !this.isOpen;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        try {
            Object object;
            IndexedFile indexedFile;
            try {
                indexedFile = IndexedFileBuilder.openOrCreate$default((IndexedFileBuilder)IndexedRepositoryBuilder.INSTANCE, (File)this.fileName, (boolean)true, null, (int)0, (int)0, (int)0, (int)0, (int)0, versionCheck, (int)252, null);
            }
            catch (IndexedFileException e) {
                Level level = Level.INFO;
                Intrinsics.checkNotNullExpressionValue((Object)level, (String)"INFO");
                object = new Object[]{this.fileName};
                Companion.log(level, e, "Deleting obsolete repository: %s", object);
                this.fileName.delete();
                indexedFile = IndexedFileBuilder.openOrCreate$default((IndexedFileBuilder)IndexedRepositoryBuilder.INSTANCE, (File)this.fileName, (boolean)true, null, (int)0, (int)0, (int)0, (int)0, (int)0, versionCheck, (int)252, null);
            }
            IndexedFile repo = indexedFile;
            byte[] metadata = repo.getMetadata();
            if (metadata != null) {
                ByteArrayInputStream byteStream = new ByteArrayInputStream(metadata);
                object = new DataInputStream(byteStream);
                Throwable throwable = null;
                try {
                    boolean bl3;
                    DataInputStream binaryStream = (DataInputStream)object;
                    boolean bl4 = false;
                    int moduleCount = binaryStream.readInt();
                    while (moduleCount-- > 0) {
                        ModuleArchive archive = new ModuleArchive(binaryStream);
                        this.moduleMap.put(archive.getRootRelativeName$avail(), archive);
                    }
                    boolean bl5 = bl3 = byteStream.available() == 0;
                    if (_Assertions.ENABLED && !bl3) {
                        String string3 = "Assertion failed";
                        throw new AssertionError((Object)string3);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
            this.repository = repo;
            this.isOpen = true;
        }
        catch (IOException e) {
            throw new IndexedFileException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void reopenIfNecessary() {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            Level level = Level.FINE;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"FINE");
            Object[] objectArray = new Object[]{this.rootName, this.isOpen};
            Companion.log(level, "Reopen if necessary %s (was open = %s)%n", objectArray);
            if (!this.isOpen) {
                this.openOrCreate();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    @NotNull
    public String toString() {
        Formatter out2 = new Formatter();
        Object[] objectArray = new Object[]{this.rootName};
        out2.format("Repository \"%s\" with modules:", objectArray);
        for (Map.Entry entry : this.moduleMap.entrySet()) {
            String key = (String)entry.getKey();
            ModuleArchive value = (ModuleArchive)entry.getValue();
            Object[] objectArray2 = new Object[]{key, value};
            out2.format("%n\t%s \u2192 %s", objectArray2);
        }
        String string2 = out2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"out.toString()");
        return string2;
    }

    private static final ModuleArchive _get_allArchives_$lambda-1$lambda-0(Map.Entry it) {
        return (ModuleArchive)it.getValue();
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lavail/persistence/cache/Repository$IndexedRepositoryBuilder;", "Lorg/availlang/persistence/IndexedFileBuilder;", "()V", "avail"})
    private static final class IndexedRepositoryBuilder
    extends IndexedFileBuilder {
        @NotNull
        public static final IndexedRepositoryBuilder INSTANCE = new IndexedRepositoryBuilder();

        private IndexedRepositoryBuilder() {
            super("Avail compiled module repository V5");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010&\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u001e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003j\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002`\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001e\u0010\b\u001a\u00020\t2\u0014\u0010\n\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001\u0018\u00010\u000bH\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lavail/persistence/cache/Repository$LimitedCache;", "K", "V", "Ljava/util/LinkedHashMap;", "Lkotlin/collections/LinkedHashMap;", "maximumSize", "", "(I)V", "removeEldestEntry", "", "eldest", "", "avail"})
    public static final class LimitedCache<K, V>
    extends LinkedHashMap<K, V> {
        private final int maximumSize;

        public LimitedCache(int maximumSize) {
            super(maximumSize, 0.75f, true);
            boolean bl;
            this.maximumSize = maximumSize;
            boolean bl2 = bl = this.maximumSize > 0;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
        }

        @Override
        protected boolean removeEldestEntry(@Nullable Map.Entry<? extends K, ? extends V> eldest) {
            return this.size() > this.maximumSize;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0019\u001a\u00020\u001aJF\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u001a0!2\u001a\u0010\"\u001a\u0016\u0012\u0004\u0012\u00020$\u0012\u0006\u0012\u0004\u0018\u00010%\u0012\u0004\u0012\u00020\u001a0#J\u0014\u0010&\u001a\b\u0018\u00010\u000bR\u00020\f2\u0006\u0010'\u001a\u00020\nJ\u0017\u0010(\u001a\u0004\u0018\u00010\u00122\u0006\u0010)\u001a\u00020*H\u0000\u00a2\u0006\u0002\b+J\"\u0010,\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\n2\u0006\u0010-\u001a\u00020.2\n\u0010/\u001a\u000600R\u00020\fJ\u001a\u00101\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\n2\n\u00102\u001a\u00060\u000bR\u00020\fJ\u000e\u00103\u001a\u00020\u001a2\u0006\u0010\u0002\u001a\u000204R!\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u00060\u000bR\u00020\f0\t8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R2\u0010\u0016\u001a&\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u00060\u000bR\u00020\f0\u0017j\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u00060\u000bR\u00020\f`\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00065"}, d2={"Lavail/persistence/cache/Repository$ModuleArchive;", "", "binaryStream", "Ljava/io/DataInputStream;", "(Lavail/persistence/cache/Repository;Ljava/io/DataInputStream;)V", "rootRelativeName", "", "(Lavail/persistence/cache/Repository;Ljava/lang/String;)V", "allKnownVersions", "Ljava/util/SortedMap;", "Lavail/persistence/cache/Repository$ModuleVersionKey;", "Lavail/persistence/cache/Repository$ModuleVersion;", "Lavail/persistence/cache/Repository;", "getAllKnownVersions", "()Ljava/util/SortedMap;", "digestCache", "Lavail/persistence/cache/Repository$LimitedCache;", "", "", "lastUpdate", "getRootRelativeName$avail", "()Ljava/lang/String;", "versions", "Ljava/util/LinkedHashMap;", "Lkotlin/collections/LinkedHashMap;", "cleanCompilations", "", "digestForFile", "resolvedModuleName", "Lavail/builder/ResolvedModuleName;", "forceRefreshDigest", "", "withDigest", "Lkotlin/Function1;", "failureHandler", "Lkotlin/Function2;", "Lavail/error/ErrorCode;", "", "getVersion", "versionKey", "provideDigest", "reference", "Lavail/resolver/ResolverReference;", "provideDigest$avail", "putCompilation", "compilationKey", "Lavail/persistence/cache/Repository$ModuleCompilationKey;", "compilation", "Lavail/persistence/cache/Repository$ModuleCompilation;", "putVersion", "version", "write", "Ljava/io/DataOutputStream;", "avail"})
    public final class ModuleArchive {
        @NotNull
        private final LinkedHashMap<ModuleVersionKey, ModuleVersion> versions;
        @NotNull
        private final String rootRelativeName;
        private long lastUpdate;
        @NotNull
        private final LimitedCache<Long, byte[]> digestCache;

        @NotNull
        public final String getRootRelativeName$avail() {
            return this.rootRelativeName;
        }

        @Nullable
        public final byte[] provideDigest$avail(@NotNull ResolverReference reference) {
            Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
            if (!Intrinsics.areEqual((Object)this.rootRelativeName, (Object)reference.getModuleName().getRootRelativeName())) {
                boolean bl = false;
                String string2 = reference.getQualifiedName() + " attempted to access archive for " + this.rootRelativeName;
                throw new IllegalArgumentException(string2.toString());
            }
            return (byte[])this.digestCache.get(reference.getLastModified());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final SortedMap<ModuleVersionKey, ModuleVersion> getAllKnownVersions() {
            Map map;
            Lock lock = Repository.this.getLock$avail();
            lock.lock();
            try {
                boolean bl = false;
                map = MapsKt.toMap((Map)this.versions);
            }
            finally {
                lock.unlock();
            }
            Map map2 = map;
            SortedMap<ModuleVersionKey, ModuleVersion> sortedMap = Collections.unmodifiableSortedMap(new TreeMap(map2));
            Intrinsics.checkNotNullExpressionValue(sortedMap, (String)"unmodifiableSortedMap(TreeMap(map))");
            return sortedMap;
        }

        public final void digestForFile(@NotNull ResolvedModuleName resolvedModuleName, boolean forceRefreshDigest, @NotNull Function1<? super byte[], Unit> withDigest, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
            Intrinsics.checkNotNullParameter((Object)resolvedModuleName, (String)"resolvedModuleName");
            Intrinsics.checkNotNullParameter(withDigest, (String)"withDigest");
            Intrinsics.checkNotNullParameter(failureHandler, (String)"failureHandler");
            boolean bl = Intrinsics.areEqual((Object)resolvedModuleName.getRootRelativeName(), (Object)this.rootRelativeName);
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            ResolverReference sourceReference = resolvedModuleName.getResolverReference();
            long lastModification = sourceReference.getLastModified();
            byte[] digest = (byte[])this.digestCache.get(lastModification);
            if (digest != null && !forceRefreshDigest) {
                withDigest.invoke((Object)digest);
                return;
            }
            Function2 success2 = (Function2)new Function2<byte[], Long, Unit>(lastModification, Repository.this, withDigest, this){
                final /* synthetic */ long $lastModification;
                final /* synthetic */ Repository this$0;
                final /* synthetic */ Function1<byte[], Unit> $withDigest;
                final /* synthetic */ ModuleArchive this$1;
                {
                    this.$lastModification = $lastModification;
                    this.this$0 = $receiver;
                    this.$withDigest = $withDigest;
                    this.this$1 = $receiver2;
                    super(2);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public final void invoke(@NotNull byte[] newDigest, long lastModified) {
                    boolean bl;
                    Intrinsics.checkNotNullParameter((Object)newDigest, (String)"newDigest");
                    boolean bl2 = bl = newDigest.length == 32;
                    if (_Assertions.ENABLED && !bl) {
                        String string2 = "Assertion failed";
                        throw new AssertionError((Object)string2);
                    }
                    if (lastModified >= this.$lastModification) {
                        Lock lock = this.this$0.getLock$avail();
                        ModuleArchive moduleArchive = this.this$1;
                        Repository repository = this.this$0;
                        lock.lock();
                        try {
                            boolean bl3 = false;
                            Long l = lastModified;
                            ((Map)ModuleArchive.access$getDigestCache$p(moduleArchive)).put(l, newDigest);
                            ModuleArchive.access$setLastUpdate$p(moduleArchive, lastModified);
                            repository.markDirty();
                            Unit unit = Unit.INSTANCE;
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                    this.$withDigest.invoke((Object)newDigest);
                }
            };
            sourceReference.digest$avail(forceRefreshDigest, (Function2<? super byte[], ? super Long, Unit>)success2, failureHandler);
        }

        public final void write(@NotNull DataOutputStream binaryStream) throws IOException {
            Intrinsics.checkNotNullParameter((Object)binaryStream, (String)"binaryStream");
            binaryStream.writeUTF(this.rootRelativeName);
            binaryStream.writeInt(this.digestCache.size());
            for (Map.Entry entry : ((Map)this.digestCache).entrySet()) {
                long key = ((Number)entry.getKey()).longValue();
                byte[] value = (byte[])entry.getValue();
                binaryStream.writeLong(key);
                binaryStream.write(value);
            }
            binaryStream.writeInt(this.versions.size());
            for (Map.Entry entry : ((Map)this.versions).entrySet()) {
                ModuleVersionKey key = (ModuleVersionKey)entry.getKey();
                ModuleVersion value = (ModuleVersion)entry.getValue();
                key.write(binaryStream);
                value.write$avail(binaryStream);
            }
        }

        public ModuleArchive(DataInputStream binaryStream) throws IOException {
            Intrinsics.checkNotNullParameter((Object)binaryStream, (String)"binaryStream");
            this.versions = new LinkedHashMap(10, 0.75f, true);
            this.digestCache = new LimitedCache(20);
            String string2 = binaryStream.readUTF();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"binaryStream.readUTF()");
            this.rootRelativeName = string2;
            int digestCount = binaryStream.readInt();
            while (digestCount-- > 0) {
                long lastModification = binaryStream.readLong();
                byte[] digest = new byte[32];
                binaryStream.readFully(digest);
                Long l = lastModification;
                ((Map)this.digestCache).put(l, digest);
            }
            int versionCount = binaryStream.readInt();
            while (versionCount-- > 0) {
                ModuleVersionKey versionKey = new ModuleVersionKey(binaryStream);
                ModuleVersion version = new ModuleVersion(binaryStream);
                ((Map)this.versions).put(versionKey, version);
            }
        }

        public ModuleArchive(String rootRelativeName2) {
            Intrinsics.checkNotNullParameter((Object)rootRelativeName2, (String)"rootRelativeName");
            this.versions = new LinkedHashMap(10, 0.75f, true);
            this.digestCache = new LimitedCache(20);
            this.rootRelativeName = rootRelativeName2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final ModuleVersion getVersion(@NotNull ModuleVersionKey versionKey) {
            ModuleVersion moduleVersion;
            Intrinsics.checkNotNullParameter((Object)versionKey, (String)"versionKey");
            Lock lock = Repository.this.getLock$avail();
            lock.lock();
            try {
                boolean bl = false;
                moduleVersion = this.versions.get(versionKey);
            }
            finally {
                lock.unlock();
            }
            return moduleVersion;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void putVersion(@NotNull ModuleVersionKey versionKey, @NotNull ModuleVersion version) {
            Intrinsics.checkNotNullParameter((Object)versionKey, (String)"versionKey");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Lock lock = Repository.this.getLock$avail();
            Repository repository = Repository.this;
            lock.lock();
            try {
                boolean bl = false;
                ((Map)this.versions).put(versionKey, version);
                repository.markDirty();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void putCompilation(@NotNull ModuleVersionKey versionKey, @NotNull ModuleCompilationKey compilationKey, @NotNull ModuleCompilation compilation) {
            Intrinsics.checkNotNullParameter((Object)versionKey, (String)"versionKey");
            Intrinsics.checkNotNullParameter((Object)compilationKey, (String)"compilationKey");
            Intrinsics.checkNotNullParameter((Object)compilation, (String)"compilation");
            Lock lock = Repository.this.getLock$avail();
            Repository repository = Repository.this;
            lock.lock();
            try {
                boolean bl = false;
                ModuleVersion moduleVersion = this.versions.get(versionKey);
                Intrinsics.checkNotNull((Object)moduleVersion);
                ModuleVersion version = moduleVersion;
                ((Map)version.getCompilations$avail()).put(compilationKey, compilation);
                repository.markDirty();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }

        public final void cleanCompilations() {
            this.versions.clear();
        }

        public static final /* synthetic */ LimitedCache access$getDigestCache$p(ModuleArchive $this) {
            return $this.digestCache;
        }

        public static final /* synthetic */ void access$setLastUpdate$p(ModuleArchive $this, long l) {
            $this.lastUpdate = l;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0011\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0000H\u0096\u0002J\b\u0010\u0016\u001a\u00020\u000bH\u0002J\u0013\u0010\u0017\u001a\u00020\r2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0018H\u0096\u0002J\b\u0010\u0019\u001a\u00020\u000bH\u0016J\b\u0010\u001a\u001a\u00020\u000fH\u0016J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u001dR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001e"}, d2={"Lavail/persistence/cache/Repository$ModuleVersionKey;", "", "binaryStream", "Ljava/io/DataInputStream;", "(Ljava/io/DataInputStream;)V", "moduleName", "Lavail/builder/ResolvedModuleName;", "sourceDigest", "", "(Lavail/builder/ResolvedModuleName;[B)V", "hash", "", "isPackage", "", "shortString", "", "getShortString", "()Ljava/lang/String;", "getSourceDigest", "()[B", "compareTo", "other", "computeHash", "equals", "", "hashCode", "toString", "write", "", "Ljava/io/DataOutputStream;", "avail"})
    public static final class ModuleVersionKey
    implements Comparable<ModuleVersionKey> {
        private final boolean isPackage;
        @NotNull
        private final byte[] sourceDigest;
        private final int hash;

        @NotNull
        public final byte[] getSourceDigest() {
            return this.sourceDigest;
        }

        public int hashCode() {
            return this.hash;
        }

        private final int computeHash() {
            long h = this.isPackage ? 3735928559L : 2896935534L;
            for (byte digestByte : this.sourceDigest) {
                h = h * (long)1664525 + (long)digestByte;
            }
            return (int)h;
        }

        public boolean equals(@Nullable Object other) {
            if (other == null) {
                return false;
            }
            if (!(other instanceof ModuleVersionKey)) {
                return false;
            }
            ModuleVersionKey key = (ModuleVersionKey)other;
            return this.hash == key.hash && this.isPackage == key.isPackage && Arrays.equals(this.sourceDigest, key.sourceDigest);
        }

        public final void write(@NotNull DataOutputStream binaryStream) throws IOException {
            Intrinsics.checkNotNullParameter((Object)binaryStream, (String)"binaryStream");
            binaryStream.writeBoolean(this.isPackage);
            binaryStream.write(this.sourceDigest);
        }

        @NotNull
        public String toString() {
            String string2 = "VersionKey(@%s...)";
            Object[] objectArray = new Object[]{this.getShortString()};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
            return string3;
        }

        public ModuleVersionKey(@NotNull DataInputStream binaryStream) throws IOException {
            Intrinsics.checkNotNullParameter((Object)binaryStream, (String)"binaryStream");
            this.isPackage = binaryStream.readBoolean();
            this.sourceDigest = new byte[32];
            binaryStream.readFully(this.sourceDigest);
            this.hash = this.computeHash();
        }

        public ModuleVersionKey(@NotNull ResolvedModuleName moduleName2, @NotNull byte[] sourceDigest) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)moduleName2, (String)"moduleName");
            Intrinsics.checkNotNullParameter((Object)sourceDigest, (String)"sourceDigest");
            boolean bl2 = bl = sourceDigest.length == 32;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            this.sourceDigest = (byte[])sourceDigest.clone();
            this.isPackage = moduleName2.isPackage();
            this.hash = this.computeHash();
        }

        @NotNull
        public final String getShortString() {
            String string2 = "%02x%02x%02x";
            Object[] objectArray = new Object[]{this.sourceDigest[0], this.sourceDigest[1], this.sourceDigest[2]};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
            return string3;
        }

        @Override
        public int compareTo(@NotNull ModuleVersionKey other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            for (int i = 0; i < this.sourceDigest.length && i < other.sourceDigest.length; ++i) {
                int d = (this.sourceDigest[i] & 0xFF) - (other.sourceDigest[i] & 0xFF);
                if (d == 0) continue;
                return d;
            }
            return this.sourceDigest.length - other.sourceDigest.length;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\n\u001a\u00020\tH\u0002J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000e\u001a\u00020\tH\u0016J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u0011R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lavail/persistence/cache/Repository$ModuleCompilationKey;", "", "binaryStream", "Ljava/io/DataInputStream;", "(Ljava/io/DataInputStream;)V", "predecessorCompilationTimes", "", "([J)V", "hash", "", "computeHash", "equals", "", "other", "hashCode", "write", "", "Ljava/io/DataOutputStream;", "avail"})
    public static final class ModuleCompilationKey {
        @NotNull
        private final long[] predecessorCompilationTimes;
        private final int hash;

        public int hashCode() {
            return this.hash;
        }

        private final int computeHash() {
            long h = 2656633125L;
            for (long predecessorCompilationTime : this.predecessorCompilationTimes) {
                h = Companion.mix$avail((int)h, predecessorCompilationTime);
            }
            return (int)h;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(@Nullable Object other) {
            if (other == null) {
                return false;
            }
            if (!(other instanceof ModuleCompilationKey)) {
                return false;
            }
            ModuleCompilationKey key = (ModuleCompilationKey)other;
            if (this.hash != key.hash) return false;
            if (!Arrays.equals(this.predecessorCompilationTimes, key.predecessorCompilationTimes)) return false;
            return true;
        }

        public final void write(@NotNull DataOutputStream binaryStream) throws IOException {
            Intrinsics.checkNotNullParameter((Object)binaryStream, (String)"binaryStream");
            binaryStream.writeInt(this.predecessorCompilationTimes.length);
            for (long predecessorCompilationTime : this.predecessorCompilationTimes) {
                binaryStream.writeLong(predecessorCompilationTime);
            }
        }

        public ModuleCompilationKey(@NotNull DataInputStream binaryStream) throws IOException {
            Intrinsics.checkNotNullParameter((Object)binaryStream, (String)"binaryStream");
            int predecessorsCount = binaryStream.readInt();
            this.predecessorCompilationTimes = new long[predecessorsCount];
            for (int i = 0; i < predecessorsCount; ++i) {
                this.predecessorCompilationTimes[i] = binaryStream.readLong();
            }
            this.hash = this.computeHash();
        }

        public ModuleCompilationKey(@NotNull long[] predecessorCompilationTimes) {
            Intrinsics.checkNotNullParameter((Object)predecessorCompilationTimes, (String)"predecessorCompilationTimes");
            this.predecessorCompilationTimes = (long[])predecessorCompilationTimes.clone();
            this.hash = this.computeHash();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B+\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0002\u0010\u000bJ\u0014\u0010!\u001a\b\u0018\u00010\rR\u00020\u000e2\u0006\u0010\"\u001a\u00020\u0017J\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u000e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0012J\u000e\u0010'\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0012J\b\u0010(\u001a\u00020\tH\u0016J\u0015\u0010)\u001a\u00020%2\u0006\u0010\u0002\u001a\u00020*H\u0000\u00a2\u0006\u0002\b+R\u001b\u0010\f\u001a\f\u0012\b\u0012\u00060\rR\u00020\u000e0\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R$\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u0017\u0012\b\u0012\u00060\rR\u00020\u000e0\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\t0\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0010R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001d\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0014R\u000e\u0010\u001f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lavail/persistence/cache/Repository$ModuleVersion;", "", "binaryStream", "Ljava/io/DataInputStream;", "(Lavail/persistence/cache/Repository;Ljava/io/DataInputStream;)V", "moduleSize", "", "localImportNames", "", "", "entryPoints", "(Lavail/persistence/cache/Repository;JLjava/util/List;Ljava/util/List;)V", "allCompilations", "Lavail/persistence/cache/Repository$ModuleCompilation;", "Lavail/persistence/cache/Repository;", "getAllCompilations", "()Ljava/util/List;", "comments", "", "getComments", "()[B", "compilations", "Lavail/persistence/cache/Repository$LimitedCache;", "Lavail/persistence/cache/Repository$ModuleCompilationKey;", "getCompilations$avail", "()Lavail/persistence/cache/Repository$LimitedCache;", "", "imports", "getImports", "moduleHeader", "getModuleHeader", "moduleHeaderRecordNumber", "stacksRecordNumber", "getCompilation", "compilationKey", "getEntryPoints", "putComments", "", "bytes", "putModuleHeader", "toString", "write", "Ljava/io/DataOutputStream;", "write$avail", "avail"})
    public final class ModuleVersion {
        private final long moduleSize;
        @NotNull
        private final List<String> localImportNames;
        @NotNull
        private final List<String> entryPoints;
        @NotNull
        private final LimitedCache<ModuleCompilationKey, ModuleCompilation> compilations;
        private long moduleHeaderRecordNumber;
        private long stacksRecordNumber;

        @NotNull
        public final LimitedCache<ModuleCompilationKey, ModuleCompilation> getCompilations$avail() {
            return this.compilations;
        }

        @NotNull
        public final List<String> getImports() {
            List<String> list = Collections.unmodifiableList(this.localImportNames);
            Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(localImportNames)");
            return list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final byte[] getModuleHeader() {
            byte[] byArray;
            boolean bl;
            boolean bl2 = bl = this.moduleHeaderRecordNumber != -1L;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            Lock lock = Repository.this.getLock$avail();
            Repository repository = Repository.this;
            lock.lock();
            try {
                boolean bl3 = false;
                IndexedFile indexedFile = repository.getRepository$avail();
                Intrinsics.checkNotNull((Object)indexedFile);
                byArray = indexedFile.get(this.moduleHeaderRecordNumber);
            }
            finally {
                lock.unlock();
            }
            return byArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final byte[] getComments() {
            byte[] byArray;
            if (this.stacksRecordNumber == -1L) {
                byArray = null;
            } else {
                Lock lock = Repository.this.getLock$avail();
                Repository repository = Repository.this;
                lock.lock();
                try {
                    boolean bl = false;
                    IndexedFile indexedFile = repository.getRepository$avail();
                    Intrinsics.checkNotNull((Object)indexedFile);
                    byte[] byArray2 = indexedFile.get(this.stacksRecordNumber);
                    byArray = byArray2;
                }
                finally {
                    lock.unlock();
                }
            }
            return byArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final List<ModuleCompilation> getAllCompilations() {
            List list;
            Lock lock = Repository.this.getLock$avail();
            lock.lock();
            try {
                boolean bl = false;
                Collection<ModuleCompilation> collection = this.compilations.values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"compilations.values");
                list = CollectionsKt.toList((Iterable)collection);
            }
            finally {
                lock.unlock();
            }
            return list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public final ModuleCompilation getCompilation(@NotNull ModuleCompilationKey compilationKey) {
            ModuleCompilation moduleCompilation;
            Intrinsics.checkNotNullParameter((Object)compilationKey, (String)"compilationKey");
            Lock lock = Repository.this.getLock$avail();
            lock.lock();
            try {
                boolean bl = false;
                moduleCompilation = (ModuleCompilation)this.compilations.get(compilationKey);
            }
            finally {
                lock.unlock();
            }
            return moduleCompilation;
        }

        @NotNull
        public final List<String> getEntryPoints() {
            List<String> list = Collections.unmodifiableList(this.entryPoints);
            Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(entryPoints)");
            return list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void putModuleHeader(@NotNull byte[] bytes) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Lock lock = Repository.this.getLock$avail();
            Repository repository = Repository.this;
            lock.lock();
            try {
                boolean bl = false;
                IndexedFile indexedFile = repository.getRepository$avail();
                Intrinsics.checkNotNull((Object)indexedFile);
                IndexedFile repo = indexedFile;
                this.moduleHeaderRecordNumber = IndexedFile.add$default((IndexedFile)repo, (byte[])bytes, (int)0, (int)0, (int)6, null);
                repository.markDirty();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void putComments(@NotNull byte[] bytes) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            Lock lock = Repository.this.getLock$avail();
            Repository repository = Repository.this;
            lock.lock();
            try {
                boolean bl = false;
                IndexedFile indexedFile = repository.getRepository$avail();
                Intrinsics.checkNotNull((Object)indexedFile);
                IndexedFile repo = indexedFile;
                this.stacksRecordNumber = IndexedFile.add$default((IndexedFile)repo, (byte[])bytes, (int)0, (int)0, (int)6, null);
                repository.markDirty();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }

        public final void write$avail(@NotNull DataOutputStream binaryStream) throws IOException {
            Intrinsics.checkNotNullParameter((Object)binaryStream, (String)"binaryStream");
            binaryStream.writeLong(this.moduleSize);
            binaryStream.writeInt(this.localImportNames.size());
            for (String entry : this.localImportNames) {
                binaryStream.writeUTF(entry);
            }
            binaryStream.writeInt(this.entryPoints.size());
            for (String string2 : this.entryPoints) {
                binaryStream.writeUTF(string2);
            }
            binaryStream.writeInt(this.compilations.size());
            for (Map.Entry entry : ((Map)this.compilations).entrySet()) {
                ModuleCompilationKey key = (ModuleCompilationKey)entry.getKey();
                ModuleCompilation value = (ModuleCompilation)entry.getValue();
                key.write(binaryStream);
                value.write$avail(binaryStream);
            }
            binaryStream.writeLong(this.moduleHeaderRecordNumber);
            binaryStream.writeLong(this.stacksRecordNumber);
        }

        @NotNull
        public String toString() {
            String string2 = "Version:%n\t\timports=%s%s%n\t\tcompilations=%s%n\t\tmoduleHeaderRecordNumber=%d%n\t\tstacksRecordNumber=%d%n";
            Object[] objectArray = new Object[]{this.localImportNames, this.entryPoints.isEmpty() ? "" : "\n\t\tentry points=" + this.entryPoints, this.compilations.values(), this.moduleHeaderRecordNumber, this.stacksRecordNumber};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
            return string3;
        }

        public ModuleVersion(DataInputStream binaryStream) throws IOException {
            Intrinsics.checkNotNullParameter((Object)binaryStream, (String)"binaryStream");
            this.compilations = new LimitedCache(10);
            this.moduleHeaderRecordNumber = -1L;
            this.stacksRecordNumber = -1L;
            this.moduleSize = binaryStream.readLong();
            int localImportCount = binaryStream.readInt();
            this.localImportNames = new ArrayList();
            while (localImportCount-- > 0) {
                String string2 = binaryStream.readUTF();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"binaryStream.readUTF()");
                this.localImportNames.add(string2);
            }
            int entryPointCount = binaryStream.readInt();
            this.entryPoints = new ArrayList();
            while (entryPointCount-- > 0) {
                String string3 = binaryStream.readUTF();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"binaryStream.readUTF()");
                this.entryPoints.add(string3);
            }
            int compilationsCount = binaryStream.readInt();
            while (compilationsCount-- > 0) {
                ((Map)this.compilations).put(new ModuleCompilationKey(binaryStream), new ModuleCompilation(binaryStream));
            }
            this.moduleHeaderRecordNumber = binaryStream.readLong();
            this.stacksRecordNumber = binaryStream.readLong();
        }

        public ModuleVersion(@NotNull long moduleSize, @NotNull List<String> localImportNames, List<String> entryPoints) {
            Intrinsics.checkNotNullParameter(localImportNames, (String)"localImportNames");
            Intrinsics.checkNotNullParameter(entryPoints, (String)"entryPoints");
            this.compilations = new LimitedCache(10);
            this.moduleHeaderRecordNumber = -1L;
            this.stacksRecordNumber = -1L;
            this.moduleSize = moduleSize;
            this.localImportNames = CollectionsKt.toMutableList((Collection)localImportNames);
            this.entryPoints = CollectionsKt.toMutableList((Collection)entryPoints);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B-\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0015\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0002\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b\u001eR\u0011\u0010\u000e\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\u0015\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0011\u0010\u0017\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lavail/persistence/cache/Repository$ModuleCompilation;", "", "binaryStream", "Ljava/io/DataInputStream;", "(Lavail/persistence/cache/Repository;Ljava/io/DataInputStream;)V", "compilationTime", "", "serializedBody", "", "serializedBlockPhrases", "manifestEntries", "", "Lavail/compiler/ModuleManifestEntry;", "(Lavail/persistence/cache/Repository;J[B[BLjava/util/List;)V", "bytes", "getBytes", "()[B", "getCompilationTime", "()J", "recordNumber", "getRecordNumber", "recordNumberOfBlockPhrases", "getRecordNumberOfBlockPhrases", "recordNumberOfManifestEntries", "getRecordNumberOfManifestEntries", "toString", "", "write", "", "Ljava/io/DataOutputStream;", "write$avail", "avail"})
    public final class ModuleCompilation {
        private final long compilationTime;
        private final long recordNumber;
        private final long recordNumberOfBlockPhrases;
        private final long recordNumberOfManifestEntries;

        public final long getCompilationTime() {
            return this.compilationTime;
        }

        public final long getRecordNumber() {
            return this.recordNumber;
        }

        public final long getRecordNumberOfBlockPhrases() {
            return this.recordNumberOfBlockPhrases;
        }

        public final long getRecordNumberOfManifestEntries() {
            return this.recordNumberOfManifestEntries;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final byte[] getBytes() {
            byte[] byArray;
            Lock lock = Repository.this.getLock$avail();
            Repository repository = Repository.this;
            lock.lock();
            try {
                boolean bl = false;
                IndexedFile indexedFile = repository.getRepository$avail();
                Intrinsics.checkNotNull((Object)indexedFile);
                byArray = indexedFile.get(this.recordNumber);
            }
            finally {
                lock.unlock();
            }
            return byArray;
        }

        public final void write$avail(@NotNull DataOutputStream binaryStream) throws IOException {
            Intrinsics.checkNotNullParameter((Object)binaryStream, (String)"binaryStream");
            binaryStream.writeLong(this.compilationTime);
            binaryStream.writeLong(this.recordNumber);
            binaryStream.writeLong(this.recordNumberOfBlockPhrases);
            binaryStream.writeLong(this.recordNumberOfManifestEntries);
        }

        @NotNull
        public String toString() {
            String string2 = "Compilation(%tFT%<tTZ, rec=%d, phrases=%d, manifest=%d)";
            Object[] objectArray = new Object[]{this.compilationTime, this.recordNumber, this.recordNumberOfBlockPhrases, this.recordNumberOfManifestEntries};
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
            return string3;
        }

        public ModuleCompilation(DataInputStream binaryStream) throws IOException {
            Intrinsics.checkNotNullParameter((Object)binaryStream, (String)"binaryStream");
            this.compilationTime = binaryStream.readLong();
            this.recordNumber = binaryStream.readLong();
            this.recordNumberOfBlockPhrases = binaryStream.readLong();
            this.recordNumberOfManifestEntries = binaryStream.readLong();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ModuleCompilation(@NotNull long compilationTime, @NotNull byte[] serializedBody, @NotNull byte[] serializedBlockPhrases, List<ModuleManifestEntry> manifestEntries) {
            Intrinsics.checkNotNullParameter((Object)serializedBody, (String)"serializedBody");
            Intrinsics.checkNotNullParameter((Object)serializedBlockPhrases, (String)"serializedBlockPhrases");
            Intrinsics.checkNotNullParameter(manifestEntries, (String)"manifestEntries");
            this.compilationTime = compilationTime;
            IndexedFile indexedFile = Repository.this.getRepository$avail();
            Intrinsics.checkNotNull((Object)indexedFile);
            IndexedFile repo = indexedFile;
            long indexOfRecord = 0L;
            long indexOfBlockPhrasesRecord = 0L;
            long indexOfManifestEntries = 0L;
            IndexedFile.ByteArrayOutputStream innerSerializedManifestEntries = new IndexedFile.ByteArrayOutputStream(4096);
            DataOutputStream serializedManifestEntries = new DataOutputStream((OutputStream)innerSerializedManifestEntries);
            Iterable $this$forEach$iv = manifestEntries;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ModuleManifestEntry entry = (ModuleManifestEntry)element$iv;
                boolean bl = false;
                entry.write(serializedManifestEntries);
            }
            IndexedFile.Companion.appendCRC(innerSerializedManifestEntries);
            Lock lock = Repository.this.getLock$avail();
            lock.lock();
            try {
                boolean bl = false;
                indexOfRecord = IndexedFile.add$default((IndexedFile)repo, (byte[])serializedBody, (int)0, (int)0, (int)6, null);
                indexOfBlockPhrasesRecord = IndexedFile.add$default((IndexedFile)repo, (byte[])serializedBlockPhrases, (int)0, (int)0, (int)6, null);
                byte[] byArray = innerSerializedManifestEntries.toByteArray();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"innerSerializedManifestEntries.toByteArray()");
                indexOfManifestEntries = IndexedFile.add$default((IndexedFile)repo, (byte[])byArray, (int)0, (int)0, (int)6, null);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
            this.recordNumber = indexOfRecord;
            this.recordNumberOfBlockPhrases = indexOfBlockPhrasesRecord;
            this.recordNumberOfManifestEntries = indexOfManifestEntries;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u0014J\u000e\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0019J/\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00142\u0012\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010 \"\u00020\u0001\u00a2\u0006\u0002\u0010!J7\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001e\u001a\u00020\u00142\u0012\u0010\u001f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010 \"\u00020\u0001\u00a2\u0006\u0002\u0010$J\u001d\u0010%\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u00062\u0006\u0010'\u001a\u00020(H\u0000\u00a2\u0006\u0002\b)R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00040\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006*"}, d2={"Lavail/persistence/cache/Repository$Companion;", "", "()V", "DEBUG_REPOSITORY", "", "DIGEST_SIZE", "", "MAX_HISTORICAL_VERSION_COMPILATIONS", "MAX_RECORDED_DIGESTS_PER_MODULE", "MAX_RECORDED_VERSIONS_PER_MODULE", "logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "versionCheck", "Lkotlin/Function2;", "getVersionCheck$avail", "()Lkotlin/jvm/functions/Function2;", "createTemporary", "Lavail/persistence/cache/Repository;", "rootName", "", "prefix", "suffix", "isIndexedRepositoryFile", "path", "Ljava/io/File;", "log", "", "level", "Ljava/util/logging/Level;", "format", "args", "", "(Ljava/util/logging/Level;Ljava/lang/String;[Ljava/lang/Object;)V", "exception", "", "(Ljava/util/logging/Level;Ljava/lang/Throwable;Ljava/lang/String;[Ljava/lang/Object;)V", "mix", "currentHash", "newLong", "", "mix$avail", "avail"})
    public static final class Companion {
        private Companion() {
        }

        public final void log(@NotNull Level level, @NotNull String format, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        }

        public final void log(@NotNull Level level, @NotNull Throwable exception, @NotNull String format, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)level, (String)"level");
            Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        }

        public final int mix$avail(int currentHash, long newLong) {
            int h = currentHash;
            h *= 1664525;
            h += (int)newLong;
            h *= 1664525;
            return h ^= (int)(newLong >> 32);
        }

        @NotNull
        public final Function2<Integer, Integer, Boolean> getVersionCheck$avail() {
            return versionCheck;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final Repository createTemporary(@NotNull String rootName, @NotNull String prefix, @Nullable String suffix) {
            Repository repository;
            Intrinsics.checkNotNullParameter((Object)rootName, (String)"rootName");
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            try {
                File file2 = File.createTempFile(prefix, suffix);
                file2.deleteOnExit();
                IndexedFile indexedFile = null;
                IndexedFileBuilder indexedFileBuilder = IndexedRepositoryBuilder.INSTANCE;
                Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
                IndexedFile indexedFile2 = indexedFile = IndexedFileBuilder.openOrCreate$default((IndexedFileBuilder)indexedFileBuilder, (File)file2, (boolean)true, null, (int)0, (int)0, (int)0, (int)0, (int)0, null, (int)508, null);
                if (indexedFile2 != null) {
                    indexedFile2.close();
                }
                repository = new Repository(rootName, file2);
            }
            catch (Exception e) {
                throw new IndexedFileException((Throwable)e);
            }
            return repository;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean isIndexedRepositoryFile(@NotNull File path) throws IOException {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            if (path.isFile()) {
                Closeable closeable = new RandomAccessFile(path, "r");
                Throwable throwable = null;
                try {
                    int bytesRead;
                    RandomAccessFile file2 = (RandomAccessFile)closeable;
                    boolean bl = false;
                    byte[] repositoryHeader = IndexedRepositoryBuilder.INSTANCE.getHeaderBytes();
                    byte[] buffer = new byte[repositoryHeader.length];
                    int pos = 0;
                    while ((bytesRead = file2.read(buffer, pos, buffer.length - pos)) != -1 && (pos += bytesRead) != buffer.length) {
                    }
                    boolean bl2 = pos == buffer.length && Arrays.equals(repositoryHeader, buffer);
                    return bl2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

