/*
 * Decompiled with CFR 0.152.
 */
package avail.persistence.cache;

import avail.AvailRuntime;
import avail.compiler.ModuleManifestEntry;
import avail.persistence.cache.Repository;
import avail.serialization.DeserializerDescriber;
import avail.utility.Strings;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.availlang.persistence.IndexedFile;
import org.availlang.persistence.MalformedSerialStreamException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\nJ\u0006\u0010\r\u001a\u00020\bJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\f\u001a\u00020\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lavail/persistence/cache/RepositoryDescriber;", "", "repository", "Lavail/persistence/cache/Repository;", "(Lavail/persistence/cache/Repository;)V", "getRepository$avail", "()Lavail/persistence/cache/Repository;", "describeCompilation", "", "recordNumber", "", "describeManifest", "recordNumberOfManifestEntries", "dumpAll", "manifestEntries", "", "Lavail/compiler/ModuleManifestEntry;", "avail"})
public final class RepositoryDescriber {
    @NotNull
    private final Repository repository;

    public RepositoryDescriber(@NotNull Repository repository) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        this.repository = repository;
    }

    @NotNull
    public final Repository getRepository$avail() {
        return this.repository;
    }

    @NotNull
    public final String dumpAll() {
        StringBuilder stringBuilder;
        StringBuilder $this$dumpAll_u24lambda_u2d3 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$dumpAll_u24lambda_u2d3.append("Structure of repository " + this.repository.getFileName() + ":");
        List<Repository.ModuleArchive> archives = this.repository.getAllArchives$avail();
        for (Repository.ModuleArchive archive : archives) {
            Strings.INSTANCE.newlineTab($this$dumpAll_u24lambda_u2d3, 0);
            $this$dumpAll_u24lambda_u2d3.append(archive.getRootRelativeName$avail());
            SortedMap<Repository.ModuleVersionKey, Repository.ModuleVersion> versionMap = archive.getAllKnownVersions();
            Map $this$forEach$iv = versionMap;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator2.next();
                boolean bl2 = false;
                Repository.ModuleVersionKey versionKey = (Repository.ModuleVersionKey)entry.getKey();
                Repository.ModuleVersion version = (Repository.ModuleVersion)entry.getValue();
                Strings.INSTANCE.newlineTab($this$dumpAll_u24lambda_u2d3, 1);
                $this$dumpAll_u24lambda_u2d3.append("digest=" + versionKey.getShortString());
                Iterable $this$forEach$iv2 = version.getAllCompilations();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    Repository.ModuleCompilation compilation = (Repository.ModuleCompilation)element$iv2;
                    boolean bl3 = false;
                    Repository.ModuleCompilation $this$dumpAll_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1_u24lambda_u2d0 = compilation;
                    boolean bl4 = false;
                    Strings.INSTANCE.newlineTab($this$dumpAll_u24lambda_u2d3, 2);
                    Object[] objectArray = new Object[]{$this$dumpAll_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1_u24lambda_u2d0.getCompilationTime()};
                    $this$dumpAll_u24lambda_u2d3.append(String.format("Time: %tFT%<tTZ", objectArray));
                    Strings.INSTANCE.newlineTab($this$dumpAll_u24lambda_u2d3, 3);
                    $this$dumpAll_u24lambda_u2d3.append("Compilation #" + $this$dumpAll_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1_u24lambda_u2d0.getRecordNumber());
                    Strings.INSTANCE.newlineTab($this$dumpAll_u24lambda_u2d3, 3);
                    $this$dumpAll_u24lambda_u2d3.append("Phrases #" + $this$dumpAll_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1_u24lambda_u2d0.getRecordNumberOfBlockPhrases());
                    Strings.INSTANCE.newlineTab($this$dumpAll_u24lambda_u2d3, 3);
                    $this$dumpAll_u24lambda_u2d3.append("Manifest #" + $this$dumpAll_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1_u24lambda_u2d0.getRecordNumberOfManifestEntries());
                }
            }
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    @NotNull
    public final String describeCompilation(long recordNumber) {
        String string2;
        IndexedFile indexedFile = this.repository.getRepository$avail();
        Intrinsics.checkNotNull((Object)indexedFile);
        byte[] record = indexedFile.get(recordNumber);
        try {
            ByteArrayInputStream stream = IndexedFile.Companion.validatedBytesFrom(record);
            DeserializerDescriber describer = new DeserializerDescriber(stream, AvailRuntime.Companion.currentRuntime());
            string2 = describer.describe();
        }
        catch (MalformedSerialStreamException e) {
            string2 = "Serialized record is malformed";
        }
        return string2;
    }

    @NotNull
    public final String describeManifest(long recordNumberOfManifestEntries) {
        StringBuilder stringBuilder;
        IndexedFile indexedFile = this.repository.getRepository$avail();
        Intrinsics.checkNotNull((Object)indexedFile);
        byte[] record = indexedFile.get(recordNumberOfManifestEntries);
        StringBuilder $this$describeManifest_u24lambda_u2d5 = stringBuilder = new StringBuilder();
        boolean bl = false;
        DataInputStream input = new DataInputStream(IndexedFile.Companion.validatedBytesFrom(record));
        while (input.available() > 0) {
            ModuleManifestEntry $this$describeManifest_u24lambda_u2d5_u24lambda_u2d4 = new ModuleManifestEntry(input);
            boolean bl2 = false;
            $this$describeManifest_u24lambda_u2d5.append($this$describeManifest_u24lambda_u2d5_u24lambda_u2d4.getKind() + " " + $this$describeManifest_u24lambda_u2d5_u24lambda_u2d4.getSummaryText() + "\n");
            $this$describeManifest_u24lambda_u2d5.append("\ttopLevel = " + $this$describeManifest_u24lambda_u2d5_u24lambda_u2d4.getTopLevelStartingLine() + "\n");
            $this$describeManifest_u24lambda_u2d5.append("\tdefBody = " + $this$describeManifest_u24lambda_u2d5_u24lambda_u2d4.getDefinitionStartingLine() + "\n");
            $this$describeManifest_u24lambda_u2d5.append("\tbodyPhrase# = " + $this$describeManifest_u24lambda_u2d5_u24lambda_u2d4.getBodyPhraseIndexNumber() + "\n");
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    @NotNull
    public final List<ModuleManifestEntry> manifestEntries(long recordNumberOfManifestEntries) {
        IndexedFile indexedFile = this.repository.getRepository$avail();
        Intrinsics.checkNotNull((Object)indexedFile);
        byte[] record = indexedFile.get(recordNumberOfManifestEntries);
        DataInputStream input = new DataInputStream(IndexedFile.Companion.validatedBytesFrom(record));
        List entries2 = new ArrayList();
        while (input.available() > 0) {
            entries2.add(new ModuleManifestEntry(input));
        }
        return entries2;
    }
}

