/*
 * Decompiled with CFR 0.152.
 */
package avail.resolver;

import avail.builder.ModuleRootErrorCode;
import avail.error.ErrorCode;
import avail.error.StandardErrorCode;
import avail.files.AvailFile;
import avail.files.FileErrorCode;
import avail.files.FileManager;
import avail.resolver.JarModuleRootResolver;
import avail.resolver.ModuleRootResolver;
import avail.resolver.ResolverReference;
import avail.resolver.ResourceType;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.annotation.concurrent.GuardedBy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.NoSuchFileException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0004\u0018\u0000 32\u00020\u0001:\u00013B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J:\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00032\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00162\u001a\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0004\u0012\u00020\u00120\u0018H\u0016JB\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00032\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00162\u001a\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0004\u0012\u00020\u00120\u0018H\u0016J:\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00032\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00162\u001a\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0004\u0012\u00020\u00120\u0018H\u0016J:\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00032\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00162\u001a\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0004\u0012\u00020\u00120\u0018H\u0016JP\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\"2\u001a\u0010#\u001a\u0016\u0012\u0004\u0012\u00020$\u0012\u0006\u0012\u0004\u0018\u00010%\u0012\u0004\u0012\u00020\u00120\u00182\u001a\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0004\u0012\u00020\u00120\u0018H\u0016J@\u0010&\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\u00120(2\u001a\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0004\u0012\u00020\u00120\u0018H\u0016JF\u0010*\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"2\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\u00120\u00182\u001a\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0004\u0012\u00020\u00120\u0018H\u0016J8\u0010+\u001a\u00020\u00122\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u00120(2\u001a\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0004\u0012\u00020\u00120\u0018H\u0016J\b\u0010,\u001a\u00020\nH\u0016JF\u0010-\u001a\u00020\u00122\u0006\u0010.\u001a\u00020\n2\u0018\u0010/\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\"00\u0012\u0004\u0012\u00020\u00120(2\u001a\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0004\u0012\u00020\u00120\u0018H\u0016JB\u00101\u001a\u00020\u00122\u0006\u0010!\u001a\u00020\"2\u0006\u00102\u001a\u00020$2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00120\u00162\u001a\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u001a\u0012\u0004\u0012\u00020\u00120\u0018H\u0016R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u0004\u0018\u00010\u000e8\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lavail/resolver/JarModuleRootResolver;", "Lavail/resolver/ModuleRootResolver;", "name", "", "uri", "Ljava/net/URI;", "fileManager", "Lavail/files/FileManager;", "(Ljava/lang/String;Ljava/net/URI;Lavail/files/FileManager;)V", "canSave", "", "getCanSave", "()Z", "jarFile", "Ljava/util/jar/JarFile;", "jarFileLock", "Ljava/util/concurrent/locks/ReentrantLock;", "close", "", "createDirectory", "qualifiedName", "completion", "Lkotlin/Function0;", "failureHandler", "Lkotlin/Function2;", "Lavail/error/ErrorCode;", "", "createFile", "mimeType", "createPackage", "deleteResource", "readFile", "bypassFileManager", "reference", "Lavail/resolver/ResolverReference;", "withContents", "", "Ljava/util/UUID;", "refreshResolverMetaData", "successHandler", "Lkotlin/Function1;", "", "refreshResolverReferenceDigest", "resolve", "resolvesToValidModuleRoot", "rootManifest", "forceRefresh", "withList", "", "saveFile", "fileContents", "Companion", "avail"})
public final class JarModuleRootResolver
extends ModuleRootResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReentrantLock jarFileLock;
    @GuardedBy(value="jarFileLock")
    @Nullable
    private JarFile jarFile;
    @NotNull
    public static final String availSourcesPathInJar = "Avail-Sources/";
    @NotNull
    public static final String availDigestsPathInJar = "Avail-Digests/all_digests.txt";

    public JarModuleRootResolver(@NotNull String name2, @NotNull URI uri, @NotNull FileManager fileManager) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter((Object)fileManager, (String)"fileManager");
        super(name2, uri, fileManager);
        this.jarFileLock = new ReentrantLock();
    }

    @Override
    public boolean getCanSave() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Lock lock = this.jarFileLock;
        lock.lock();
        try {
            boolean bl = false;
            JarFile jarFile = this.jarFile;
            if (jarFile != null) {
                jarFile.close();
            }
            this.jarFile = null;
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public boolean resolvesToValidModuleRoot() {
        return new File(this.getUri().getPath()).isFile();
    }

    @Override
    public void resolve(@NotNull Function1<? super ResolverReference, Unit> successHandler, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Intrinsics.checkNotNullParameter(successHandler, (String)"successHandler");
        Intrinsics.checkNotNullParameter(failureHandler, (String)"failureHandler");
        this.executeTask((Function0<Unit>)((Function0)new Function0<Unit>(this, failureHandler, successHandler){
            final /* synthetic */ JarModuleRootResolver this$0;
            final /* synthetic */ Function2<ErrorCode, Throwable, Unit> $failureHandler;
            final /* synthetic */ Function1<ResolverReference, Unit> $successHandler;
            {
                this.this$0 = $receiver;
                this.$failureHandler = $failureHandler;
                this.$successHandler = $successHandler;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke() {
                Map map = new LinkedHashMap<K, V>();
                String rootPrefix = "/" + this.this$0.getModuleRoot().getName();
                try {
                    void $this$forEach$iv;
                    Enumeration<JarEntry> $i$a$-withLock-JarModuleRootResolver$resolve$1$entries$22;
                    String[] stream;
                    Map digests = new LinkedHashMap<K, V>();
                    Object object = JarModuleRootResolver.access$getJarFileLock$p(this.this$0);
                    JarModuleRootResolver jarModuleRootResolver = this.this$0;
                    object.lock();
                    try {
                        void $this$forEach$iv2;
                        Object element$iv$iv;
                        Iterator<T> $this$filterTo$iv$iv;
                        Iterable $this$filter$iv;
                        boolean $i$a$-withLock-JarModuleRootResolver$resolve$1$entries$22 = false;
                        JarModuleRootResolver.access$setJarFile$p(jarModuleRootResolver, new JarFile(jarModuleRootResolver.getUri().getPath()));
                        JarFile jarFile = JarModuleRootResolver.access$getJarFile$p(jarModuleRootResolver);
                        Intrinsics.checkNotNull((Object)jarFile);
                        ZipEntry zipEntry = jarFile.getEntry("Avail-Digests/all_digests.txt");
                        Intrinsics.checkNotNull((Object)zipEntry);
                        ZipEntry digestEntry = zipEntry;
                        byte[] bytes = new byte[(int)digestEntry.getSize()];
                        JarFile jarFile2 = JarModuleRootResolver.access$getJarFile$p(jarModuleRootResolver);
                        Intrinsics.checkNotNull((Object)jarFile2);
                        stream = new DataInputStream(new BufferedInputStream(jarFile2.getInputStream(digestEntry), 4096));
                        stream.readFully(bytes);
                        String text = new String(bytes, Charsets.UTF_8);
                        Iterable iterable = StringsKt.lines((CharSequence)text);
                        boolean $i$f$filter = false;
                        void var14_20 = $this$filter$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$filterTo = false;
                        Iterator<T> iterator2 = $this$filterTo$iv$iv.iterator();
                        while (iterator2.hasNext()) {
                            element$iv$iv = iterator2.next();
                            String p0 = (String)element$iv$iv;
                            boolean bl = false;
                            if (!(((CharSequence)p0).length() > 0)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filter$iv = (List)destination$iv$iv;
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv2) {
                            String line = (String)element$iv;
                            boolean bl = false;
                            element$iv$iv = new String[]{":"};
                            List list = StringsKt.split$default((CharSequence)line, element$iv$iv, (boolean)false, (int)0, (int)6, null);
                            String innerFileName = (String)list.get(0);
                            String digestString = (String)list.get(1);
                            int n = 0;
                            int n2 = digestString.length() >>> 1;
                            byte[] byArray = new byte[n2];
                            while (n < n2) {
                                int n3 = n++;
                                String string2 = digestString.substring(n3 << 1, (n3 << 1) + 2);
                                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                                byArray[n3] = (byte)Integer.parseInt(string2, CharsKt.checkRadix((int)16));
                            }
                            byte[] digestBytes = byArray;
                            digests.put(innerFileName, digestBytes);
                        }
                        JarFile jarFile3 = JarModuleRootResolver.access$getJarFile$p(jarModuleRootResolver);
                        Intrinsics.checkNotNull((Object)jarFile3);
                        $i$a$-withLock-JarModuleRootResolver$resolve$1$entries$22 = jarFile3.entries();
                    }
                    finally {
                        object.unlock();
                    }
                    Enumeration<JarEntry> entries2 = $i$a$-withLock-JarModuleRootResolver$resolve$1$entries$22;
                    Intrinsics.checkNotNullExpressionValue(entries2, (String)"entries");
                    object = CollectionsKt.iterator(entries2);
                    while (object.hasNext()) {
                        ResourceType resourceType;
                        String name2;
                        JarEntry entry = (JarEntry)object.next();
                        String string3 = name2 = entry.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"name");
                        if (!StringsKt.startsWith$default((String)string3, (String)"Avail-Sources/", (boolean)false, (int)2, null)) continue;
                        String string4 = name2;
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"name");
                        name2 = StringsKt.removePrefix((String)string4, (CharSequence)"Avail-Sources/");
                        String string5 = entry.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"entry.name");
                        if (StringsKt.endsWith$default((String)string5, (String)".avail/", (boolean)false, (int)2, null)) {
                            resourceType = ResourceType.PACKAGE;
                        } else {
                            String string6 = name2;
                            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"name");
                            if (StringsKt.endsWith$default((String)string6, (String)"/", (boolean)false, (int)2, null)) {
                                resourceType = ResourceType.DIRECTORY;
                            } else {
                                String string7 = name2;
                                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"name");
                                if (StringsKt.endsWith$default((String)string7, (String)".avail", (boolean)false, (int)2, null)) {
                                    boolean bytes;
                                    boolean bl = bytes = !entry.isDirectory();
                                    if (_Assertions.ENABLED && !bytes) {
                                        stream = "Assertion failed";
                                        throw new AssertionError(stream);
                                    }
                                    String string8 = name2;
                                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"name");
                                    stream = new String[]{"/"};
                                    List parts = StringsKt.split$default((CharSequence)string8, (String[])stream, (boolean)false, (int)0, (int)6, null);
                                    resourceType = parts.size() >= 2 && Intrinsics.areEqual((Object)CollectionsKt.last((List)parts), parts.get(parts.size() - 2)) ? ResourceType.REPRESENTATIVE : ResourceType.MODULE;
                                } else {
                                    resourceType = ResourceType.RESOURCE;
                                }
                            }
                        }
                        ResourceType type = resourceType;
                        String string9 = name2;
                        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"name");
                        String string10 = name2 = StringsKt.removeSuffix((String)string9, (CharSequence)"/");
                        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"name");
                        stream = new String[]{"/"};
                        String qualifiedName2 = CollectionsKt.joinToString$default((Iterable)StringsKt.split$default((CharSequence)string10, (String[])stream, (boolean)false, (int)0, (int)6, null), (CharSequence)"/", (CharSequence)(rootPrefix + "/"), null, (int)0, null, (Function1)resolve.qualifiedName.1.INSTANCE, (int)28, null);
                        String mimeType = switch (resolve.WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                            case 1, 2 -> "text/plain";
                            default -> "";
                        };
                        ResolverReference reference = new ResolverReference(this.this$0, new URI(null, entry.getName(), null), qualifiedName2, type, mimeType, entry.getLastModifiedTime().toMillis(), entry.getSize(), null, (byte[])digests.get(name2), 128, null);
                        map.put(qualifiedName2, reference);
                    }
                    map.put(rootPrefix, new ResolverReference(this.this$0, new URI(rootPrefix), rootPrefix, ResourceType.ROOT, "", 0L, 0L, this.this$0.getModuleRoot().getName(), null, 256, null));
                    object = map;
                    jarModuleRootResolver = this.this$0;
                    boolean $i$f$forEach = false;
                    Iterator<Map.Entry<K, V>> iterator3 = $this$forEach$iv.entrySet().iterator();
                    while (iterator3.hasNext()) {
                        ResolverReference parentNode;
                        String parentName2;
                        Map.Entry<K, V> element$iv;
                        Map.Entry<K, V> entry = element$iv = iterator3.next();
                        boolean bl = false;
                        String name3 = (String)entry.getKey();
                        ResolverReference reference = (ResolverReference)entry.getValue();
                        jarModuleRootResolver.getReferenceMap().put(reference.getQualifiedName(), reference);
                        if (!(((CharSequence)name3).length() > 0) || (ResolverReference)map.get(parentName2 = StringsKt.substringBeforeLast((String)name3, (String)"/", (String)"")) == null) continue;
                        boolean bl2 = reference.isResource();
                        if (bl2) {
                            parentNode.getResources().add(reference);
                            continue;
                        }
                        if (bl2) continue;
                        parentNode.getModules().add(reference);
                    }
                }
                catch (Throwable e) {
                    this.$failureHandler.invoke((Object)ModuleRootErrorCode.MODULE_ROOT_RESOLUTION_FAILED, (Object)e);
                    return;
                }
                V v = map.get(rootPrefix);
                Intrinsics.checkNotNull(v);
                ResolverReference rootReference = (ResolverReference)v;
                this.this$0.setModuleRootTree(rootReference);
                this.$successHandler.invoke((Object)rootReference);
            }
        }));
    }

    @Override
    public void rootManifest(boolean forceRefresh, @NotNull Function1<? super List<ResolverReference>, Unit> withList, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Intrinsics.checkNotNullParameter(withList, (String)"withList");
        Intrinsics.checkNotNullParameter(failureHandler, (String)"failureHandler");
        if (!this.getReferenceMap().isEmpty() && !forceRefresh) {
            withList.invoke((Object)CollectionsKt.toList((Iterable)this.getReferenceMap().values()));
            return;
        }
        this.executeTask((Function0<Unit>)((Function0)new Function0<Unit>(this, failureHandler, withList){
            final /* synthetic */ JarModuleRootResolver this$0;
            final /* synthetic */ Function2<ErrorCode, Throwable, Unit> $failureHandler;
            final /* synthetic */ Function1<List<ResolverReference>, Unit> $withList;
            {
                this.this$0 = $receiver;
                this.$failureHandler = $failureHandler;
                this.$withList = $withList;
                super(0);
            }

            public final void invoke() {
                this.this$0.resolve((Function1<? super ResolverReference, Unit>)((Function1)new Function1<ResolverReference, Unit>(this.$withList, this.this$0){
                    final /* synthetic */ Function1<List<ResolverReference>, Unit> $withList;
                    final /* synthetic */ JarModuleRootResolver this$0;
                    {
                        this.$withList = $withList;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull ResolverReference it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.$withList.invoke((Object)CollectionsKt.toList((Iterable)this.this$0.getReferenceMap().values()));
                    }
                }), this.$failureHandler);
            }
        }));
    }

    @Override
    public void refreshResolverMetaData(@NotNull ResolverReference reference, @NotNull Function1<? super Long, Unit> successHandler, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter(successHandler, (String)"successHandler");
        Intrinsics.checkNotNullParameter(failureHandler, (String)"failureHandler");
        this.executeTask((Function0<Unit>)((Function0)new Function0<Unit>(successHandler, reference){
            final /* synthetic */ Function1<Long, Unit> $successHandler;
            final /* synthetic */ ResolverReference $reference;
            {
                this.$successHandler = $successHandler;
                this.$reference = $reference;
                super(0);
            }

            public final void invoke() {
                this.$successHandler.invoke((Object)this.$reference.getLastModified());
            }
        }));
    }

    @Override
    public void refreshResolverReferenceDigest(@NotNull ResolverReference reference, @NotNull Function2<? super byte[], ? super Long, Unit> successHandler, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter(successHandler, (String)"successHandler");
        Intrinsics.checkNotNullParameter(failureHandler, (String)"failureHandler");
        byte[] digest = reference.getForcedDigest();
        if (digest == null) {
            failureHandler.invoke((Object)FileErrorCode.FILE_NOT_FOUND, (Object)new NoSuchFileException(new File(reference.getQualifiedName()), null, "Avail file " + reference.getQualifiedName() + " does not occur in Jar", 2, null));
        } else {
            successHandler.invoke((Object)digest, (Object)reference.getLastModified());
        }
    }

    @Override
    public void createFile(@NotNull String qualifiedName2, @NotNull String mimeType, @NotNull Function0<Unit> completion, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Intrinsics.checkNotNullParameter((Object)qualifiedName2, (String)"qualifiedName");
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        Intrinsics.checkNotNullParameter(failureHandler, (String)"failureHandler");
        failureHandler.invoke((Object)FileErrorCode.PERMISSIONS, null);
    }

    @Override
    public void createPackage(@NotNull String qualifiedName2, @NotNull Function0<Unit> completion, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Intrinsics.checkNotNullParameter((Object)qualifiedName2, (String)"qualifiedName");
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        Intrinsics.checkNotNullParameter(failureHandler, (String)"failureHandler");
        failureHandler.invoke((Object)FileErrorCode.PERMISSIONS, null);
    }

    @Override
    public void createDirectory(@NotNull String qualifiedName2, @NotNull Function0<Unit> completion, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Intrinsics.checkNotNullParameter((Object)qualifiedName2, (String)"qualifiedName");
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        Intrinsics.checkNotNullParameter(failureHandler, (String)"failureHandler");
        failureHandler.invoke((Object)FileErrorCode.PERMISSIONS, null);
    }

    @Override
    public void deleteResource(@NotNull String qualifiedName2, @NotNull Function0<Unit> completion, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Intrinsics.checkNotNullParameter((Object)qualifiedName2, (String)"qualifiedName");
        Intrinsics.checkNotNullParameter(completion, (String)"completion");
        Intrinsics.checkNotNullParameter(failureHandler, (String)"failureHandler");
        failureHandler.invoke((Object)FileErrorCode.PERMISSIONS, null);
    }

    @Override
    public void saveFile(@NotNull ResolverReference reference, @NotNull byte[] fileContents, @NotNull Function0<Unit> successHandler, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)fileContents, (String)"fileContents");
        Intrinsics.checkNotNullParameter(successHandler, (String)"successHandler");
        Intrinsics.checkNotNullParameter(failureHandler, (String)"failureHandler");
        failureHandler.invoke((Object)FileErrorCode.PERMISSIONS, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readFile(boolean bypassFileManager, @NotNull ResolverReference reference, @NotNull Function2<? super byte[], ? super UUID, Unit> withContents, @NotNull Function2<? super ErrorCode, ? super Throwable, Unit> failureHandler) {
        Object object;
        boolean handled2;
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter(withContents, (String)"withContents");
        Intrinsics.checkNotNullParameter(failureHandler, (String)"failureHandler");
        ResourceType[] resourceTypeArray = new ResourceType[]{ResourceType.ROOT, ResourceType.DIRECTORY, ResourceType.PACKAGE};
        if (!(!SetsKt.setOf((Object[])resourceTypeArray).contains((Object)reference.getType()))) {
            boolean bl = false;
            String string2 = reference.getQualifiedName() + " is not a file that can be read!";
            throw new IllegalArgumentException(string2.toString());
        }
        if (!bypassFileManager && (handled2 = this.getFileManager().optionallyProvideExistingFile(reference, (Function2<? super UUID, ? super AvailFile, Unit>)((Function2)new Function2<UUID, AvailFile, Unit>(reference, withContents){
            final /* synthetic */ ResolverReference $reference;
            final /* synthetic */ Function2<byte[], UUID, Unit> $withContents;
            {
                this.$reference = $reference;
                this.$withContents = $withContents;
                super(2);
            }

            public final void invoke(@NotNull UUID uuid, @NotNull AvailFile availFile) {
                Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
                Intrinsics.checkNotNullParameter((Object)availFile, (String)"availFile");
                this.$reference.refresh(availFile.getLastModified(), availFile.getRawContent().length);
                this.$withContents.invoke((Object)availFile.getRawContent(), (Object)uuid);
            }
        }), failureHandler))) {
            return;
        }
        try {
            byte[] $i$a$-withLock-JarModuleRootResolver$readFile$fileContent$22;
            object = this.jarFileLock;
            object.lock();
            try {
                boolean bl;
                boolean $i$a$-withLock-JarModuleRootResolver$readFile$fileContent$22 = false;
                JarFile jarFile = this.jarFile;
                Intrinsics.checkNotNull((Object)jarFile);
                ZipEntry entry = jarFile.getEntry(reference.getUri().getSchemeSpecificPart());
                boolean bl2 = bl = (long)((int)entry.getSize()) == entry.getSize();
                if (_Assertions.ENABLED && !bl) {
                    String string3 = "Assertion failed";
                    throw new AssertionError((Object)string3);
                }
                byte[] bytes = new byte[(int)entry.getSize()];
                JarFile jarFile2 = this.jarFile;
                Intrinsics.checkNotNull((Object)jarFile2);
                DataInputStream stream = new DataInputStream(new BufferedInputStream(jarFile2.getInputStream(entry), 4096));
                stream.readFully(bytes);
                $i$a$-withLock-JarModuleRootResolver$readFile$fileContent$22 = bytes;
            }
            finally {
                object.unlock();
            }
            object = $i$a$-withLock-JarModuleRootResolver$readFile$fileContent$22;
        }
        catch (IOException e) {
            failureHandler.invoke((Object)StandardErrorCode.IO_EXCEPTION, (Object)e);
            return;
        }
        Object fileContent = object;
        withContents.invoke(fileContent, null);
    }

    public static final /* synthetic */ ReentrantLock access$getJarFileLock$p(JarModuleRootResolver $this) {
        return $this.jarFileLock;
    }

    public static final /* synthetic */ void access$setJarFile$p(JarModuleRootResolver $this, JarFile jarFile) {
        $this.jarFile = jarFile;
    }

    public static final /* synthetic */ JarFile access$getJarFile$p(JarModuleRootResolver $this) {
        return $this.jarFile;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lavail/resolver/JarModuleRootResolver$Companion;", "", "()V", "availDigestsPathInJar", "", "availSourcesPathInJar", "avail"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

