/*
 * Decompiled with CFR 0.152.
 */
package avail.serialization;

import avail.AvailRuntime;
import avail.descriptor.atoms.A_Atom;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.performance.Statistic;
import avail.serialization.AbstractDeserializer;
import avail.serialization.FourStreamIndexCompressor;
import avail.serialization.SerializerOperand;
import avail.serialization.SerializerOperation;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.availlang.persistence.MalformedSerialStreamException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000  2\u00020\u0001:\u0001 B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0014\b\u0002\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\rH\u0002J\b\u0010\u0018\u001a\u0004\u0018\u00010\rJ\u0015\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\bH\u0010\u00a2\u0006\u0002\b\u001bJ\u0015\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\rH\u0010\u00a2\u0006\u0002\b\u001eJ\u0006\u0010\u0011\u001a\u00020\u001fR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\r0\u0013X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0014\u00a8\u0006!"}, d2={"Lavail/serialization/Deserializer;", "Lavail/serialization/AbstractDeserializer;", "input", "Ljava/io/InputStream;", "runtime", "Lavail/AvailRuntime;", "lookupPumpedObject", "Lkotlin/Function1;", "", "Lavail/descriptor/representation/A_BasicObject;", "(Ljava/io/InputStream;Lavail/AvailRuntime;Lkotlin/jvm/functions/Function1;)V", "assembledObjects", "", "Lavail/descriptor/representation/AvailObject;", "compressor", "Lavail/serialization/FourStreamIndexCompressor;", "producedObject", "serializedObjects", "subobjectsBuffer", "", "[Lavail/descriptor/representation/AvailObject;", "addObject", "", "newObject", "deserialize", "fromCompressedObjectIndex", "compressedIndex", "fromCompressedObjectIndex$avail", "recordProducedObject", "obj", "recordProducedObject$avail", "Lavail/descriptor/tuples/A_Tuple;", "Companion", "avail"})
public final class Deserializer
extends AbstractDeserializer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<AvailObject> assembledObjects;
    @Nullable
    private AvailObject producedObject;
    @NotNull
    private final AvailObject[] subobjectsBuffer;
    @NotNull
    private final List<AvailObject> serializedObjects;
    @NotNull
    private final FourStreamIndexCompressor compressor;

    public Deserializer(@NotNull InputStream input, @NotNull AvailRuntime runtime, @NotNull Function1<? super Integer, ? extends A_BasicObject> lookupPumpedObject) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)runtime, (String)"runtime");
        Intrinsics.checkNotNullParameter(lookupPumpedObject, (String)"lookupPumpedObject");
        super(input, runtime, lookupPumpedObject);
        this.assembledObjects = new ArrayList();
        int n = 0;
        int n2 = SerializerOperation.Companion.getMaxSubobjects$avail();
        AvailObject[] availObjectArray = new AvailObject[n2];
        Deserializer deserializer2 = this;
        while (n < n2) {
            int n3 = n++;
            availObjectArray[n3] = NilDescriptor.Companion.getNil();
        }
        deserializer2.subobjectsBuffer = availObjectArray;
        this.serializedObjects = new ArrayList();
        this.compressor = new FourStreamIndexCompressor();
    }

    public /* synthetic */ Deserializer(InputStream inputStream, AvailRuntime availRuntime, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            function1 = 1.INSTANCE;
        }
        this(inputStream, availRuntime, (Function1<? super Integer, ? extends A_BasicObject>)function1);
    }

    private final void addObject(AvailObject newObject) {
        this.assembledObjects.add(newObject.makeImmutable());
        this.compressor.incrementIndex();
    }

    @Nullable
    public final AvailObject deserialize() throws MalformedSerialStreamException {
        boolean bl;
        boolean bl2 = bl = this.producedObject == null;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        try {
            if (this.getInput$avail().available() == 0) {
                return null;
            }
            while (this.producedObject == null) {
                long before = System.nanoTime();
                int ordinal = this.readByte();
                SerializerOperation operation = SerializerOperation.Companion.byOrdinal$avail(ordinal);
                SerializerOperand[] operands = operation.getOperands$avail();
                int n = operands.length;
                for (int i = 0; i < n; ++i) {
                    this.subobjectsBuffer[i] = operands[i].read(this);
                }
                A_BasicObject newObject = operation.compose$avail(this.subobjectsBuffer, this);
                newObject.makeImmutable();
                this.addObject((AvailObject)newObject);
                if (operation.getShouldCaptureObject()) {
                    this.serializedObjects.add((AvailObject)newObject);
                }
                Statistic.record$default(operation.getDeserializeStat$avail(), System.nanoTime() - before, 0, 2, null);
            }
            AvailObject temp = this.producedObject;
            this.producedObject = null;
            return temp;
        }
        catch (Exception e) {
            throw new MalformedSerialStreamException((Throwable)e);
        }
    }

    @Override
    @NotNull
    public AvailObject fromCompressedObjectIndex$avail(int compressedIndex) {
        int index2 = this.compressor.decompress(compressedIndex);
        return (Integer.MIN_VALUE <= index2 ? index2 < 0 : false) ? (AvailObject)this.getLookupPumpedObject$avail().invoke((Object)index2) : this.assembledObjects.get(index2);
    }

    @Override
    public void recordProducedObject$avail(@NotNull AvailObject obj) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        boolean bl2 = bl = this.producedObject == null;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.producedObject = obj;
    }

    @NotNull
    public final A_Tuple serializedObjects() {
        return ObjectTupleDescriptor.Companion.tupleFromList(this.serializedObjects).makeShared();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lavail/serialization/Deserializer$Companion;", "", "()V", "specialAtom", "Lavail/descriptor/atoms/A_Atom;", "index", "", "specialAtom$avail", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final A_Atom specialAtom$avail(int index2) {
            return AvailRuntime.Companion.getSpecialAtoms().get(index2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

