/*
 * Decompiled with CFR 0.152.
 */
package avail.stacks;

import avail.stacks.StacksDescription;
import avail.stacks.StacksErrorLog;
import avail.stacks.comment.ModuleComment;
import avail.utility.Strings;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.availlang.json.JSONWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0005J\u001e\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u0005J\u0016\u0010!\u001a\u00020\u001a2\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u000eJ\u000e\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u0014J\u0016\u0010&\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u0005J\u0006\u0010'\u001a\u00020\u0005J\u0006\u0010(\u001a\u00020\u001aJ\u001a\u0010\u0011\u001a\u00020\u001a2\u0012\u0010)\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004J\u000e\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0005J\u0016\u0010-\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201J\u000e\u00102\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020/J\u000e\u00103\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020/J\u0016\u00104\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u000201R#\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR/\u0010\t\u001a \u0012\u0004\u0012\u00020\u0005\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000b0\n0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u000e0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\bR:\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\bR\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001d\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\b\u00a8\u00065"}, d2={"Lavail/stacks/LinkingFileMap;", "", "()V", "aliasesToFileLink", "", "", "", "getAliasesToFileLink", "()Ljava/util/Map;", "categoryMethodList", "", "Lkotlin/Pair;", "getCategoryMethodList", "categoryToDescription", "Lavail/stacks/StacksDescription;", "getCategoryToDescription", "<set-?>", "internalLinks", "getInternalLinks", "moduleComments", "Lavail/stacks/comment/ModuleComment;", "getModuleComments", "()Ljava/util/Set;", "namedFileLinks", "getNamedFileLinks", "addAlias", "", "alias", "fileLink", "addCategoryMethodPair", "categoryName", "methodLeafName", "methodAndMethodLink", "addCategoryToDescription", "name", "description", "addModuleComment", "comment", "addNamedFileLinks", "categoryMethodsToJson", "clear", "links", "isCategory", "", "key", "writeCategoryDescriptionToJSON", "path", "Ljava/nio/file/Path;", "errorLog", "Lavail/stacks/StacksErrorLog;", "writeCategoryLinksToJSON", "writeInternalLinksToJSON", "writeModuleCommentsToJSON", "avail"})
public final class LinkingFileMap {
    @NotNull
    private final Map<String, StacksDescription> categoryToDescription = new LinkedHashMap();
    @NotNull
    private final Set<ModuleComment> moduleComments = new LinkedHashSet();
    @NotNull
    private final Map<String, List<Pair<String, String>>> categoryMethodList = new LinkedHashMap();
    @NotNull
    private final Map<String, Set<String>> aliasesToFileLink = new LinkedHashMap();
    @NotNull
    private final Map<String, String> namedFileLinks = new LinkedHashMap();
    @Nullable
    private Map<String, String> internalLinks;

    @NotNull
    public final Map<String, StacksDescription> getCategoryToDescription() {
        return this.categoryToDescription;
    }

    @NotNull
    public final Set<ModuleComment> getModuleComments() {
        return this.moduleComments;
    }

    @NotNull
    public final Map<String, List<Pair<String, String>>> getCategoryMethodList() {
        return this.categoryMethodList;
    }

    @NotNull
    public final Map<String, Set<String>> getAliasesToFileLink() {
        return this.aliasesToFileLink;
    }

    @NotNull
    public final Map<String, String> getNamedFileLinks() {
        return this.namedFileLinks;
    }

    @Nullable
    public final Map<String, String> getInternalLinks() {
        return this.internalLinks;
    }

    public final void addAlias(@NotNull String alias, @NotNull String fileLink) {
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        Intrinsics.checkNotNullParameter((Object)fileLink, (String)"fileLink");
        if (this.aliasesToFileLink.containsKey(alias)) {
            Set<String> set2 = this.aliasesToFileLink.get(alias);
            Intrinsics.checkNotNull(set2);
            set2.add(fileLink);
        } else {
            Set newLinks = new LinkedHashSet();
            newLinks.add(fileLink);
            this.aliasesToFileLink.put(alias, newLinks);
        }
    }

    public final void addNamedFileLinks(@NotNull String alias, @NotNull String fileLink) {
        Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
        Intrinsics.checkNotNullParameter((Object)fileLink, (String)"fileLink");
        this.namedFileLinks.put(alias, fileLink);
    }

    public final void internalLinks(@NotNull Map<String, String> links) {
        Intrinsics.checkNotNullParameter(links, (String)"links");
        this.internalLinks = links;
    }

    public final void addCategoryToDescription(@NotNull String name2, @NotNull StacksDescription description) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        this.categoryToDescription.put(name2, description);
    }

    public final boolean isCategory(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.categoryToDescription.containsKey(key);
    }

    public final void addCategoryMethodPair(@NotNull String categoryName, @NotNull String methodLeafName, @NotNull String methodAndMethodLink) {
        Intrinsics.checkNotNullParameter((Object)categoryName, (String)"categoryName");
        Intrinsics.checkNotNullParameter((Object)methodLeafName, (String)"methodLeafName");
        Intrinsics.checkNotNullParameter((Object)methodAndMethodLink, (String)"methodAndMethodLink");
        Pair methodPair = TuplesKt.to((Object)methodLeafName, (Object)methodAndMethodLink);
        if (this.categoryMethodList.containsKey(categoryName)) {
            List<Pair<String, String>> list = this.categoryMethodList.get(categoryName);
            Intrinsics.checkNotNull(list);
            list.add((Pair<String, String>)methodPair);
        } else {
            Map<String, List<Pair<String, String>>> map = this.categoryMethodList;
            Object object = new Pair[]{methodPair};
            object = CollectionsKt.mutableListOf((Object[])object);
            map.put(categoryName, (List<Pair<String, String>>)object);
        }
    }

    public final void writeCategoryLinksToJSON(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            StandardOpenOption[] standardOpenOptionArray = new StandardOpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE};
            StandardOpenOption[] options = standardOpenOptionArray;
            BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, (OpenOption[])Arrays.copyOf(options, options.length));
            Intrinsics.checkNotNullExpressionValue((Object)writer, (String)"writer");
            JSONWriter jsonWriter = new JSONWriter((Writer)writer, false, 2, null);
            jsonWriter.startObject();
            jsonWriter.write("categories");
            jsonWriter.startArray();
            for (Map.Entry<String, List<Pair<String, String>>> entry : this.categoryMethodList.entrySet()) {
                String key = entry.getKey();
                List<Pair<String, String>> pairs = entry.getValue();
                jsonWriter.startObject();
                jsonWriter.write("selected");
                jsonWriter.write(false);
                jsonWriter.write("category");
                jsonWriter.write(key);
                jsonWriter.write("methods");
                jsonWriter.startArray();
                for (Pair<String, String> pair : pairs) {
                    String relativeLink;
                    String distinct = "" + pair.getFirst() + pair.getSecond();
                    Intrinsics.checkNotNullExpressionValue((Object)((String)pair.getSecond()).substring(1), (String)"this as java.lang.String).substring(startIndex)");
                    jsonWriter.startObject();
                    jsonWriter.write("methodName");
                    jsonWriter.write((String)pair.getFirst());
                    jsonWriter.write("link");
                    jsonWriter.write(relativeLink);
                    jsonWriter.write("distinct");
                    jsonWriter.write(distinct);
                    jsonWriter.endObject();
                }
                jsonWriter.endArray();
                jsonWriter.endObject();
            }
            jsonWriter.endArray();
            jsonWriter.endObject();
            jsonWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @NotNull
    public final String categoryMethodsToJson() {
        StringBuilder stringBuilder = new StringBuilder().append("[\n");
        List categorySet = CollectionsKt.toList((Iterable)this.categoryMethodList.keySet());
        int setSize = categorySet.size();
        if (setSize > 0) {
            List<Pair<String, String>> methodList;
            int n = setSize - 1;
            for (int j = 0; j < n; ++j) {
                List<Pair<String, String>> methodList2;
                stringBuilder.append(Strings.INSTANCE.tabs(1)).append("{\n").append(Strings.INSTANCE.tabs(2)).append("\"selected\" : false,\n").append(Strings.INSTANCE.tabs(2)).append("\"category\" : \"").append((String)categorySet.get(j)).append("\",\n").append(Strings.INSTANCE.tabs(2)).append("\"methods\" : [\n");
                List<Pair<String, String>> list = methodList2 = this.categoryMethodList.get(categorySet.get(j));
                Intrinsics.checkNotNull(list);
                int listSize = list.size();
                if (listSize <= 0) continue;
                int n2 = listSize - 1;
                for (int i = 0; i < n2; ++i) {
                    Pair<String, String> pair = methodList2.get(i);
                    StringBuilder stringBuilder2 = stringBuilder.append(Strings.INSTANCE.tabs(3)).append("{\"methodName\" : \"").append((String)pair.getFirst()).append("\", \"link\" : \"");
                    String string2 = ((String)pair.getSecond()).substring(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                    stringBuilder2.append(string2).append("\", \"distinct\" : \"").append((String)pair.getFirst()).append((String)pair.getSecond()).append("\"},\n");
                }
                Pair<String, String> lastPair = methodList2.get(listSize - 1);
                StringBuilder stringBuilder3 = stringBuilder.append(Strings.INSTANCE.tabs(3)).append("{\"methodName\" : \"").append((String)lastPair.getFirst()).append("\", \"link\" : \"");
                String string3 = ((String)lastPair.getSecond()).substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                stringBuilder3.append(string3).append("\", \"distinct\" : \"").append((String)lastPair.getFirst()).append((String)lastPair.getSecond()).append("\"}\n").append(Strings.INSTANCE.tabs(2)).append("]\n").append(Strings.INSTANCE.tabs(1)).append("},\n");
            }
            stringBuilder.append(Strings.INSTANCE.tabs(1)).append("{\n").append(Strings.INSTANCE.tabs(2)).append("\"selected\" : ").append("false,\n").append(Strings.INSTANCE.tabs(2)).append("\"category\" : \"").append((String)categorySet.get(setSize - 1)).append("\",\n").append(Strings.INSTANCE.tabs(2)).append("\"methods\" : [\n");
            List<Pair<String, String>> list = methodList = this.categoryMethodList.get(categorySet.get(setSize - 1));
            Intrinsics.checkNotNull(list);
            int listSize = list.size();
            if (listSize > 0) {
                int n3 = listSize - 1;
                for (int i = 0; i < n3; ++i) {
                    Pair<String, String> pair = methodList.get(i);
                    StringBuilder stringBuilder4 = stringBuilder.append(Strings.INSTANCE.tabs(3)).append("{\"methodName\" : \"").append((String)pair.getFirst()).append("\", \"link\" : \"");
                    String string4 = ((String)pair.getSecond()).substring(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
                    stringBuilder4.append(string4).append("\", \"distinct\" : \"").append((String)pair.getFirst()).append((String)pair.getSecond()).append("\"},\n");
                }
                Pair<String, String> lastPair = methodList.get(listSize - 1);
                StringBuilder stringBuilder5 = stringBuilder.append(Strings.INSTANCE.tabs(3)).append("{\"methodName\" : \"").append((String)lastPair.getFirst()).append("\", \"link\" : \"");
                String string5 = ((String)lastPair.getSecond()).substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).substring(startIndex)");
                stringBuilder5.append(string5).append("\", \"distinct\" : \"").append((String)lastPair.getFirst()).append((String)lastPair.getSecond()).append("\"}\n").append(Strings.INSTANCE.tabs(2)).append("]\n").append(Strings.INSTANCE.tabs(1)).append("}\n]");
            }
        }
        String string6 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"stringBuilder.toString()");
        return string6;
    }

    public final void clear() {
        this.categoryMethodList.clear();
        this.categoryToDescription.clear();
    }

    public final void writeInternalLinksToJSON(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        try {
            StandardOpenOption[] standardOpenOptionArray = new StandardOpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE};
            StandardOpenOption[] options = standardOpenOptionArray;
            BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, (OpenOption[])Arrays.copyOf(options, options.length));
            Intrinsics.checkNotNullExpressionValue((Object)writer, (String)"writer");
            JSONWriter jsonWriter = new JSONWriter((Writer)writer, false, 2, null);
            jsonWriter.startObject();
            Map<String, String> map = this.internalLinks;
            Intrinsics.checkNotNull(map);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                jsonWriter.write(key);
                jsonWriter.write(value);
            }
            jsonWriter.endObject();
            jsonWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final void addModuleComment(@NotNull ModuleComment comment) {
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        this.moduleComments.add(comment);
    }

    public final void writeCategoryDescriptionToJSON(@NotNull Path path, @NotNull StacksErrorLog errorLog) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)errorLog, (String)"errorLog");
        try {
            StandardOpenOption[] standardOpenOptionArray = new StandardOpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE};
            StandardOpenOption[] options = standardOpenOptionArray;
            BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, (OpenOption[])Arrays.copyOf(options, options.length));
            Intrinsics.checkNotNullExpressionValue((Object)writer, (String)"writer");
            JSONWriter jsonWriter = new JSONWriter((Writer)writer, false, 2, null);
            jsonWriter.startObject();
            jsonWriter.write("categories");
            jsonWriter.startArray();
            for (Map.Entry<String, StacksDescription> entry : this.categoryToDescription.entrySet()) {
                String key = entry.getKey();
                StacksDescription value = entry.getValue();
                jsonWriter.startObject();
                jsonWriter.write("category");
                jsonWriter.write(key);
                jsonWriter.write("description");
                value.toJSON(this, 0, errorLog, jsonWriter);
                jsonWriter.endObject();
            }
            jsonWriter.endArray();
            jsonWriter.endObject();
            jsonWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public final void writeModuleCommentsToJSON(@NotNull Path path, @NotNull StacksErrorLog errorLog) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)errorLog, (String)"errorLog");
        try {
            StandardOpenOption[] standardOpenOptionArray = new StandardOpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE};
            StandardOpenOption[] options = standardOpenOptionArray;
            BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, (OpenOption[])Arrays.copyOf(options, options.length));
            Intrinsics.checkNotNullExpressionValue((Object)writer, (String)"writer");
            JSONWriter jsonWriter = new JSONWriter((Writer)writer, false, 2, null);
            jsonWriter.startObject();
            jsonWriter.write("modules");
            jsonWriter.startArray();
            for (ModuleComment comment : this.moduleComments) {
                comment.toJSON(this, "", errorLog, jsonWriter);
            }
            jsonWriter.endArray();
            jsonWriter.endObject();
            jsonWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

