/*
 * Decompiled with CFR 0.152.
 */
package avail.compiler.splitter;

import avail.compiler.problems.CompilerDiagnostics;
import avail.compiler.splitter.Alternation;
import avail.compiler.splitter.Argument;
import avail.compiler.splitter.ArgumentForMacroOnly;
import avail.compiler.splitter.ArgumentInModuleScope;
import avail.compiler.splitter.CompletelyOptional;
import avail.compiler.splitter.Counter;
import avail.compiler.splitter.Expression;
import avail.compiler.splitter.Group;
import avail.compiler.splitter.InstructionGenerator;
import avail.compiler.splitter.MessageSplitterTokenizer;
import avail.compiler.splitter.NumberedChoice;
import avail.compiler.splitter.Optional;
import avail.compiler.splitter.RawKeywordTokenArgument;
import avail.compiler.splitter.RawLiteralTokenArgument;
import avail.compiler.splitter.RawTokenArgument;
import avail.compiler.splitter.SectionCheckpoint;
import avail.compiler.splitter.Sequence;
import avail.compiler.splitter.Simple;
import avail.compiler.splitter.VariableQuote;
import avail.compiler.splitter.WrapState;
import avail.descriptor.atoms.AtomDescriptor;
import avail.descriptor.numbers.A_Number;
import avail.descriptor.phrases.A_Phrase;
import avail.descriptor.representation.A_BasicObject;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.sets.A_Set;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.StringDescriptor;
import avail.descriptor.tuples.TupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.exceptions.AvailErrorCode;
import avail.exceptions.MalformedMessageException;
import avail.exceptions.SignatureException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 W2\u00020\u0001:\u0002WXB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\b\b\u0002\u0010.\u001a\u00020\u0011H\u0007J\u000e\u0010/\u001a\u00020\u00062\u0006\u00100\u001a\u000201J\b\u00102\u001a\u00020+H\u0002J\u0014\u00103\u001a\u00020+2\n\u00104\u001a\u000605j\u0002`6H\u0002J\u0016\u00107\u001a\u0002082\u0006\u00109\u001a\u00020-2\u0006\u0010:\u001a\u00020\u0011J\b\u0010;\u001a\u00020+H\u0002J\u000e\u0010<\u001a\u00020=2\u0006\u00109\u001a\u00020-J\u0016\u0010>\u001a\b\u0012\u0004\u0012\u00020@0?2\u0006\u00109\u001a\u00020-H\u0002J\n\u0010A\u001a\u0004\u0018\u00010@H\u0002J\n\u0010B\u001a\u0004\u0018\u00010@H\u0002J\b\u0010C\u001a\u00020@H\u0002J\b\u0010D\u001a\u00020@H\u0002J\u0010\u0010E\u001a\u00020@2\u0006\u0010F\u001a\u00020@H\u0002J\b\u0010G\u001a\u00020)H\u0002J\b\u0010H\u001a\u00020@H\u0002J\b\u0010I\u001a\u00020@H\u0002J\u0010\u0010J\u001a\u00020\u00062\u0006\u0010K\u001a\u00020LH\u0002J\u0010\u0010M\u001a\u00020\u00062\u0006\u0010K\u001a\u00020LH\u0002J(\u0010M\u001a\u00020\u00062\u0006\u0010K\u001a\u00020L2\u0006\u0010N\u001a\u00020\u00062\u0006\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u000208H\u0002J\b\u0010R\u001a\u00020\u0011H\u0002J\"\u0010S\u001a\u00020+2\u0006\u0010T\u001a\u0002012\n\u00104\u001a\u000605j\u0002`62\u0006\u0010U\u001a\u00020\u0011J\b\u0010V\u001a\u000208H\u0016R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u001e\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\rR\u000e\u0010\u0016\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u001a\u00a2\u0006\n\n\u0002\u0010\u001d\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001e\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0014R\u001a\u0010 \u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0014\"\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0014R\u0011\u0010&\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\bR\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006Y"}, d2={"Lavail/compiler/splitter/MessageSplitter;", "", "messageName", "Lavail/descriptor/tuples/A_String;", "(Lavail/descriptor/tuples/A_String;)V", "atEnd", "", "getAtEnd", "()Z", "containsGroups", "getContainsGroups", "currentMessagePart", "getCurrentMessagePart", "()Lavail/descriptor/tuples/A_String;", "currentMessagePartOrNull", "getCurrentMessagePartOrNull", "<set-?>", "", "leafArgumentCount", "getLeafArgumentCount", "()I", "getMessageName", "messagePartPosition", "messagePartPositions", "", "messageParts", "", "getMessageParts", "()[Lavail/descriptor/tuples/A_String;", "[Lavail/descriptor/tuples/A_String;", "numberOfArguments", "getNumberOfArguments", "numberOfSectionCheckpoints", "getNumberOfSectionCheckpoints", "setNumberOfSectionCheckpoints", "(I)V", "positionInName", "getPositionInName", "recursivelyContainsReorders", "getRecursivelyContainsReorders", "rootSequence", "Lavail/compiler/splitter/Sequence;", "checkImplementationSignature", "", "functionType", "Lavail/descriptor/types/A_Type;", "sectionNumber", "checkListStructure", "list", "Lavail/descriptor/phrases/A_Phrase;", "checkSuffixCharactersNotInSuffix", "dumpForDebug", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "highlightedNameFor", "", "phraseType", "pc", "incrementLeafArgumentCount", "instructionsTupleFor", "Lavail/descriptor/tuples/A_Tuple;", "originExpressionsFor", "", "Lavail/compiler/splitter/Expression;", "parseElement", "parseElementOrAlternation", "parseEllipsisElement", "parseGuillemetElement", "parseOptionalExplicitOrdinal", "expression", "parseSequence", "parseSimple", "parseUnderscoreElement", "peekAheadFor", "metacharacter", "Lavail/compiler/splitter/MessageSplitter$Metacharacter;", "peekFor", "failureCondition", "errorCode", "Lavail/exceptions/AvailErrorCode;", "errorString", "peekForExplicitOrdinal", "printSendNodeOnIndent", "sendPhrase", "indent", "toString", "Companion", "Metacharacter", "avail"})
public final class MessageSplitter {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final A_String messageName;
    @NotNull
    private final A_String[] messageParts;
    @NotNull
    private final int[] messagePartPositions;
    private int messagePartPosition;
    private int leafArgumentCount;
    private int numberOfSectionCheckpoints;
    @NotNull
    private final Sequence rootSequence;
    @NotNull
    private static final A_Set possibleErrors;
    @NotNull
    private static final String circledNumbersString = "\u24ea\u2460\u2461\u2462\u2463\u2464\u2465\u2466\u2467\u2468\u2469\u246a\u246b\u246c\u246d\u246e\u246f\u2470\u2471\u2472\u2473\u3251\u3252\u3253\u3254\u3255\u3256\u3257\u3258\u3259\u325a\u325b\u325c\u325d\u325e\u325f\u32b1\u32b2\u32b3\u32b4\u32b5\u32b6\u32b7\u32b8\u32b9\u32ba\u32bb\u32bc\u32bd\u32be\u32bf";
    private static final int circledNumbersCount;
    @NotNull
    private static final int[] circledNumberCodePoints;
    @NotNull
    private static final Map<Integer, Integer> circledNumbersMap;
    @NotNull
    private static final AtomicReference<A_Tuple> permutations;
    @NotNull
    private static final List<AvailObject> constantsList;
    @NotNull
    private static final Map<AvailObject, Integer> constantsMap;
    @NotNull
    private static final ReentrantReadWriteLock constantsLock;
    private static final int indexForTrue;
    private static final int indexForFalse;

    public MessageSplitter(final @NotNull A_String messageName) throws MalformedMessageException {
        Intrinsics.checkNotNullParameter(messageName, "messageName");
        this.messageName = messageName.makeShared();
        MessageSplitterTokenizer tokenizer = new MessageSplitterTokenizer(this.messageName);
        this.messageParts = tokenizer.canonicalMessageParts();
        this.messagePartPositions = tokenizer.messagePartPositions();
        try {
            this.messagePartPosition = 1;
            this.rootSequence = this.parseSequence();
            if (!this.getAtEnd()) {
                this.peekFor(Metacharacter.CLOSE_GUILLEMET, true, AvailErrorCode.E_UNBALANCED_GUILLEMETS, "close guillemet (\u00bb) with no corresponding open guillemet (\u00ab)");
                this.peekFor(Metacharacter.DOUBLE_DAGGER, true, AvailErrorCode.E_UNBALANCED_GUILLEMETS, "double-dagger (\u2021) outside of a group");
                Companion.throwMalformedMessageException(AvailErrorCode.E_UNBALANCED_GUILLEMETS, "Encountered unexpected character: " + this.getCurrentMessagePart());
                throw new KotlinNothingValueException();
            }
        }
        catch (MalformedMessageException e) {
            throw new MalformedMessageException(e.getErrorCode(), new Function0<String>(){

                @Override
                @NotNull
                public final String invoke() {
                    StringBuilder stringBuilder;
                    MalformedMessageException malformedMessageException = e;
                    MessageSplitter messageSplitter = this;
                    A_String a_String = messageName;
                    StringBuilder $this$invoke_u24lambda_u2d0 = stringBuilder = new StringBuilder();
                    boolean bl = false;
                    $this$invoke_u24lambda_u2d0.append(malformedMessageException.describeProblem());
                    $this$invoke_u24lambda_u2d0.append(". See arrow (");
                    $this$invoke_u24lambda_u2d0.append(CompilerDiagnostics.Companion.getErrorIndicatorSymbol());
                    $this$invoke_u24lambda_u2d0.append(") in: \"");
                    int characterIndex = messageSplitter.messagePartPosition > 0 ? (!messageSplitter.getAtEnd() ? messageSplitter.messagePartPositions[messageSplitter.messagePartPosition - 1] : A_Tuple.Companion.getTupleSize(a_String) + 1) : 0;
                    A_String before = a_String.copyStringFromToCanDestroy(1, characterIndex - 1, false);
                    A_String after = a_String.copyStringFromToCanDestroy(characterIndex, A_Tuple.Companion.getTupleSize(a_String), false);
                    $this$invoke_u24lambda_u2d0.append(before.asNativeString());
                    $this$invoke_u24lambda_u2d0.append(CompilerDiagnostics.Companion.getErrorIndicatorSymbol());
                    $this$invoke_u24lambda_u2d0.append(after.asNativeString());
                    $this$invoke_u24lambda_u2d0.append('\"');
                    String string2 = stringBuilder.toString();
                    Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
                    return string2;
                }
            });
        }
    }

    @NotNull
    public final A_String getMessageName() {
        return this.messageName;
    }

    @NotNull
    public final A_String[] getMessageParts() {
        return this.messageParts;
    }

    public final int getLeafArgumentCount() {
        return this.leafArgumentCount;
    }

    public final int getNumberOfSectionCheckpoints() {
        return this.numberOfSectionCheckpoints;
    }

    public final void setNumberOfSectionCheckpoints(int n) {
        this.numberOfSectionCheckpoints = n;
    }

    private final void dumpForDebug(StringBuilder builder2) {
        StringBuilder $this$dumpForDebug_u24lambda_u2d1 = builder2;
        boolean bl = false;
        $this$dumpForDebug_u24lambda_u2d1.append(this.messageName.asNativeString());
        $this$dumpForDebug_u24lambda_u2d1.append("\n------\n");
        A_String[] $this$forEach$iv = this.messageParts;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            A_String element$iv;
            A_String it = element$iv = $this$forEach$iv[i];
            boolean bl2 = false;
            $this$dumpForDebug_u24lambda_u2d1.append("\t" + it.asNativeString() + "\n");
        }
    }

    private final int getPositionInName() {
        return this.getAtEnd() ? A_Tuple.Companion.getTupleSize(this.messageName) : this.messagePartPositions[this.messagePartPosition - 1];
    }

    private final boolean getAtEnd() {
        return this.messagePartPosition > this.messageParts.length;
    }

    private final A_String getCurrentMessagePartOrNull() {
        return this.getAtEnd() ? null : this.messageParts[this.messagePartPosition - 1];
    }

    private final A_String getCurrentMessagePart() {
        boolean bl;
        boolean bl2 = bl = !this.getAtEnd();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        return this.messageParts[this.messagePartPosition - 1];
    }

    public final void printSendNodeOnIndent(@NotNull A_Phrase sendPhrase, @NotNull StringBuilder builder2, int indent) {
        Intrinsics.checkNotNullParameter(sendPhrase, "sendPhrase");
        Intrinsics.checkNotNullParameter(builder2, "builder");
        builder2.append('\u00ab');
        this.rootSequence.printWithArguments$avail(A_Phrase.Companion.getExpressionsTuple(A_Phrase.Companion.getArgumentsListNode(sendPhrase)).iterator(), builder2, indent);
        builder2.append('\u00bb');
    }

    @NotNull
    public final A_Tuple instructionsTupleFor(@NotNull A_Type phraseType) throws SignatureException {
        Intrinsics.checkNotNullParameter(phraseType, "phraseType");
        InstructionGenerator generator = new InstructionGenerator();
        this.rootSequence.emitOn$avail(phraseType, generator, WrapState.PUSHED_LIST);
        generator.optimizeInstructions();
        return generator.instructionsTuple();
    }

    private final List<Expression> originExpressionsFor(A_Type phraseType) {
        boolean bl;
        InstructionGenerator generator = new InstructionGenerator();
        this.rootSequence.emitOn$avail(phraseType, generator, WrapState.PUSHED_LIST);
        generator.optimizeInstructions();
        List<Expression> expressions = generator.expressionList();
        boolean bl2 = bl = expressions.size() == A_Tuple.Companion.getTupleSize(generator.instructionsTuple());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        return expressions;
    }

    @NotNull
    public final String highlightedNameFor(@NotNull A_Type phraseType, int pc) {
        Intrinsics.checkNotNullParameter(phraseType, "phraseType");
        String string2 = this.messageName.asNativeString();
        List<Expression> expressions = this.originExpressionsFor(phraseType);
        int zeroBasedPosition = pc == expressions.size() + 1 ? string2.length() : expressions.get(pc - 1).getPositionInName() - 1;
        String string3 = string2;
        IntRange intRange = RangesKt.until(zeroBasedPosition, zeroBasedPosition);
        CharSequence charSequence = CompilerDiagnostics.Companion.getErrorIndicatorSymbol();
        String annotatedString = ((Object)StringsKt.replaceRange((CharSequence)string3, intRange, charSequence)).toString();
        return StringDescriptor.Companion.stringFrom(annotatedString).toString();
    }

    private final boolean peekFor(Metacharacter metacharacter) {
        A_String token = this.getCurrentMessagePartOrNull();
        if (token != null && token.equals(metacharacter.getString())) {
            int n = this.messagePartPosition;
            this.messagePartPosition = n + 1;
            return true;
        }
        return false;
    }

    private final boolean peekAheadFor(Metacharacter metacharacter) {
        A_String token = this.getCurrentMessagePartOrNull();
        return token != null && token.equals(metacharacter.getString());
    }

    private final int peekForExplicitOrdinal() {
        int codePoint;
        if (!this.getAtEnd() && circledNumbersMap.containsKey(codePoint = A_Tuple.Companion.tupleCodePointAt(this.getCurrentMessagePart(), 1))) {
            int n = this.messagePartPosition;
            this.messagePartPosition = n + 1;
            Integer n2 = circledNumbersMap.get(codePoint);
            Intrinsics.checkNotNull(n2);
            return ((Number)n2).intValue();
        }
        return -1;
    }

    private final boolean peekFor(Metacharacter metacharacter, boolean failureCondition, AvailErrorCode errorCode, String errorString) throws MalformedMessageException {
        A_String token = this.getCurrentMessagePartOrNull();
        if (token == null || !token.equals(metacharacter.getString())) {
            return false;
        }
        MessageSplitter.Companion.throwMalformedIf(failureCondition, errorCode, errorString);
        int n = this.messagePartPosition;
        this.messagePartPosition = n + 1;
        return true;
    }

    private final Sequence parseSequence() throws MalformedMessageException {
        Sequence sequence = new Sequence(this.messagePartPosition);
        Expression expression = this.parseElementOrAlternation();
        while (expression != null) {
            sequence.addExpression(expression);
            expression = this.parseElementOrAlternation();
        }
        sequence.checkForConsistentOrdinals();
        return sequence;
    }

    private final Expression parseElementOrAlternation() throws MalformedMessageException {
        Expression expression = this.parseElement();
        if (expression == null) {
            return null;
        }
        Expression firstExpression = expression;
        if (!this.peekAheadFor(Metacharacter.VERTICAL_BAR)) {
            return firstExpression;
        }
        MessageSplitter.Companion.checkAlternative(firstExpression);
        List alternatives = new ArrayList();
        alternatives.add(firstExpression);
        while (this.peekFor(Metacharacter.VERTICAL_BAR)) {
            Expression nextExpression;
            if (this.parseElement() == null) {
                Companion.throwMalformedMessageException(AvailErrorCode.E_VERTICAL_BAR_MUST_SEPARATE_TOKENS_OR_SIMPLE_GROUPS, "Expecting another token or simple group after the vertical bar (|)");
                throw new KotlinNothingValueException();
            }
            MessageSplitter.Companion.checkAlternative(nextExpression);
            alternatives.add(nextExpression);
        }
        return new Alternation(firstExpression.getPositionInName(), alternatives);
    }

    private final Expression parseElement() throws MalformedMessageException {
        Expression expression;
        if (this.getAtEnd()) {
            expression = null;
        } else if (this.peekAheadFor(Metacharacter.DOUBLE_DAGGER) || this.peekAheadFor(Metacharacter.CLOSE_GUILLEMET)) {
            expression = null;
        } else if (this.peekFor(Metacharacter.UNDERSCORE)) {
            expression = this.parseOptionalExplicitOrdinal(this.parseUnderscoreElement());
        } else if (this.peekFor(Metacharacter.ELLIPSIS)) {
            expression = this.parseOptionalExplicitOrdinal(this.parseEllipsisElement());
        } else if (this.peekFor(Metacharacter.OPEN_GUILLEMET)) {
            expression = this.parseOptionalExplicitOrdinal(this.parseGuillemetElement());
        } else if (this.peekFor(Metacharacter.SECTION_SIGN)) {
            ++this.numberOfSectionCheckpoints;
            expression = new SectionCheckpoint(this.getPositionInName(), this.numberOfSectionCheckpoints);
        } else {
            expression = this.parseSimple();
        }
        return expression;
    }

    private final Expression parseSimple() throws MalformedMessageException {
        if (this.peekFor(Metacharacter.BACK_QUOTE, this.getAtEnd(), AvailErrorCode.E_EXPECTED_OPERATOR_AFTER_BACKQUOTE, "Backquote (`) must be followed by a special metacharacter, space, or circled number")) {
            A_String token = this.getCurrentMessagePart();
            MessageSplitter.Companion.throwMalformedIf(A_Tuple.Companion.getTupleSize(token) != 1 || !Metacharacter.Companion.canBeBackQuoted(A_Tuple.Companion.tupleCodePointAt(token, 1)), AvailErrorCode.E_EXPECTED_OPERATOR_AFTER_BACKQUOTE, "Backquote (`) must be followed by a special metacharacter, space, or circled number, not (" + token + ")");
        } else {
            this.checkSuffixCharactersNotInSuffix();
        }
        Expression expression = new Simple(this.getCurrentMessagePart(), this.messagePartPosition, this.messagePartPositions[this.messagePartPosition - 1]);
        int n = this.messagePartPosition;
        this.messagePartPosition = n + 1;
        if (this.peekFor(Metacharacter.TILDE, !expression.isLowerCase$avail(), AvailErrorCode.E_CASE_INSENSITIVE_EXPRESSION_CANONIZATION, "Tilde (~) may only occur after a lowercase token or a group of lowercase tokens")) {
            expression = expression.applyCaseInsensitive$avail();
        }
        if (this.peekFor(Metacharacter.QUESTION_MARK)) {
            Sequence sequence = new Sequence(expression.getPositionInName());
            sequence.addExpression(expression);
            expression = new Optional(expression.getPositionInName(), sequence);
        } else if (this.peekFor(Metacharacter.DOUBLE_QUESTION_MARK)) {
            Sequence sequence = new Sequence(expression.getPositionInName());
            sequence.addExpression(expression);
            expression = new CompletelyOptional(expression.getPositionInName(), sequence);
        }
        return expression;
    }

    private final Expression parseOptionalExplicitOrdinal(Expression expression) {
        int ordinal = this.peekForExplicitOrdinal();
        if (ordinal != -1) {
            expression.setExplicitOrdinal(ordinal);
        }
        return expression;
    }

    private final void checkSuffixCharactersNotInSuffix() throws MalformedMessageException {
        A_String a_String = this.getCurrentMessagePartOrNull();
        if (a_String == null) {
            return;
        }
        A_String token = a_String;
        if (circledNumbersMap.containsKey(A_Tuple.Companion.tupleCodePointAt(token, 1))) {
            Companion.throwMalformedMessageException(AvailErrorCode.E_INCONSISTENT_ARGUMENT_REORDERING, "Unquoted circled numbers (\u24ea-\u32bf) may only follow an argument, an ellipsis, or an argument group");
            throw new KotlinNothingValueException();
        }
        this.peekFor(Metacharacter.OCTOTHORP, true, AvailErrorCode.E_OCTOTHORP_MUST_FOLLOW_A_SIMPLE_GROUP_OR_ELLIPSIS, "An octothorp (#) may only follow a simple group (\u00ab\u00bb) or an ellipsis (\u2026)");
        this.peekFor(Metacharacter.QUESTION_MARK, true, AvailErrorCode.E_QUESTION_MARK_MUST_FOLLOW_A_SIMPLE_GROUP, "A question mark (?) may only follow a simple group (optional) or a group with no double-dagger (\u2021)");
        this.peekFor(Metacharacter.TILDE, true, AvailErrorCode.E_CASE_INSENSITIVE_EXPRESSION_CANONIZATION, "Tilde (~) may only occur after a lowercase token or a group of lowercase tokens");
        this.peekFor(Metacharacter.VERTICAL_BAR, true, AvailErrorCode.E_VERTICAL_BAR_MUST_SEPARATE_TOKENS_OR_SIMPLE_GROUPS, "A vertical bar (|) may only separate tokens or simple groups");
        this.peekFor(Metacharacter.EXCLAMATION_MARK, true, AvailErrorCode.E_EXCLAMATION_MARK_MUST_FOLLOW_AN_ALTERNATION_GROUP, "An exclamation mark (!) may only follow an alternation group (or follow an underscore for macros)");
        this.peekFor(Metacharacter.UP_ARROW, true, AvailErrorCode.E_UP_ARROW_MUST_FOLLOW_ARGUMENT, "An up-arrow (\u2191) may only follow an argument");
    }

    private final Expression parseGuillemetElement() throws MalformedMessageException {
        Expression expression;
        Group group;
        int startOfGroup = this.getPositionInName();
        Sequence beforeDagger = this.parseSequence();
        if (this.peekFor(Metacharacter.DOUBLE_DAGGER)) {
            Sequence afterDagger = this.parseSequence();
            this.peekFor(Metacharacter.DOUBLE_DAGGER, true, AvailErrorCode.E_INCORRECT_USE_OF_DOUBLE_DAGGER, "A group must have at most one double-dagger (\u2021)");
            v0 = new Group(startOfGroup, beforeDagger, afterDagger);
        } else {
            v0 = group = new Group(startOfGroup, beforeDagger);
        }
        if (!this.peekFor(Metacharacter.CLOSE_GUILLEMET)) {
            Companion.throwMalformedMessageException(AvailErrorCode.E_UNBALANCED_GUILLEMETS, "Expected close guillemet (\u00bb) to end group");
            throw new KotlinNothingValueException();
        }
        if (this.peekFor(Metacharacter.TILDE, !group.isLowerCase$avail(), AvailErrorCode.E_CASE_INSENSITIVE_EXPRESSION_CANONIZATION, "Tilde (~) may only occur after a lowercase token or a group of lowercase tokens")) {
            group = group.applyCaseInsensitive$avail();
        }
        if (this.peekFor(Metacharacter.OCTOTHORP, group.getUnderscoreCount$avail() > 0, AvailErrorCode.E_OCTOTHORP_MUST_FOLLOW_A_SIMPLE_GROUP_OR_ELLIPSIS, "An octothorp (#) may only follow a non-yielding group or an ellipsis (\u2026)")) {
            expression = new Counter(startOfGroup, group);
        } else if (this.peekFor(Metacharacter.QUESTION_MARK, group.getHasDagger(), AvailErrorCode.E_QUESTION_MARK_MUST_FOLLOW_A_SIMPLE_GROUP, "A question mark (?) may only follow a simple group (optional) or a group with arguments (0 or 1 occurrences), but not one with a double-dagger (\u2021), since that suggests multiple occurrences to be separated")) {
            if (group.getUnderscoreCount$avail() > 0) {
                group.beOptional();
                expression = group;
            } else {
                expression = new Optional(startOfGroup, group.getBeforeDagger());
            }
        } else if (this.peekFor(Metacharacter.DOUBLE_QUESTION_MARK, group.getUnderscoreCount$avail() > 0 || group.getHasDagger(), AvailErrorCode.E_DOUBLE_QUESTION_MARK_MUST_FOLLOW_A_TOKEN_OR_SIMPLE_GROUP, "A double question mark (\u2047) may only follow a token or simple group, not one with a double-dagger (\u2021) or arguments")) {
            expression = new CompletelyOptional(startOfGroup, group.getBeforeDagger());
        } else if (this.peekFor(Metacharacter.EXCLAMATION_MARK, group.getUnderscoreCount$avail() > 0 || group.getHasDagger() || group.getBeforeDagger().getExpressions().size() != 1 || !(group.getBeforeDagger().getExpressions().get(0) instanceof Alternation), AvailErrorCode.E_EXCLAMATION_MARK_MUST_FOLLOW_AN_ALTERNATION_GROUP, "An exclamation mark (!) may only follow an alternation group or (for macros) an underscore")) {
            Expression $this$cast$iv = group.getBeforeDagger().getExpressions().get(0);
            boolean $i$f$cast = false;
            Alternation alternation = (Alternation)$this$cast$iv;
            expression = new NumberedChoice(alternation);
        } else {
            expression = group;
        }
        return expression;
    }

    private final Expression parseEllipsisElement() {
        int tokenStart = this.messagePartPositions[this.messagePartPosition - 2];
        this.incrementLeafArgumentCount();
        return this.peekFor(Metacharacter.EXCLAMATION_MARK) ? (Expression)new RawTokenArgument(tokenStart, this.leafArgumentCount) : (this.peekFor(Metacharacter.OCTOTHORP) ? (Expression)new RawLiteralTokenArgument(tokenStart, this.leafArgumentCount) : (Expression)new RawKeywordTokenArgument(tokenStart, this.leafArgumentCount));
    }

    private final Expression parseUnderscoreElement() {
        int positionInName = this.messagePartPositions[this.messagePartPosition - 2];
        this.incrementLeafArgumentCount();
        return this.peekFor(Metacharacter.SINGLE_DAGGER) ? (Expression)new ArgumentInModuleScope(positionInName, this.leafArgumentCount) : (this.peekFor(Metacharacter.UP_ARROW) ? (Expression)new VariableQuote(positionInName, this.leafArgumentCount) : (this.peekFor(Metacharacter.EXCLAMATION_MARK) ? (Expression)new ArgumentForMacroOnly(positionInName, this.leafArgumentCount) : (Expression)new Argument(positionInName, this.leafArgumentCount)));
    }

    private final void incrementLeafArgumentCount() {
        int n = this.leafArgumentCount;
        this.leafArgumentCount = n + 1;
    }

    public final int getNumberOfArguments() {
        return this.rootSequence.getYielders().size();
    }

    @JvmOverloads
    public final void checkImplementationSignature(@NotNull A_Type functionType, int sectionNumber) throws SignatureException {
        Intrinsics.checkNotNullParameter(functionType, "functionType");
        A_Type argsTupleType = A_Type.Companion.getArgsTupleType(functionType);
        A_Type sizes = A_Type.Companion.getSizeRange(argsTupleType);
        A_Number lowerBound = A_Type.Companion.getLowerBound(sizes);
        A_Number upperBound = A_Type.Companion.getUpperBound(sizes);
        if (!lowerBound.equals(upperBound) || !A_Number.Companion.isInt(lowerBound)) {
            Companion.throwSignatureException(AvailErrorCode.E_INCORRECT_NUMBER_OF_ARGUMENTS);
            throw new KotlinNothingValueException();
        }
        int lowerBoundInt = A_Number.Companion.getExtractInt(lowerBound);
        if (lowerBoundInt != this.getNumberOfArguments()) {
            Companion.throwSignatureException(AvailErrorCode.E_INCORRECT_NUMBER_OF_ARGUMENTS);
            throw new KotlinNothingValueException();
        }
        this.rootSequence.checkRootType(A_Type.Companion.getArgsTupleType(functionType), sectionNumber);
    }

    public static /* synthetic */ void checkImplementationSignature$default(MessageSplitter messageSplitter, A_Type a_Type, int n, int n2, Object object) throws SignatureException {
        if ((n2 & 2) != 0) {
            n = Integer.MAX_VALUE;
        }
        messageSplitter.checkImplementationSignature(a_Type, n);
    }

    public final boolean checkListStructure(@NotNull A_Phrase list2) {
        Intrinsics.checkNotNullParameter(list2, "list");
        return this.rootSequence.checkListStructure(list2);
    }

    public final boolean getContainsGroups() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.rootSequence.getExpressions();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Expression p0 = (Expression)element$iv;
                    boolean bl2 = false;
                    if (!p0.isGroup$avail()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean getRecursivelyContainsReorders() {
        return this.rootSequence.getRecursivelyContainsReorders();
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder;
        StringBuilder $this$toString_u24lambda_u2d2 = stringBuilder = new StringBuilder();
        boolean bl = false;
        this.dumpForDebug($this$toString_u24lambda_u2d2);
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "StringBuilder().apply(builderAction).toString()");
        return string2;
    }

    @JvmOverloads
    public final void checkImplementationSignature(@NotNull A_Type functionType) throws SignatureException {
        Intrinsics.checkNotNullParameter(functionType, "functionType");
        MessageSplitter.checkImplementationSignature$default(this, functionType, 0, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$associateTo$iv$iv;
        Companion = new Companion(null);
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_INCORRECT_ARGUMENT_TYPE, AvailErrorCode.E_INCORRECT_TYPE_FOR_GROUP, AvailErrorCode.E_INCORRECT_TYPE_FOR_COMPLEX_GROUP, AvailErrorCode.E_INCORRECT_TYPE_FOR_COUNTING_GROUP, AvailErrorCode.E_INCORRECT_TYPE_FOR_BOOLEAN_GROUP, AvailErrorCode.E_INCORRECT_TYPE_FOR_NUMBERED_CHOICE, AvailErrorCode.E_INCORRECT_USE_OF_DOUBLE_DAGGER, AvailErrorCode.E_UNBALANCED_GUILLEMETS, AvailErrorCode.E_METHOD_NAME_IS_NOT_CANONICAL, AvailErrorCode.E_ALTERNATIVE_MUST_NOT_CONTAIN_ARGUMENTS, AvailErrorCode.E_OCTOTHORP_MUST_FOLLOW_A_SIMPLE_GROUP_OR_ELLIPSIS, AvailErrorCode.E_QUESTION_MARK_MUST_FOLLOW_A_SIMPLE_GROUP, AvailErrorCode.E_VERTICAL_BAR_MUST_SEPARATE_TOKENS_OR_SIMPLE_GROUPS, AvailErrorCode.E_EXCLAMATION_MARK_MUST_FOLLOW_AN_ALTERNATION_GROUP, AvailErrorCode.E_DOUBLE_QUESTION_MARK_MUST_FOLLOW_A_TOKEN_OR_SIMPLE_GROUP, AvailErrorCode.E_CASE_INSENSITIVE_EXPRESSION_CANONIZATION, AvailErrorCode.E_EXPECTED_OPERATOR_AFTER_BACKQUOTE, AvailErrorCode.E_UP_ARROW_MUST_FOLLOW_ARGUMENT, AvailErrorCode.E_INCONSISTENT_ARGUMENT_REORDERING};
        possibleErrors = SetDescriptor.Companion.set(availErrorCodeArray).makeShared();
        circledNumbersCount = circledNumbersString.codePointCount(0, circledNumbersString.length());
        PrimitiveIterator.OfInt ofInt = circledNumbersString.codePoints().iterator();
        Intrinsics.checkNotNullExpressionValue(ofInt, "circledNumbersString.codePoints().iterator()");
        circledNumberCodePoints = CollectionsKt.toIntArray(SequencesKt.toList(SequencesKt.asSequence(ofInt)));
        Iterable<IndexedValue<Integer>> $this$associate$iv = ArraysKt.withIndex(circledNumberCodePoints);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
        Iterable<IndexedValue<Integer>> iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Object object = (IndexedValue)element$iv$iv;
            boolean bl = false;
            int i = ((IndexedValue)object).component1();
            int cp = ((Number)((IndexedValue)object).component2()).intValue();
            object = TuplesKt.to(cp, i);
            map.put(((Pair)object).getFirst(), ((Pair)object).getSecond());
        }
        circledNumbersMap = destination$iv$iv;
        permutations = new AtomicReference<AvailObject>(TupleDescriptor.Companion.getEmptyTuple());
        constantsList = new ArrayList();
        constantsMap = new LinkedHashMap();
        constantsLock = new ReentrantReadWriteLock();
        indexForTrue = Companion.indexForConstant(AtomDescriptor.Companion.getTrueObject());
        indexForFalse = Companion.indexForConstant(AtomDescriptor.Companion.getFalseObject());
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0014\b\u0086\u0001\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001dB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fj\u0002\b\rj\u0002\b\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001c\u00a8\u0006\u001e"}, d2={"Lavail/compiler/splitter/MessageSplitter$Metacharacter;", "", "javaString", "", "(Ljava/lang/String;ILjava/lang/String;)V", "codepoint", "", "getCodepoint", "()I", "string", "Lavail/descriptor/tuples/A_String;", "getString", "()Lavail/descriptor/tuples/A_String;", "BACK_QUOTE", "CLOSE_GUILLEMET", "DOUBLE_DAGGER", "DOUBLE_QUESTION_MARK", "ELLIPSIS", "EXCLAMATION_MARK", "OCTOTHORP", "OPEN_GUILLEMET", "QUESTION_MARK", "SECTION_SIGN", "SINGLE_DAGGER", "SPACE", "TILDE", "UNDERSCORE", "UP_ARROW", "VERTICAL_BAR", "Companion", "avail"})
    public static final class Metacharacter
    extends Enum<Metacharacter> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final A_String string;
        private final int codepoint;
        @NotNull
        private static final Set<Integer> backquotableCodepoints;
        public static final /* enum */ Metacharacter BACK_QUOTE;
        public static final /* enum */ Metacharacter CLOSE_GUILLEMET;
        public static final /* enum */ Metacharacter DOUBLE_DAGGER;
        public static final /* enum */ Metacharacter DOUBLE_QUESTION_MARK;
        public static final /* enum */ Metacharacter ELLIPSIS;
        public static final /* enum */ Metacharacter EXCLAMATION_MARK;
        public static final /* enum */ Metacharacter OCTOTHORP;
        public static final /* enum */ Metacharacter OPEN_GUILLEMET;
        public static final /* enum */ Metacharacter QUESTION_MARK;
        public static final /* enum */ Metacharacter SECTION_SIGN;
        public static final /* enum */ Metacharacter SINGLE_DAGGER;
        public static final /* enum */ Metacharacter SPACE;
        public static final /* enum */ Metacharacter TILDE;
        public static final /* enum */ Metacharacter UNDERSCORE;
        public static final /* enum */ Metacharacter UP_ARROW;
        public static final /* enum */ Metacharacter VERTICAL_BAR;
        private static final /* synthetic */ Metacharacter[] $VALUES;

        /*
         * WARNING - void declaration
         */
        private Metacharacter(String javaString) {
            void it;
            boolean bl;
            AvailObject availObject;
            AvailObject availObject2 = availObject = StringDescriptor.Companion.stringFrom(javaString).makeShared();
            Metacharacter metacharacter = this;
            boolean bl2 = false;
            boolean bl3 = bl = A_Tuple.Companion.getTupleSize((A_Tuple)it) == 1;
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            metacharacter.string = availObject;
            this.codepoint = A_Tuple.Companion.tupleCodePointAt(this.string, 1);
        }

        @NotNull
        public final A_String getString() {
            return this.string;
        }

        public final int getCodepoint() {
            return this.codepoint;
        }

        public static Metacharacter[] values() {
            return (Metacharacter[])$VALUES.clone();
        }

        public static Metacharacter valueOf(String value) {
            return Enum.valueOf(Metacharacter.class, value);
        }

        static {
            BACK_QUOTE = new Metacharacter("`");
            CLOSE_GUILLEMET = new Metacharacter("\u00bb");
            DOUBLE_DAGGER = new Metacharacter("\u2021");
            DOUBLE_QUESTION_MARK = new Metacharacter("\u2047");
            ELLIPSIS = new Metacharacter("\u2026");
            EXCLAMATION_MARK = new Metacharacter("!");
            OCTOTHORP = new Metacharacter("#");
            OPEN_GUILLEMET = new Metacharacter("\u00ab");
            QUESTION_MARK = new Metacharacter("?");
            SECTION_SIGN = new Metacharacter("\u00a7");
            SINGLE_DAGGER = new Metacharacter("\u2020");
            SPACE = new Metacharacter(" ");
            TILDE = new Metacharacter("~");
            UNDERSCORE = new Metacharacter("_");
            UP_ARROW = new Metacharacter("\u2191");
            VERTICAL_BAR = new Metacharacter("|");
            $VALUES = metacharacterArray = new Metacharacter[]{Metacharacter.BACK_QUOTE, Metacharacter.CLOSE_GUILLEMET, Metacharacter.DOUBLE_DAGGER, Metacharacter.DOUBLE_QUESTION_MARK, Metacharacter.ELLIPSIS, Metacharacter.EXCLAMATION_MARK, Metacharacter.OCTOTHORP, Metacharacter.OPEN_GUILLEMET, Metacharacter.QUESTION_MARK, Metacharacter.SECTION_SIGN, Metacharacter.SINGLE_DAGGER, Metacharacter.SPACE, Metacharacter.TILDE, Metacharacter.UNDERSCORE, Metacharacter.UP_ARROW, Metacharacter.VERTICAL_BAR};
            Companion = new Companion(null);
            backquotableCodepoints = new LinkedHashSet();
            backquotableCodepoints.addAll(circledNumbersMap.keySet());
            Metacharacter[] $this$forEach$iv = Metacharacter.values();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Metacharacter element$iv;
                Metacharacter it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                backquotableCodepoints.add(it.codepoint);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lavail/compiler/splitter/MessageSplitter$Metacharacter$Companion;", "", "()V", "backquotableCodepoints", "", "", "canBeBackQuoted", "", "codePoint", "avail"})
        public static final class Companion {
            private Companion() {
            }

            public final boolean canBeBackQuoted(int codePoint) {
                return backquotableCodepoints.contains(codePoint);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u000e\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u0006J\u000e\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020\u0006J\u000e\u0010&\u001a\u00020\u00062\u0006\u0010'\u001a\u00020(J\u000e\u0010)\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u0019J\u000e\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0006J\u000e\u0010.\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0006J\u000e\u0010/\u001a\u00020\r2\u0006\u0010%\u001a\u00020\u0006J \u00100\u001a\u00020\u001f2\u0006\u00101\u001a\u00020,2\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\nH\u0002J\u0016\u00105\u001a\u0002062\u0006\u00102\u001a\u0002032\u0006\u00107\u001a\u00020\nJ\u000e\u00108\u001a\u0002062\u0006\u00102\u001a\u000203R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00060\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u00069"}, d2={"Lavail/compiler/splitter/MessageSplitter$Companion;", "", "()V", "circledNumberCodePoints", "", "circledNumbersCount", "", "circledNumbersMap", "", "circledNumbersString", "", "constantsList", "", "Lavail/descriptor/representation/AvailObject;", "constantsLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "constantsMap", "", "indexForFalse", "getIndexForFalse", "()I", "indexForTrue", "getIndexForTrue", "permutations", "Ljava/util/concurrent/atomic/AtomicReference;", "Lavail/descriptor/tuples/A_Tuple;", "possibleErrors", "Lavail/descriptor/sets/A_Set;", "getPossibleErrors", "()Lavail/descriptor/sets/A_Set;", "checkAlternative", "", "expression", "Lavail/compiler/splitter/Expression;", "circledNumberCodePoint", "number", "constantForIndex", "index", "indexForConstant", "constant", "Lavail/descriptor/representation/A_BasicObject;", "indexForPermutation", "permutation", "isOperator", "", "cp", "isUnderscoreOrSpaceOrOperator", "permutationAtIndex", "throwMalformedIf", "condition", "errorCode", "Lavail/exceptions/AvailErrorCode;", "errorString", "throwMalformedMessageException", "", "errorMessage", "throwSignatureException", "avail"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final A_Set getPossibleErrors() {
            return possibleErrors;
        }

        public final int circledNumberCodePoint(int number) {
            boolean bl;
            boolean bl2 = 0 <= number ? number < circledNumbersCount : (bl = false);
            if (_Assertions.ENABLED && !bl) {
                String string2 = "Assertion failed";
                throw new AssertionError((Object)string2);
            }
            return circledNumberCodePoints[number];
        }

        @NotNull
        public final AvailObject permutationAtIndex(int index2) {
            Object v = permutations.get();
            Intrinsics.checkNotNullExpressionValue(v, "permutations.get()");
            return A_Tuple.Companion.tupleAt((A_Tuple)v, index2);
        }

        public final int indexForPermutation(@NotNull A_Tuple permutation) {
            Intrinsics.checkNotNullParameter(permutation, "permutation");
            int checkedLimit = 0;
            while (true) {
                A_Tuple before = (A_Tuple)permutations.get();
                Intrinsics.checkNotNullExpressionValue(before, "before");
                int newLimit = A_Tuple.Companion.getTupleSize(before);
                int i = checkedLimit + 1;
                if (i <= newLimit) {
                    while (true) {
                        if (A_Tuple.Companion.tupleAt(before, i).equals(permutation)) {
                            return i;
                        }
                        if (i == newLimit) break;
                        ++i;
                    }
                }
                AvailObject after = A_Tuple.Companion.appendCanDestroy(before, permutation, false).makeShared();
                if (permutations.compareAndSet(before, after)) {
                    return A_Tuple.Companion.getTupleSize(after);
                }
                checkedLimit = newLimit;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final int indexForConstant(@NotNull A_BasicObject constant) {
            Object object;
            Intrinsics.checkNotNullParameter(constant, "constant");
            AvailObject strongConstant = constant.makeShared();
            ReentrantReadWriteLock.ReadLock readLock = constantsLock.readLock();
            readLock.lock();
            try {
                boolean bl = false;
                Integer index2 = (Integer)constantsMap.get(strongConstant);
                if (index2 != null) {
                    int n = index2;
                    return n;
                }
                object = Unit.INSTANCE;
            }
            finally {
                readLock.unlock();
            }
            ReentrantReadWriteLock $this$safeWrite$iv = constantsLock;
            boolean $i$f$safeWrite = false;
            ReentrantReadWriteLock.WriteLock writeLock = $this$safeWrite$iv.writeLock();
            Intrinsics.checkNotNullExpressionValue(writeLock, "this.writeLock()");
            object = writeLock;
            object.lock();
            try {
                boolean bl;
                boolean bl2 = false;
                Integer index3 = (Integer)constantsMap.get(strongConstant);
                if (index3 != null) {
                    int n = index3;
                    return n;
                }
                boolean bl3 = bl = constantsMap.size() == constantsList.size();
                if (_Assertions.ENABLED && !bl) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                int newIndex = constantsList.size() + 1;
                constantsList.add(strongConstant);
                Integer n = newIndex;
                constantsMap.put(strongConstant, n);
                int n2 = newIndex;
                return n2;
            }
            finally {
                object.unlock();
            }
        }

        public final int getIndexForTrue() {
            return indexForTrue;
        }

        public final int getIndexForFalse() {
            return indexForFalse;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final AvailObject constantForIndex(int index2) {
            AvailObject availObject;
            ReentrantReadWriteLock.ReadLock readLock = constantsLock.readLock();
            readLock.lock();
            try {
                boolean bl = false;
                availObject = (AvailObject)constantsList.get(index2 - 1);
            }
            finally {
                readLock.unlock();
            }
            return availObject;
        }

        private final void throwMalformedIf(boolean condition, AvailErrorCode errorCode, String errorString) throws MalformedMessageException {
            if (condition) {
                this.throwMalformedMessageException(errorCode, errorString);
                throw new KotlinNothingValueException();
            }
        }

        private final void checkAlternative(Expression expression) throws MalformedMessageException {
            this.throwMalformedIf(expression.getYieldsValue$avail() || expression.getUnderscoreCount$avail() > 0, AvailErrorCode.E_ALTERNATIVE_MUST_NOT_CONTAIN_ARGUMENTS, "Alternatives must not contain arguments");
        }

        @NotNull
        public final Void throwSignatureException(@NotNull AvailErrorCode errorCode) throws SignatureException {
            Intrinsics.checkNotNullParameter((Object)errorCode, "errorCode");
            throw new SignatureException(errorCode);
        }

        @NotNull
        public final Void throwMalformedMessageException(@NotNull AvailErrorCode errorCode, @NotNull String errorMessage2) throws MalformedMessageException {
            Intrinsics.checkNotNullParameter((Object)errorCode, "errorCode");
            Intrinsics.checkNotNullParameter(errorMessage2, "errorMessage");
            throw new MalformedMessageException(errorCode, new Function0<String>(errorMessage2){
                final /* synthetic */ String $errorMessage;
                {
                    this.$errorMessage = $errorMessage;
                    super(0);
                }

                @NotNull
                public final String invoke() {
                    return this.$errorMessage;
                }
            });
        }

        public final boolean isUnderscoreOrSpaceOrOperator(int cp) {
            return cp == 95 || cp == 8230 || cp == 32 || cp == 47 || this.isOperator(cp);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isOperator(int cp) {
            boolean bl;
            if (Character.isDigit(cp)) return false;
            if (Character.isUnicodeIdentifierStart(cp)) return false;
            if (Character.isSpaceChar(cp)) return false;
            if (Character.isWhitespace(cp)) return false;
            if (cp < 32) return false;
            if (127 <= cp) {
                if (cp < 160) {
                    return false;
                }
                bl = false;
            } else {
                bl = false;
            }
            if (bl) return false;
            if (!Character.isDefined(cp)) return false;
            if (cp == 95) return false;
            if (cp == 34) return false;
            if (cp == 65279) return false;
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

