/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.modules;

import avail.descriptor.atoms.A_Atom;
import avail.descriptor.module.A_Module;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.EnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.descriptor.types.VariableTypeDescriptor;
import avail.descriptor.variables.VariableSharedGlobalDescriptor;
import avail.interpreter.Primitive;
import avail.interpreter.execution.Interpreter;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lavail/interpreter/primitive/modules/P_PrivateCreateModuleVariable;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "avail"})
public final class P_PrivateCreateModuleVariable
extends Primitive {
    @NotNull
    public static final P_PrivateCreateModuleVariable INSTANCE = new P_PrivateCreateModuleVariable();

    private P_PrivateCreateModuleVariable() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanFold, Primitive.Flag.CanInline, Primitive.Flag.Private, Primitive.Flag.CannotFail};
        super(5, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        boolean bl;
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(5);
        List<AvailObject> list2 = interpreter.argsBuffer;
        AvailObject module = list2.get(0);
        AvailObject name2 = list2.get(1);
        AvailObject varType = list2.get(2);
        AvailObject isConstantObject = list2.get(3);
        AvailObject stablyComputedObject = list2.get(4);
        boolean isConstant = A_Atom.Companion.getExtractBoolean(isConstantObject);
        boolean stablyComputed = A_Atom.Companion.getExtractBoolean(stablyComputedObject);
        boolean bl2 = bl = isConstant || !stablyComputed;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        AvailObject variable = VariableSharedGlobalDescriptor.Companion.createGlobal(varType, module, name2, isConstant);
        if (stablyComputed) {
            variable.setValueWasStablyComputed(true);
        }
        if (isConstant) {
            A_Module.Companion.addConstantBinding(module, name2, variable);
        } else {
            A_Module.Companion.addVariableBinding(module, name2, variable);
        }
        return interpreter.primitiveSuccess(variable);
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(PrimitiveTypeDescriptor.Types.MODULE.getO(), TupleTypeDescriptor.Companion.getStringType(), VariableTypeDescriptor.Companion.getMostGeneralVariableMeta(), EnumerationTypeDescriptor.Companion.getBooleanType(), EnumerationTypeDescriptor.Companion.getBooleanType()), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null);
    }
}

