/*
 * Decompiled with CFR 0.152.
 */
package avail.interpreter.primitive.style;

import avail.descriptor.atoms.A_Atom;
import avail.descriptor.character.CharacterDescriptor;
import avail.descriptor.fiber.A_Fiber;
import avail.descriptor.phrases.A_Phrase;
import avail.descriptor.representation.AvailObject;
import avail.descriptor.representation.NilDescriptor;
import avail.descriptor.sets.SetDescriptor;
import avail.descriptor.tokens.A_Token;
import avail.descriptor.tokens.LiteralTokenDescriptor;
import avail.descriptor.tuples.A_String;
import avail.descriptor.tuples.A_Tuple;
import avail.descriptor.tuples.ObjectTupleDescriptor;
import avail.descriptor.tuples.RepeatedElementTupleDescriptor;
import avail.descriptor.types.A_Type;
import avail.descriptor.types.AbstractEnumerationTypeDescriptor;
import avail.descriptor.types.EnumerationTypeDescriptor;
import avail.descriptor.types.FunctionTypeDescriptor;
import avail.descriptor.types.PhraseTypeDescriptor;
import avail.descriptor.types.PrimitiveTypeDescriptor;
import avail.descriptor.types.TupleTypeDescriptor;
import avail.exceptions.AvailErrorCode;
import avail.interpreter.Primitive;
import avail.interpreter.execution.AvailLoader;
import avail.interpreter.execution.Interpreter;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lavail/interpreter/primitive/style/P_StyleSpanOfPhrase;", "Lavail/interpreter/Primitive;", "()V", "attempt", "Lavail/interpreter/Primitive$Result;", "interpreter", "Lavail/interpreter/execution/Interpreter;", "privateBlockTypeRestriction", "Lavail/descriptor/types/A_Type;", "privateFailureVariableType", "avail"})
public final class P_StyleSpanOfPhrase
extends Primitive {
    @NotNull
    public static final P_StyleSpanOfPhrase INSTANCE = new P_StyleSpanOfPhrase();

    private P_StyleSpanOfPhrase() {
        Primitive.Flag[] flagArray = new Primitive.Flag[]{Primitive.Flag.CanInline, Primitive.Flag.WritesToHiddenGlobalState};
        super(3, flagArray);
    }

    @Override
    @NotNull
    public Primitive.Result attempt(@NotNull Interpreter interpreter) {
        String styleOrNull;
        int pastEnd;
        Intrinsics.checkNotNullParameter(interpreter, "interpreter");
        interpreter.checkArgumentCount(3);
        A_Phrase phrase = interpreter.argument(0);
        A_String styleName = interpreter.argument(1);
        boolean overwrite = A_Atom.Companion.getExtractBoolean(interpreter.argument(2));
        A_Fiber fiber2 = interpreter.fiber();
        if (!A_Fiber.Companion.getCanStyle(fiber2)) {
            return interpreter.primitiveFailure(AvailErrorCode.E_CANNOT_STYLE);
        }
        AvailLoader availLoader = A_Fiber.Companion.getAvailLoader(fiber2);
        Intrinsics.checkNotNull(availLoader);
        AvailLoader loader = availLoader;
        A_Tuple allTokens2 = A_Phrase.Companion.getAllTokens(phrase);
        if (A_Tuple.Companion.getTupleSize(allTokens2) == 0) {
            return interpreter.primitiveSuccess(NilDescriptor.Companion.getNil());
        }
        AvailObject firstToken = A_Tuple.Companion.tupleAt(allTokens2, 1);
        int start = firstToken.start();
        if (start == (pastEnd = A_Token.Companion.pastEnd(A_Tuple.Companion.tupleAt(allTokens2, A_Tuple.Companion.getTupleSize(allTokens2))))) {
            return interpreter.primitiveSuccess(NilDescriptor.Companion.getNil());
        }
        String string2 = styleOrNull = A_Tuple.Companion.getTupleSize(styleName) == 0 ? null : styleName.asNativeString();
        if (styleOrNull == null && !overwrite) {
            return interpreter.primitiveSuccess(NilDescriptor.Companion.getNil());
        }
        A_Tuple a_Tuple = RepeatedElementTupleDescriptor.Companion.createRepeatedElementTuple(pastEnd - start, CharacterDescriptor.Companion.fromCodePoint(63));
        Intrinsics.checkNotNull(a_Tuple, "null cannot be cast to non-null type avail.descriptor.tuples.A_String");
        AvailObject fakeToken = LiteralTokenDescriptor.Companion.literalToken$default(LiteralTokenDescriptor.Companion, (A_String)a_Tuple, start, firstToken.lineNumber(), NilDescriptor.Companion.getNil(), NilDescriptor.Companion.getNil(), null, 32, null);
        fakeToken.setCurrentModule(loader.getModule());
        AvailLoader.styleToken$default(loader, (A_Token)fakeToken, styleOrNull, overwrite, null, 8, null);
        return interpreter.primitiveSuccess(NilDescriptor.Companion.getNil());
    }

    @Override
    @NotNull
    protected A_Type privateFailureVariableType() {
        AvailErrorCode[] availErrorCodeArray = new AvailErrorCode[]{AvailErrorCode.E_CANNOT_STYLE};
        return AbstractEnumerationTypeDescriptor.Companion.enumerationWith(SetDescriptor.Companion.set(availErrorCodeArray));
    }

    @Override
    @NotNull
    protected A_Type privateBlockTypeRestriction() {
        return FunctionTypeDescriptor.Companion.functionType$default(FunctionTypeDescriptor.Companion, ObjectTupleDescriptor.Companion.tuple(PhraseTypeDescriptor.PhraseKind.PARSE_PHRASE.getMostGeneralType(), TupleTypeDescriptor.Companion.getStringType(), EnumerationTypeDescriptor.Companion.getBooleanType()), PrimitiveTypeDescriptor.Types.TOP.getO(), null, 4, null);
    }
}

